% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_describe_alarms_for_metric}
\alias{cloudwatch_describe_alarms_for_metric}
\title{Retrieves the alarms for the specified metric}
\usage{
cloudwatch_describe_alarms_for_metric(
  MetricName,
  Namespace,
  Statistic = NULL,
  ExtendedStatistic = NULL,
  Dimensions = NULL,
  Period = NULL,
  Unit = NULL
)
}
\arguments{
\item{MetricName}{[required] The name of the metric.}

\item{Namespace}{[required] The namespace of the metric.}

\item{Statistic}{The statistic for the metric, other than percentiles. For percentile
statistics, use \code{ExtendedStatistics}.}

\item{ExtendedStatistic}{The percentile statistic for the metric. Specify a value between p0.0
and p100.}

\item{Dimensions}{The dimensions associated with the metric. If the metric has any
associated dimensions, you must specify them in order for the call to
succeed.}

\item{Period}{The period, in seconds, over which the statistic is applied.}

\item{Unit}{The unit for the metric.}
}
\description{
Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit.

See \url{https://paws-r.github.io/docs/cloudwatch/describe_alarms_for_metric.html} for full documentation.
}
\keyword{internal}
