% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_register_publisher}
\alias{cloudformation_register_publisher}
\title{Registers your account as a publisher of public extensions in the
CloudFormation registry}
\usage{
cloudformation_register_publisher(
  AcceptTermsAndConditions = NULL,
  ConnectionArn = NULL
)
}
\arguments{
\item{AcceptTermsAndConditions}{Whether you accept the \href{https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf}{Terms and Conditions}
for publishing extensions in the CloudFormation registry. You must
accept the terms and conditions in order to register to publish public
extensions to the CloudFormation registry.

The default is \code{false}.}

\item{ConnectionArn}{If you are using a Bitbucket or GitHub account for identity
verification, the Amazon Resource Name (ARN) for your connection to that
account.

For more information, see \href{https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs}{Registering your account to publish CloudFormation extensions}
in the \emph{CloudFormation CLI User Guide}.}
}
\description{
Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.

See \url{https://paws-r.github.io/docs/cloudformation/register_publisher.html} for full documentation.
}
\keyword{internal}
