# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Managed Grafana
#'
#' @description
#' Amazon Managed Grafana is a fully managed and secure data visualization
#' service that you can use to instantly query, correlate, and visualize
#' operational metrics, logs, and traces from multiple sources. Amazon
#' Managed Grafana makes it easy to deploy, operate, and scale Grafana, a
#' widely deployed data visualization tool that is popular for its
#' extensible data support.
#' 
#' With Amazon Managed Grafana, you create logically isolated Grafana
#' servers called *workspaces*. In a workspace, you can create Grafana
#' dashboards and visualizations to analyze your metrics, logs, and traces
#' without having to build, package, or deploy any hardware to run Grafana
#' servers.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- managedgrafana(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- managedgrafana()
#' svc$associate_license(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=managedgrafana_associate_license]{associate_license} \tab Assigns a Grafana Enterprise license to a workspace\cr
#'  \link[=managedgrafana_create_workspace]{create_workspace} \tab Creates a workspace\cr
#'  \link[=managedgrafana_create_workspace_api_key]{create_workspace_api_key} \tab Creates an API key for the workspace\cr
#'  \link[=managedgrafana_delete_workspace]{delete_workspace} \tab Deletes an Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_delete_workspace_api_key]{delete_workspace_api_key} \tab Deletes an API key for a workspace\cr
#'  \link[=managedgrafana_describe_workspace]{describe_workspace} \tab Displays information about one Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_describe_workspace_authentication]{describe_workspace_authentication} \tab Displays information about the authentication methods used in one Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_disassociate_license]{disassociate_license} \tab Removes the Grafana Enterprise license from a workspace\cr
#'  \link[=managedgrafana_list_permissions]{list_permissions} \tab Lists the users and groups who have the Grafana Admin and Editor roles in this workspace\cr
#'  \link[=managedgrafana_list_tags_for_resource]{list_tags_for_resource} \tab The ListTagsForResource operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the resourceArn\cr
#'  \link[=managedgrafana_list_workspaces]{list_workspaces} \tab Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace\cr
#'  \link[=managedgrafana_tag_resource]{tag_resource} \tab The TagResource operation associates tags with an Amazon Managed Grafana resource\cr
#'  \link[=managedgrafana_untag_resource]{untag_resource} \tab The UntagResource operation removes the association of the tag with the Amazon Managed Grafana resource\cr
#'  \link[=managedgrafana_update_permissions]{update_permissions} \tab Updates which users in a workspace have the Grafana Admin or Editor roles\cr
#'  \link[=managedgrafana_update_workspace]{update_workspace} \tab Modifies an existing Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_update_workspace_authentication]{update_workspace_authentication} \tab Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname managedgrafana
#' @export
managedgrafana <- function(config = list()) {
  svc <- .managedgrafana$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.managedgrafana <- list()

.managedgrafana$operations <- list()

.managedgrafana$metadata <- list(
  service_name = "managedgrafana",
  endpoints = list("*" = list(endpoint = "grafana.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "grafana.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "grafana.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "grafana.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "grafana",
  api_version = "2020-08-18",
  signing_name = "grafana",
  json_version = "1.1",
  target_prefix = ""
)

.managedgrafana$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.managedgrafana$metadata, handlers, config)
}
