% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_scaling_policy}
\alias{autoscaling_put_scaling_policy}
\title{Creates or updates a scaling policy for an Auto Scaling group}
\usage{
autoscaling_put_scaling_policy(AutoScalingGroupName, PolicyName,
  PolicyType, AdjustmentType, MinAdjustmentStep, MinAdjustmentMagnitude,
  ScalingAdjustment, Cooldown, MetricAggregationType, StepAdjustments,
  EstimatedInstanceWarmup, TargetTrackingConfiguration)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{PolicyName}{[required] The name of the policy.}

\item{PolicyType}{The policy type. The valid values are \code{SimpleScaling}, \code{StepScaling},
and \code{TargetTrackingScaling}. If the policy type is null, the value is
treated as \code{SimpleScaling}.}

\item{AdjustmentType}{Specifies whether the \code{ScalingAdjustment} parameter is an absolute
number or a percentage of the current capacity. The valid values are
\code{ChangeInCapacity}, \code{ExactCapacity}, and \code{PercentChangeInCapacity}.

Valid only if the policy type is \code{StepScaling} or \code{SimpleScaling}. For
more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment}{Scaling Adjustment Types}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MinAdjustmentStep}{Available for backward compatibility. Use \code{MinAdjustmentMagnitude}
instead.}

\item{MinAdjustmentMagnitude}{The minimum number of instances to scale. If the value of
\code{AdjustmentType} is \code{PercentChangeInCapacity}, the scaling policy
changes the \code{DesiredCapacity} of the Auto Scaling group by at least this
many instances. Otherwise, the error is \code{ValidationError}.

This property replaces the \code{MinAdjustmentStep} property. For example,
suppose that you create a step scaling policy to scale out an Auto
Scaling group by 25 percent and you specify a \code{MinAdjustmentMagnitude}
of 2. If the group has 4 instances and the scaling policy is performed,
25 percent of 4 is 1. However, because you specified a
\code{MinAdjustmentMagnitude} of 2, Amazon EC2 Auto Scaling scales out the
group by 2 instances.

Valid only if the policy type is \code{SimpleScaling} or \code{StepScaling}.}

\item{ScalingAdjustment}{The amount by which a simple scaling policy scales the Auto Scaling
group in response to an alarm breach. The adjustment is based on the
value that you specified in the \code{AdjustmentType} parameter (either an
absolute number or a percentage). A positive value adds to the current
capacity and a negative value subtracts from the current capacity. For
exact capacity, you must specify a positive value.

Conditional: If you specify \code{SimpleScaling} for the policy type, you
must specify this parameter. (Not used with any other policy type.)}

\item{Cooldown}{The amount of time, in seconds, after a scaling activity completes
before any further dynamic scaling activities can start. If this
parameter is not specified, the default cooldown period for the group
applies.

Valid only if the policy type is \code{SimpleScaling}. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html}{Scaling Cooldowns}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MetricAggregationType}{The aggregation type for the CloudWatch metrics. The valid values are
\code{Minimum}, \code{Maximum}, and \code{Average}. If the aggregation type is null,
the value is treated as \code{Average}.

Valid only if the policy type is \code{StepScaling}.}

\item{StepAdjustments}{A set of adjustments that enable you to scale based on the size of the
alarm breach.

Conditional: If you specify \code{StepScaling} for the policy type, you must
specify this parameter. (Not used with any other policy type.)}

\item{EstimatedInstanceWarmup}{The estimated time, in seconds, until a newly launched instance can
contribute to the CloudWatch metrics. The default is to use the value
specified for the default cooldown period for the group.

Valid only if the policy type is \code{StepScaling} or
\code{TargetTrackingScaling}.}

\item{TargetTrackingConfiguration}{A target tracking scaling policy. Includes support for predefined or
customized metrics.

For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html}{TargetTrackingConfiguration}
in the \emph{Amazon EC2 Auto Scaling API Reference}.

Conditional: If you specify \code{TargetTrackingScaling} for the policy type,
you must specify this parameter. (Not used with any other policy type.)}
}
\description{
Creates or updates a scaling policy for an Auto Scaling group. To update
an existing scaling policy, use the existing policy name and set the
parameters to change. Any existing parameter not changed in an update to
an existing policy is not changed in this update request.
}
\details{
For more information about using scaling policies to scale your Auto
Scaling group automatically, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scale-based-on-demand.html}{Dynamic Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_scaling_policy(
  AutoScalingGroupName = "string",
  PolicyName = "string",
  PolicyType = "string",
  AdjustmentType = "string",
  MinAdjustmentStep = 123,
  MinAdjustmentMagnitude = 123,
  ScalingAdjustment = 123,
  Cooldown = 123,
  MetricAggregationType = "string",
  StepAdjustments = list(
    list(
      MetricIntervalLowerBound = 123.0,
      MetricIntervalUpperBound = 123.0,
      ScalingAdjustment = 123
    )
  ),
  EstimatedInstanceWarmup = 123,
  TargetTrackingConfiguration = list(
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"ALBRequestCountPerTarget",
      ResourceLabel = "string"
    ),
    CustomizedMetricSpecification = list(
      MetricName = "string",
      Namespace = "string",
      Dimensions = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
      Unit = "string"
    ),
    TargetValue = 123.0,
    DisableScaleIn = TRUE|FALSE
  )
)
}
}

\examples{
# This example adds the specified policy to the specified Auto Scaling
# group.
\donttest{svc$put_scaling_policy(
  AdjustmentType = "ChangeInCapacity",
  AutoScalingGroupName = "my-auto-scaling-group",
  PolicyName = "ScaleIn",
  ScalingAdjustment = -1L
)}

}
\keyword{internal}
