% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_reset_service_setting}
\alias{ssm_reset_service_setting}
\title{ServiceSetting is an account-level setting for an AWS service}
\usage{
ssm_reset_service_setting(SettingId)
}
\arguments{
\item{SettingId}{[required] The ID of the service setting to reset.}
}
\description{
\code{ServiceSetting} is an account-level setting for an AWS service. This
setting defines how a user interacts with or uses a service or a feature
of a service. For example, if an AWS service charges money to the
account based on feature or service usage, then the AWS service team
might create a default setting of "false". This means the user can't
use this feature unless they change the setting to "true" and
intentionally opt in for a paid feature.
}
\details{
Services map a \code{SettingId} object to a setting value. AWS services teams
define the default value for a \code{SettingId}. You can't create a new
\code{SettingId}, but you can overwrite the default value if you have the
\code{ssm:UpdateServiceSetting} permission for the setting. Use the
GetServiceSetting API action to view the current value. Use the
UpdateServiceSetting API action to change the default setting.

Reset the service setting for the account to the default value as
provisioned by the AWS service team.
}
\section{Request syntax}{
\preformatted{svc$reset_service_setting(
  SettingId = "string"
)
}
}

\keyword{internal}
