% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_list_metrics}
\alias{cloudwatch_list_metrics}
\title{List the specified metrics}
\usage{
cloudwatch_list_metrics(Namespace, MetricName, Dimensions, NextToken)
}
\arguments{
\item{Namespace}{The namespace to filter against.}

\item{MetricName}{The name of the metric to filter against.}

\item{Dimensions}{The dimensions to filter against.}

\item{NextToken}{The token returned by a previous call to indicate that there is more
data available.}
}
\description{
List the specified metrics. You can use the returned metrics with
GetMetricData or GetMetricStatistics to obtain statistical data.
}
\details{
Up to 500 results are returned for any one call. To retrieve additional
results, use the returned token with subsequent calls.

After you create a metric, allow up to fifteen minutes before the metric
appears. Statistics about the metric, however, are available sooner
using GetMetricData or GetMetricStatistics.
}
\section{Request syntax}{
\preformatted{svc$list_metrics(
  Namespace = "string",
  MetricName = "string",
  Dimensions = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
