% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_association}
\alias{ssm_describe_association}
\title{Describes the association for the specified target or instance}
\usage{
ssm_describe_association(Name, InstanceId, AssociationId,
  AssociationVersion)
}
\arguments{
\item{Name}{The name of the Systems Manager document.}

\item{InstanceId}{The instance ID.}

\item{AssociationId}{The association ID for which you want information.}

\item{AssociationVersion}{Specify the association version to retrieve. To view the latest version,
either specify \code{$LATEST} for this parameter, or omit this parameter. To
view a list of all associations for an instance, use ListAssociations.
To get a list of versions for a specific association, use
ListAssociationVersions.}
}
\description{
Describes the association for the specified target or instance. If you
created the association by using the \code{Targets} parameter, then you must
retrieve the association by using the association ID. If you created the
association by specifying an instance ID and a Systems Manager document,
then you retrieve the association by specifying the document name and
the instance ID.
}
\section{Request syntax}{
\preformatted{svc$describe_association(
  Name = "string",
  InstanceId = "string",
  AssociationId = "string",
  AssociationVersion = "string"
)
}
}

\keyword{internal}
