# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include cloudwatch_service.R
NULL

#' Deletes the specified alarms
#'
#' Deletes the specified alarms. In the event of an error, no alarms are
#' deleted.
#'
#' @usage
#' cloudwatch_delete_alarms(AlarmNames)
#'
#' @param AlarmNames &#91;required&#93; The alarms to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_alarms(
#'   AlarmNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_alarms
cloudwatch_delete_alarms <- function(AlarmNames) {
  op <- new_operation(
    name = "DeleteAlarms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_alarms_input(AlarmNames = AlarmNames)
  output <- .cloudwatch$delete_alarms_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_alarms <- cloudwatch_delete_alarms

#' Deletes the specified anomaly detection model from your account
#'
#' Deletes the specified anomaly detection model from your account.
#'
#' @usage
#' cloudwatch_delete_anomaly_detector(Namespace, MetricName, Dimensions,
#'   Stat)
#'
#' @param Namespace &#91;required&#93; The namespace associated with the anomaly detection model to delete.
#' @param MetricName &#91;required&#93; The metric name associated with the anomaly detection model to delete.
#' @param Dimensions The metric dimensions associated with the anomaly detection model to
#' delete.
#' @param Stat &#91;required&#93; The statistic associated with the anomaly detection model to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_anomaly_detector(
#'   Namespace = "string",
#'   MetricName = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Stat = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_anomaly_detector
cloudwatch_delete_anomaly_detector <- function(Namespace, MetricName, Dimensions = NULL, Stat) {
  op <- new_operation(
    name = "DeleteAnomalyDetector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_anomaly_detector_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, Stat = Stat)
  output <- .cloudwatch$delete_anomaly_detector_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_anomaly_detector <- cloudwatch_delete_anomaly_detector

#' Deletes all dashboards that you specify
#'
#' Deletes all dashboards that you specify. You may specify up to 100
#' dashboards to delete. If there is an error during this call, no
#' dashboards are deleted.
#'
#' @usage
#' cloudwatch_delete_dashboards(DashboardNames)
#'
#' @param DashboardNames &#91;required&#93; The dashboards to be deleted. This parameter is required.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dashboards(
#'   DashboardNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_dashboards
cloudwatch_delete_dashboards <- function(DashboardNames) {
  op <- new_operation(
    name = "DeleteDashboards",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_dashboards_input(DashboardNames = DashboardNames)
  output <- .cloudwatch$delete_dashboards_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_dashboards <- cloudwatch_delete_dashboards

#' Retrieves the history for the specified alarm
#'
#' Retrieves the history for the specified alarm. You can filter the
#' results by date range or item type. If an alarm name is not specified,
#' the histories for all alarms are returned.
#' 
#' CloudWatch retains the history of an alarm even if you delete the alarm.
#'
#' @usage
#' cloudwatch_describe_alarm_history(AlarmName, HistoryItemType, StartDate,
#'   EndDate, MaxRecords, NextToken)
#'
#' @param AlarmName The name of the alarm.
#' @param HistoryItemType The type of alarm histories to retrieve.
#' @param StartDate The starting date to retrieve alarm history.
#' @param EndDate The ending date to retrieve alarm history.
#' @param MaxRecords The maximum number of alarm history records to retrieve.
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#'
#' @section Request syntax:
#' ```
#' svc$describe_alarm_history(
#'   AlarmName = "string",
#'   HistoryItemType = "ConfigurationUpdate"|"StateUpdate"|"Action",
#'   StartDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_alarm_history
cloudwatch_describe_alarm_history <- function(AlarmName = NULL, HistoryItemType = NULL, StartDate = NULL, EndDate = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAlarmHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$describe_alarm_history_input(AlarmName = AlarmName, HistoryItemType = HistoryItemType, StartDate = StartDate, EndDate = EndDate, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .cloudwatch$describe_alarm_history_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_alarm_history <- cloudwatch_describe_alarm_history

#' Retrieves the specified alarms
#'
#' Retrieves the specified alarms. If no alarms are specified, all alarms
#' are returned. Alarms can be retrieved by using only a prefix for the
#' alarm name, the alarm state, or a prefix for any action.
#'
#' @usage
#' cloudwatch_describe_alarms(AlarmNames, AlarmNamePrefix, StateValue,
#'   ActionPrefix, MaxRecords, NextToken)
#'
#' @param AlarmNames The names of the alarms.
#' @param AlarmNamePrefix The alarm name prefix. If this parameter is specified, you cannot
#' specify `AlarmNames`.
#' @param StateValue The state value to be used in matching alarms.
#' @param ActionPrefix The action name prefix.
#' @param MaxRecords The maximum number of alarm descriptions to retrieve.
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#'
#' @section Request syntax:
#' ```
#' svc$describe_alarms(
#'   AlarmNames = list(
#'     "string"
#'   ),
#'   AlarmNamePrefix = "string",
#'   StateValue = "OK"|"ALARM"|"INSUFFICIENT_DATA",
#'   ActionPrefix = "string",
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_alarms
cloudwatch_describe_alarms <- function(AlarmNames = NULL, AlarmNamePrefix = NULL, StateValue = NULL, ActionPrefix = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAlarms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$describe_alarms_input(AlarmNames = AlarmNames, AlarmNamePrefix = AlarmNamePrefix, StateValue = StateValue, ActionPrefix = ActionPrefix, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .cloudwatch$describe_alarms_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_alarms <- cloudwatch_describe_alarms

#' Retrieves the alarms for the specified metric
#'
#' Retrieves the alarms for the specified metric. To filter the results,
#' specify a statistic, period, or unit.
#'
#' @usage
#' cloudwatch_describe_alarms_for_metric(MetricName, Namespace, Statistic,
#'   ExtendedStatistic, Dimensions, Period, Unit)
#'
#' @param MetricName &#91;required&#93; The name of the metric.
#' @param Namespace &#91;required&#93; The namespace of the metric.
#' @param Statistic The statistic for the metric, other than percentiles. For percentile
#' statistics, use `ExtendedStatistics`.
#' @param ExtendedStatistic The percentile statistic for the metric. Specify a value between p0.0
#' and p100.
#' @param Dimensions The dimensions associated with the metric. If the metric has any
#' associated dimensions, you must specify them in order for the call to
#' succeed.
#' @param Period The period, in seconds, over which the statistic is applied.
#' @param Unit The unit for the metric.
#'
#' @section Request syntax:
#' ```
#' svc$describe_alarms_for_metric(
#'   MetricName = "string",
#'   Namespace = "string",
#'   Statistic = "SampleCount"|"Average"|"Sum"|"Minimum"|"Maximum",
#'   ExtendedStatistic = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Period = 123,
#'   Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_alarms_for_metric
cloudwatch_describe_alarms_for_metric <- function(MetricName, Namespace, Statistic = NULL, ExtendedStatistic = NULL, Dimensions = NULL, Period = NULL, Unit = NULL) {
  op <- new_operation(
    name = "DescribeAlarmsForMetric",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$describe_alarms_for_metric_input(MetricName = MetricName, Namespace = Namespace, Statistic = Statistic, ExtendedStatistic = ExtendedStatistic, Dimensions = Dimensions, Period = Period, Unit = Unit)
  output <- .cloudwatch$describe_alarms_for_metric_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_alarms_for_metric <- cloudwatch_describe_alarms_for_metric

#' Lists the anomaly detection models that you have created in your account
#'
#' Lists the anomaly detection models that you have created in your
#' account. You can list all models in your account or filter the results
#' to only the models that are related to a certain namespace, metric name,
#' or metric dimension.
#'
#' @usage
#' cloudwatch_describe_anomaly_detectors(NextToken, MaxResults, Namespace,
#'   MetricName, Dimensions)
#'
#' @param NextToken Use the token returned by the previous operation to request the next
#' page of results.
#' @param MaxResults The maximum number of results to return in one operation. The maximum
#' value you can specify is 10.
#' 
#' To retrieve the remaining results, make another call with the returned
#' `NextToken` value.
#' @param Namespace Limits the results to only the anomaly detection models that are
#' associated with the specified namespace.
#' @param MetricName Limits the results to only the anomaly detection models that are
#' associated with the specified metric name. If there are multiple metrics
#' with this name in different namespaces that have anomaly detection
#' models, they\'re all returned.
#' @param Dimensions Limits the results to only the anomaly detection models that are
#' associated with the specified metric dimensions. If there are multiple
#' metrics that have these dimensions and have anomaly detection models
#' associated, they\'re all returned.
#'
#' @section Request syntax:
#' ```
#' svc$describe_anomaly_detectors(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Namespace = "string",
#'   MetricName = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_anomaly_detectors
cloudwatch_describe_anomaly_detectors <- function(NextToken = NULL, MaxResults = NULL, Namespace = NULL, MetricName = NULL, Dimensions = NULL) {
  op <- new_operation(
    name = "DescribeAnomalyDetectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$describe_anomaly_detectors_input(NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions)
  output <- .cloudwatch$describe_anomaly_detectors_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_anomaly_detectors <- cloudwatch_describe_anomaly_detectors

#' Disables the actions for the specified alarms
#'
#' Disables the actions for the specified alarms. When an alarm\'s actions
#' are disabled, the alarm actions do not execute when the alarm state
#' changes.
#'
#' @usage
#' cloudwatch_disable_alarm_actions(AlarmNames)
#'
#' @param AlarmNames &#91;required&#93; The names of the alarms.
#'
#' @section Request syntax:
#' ```
#' svc$disable_alarm_actions(
#'   AlarmNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_disable_alarm_actions
cloudwatch_disable_alarm_actions <- function(AlarmNames) {
  op <- new_operation(
    name = "DisableAlarmActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$disable_alarm_actions_input(AlarmNames = AlarmNames)
  output <- .cloudwatch$disable_alarm_actions_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$disable_alarm_actions <- cloudwatch_disable_alarm_actions

#' Enables the actions for the specified alarms
#'
#' Enables the actions for the specified alarms.
#'
#' @usage
#' cloudwatch_enable_alarm_actions(AlarmNames)
#'
#' @param AlarmNames &#91;required&#93; The names of the alarms.
#'
#' @section Request syntax:
#' ```
#' svc$enable_alarm_actions(
#'   AlarmNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_enable_alarm_actions
cloudwatch_enable_alarm_actions <- function(AlarmNames) {
  op <- new_operation(
    name = "EnableAlarmActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$enable_alarm_actions_input(AlarmNames = AlarmNames)
  output <- .cloudwatch$enable_alarm_actions_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$enable_alarm_actions <- cloudwatch_enable_alarm_actions

#' Displays the details of the dashboard that you specify
#'
#' Displays the details of the dashboard that you specify.
#' 
#' To copy an existing dashboard, use `GetDashboard`, and then use the data
#' returned within `DashboardBody` as the template for the new dashboard
#' when you call `PutDashboard` to create the copy.
#'
#' @usage
#' cloudwatch_get_dashboard(DashboardName)
#'
#' @param DashboardName &#91;required&#93; The name of the dashboard to be described.
#'
#' @section Request syntax:
#' ```
#' svc$get_dashboard(
#'   DashboardName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_dashboard
cloudwatch_get_dashboard <- function(DashboardName) {
  op <- new_operation(
    name = "GetDashboard",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_dashboard_input(DashboardName = DashboardName)
  output <- .cloudwatch$get_dashboard_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_dashboard <- cloudwatch_get_dashboard

#' You can use the GetMetricData API to retrieve as many as 100 different
#' metrics in a single request, with a total of as many as 100,800
#' datapoints
#'
#' You can use the `GetMetricData` API to retrieve as many as 100 different
#' metrics in a single request, with a total of as many as 100,800
#' datapoints. You can also optionally perform math expressions on the
#' values of the returned statistics, to create new time series that
#' represent new insights into your data. For example, using Lambda
#' metrics, you could divide the Errors metric by the Invocations metric to
#' get an error rate time series. For more information about metric math
#' expressions, see [Metric Math Syntax and
#' Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
#' in the *Amazon CloudWatch User Guide*.
#' 
#' Calls to the `GetMetricData` API have a different pricing structure than
#' calls to `GetMetricStatistics`. For more information about pricing, see
#' [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' Amazon CloudWatch retains metric data as follows:
#' 
#' -   Data points with a period of less than 60 seconds are available for
#'     3 hours. These data points are high-resolution metrics and are
#'     available only for custom metrics that have been defined with a
#'     `StorageResolution` of 1.
#' 
#' -   Data points with a period of 60 seconds (1-minute) are available for
#'     15 days.
#' 
#' -   Data points with a period of 300 seconds (5-minute) are available
#'     for 63 days.
#' 
#' -   Data points with a period of 3600 seconds (1 hour) are available for
#'     455 days (15 months).
#' 
#' Data points that are initially published with a shorter period are
#' aggregated together for long-term storage. For example, if you collect
#' data using a period of 1 minute, the data remains available for 15 days
#' with 1-minute resolution. After 15 days, this data is still available,
#' but is aggregated and retrievable only with a resolution of 5 minutes.
#' After 63 days, the data is further aggregated and is available with a
#' resolution of 1 hour.
#'
#' @usage
#' cloudwatch_get_metric_data(MetricDataQueries, StartTime, EndTime,
#'   NextToken, ScanBy, MaxDatapoints)
#'
#' @param MetricDataQueries &#91;required&#93; The metric queries to be returned. A single `GetMetricData` call can
#' include as many as 100 `MetricDataQuery` structures. Each of these
#' structures can specify either a metric to retrieve, or a math expression
#' to perform on retrieved data.
#' @param StartTime &#91;required&#93; The time stamp indicating the earliest data to be returned.
#' 
#' For better performance, specify `StartTime` and `EndTime` values that
#' align with the value of the metric\'s `Period` and sync up with the
#' beginning and end of an hour. For example, if the `Period` of a metric
#' is 5 minutes, specifying 12:05 or 12:30 as `StartTime` can get a faster
#' response from CloudWatch than setting 12:07 or 12:29 as the `StartTime`.
#' @param EndTime &#91;required&#93; The time stamp indicating the latest data to be returned.
#' 
#' For better performance, specify `StartTime` and `EndTime` values that
#' align with the value of the metric\'s `Period` and sync up with the
#' beginning and end of an hour. For example, if the `Period` of a metric
#' is 5 minutes, specifying 12:05 or 12:30 as `EndTime` can get a faster
#' response from CloudWatch than setting 12:07 or 12:29 as the `EndTime`.
#' @param NextToken Include this value, if it was returned by the previous call, to get the
#' next set of data points.
#' @param ScanBy The order in which data points should be returned. `TimestampDescending`
#' returns the newest data first and paginates when the `MaxDatapoints`
#' limit is reached. `TimestampAscending` returns the oldest data first and
#' paginates when the `MaxDatapoints` limit is reached.
#' @param MaxDatapoints The maximum number of data points the request should return before
#' paginating. If you omit this, the default of 100,800 is used.
#'
#' @section Request syntax:
#' ```
#' svc$get_metric_data(
#'   MetricDataQueries = list(
#'     list(
#'       Id = "string",
#'       MetricStat = list(
#'         Metric = list(
#'           Namespace = "string",
#'           MetricName = "string",
#'           Dimensions = list(
#'             list(
#'               Name = "string",
#'               Value = "string"
#'             )
#'           )
#'         ),
#'         Period = 123,
#'         Stat = "string",
#'         Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'       ),
#'       Expression = "string",
#'       Label = "string",
#'       ReturnData = TRUE|FALSE
#'     )
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string",
#'   ScanBy = "TimestampDescending"|"TimestampAscending",
#'   MaxDatapoints = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_data
cloudwatch_get_metric_data <- function(MetricDataQueries, StartTime, EndTime, NextToken = NULL, ScanBy = NULL, MaxDatapoints = NULL) {
  op <- new_operation(
    name = "GetMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_metric_data_input(MetricDataQueries = MetricDataQueries, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, ScanBy = ScanBy, MaxDatapoints = MaxDatapoints)
  output <- .cloudwatch$get_metric_data_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_data <- cloudwatch_get_metric_data

#' Gets statistics for the specified metric
#'
#' Gets statistics for the specified metric.
#' 
#' The maximum number of data points returned from a single call is 1,440.
#' If you request more than 1,440 data points, CloudWatch returns an error.
#' To reduce the number of data points, you can narrow the specified time
#' range and make multiple requests across adjacent time ranges, or you can
#' increase the specified period. Data points are not returned in
#' chronological order.
#' 
#' CloudWatch aggregates data points based on the length of the period that
#' you specify. For example, if you request statistics with a one-hour
#' period, CloudWatch aggregates all data points with time stamps that fall
#' within each one-hour period. Therefore, the number of values aggregated
#' by CloudWatch is larger than the number of data points returned.
#' 
#' CloudWatch needs raw data points to calculate percentile statistics. If
#' you publish data using a statistic set instead, you can only retrieve
#' percentile statistics for this data if one of the following conditions
#' is true:
#' 
#' -   The SampleCount value of the statistic set is 1.
#' 
#' -   The Min and the Max values of the statistic set are equal.
#' 
#' Percentile statistics are not available for metrics when any of the
#' metric values are negative numbers.
#' 
#' Amazon CloudWatch retains metric data as follows:
#' 
#' -   Data points with a period of less than 60 seconds are available for
#'     3 hours. These data points are high-resolution metrics and are
#'     available only for custom metrics that have been defined with a
#'     `StorageResolution` of 1.
#' 
#' -   Data points with a period of 60 seconds (1-minute) are available for
#'     15 days.
#' 
#' -   Data points with a period of 300 seconds (5-minute) are available
#'     for 63 days.
#' 
#' -   Data points with a period of 3600 seconds (1 hour) are available for
#'     455 days (15 months).
#' 
#' Data points that are initially published with a shorter period are
#' aggregated together for long-term storage. For example, if you collect
#' data using a period of 1 minute, the data remains available for 15 days
#' with 1-minute resolution. After 15 days, this data is still available,
#' but is aggregated and retrievable only with a resolution of 5 minutes.
#' After 63 days, the data is further aggregated and is available with a
#' resolution of 1 hour.
#' 
#' CloudWatch started retaining 5-minute and 1-hour metric data as of July
#' 9, 2016.
#' 
#' For information about metrics and dimensions supported by AWS services,
#' see the [Amazon CloudWatch Metrics and Dimensions
#' Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html)
#' in the *Amazon CloudWatch User Guide*.
#'
#' @usage
#' cloudwatch_get_metric_statistics(Namespace, MetricName, Dimensions,
#'   StartTime, EndTime, Period, Statistics, ExtendedStatistics, Unit)
#'
#' @param Namespace &#91;required&#93; The namespace of the metric, with or without spaces.
#' @param MetricName &#91;required&#93; The name of the metric, with or without spaces.
#' @param Dimensions The dimensions. If the metric contains multiple dimensions, you must
#' include a value for each dimension. CloudWatch treats each unique
#' combination of dimensions as a separate metric. If a specific
#' combination of dimensions was not published, you can\'t retrieve
#' statistics for it. You must specify the same dimensions that were used
#' when the metrics were created. For an example, see [Dimension
#' Combinations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations)
#' in the *Amazon CloudWatch User Guide*. For more information about
#' specifying dimensions, see [Publishing
#' Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
#' in the *Amazon CloudWatch User Guide*.
#' @param StartTime &#91;required&#93; The time stamp that determines the first data point to return. Start
#' times are evaluated relative to the time that CloudWatch receives the
#' request.
#' 
#' The value specified is inclusive; results include data points with the
#' specified time stamp. The time stamp must be in ISO 8601 UTC format (for
#' example, 2016-10-03T23:00:00Z).
#' 
#' CloudWatch rounds the specified time stamp as follows:
#' 
#' -   Start time less than 15 days ago - Round down to the nearest whole
#'     minute. For example, 12:32:34 is rounded down to 12:32:00.
#' 
#' -   Start time between 15 and 63 days ago - Round down to the nearest
#'     5-minute clock interval. For example, 12:32:34 is rounded down to
#'     12:30:00.
#' 
#' -   Start time greater than 63 days ago - Round down to the nearest
#'     1-hour clock interval. For example, 12:32:34 is rounded down to
#'     12:00:00.
#' 
#' If you set `Period` to 5, 10, or 30, the start time of your request is
#' rounded down to the nearest time that corresponds to even 5-, 10-, or
#' 30-second divisions of a minute. For example, if you make a query at
#' (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of
#' your request is rounded down and you receive data from 01:05:10 to
#' 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of
#' data, using a period of 5 seconds, you receive data timestamped between
#' 15:02:15 and 15:07:15.
#' @param EndTime &#91;required&#93; The time stamp that determines the last data point to return.
#' 
#' The value specified is exclusive; results include data points up to the
#' specified time stamp. The time stamp must be in ISO 8601 UTC format (for
#' example, 2016-10-10T23:00:00Z).
#' @param Period &#91;required&#93; The granularity, in seconds, of the returned data points. For metrics
#' with regular resolution, a period can be as short as one minute (60
#' seconds) and must be a multiple of 60. For high-resolution metrics that
#' are collected at intervals of less than one minute, the period can be 1,
#' 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those
#' metrics stored by a `PutMetricData` call that includes a
#' `StorageResolution` of 1 second.
#' 
#' If the `StartTime` parameter specifies a time stamp that is greater than
#' 3 hours ago, you must specify the period as follows or no data points in
#' that time range is returned:
#' 
#' -   Start time between 3 hours and 15 days ago - Use a multiple of 60
#'     seconds (1 minute).
#' 
#' -   Start time between 15 and 63 days ago - Use a multiple of 300
#'     seconds (5 minutes).
#' 
#' -   Start time greater than 63 days ago - Use a multiple of 3600 seconds
#'     (1 hour).
#' @param Statistics The metric statistics, other than percentile. For percentile statistics,
#' use `ExtendedStatistics`. When calling `GetMetricStatistics`, you must
#' specify either `Statistics` or `ExtendedStatistics`, but not both.
#' @param ExtendedStatistics The percentile statistics. Specify values between p0.0 and p100. When
#' calling `GetMetricStatistics`, you must specify either `Statistics` or
#' `ExtendedStatistics`, but not both. Percentile statistics are not
#' available for metrics when any of the metric values are negative
#' numbers.
#' @param Unit The unit for a given metric. Metrics may be reported in multiple units.
#' Not supplying a unit results in all units being returned. If you specify
#' only a unit that the metric does not report, the results of the call are
#' null.
#'
#' @section Request syntax:
#' ```
#' svc$get_metric_statistics(
#'   Namespace = "string",
#'   MetricName = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Period = 123,
#'   Statistics = list(
#'     "SampleCount"|"Average"|"Sum"|"Minimum"|"Maximum"
#'   ),
#'   ExtendedStatistics = list(
#'     "string"
#'   ),
#'   Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_statistics
cloudwatch_get_metric_statistics <- function(Namespace, MetricName, Dimensions = NULL, StartTime, EndTime, Period, Statistics = NULL, ExtendedStatistics = NULL, Unit = NULL) {
  op <- new_operation(
    name = "GetMetricStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_metric_statistics_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, StartTime = StartTime, EndTime = EndTime, Period = Period, Statistics = Statistics, ExtendedStatistics = ExtendedStatistics, Unit = Unit)
  output <- .cloudwatch$get_metric_statistics_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_statistics <- cloudwatch_get_metric_statistics

#' You can use the GetMetricWidgetImage API to retrieve a snapshot graph of
#' one or more Amazon CloudWatch metrics as a bitmap image
#'
#' You can use the `GetMetricWidgetImage` API to retrieve a snapshot graph
#' of one or more Amazon CloudWatch metrics as a bitmap image. You can then
#' embed this image into your services and products, such as wiki pages,
#' reports, and documents. You could also retrieve images regularly, such
#' as every minute, and create your own custom live dashboard.
#' 
#' The graph you retrieve can include all CloudWatch metric graph features,
#' including metric math and horizontal and vertical annotations.
#' 
#' There is a limit of 20 transactions per second for this API. Each
#' `GetMetricWidgetImage` action has the following limits:
#' 
#' -   As many as 100 metrics in the graph.
#' 
#' -   Up to 100 KB uncompressed payload.
#'
#' @usage
#' cloudwatch_get_metric_widget_image(MetricWidget, OutputFormat)
#'
#' @param MetricWidget &#91;required&#93; A JSON string that defines the bitmap graph to be retrieved. The string
#' includes the metrics to include in the graph, statistics, annotations,
#' title, axis limits, and so on. You can include only one `MetricWidget`
#' parameter in each `GetMetricWidgetImage` call.
#' 
#' For more information about the syntax of `MetricWidget` see
#' CloudWatch-Metric-Widget-Structure.
#' 
#' If any metric on the graph could not load all the requested data points,
#' an orange triangle with an exclamation point appears next to the graph
#' legend.
#' @param OutputFormat The format of the resulting image. Only PNG images are supported.
#' 
#' The default is `png`. If you specify `png`, the API returns an HTTP
#' response with the content-type set to `text/xml`. The image data is in a
#' `MetricWidgetImage` field. For example:
#' 
#' ` &lt;GetMetricWidgetImageResponse xmlns=&lt;URLstring&gt;&gt;`
#' 
#' ` &lt;GetMetricWidgetImageResult&gt;`
#' 
#' ` &lt;MetricWidgetImage&gt;`
#' 
#' ` iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...`
#' 
#' ` &lt;/MetricWidgetImage&gt;`
#' 
#' ` &lt;/GetMetricWidgetImageResult&gt;`
#' 
#' ` &lt;ResponseMetadata&gt;`
#' 
#' ` &lt;RequestId&gt;6f0d4192-4d42-11e8-82c1-f539a07e0e3b&lt;/RequestId&gt;`
#' 
#' ` &lt;/ResponseMetadata&gt;`
#' 
#' `&lt;/GetMetricWidgetImageResponse&gt;`
#' 
#' The `image/png` setting is intended only for custom HTTP requests. For
#' most use cases, and all actions using an AWS SDK, you should use `png`.
#' If you specify `image/png`, the HTTP response has a content-type set to
#' `image/png`, and the body of the response is a PNG image.
#'
#' @section Request syntax:
#' ```
#' svc$get_metric_widget_image(
#'   MetricWidget = "string",
#'   OutputFormat = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_widget_image
cloudwatch_get_metric_widget_image <- function(MetricWidget, OutputFormat = NULL) {
  op <- new_operation(
    name = "GetMetricWidgetImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_metric_widget_image_input(MetricWidget = MetricWidget, OutputFormat = OutputFormat)
  output <- .cloudwatch$get_metric_widget_image_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_widget_image <- cloudwatch_get_metric_widget_image

#' Returns a list of the dashboards for your account
#'
#' Returns a list of the dashboards for your account. If you include
#' `DashboardNamePrefix`, only those dashboards with names starting with
#' the prefix are listed. Otherwise, all dashboards in your account are
#' listed.
#' 
#' `ListDashboards` returns up to 1000 results on one page. If there are
#' more than 1000 dashboards, you can call `ListDashboards` again and
#' include the value you received for `NextToken` in the first call, to
#' receive the next 1000 results.
#'
#' @usage
#' cloudwatch_list_dashboards(DashboardNamePrefix, NextToken)
#'
#' @param DashboardNamePrefix If you specify this parameter, only the dashboards with names starting
#' with the specified string are listed. The maximum length is 255, and
#' valid characters are A-Z, a-z, 0-9, \".\", \"-\", and \"\\_\".
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#'
#' @section Request syntax:
#' ```
#' svc$list_dashboards(
#'   DashboardNamePrefix = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_dashboards
cloudwatch_list_dashboards <- function(DashboardNamePrefix = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDashboards",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$list_dashboards_input(DashboardNamePrefix = DashboardNamePrefix, NextToken = NextToken)
  output <- .cloudwatch$list_dashboards_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_dashboards <- cloudwatch_list_dashboards

#' List the specified metrics
#'
#' List the specified metrics. You can use the returned metrics with
#' GetMetricData or GetMetricStatistics to obtain statistical data.
#' 
#' Up to 500 results are returned for any one call. To retrieve additional
#' results, use the returned token with subsequent calls.
#' 
#' After you create a metric, allow up to fifteen minutes before the metric
#' appears. Statistics about the metric, however, are available sooner
#' using GetMetricData or GetMetricStatistics.
#'
#' @usage
#' cloudwatch_list_metrics(Namespace, MetricName, Dimensions, NextToken)
#'
#' @param Namespace The namespace to filter against.
#' @param MetricName The name of the metric to filter against.
#' @param Dimensions The dimensions to filter against.
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#'
#' @section Request syntax:
#' ```
#' svc$list_metrics(
#'   Namespace = "string",
#'   MetricName = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_metrics
cloudwatch_list_metrics <- function(Namespace = NULL, MetricName = NULL, Dimensions = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$list_metrics_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, NextToken = NextToken)
  output <- .cloudwatch$list_metrics_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_metrics <- cloudwatch_list_metrics

#' Displays the tags associated with a CloudWatch resource
#'
#' Displays the tags associated with a CloudWatch resource. Alarms support
#' tagging.
#'
#' @usage
#' cloudwatch_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch resource that you want to view tags for. For
#' more information on ARN format, see [Example
#' ARNs](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-cloudwatch)
#' in the *Amazon Web Services General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_tags_for_resource
cloudwatch_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloudwatch$list_tags_for_resource_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_tags_for_resource <- cloudwatch_list_tags_for_resource

#' Creates an anomaly detection model for a CloudWatch metric
#'
#' Creates an anomaly detection model for a CloudWatch metric. You can use
#' the model to display a band of expected normal values when the metric is
#' graphed.
#' 
#' For more information, see [CloudWatch Anomaly
#' Detection](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html).
#'
#' @usage
#' cloudwatch_put_anomaly_detector(Namespace, MetricName, Dimensions, Stat,
#'   Configuration)
#'
#' @param Namespace &#91;required&#93; The namespace of the metric to create the anomaly detection model for.
#' @param MetricName &#91;required&#93; The name of the metric to create the anomaly detection model for.
#' @param Dimensions The metric dimensions to create the anomaly detection model for.
#' @param Stat &#91;required&#93; The statistic to use for the metric and the anomaly detection model.
#' @param Configuration The configuration specifies details about how the anomaly detection
#' model is to be trained, including time ranges to exclude when training
#' and updating the model. You can specify as many as 10 time ranges.
#' 
#' The configuration can also include the time zone to use for the metric.
#' 
#' You can in
#'
#' @section Request syntax:
#' ```
#' svc$put_anomaly_detector(
#'   Namespace = "string",
#'   MetricName = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Stat = "string",
#'   Configuration = list(
#'     ExcludedTimeRanges = list(
#'       list(
#'         StartTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         EndTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     MetricTimezone = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_anomaly_detector
cloudwatch_put_anomaly_detector <- function(Namespace, MetricName, Dimensions = NULL, Stat, Configuration = NULL) {
  op <- new_operation(
    name = "PutAnomalyDetector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_anomaly_detector_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, Stat = Stat, Configuration = Configuration)
  output <- .cloudwatch$put_anomaly_detector_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_anomaly_detector <- cloudwatch_put_anomaly_detector

#' Creates a dashboard if it does not already exist, or updates an existing
#' dashboard
#'
#' Creates a dashboard if it does not already exist, or updates an existing
#' dashboard. If you update a dashboard, the entire contents are replaced
#' with what you specify here.
#' 
#' All dashboards in your account are global, not region-specific.
#' 
#' A simple way to create a dashboard using `PutDashboard` is to copy an
#' existing dashboard. To copy an existing dashboard using the console, you
#' can load the dashboard and then use the View/edit source command in the
#' Actions menu to display the JSON block for that dashboard. Another way
#' to copy a dashboard is to use `GetDashboard`, and then use the data
#' returned within `DashboardBody` as the template for the new dashboard
#' when you call `PutDashboard`.
#' 
#' When you create a dashboard with `PutDashboard`, a good practice is to
#' add a text widget at the top of the dashboard with a message that the
#' dashboard was created by script and should not be changed in the
#' console. This message could also point console users to the location of
#' the `DashboardBody` script or the CloudFormation template used to create
#' the dashboard.
#'
#' @usage
#' cloudwatch_put_dashboard(DashboardName, DashboardBody)
#'
#' @param DashboardName &#91;required&#93; The name of the dashboard. If a dashboard with this name already exists,
#' this call modifies that dashboard, replacing its current contents.
#' Otherwise, a new dashboard is created. The maximum length is 255, and
#' valid characters are A-Z, a-z, 0-9, \"-\", and \"\\_\". This parameter is
#' required.
#' @param DashboardBody &#91;required&#93; The detailed information about the dashboard in JSON format, including
#' the widgets to include and their location on the dashboard. This
#' parameter is required.
#' 
#' For more information about the syntax, see
#' CloudWatch-Dashboard-Body-Structure.
#'
#' @section Request syntax:
#' ```
#' svc$put_dashboard(
#'   DashboardName = "string",
#'   DashboardBody = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_dashboard
cloudwatch_put_dashboard <- function(DashboardName, DashboardBody) {
  op <- new_operation(
    name = "PutDashboard",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_dashboard_input(DashboardName = DashboardName, DashboardBody = DashboardBody)
  output <- .cloudwatch$put_dashboard_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_dashboard <- cloudwatch_put_dashboard

#' Creates or updates an alarm and associates it with the specified metric,
#' metric math expression, or anomaly detection model
#'
#' Creates or updates an alarm and associates it with the specified metric,
#' metric math expression, or anomaly detection model.
#' 
#' Alarms based on anomaly detection models cannot have Auto Scaling
#' actions.
#' 
#' When this operation creates an alarm, the alarm state is immediately set
#' to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set
#' appropriately. Any actions associated with the new state are then
#' executed.
#' 
#' When you update an existing alarm, its state is left unchanged, but the
#' update completely overwrites the previous configuration of the alarm.
#' 
#' If you are an IAM user, you must have Amazon EC2 permissions for some
#' alarm operations:
#' 
#' -   `iam:CreateServiceLinkedRole` for all alarms with EC2 actions
#' 
#' -   `ec2:DescribeInstanceStatus` and `ec2:DescribeInstances` for all
#'     alarms on EC2 instance status metrics
#' 
#' -   `ec2:StopInstances` for alarms with stop actions
#' 
#' -   `ec2:TerminateInstances` for alarms with terminate actions
#' 
#' -   No specific permissions are needed for alarms with recover actions
#' 
#' If you have read/write permissions for Amazon CloudWatch but not for
#' Amazon EC2, you can still create an alarm, but the stop or terminate
#' actions are not performed. However, if you are later granted the
#' required permissions, the alarm actions that you created earlier are
#' performed.
#' 
#' If you are using an IAM role (for example, an EC2 instance profile), you
#' cannot stop or terminate the instance using alarm actions. However, you
#' can still see the alarm state and perform any other actions such as
#' Amazon SNS notifications or Auto Scaling policies.
#' 
#' If you are using temporary security credentials granted using AWS STS,
#' you cannot stop or terminate an EC2 instance using alarm actions.
#' 
#' The first time you create an alarm in the AWS Management Console, the
#' CLI, or by using the PutMetricAlarm API, CloudWatch creates the
#' necessary service-linked role for you. The service-linked role is called
#' `AWSServiceRoleForCloudWatchEvents`. For more information, see [AWS
#' service-linked
#' role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role).
#'
#' @usage
#' cloudwatch_put_metric_alarm(AlarmName, AlarmDescription, ActionsEnabled,
#'   OKActions, AlarmActions, InsufficientDataActions, MetricName, Namespace,
#'   Statistic, ExtendedStatistic, Dimensions, Period, Unit,
#'   EvaluationPeriods, DatapointsToAlarm, Threshold, ComparisonOperator,
#'   TreatMissingData, EvaluateLowSampleCountPercentile, Metrics, Tags,
#'   ThresholdMetricId)
#'
#' @param AlarmName &#91;required&#93; The name for the alarm. This name must be unique within your AWS
#' account.
#' @param AlarmDescription The description for the alarm.
#' @param ActionsEnabled Indicates whether actions should be executed during any changes to the
#' alarm state. The default is TRUE.
#' @param OKActions The actions to execute when this alarm transitions to an `OK` state from
#' any other state. Each action is specified as an Amazon Resource Name
#' (ARN).
#' 
#' Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` \\|
#' `arn:aws:automate:<i>region</i>:ec2:terminate` \\|
#' `arn:aws:automate:<i>region</i>:ec2:recover` \\|
#' `arn:aws:automate:<i>region</i>:ec2:reboot` \\|
#' `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` \\|
#' `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
#' 
#' Valid Values (for use with IAM roles):
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0`
#' \\|
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0`
#' \\|
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
#' @param AlarmActions The actions to execute when this alarm transitions to the `ALARM` state
#' from any other state. Each action is specified as an Amazon Resource
#' Name (ARN).
#' 
#' Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` \\|
#' `arn:aws:automate:<i>region</i>:ec2:terminate` \\|
#' `arn:aws:automate:<i>region</i>:ec2:recover` \\|
#' `arn:aws:automate:<i>region</i>:ec2:reboot` \\|
#' `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` \\|
#' `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
#' 
#' Valid Values (for use with IAM roles):
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0`
#' \\|
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0`
#' \\|
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
#' @param InsufficientDataActions The actions to execute when this alarm transitions to the
#' `INSUFFICIENT_DATA` state from any other state. Each action is specified
#' as an Amazon Resource Name (ARN).
#' 
#' Valid Values: `arn:aws:automate:<i>region</i>:ec2:stop` \\|
#' `arn:aws:automate:<i>region</i>:ec2:terminate` \\|
#' `arn:aws:automate:<i>region</i>:ec2:recover` \\|
#' `arn:aws:automate:<i>region</i>:ec2:reboot` \\|
#' `arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> ` \\|
#' `arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> `
#' 
#' Valid Values (for use with IAM roles):
#' `&gt;arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0`
#' \\|
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0`
#' \\|
#' `arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
#' @param MetricName The name for the metric associated with the alarm.
#' 
#' If you are creating an alarm based on a math expression, you cannot
#' specify this parameter, or any of the `Dimensions`, `Period`,
#' `Namespace`, `Statistic`, or `ExtendedStatistic` parameters. Instead,
#' you specify all this information in the `Metrics` array.
#' @param Namespace The namespace for the metric associated specified in `MetricName`.
#' @param Statistic The statistic for the metric specified in `MetricName`, other than
#' percentile. For percentile statistics, use `ExtendedStatistic`. When you
#' call `PutMetricAlarm` and specify a `MetricName`, you must specify
#' either `Statistic` or `ExtendedStatistic,` but not both.
#' @param ExtendedStatistic The percentile statistic for the metric specified in `MetricName`.
#' Specify a value between p0.0 and p100. When you call `PutMetricAlarm`
#' and specify a `MetricName`, you must specify either `Statistic` or
#' `ExtendedStatistic,` but not both.
#' @param Dimensions The dimensions for the metric specified in `MetricName`.
#' @param Period The length, in seconds, used each time the metric specified in
#' `MetricName` is evaluated. Valid values are 10, 30, and any multiple of
#' 60.
#' 
#' Be sure to specify 10 or 30 only for metrics that are stored by a
#' `PutMetricData` call with a `StorageResolution` of 1. If you specify a
#' period of 10 or 30 for a metric that does not have sub-minute
#' resolution, the alarm still attempts to gather data at the period rate
#' that you specify. In this case, it does not receive data for the
#' attempts that do not correspond to a one-minute data resolution, and the
#' alarm may often lapse into INSUFFICENT\\_DATA status. Specifying 10 or 30
#' also sets this alarm as a high-resolution alarm, which has a higher
#' charge than other alarms. For more information about pricing, see
#' [Amazon CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' An alarm\'s total current evaluation period can be no longer than one
#' day, so `Period` multiplied by `EvaluationPeriods` cannot be more than
#' 86,400 seconds.
#' @param Unit The unit of measure for the statistic. For example, the units for the
#' Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the
#' number of bytes that an instance receives on all network interfaces. You
#' can also specify a unit when you create a custom metric. Units help
#' provide conceptual meaning to your data. Metric data points that specify
#' a unit of measure, such as Percent, are aggregated separately.
#' 
#' If you specify a unit, you must use a unit that is appropriate for the
#' metric. Otherwise, the CloudWatch alarm can get stuck in the
#' `INSUFFICIENT DATA` state.
#' @param EvaluationPeriods &#91;required&#93; The number of periods over which data is compared to the specified
#' threshold. If you are setting an alarm that requires that a number of
#' consecutive data points be breaching to trigger the alarm, this value
#' specifies that number. If you are setting an \"M out of N\" alarm, this
#' value is the N.
#' 
#' An alarm\'s total current evaluation period can be no longer than one
#' day, so this number multiplied by `Period` cannot be more than 86,400
#' seconds.
#' @param DatapointsToAlarm The number of datapoints that must be breaching to trigger the alarm.
#' This is used only if you are setting an \"M out of N\" alarm. In that
#' case, this value is the M. For more information, see [Evaluating an
#' Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation)
#' in the *Amazon CloudWatch User Guide*.
#' @param Threshold The value against which the specified statistic is compared.
#' @param ComparisonOperator &#91;required&#93; The arithmetic operation to use when comparing the specified statistic
#' and threshold. The specified statistic value is used as the first
#' operand.
#' 
#' The values `LessThanLowerOrGreaterThanUpperThreshold`,
#' `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only
#' for alarms based on anomaly detection models.
#' @param TreatMissingData Sets how this alarm is to handle missing data points. If
#' `TreatMissingData` is omitted, the default behavior of `missing` is
#' used. For more information, see [Configuring How CloudWatch Alarms
#' Treats Missing
#' Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
#' 
#' Valid Values: `breaching | notBreaching | ignore | missing`
#' @param EvaluateLowSampleCountPercentile Used only for alarms based on percentiles. If you specify `ignore`, the
#' alarm state does not change during periods with too few data points to
#' be statistically significant. If you specify `evaluate` or omit this
#' parameter, the alarm is always evaluated and possibly changes state no
#' matter how many data points are available. For more information, see
#' [Percentile-Based CloudWatch Alarms and Low Data
#' Samples](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
#' 
#' Valid Values: `evaluate | ignore`
#' @param Metrics An array of `MetricDataQuery` structures that enable you to create an
#' alarm based on the result of a metric math expression. Each item in the
#' `Metrics` array either retrieves a metric or performs a math expression.
#' 
#' One item in the `Metrics` array is the expression that the alarm
#' watches. You designate this expression by setting `ReturnValue` to true
#' for this object in the array. For more information, see MetricDataQuery.
#' 
#' If you use the `Metrics` parameter, you cannot include the `MetricName`,
#' `Dimensions`, `Period`, `Namespace`, `Statistic`, or `ExtendedStatistic`
#' parameters of `PutMetricAlarm` in the same operation. Instead, you
#' retrieve the metrics you are using in your math expression as part of
#' the `Metrics` array.
#' @param Tags A list of key-value pairs to associate with the alarm. You can associate
#' as many as 50 tags with an alarm.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions, by granting a user permission to
#' access or change only resources with certain tag values.
#' @param ThresholdMetricId If this is an alarm based on an anomaly detection model, make this value
#' match the ID of the `ANOMALY_DETECTION_BAND` function.
#' 
#' For an example of how to use this parameter, see the **Anomaly Detection
#' Model Alarm** example on this page.
#' 
#' If your alarm uses this parameter, it cannot have Auto Scaling actions.
#'
#' @section Request syntax:
#' ```
#' svc$put_metric_alarm(
#'   AlarmName = "string",
#'   AlarmDescription = "string",
#'   ActionsEnabled = TRUE|FALSE,
#'   OKActions = list(
#'     "string"
#'   ),
#'   AlarmActions = list(
#'     "string"
#'   ),
#'   InsufficientDataActions = list(
#'     "string"
#'   ),
#'   MetricName = "string",
#'   Namespace = "string",
#'   Statistic = "SampleCount"|"Average"|"Sum"|"Minimum"|"Maximum",
#'   ExtendedStatistic = "string",
#'   Dimensions = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Period = 123,
#'   Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   EvaluationPeriods = 123,
#'   DatapointsToAlarm = 123,
#'   Threshold = 123.0,
#'   ComparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold"|"LessThanLowerOrGreaterThanUpperThreshold"|"LessThanLowerThreshold"|"GreaterThanUpperThreshold",
#'   TreatMissingData = "string",
#'   EvaluateLowSampleCountPercentile = "string",
#'   Metrics = list(
#'     list(
#'       Id = "string",
#'       MetricStat = list(
#'         Metric = list(
#'           Namespace = "string",
#'           MetricName = "string",
#'           Dimensions = list(
#'             list(
#'               Name = "string",
#'               Value = "string"
#'             )
#'           )
#'         ),
#'         Period = 123,
#'         Stat = "string",
#'         Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'       ),
#'       Expression = "string",
#'       Label = "string",
#'       ReturnData = TRUE|FALSE
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ThresholdMetricId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_metric_alarm
cloudwatch_put_metric_alarm <- function(AlarmName, AlarmDescription = NULL, ActionsEnabled = NULL, OKActions = NULL, AlarmActions = NULL, InsufficientDataActions = NULL, MetricName = NULL, Namespace = NULL, Statistic = NULL, ExtendedStatistic = NULL, Dimensions = NULL, Period = NULL, Unit = NULL, EvaluationPeriods, DatapointsToAlarm = NULL, Threshold = NULL, ComparisonOperator, TreatMissingData = NULL, EvaluateLowSampleCountPercentile = NULL, Metrics = NULL, Tags = NULL, ThresholdMetricId = NULL) {
  op <- new_operation(
    name = "PutMetricAlarm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_metric_alarm_input(AlarmName = AlarmName, AlarmDescription = AlarmDescription, ActionsEnabled = ActionsEnabled, OKActions = OKActions, AlarmActions = AlarmActions, InsufficientDataActions = InsufficientDataActions, MetricName = MetricName, Namespace = Namespace, Statistic = Statistic, ExtendedStatistic = ExtendedStatistic, Dimensions = Dimensions, Period = Period, Unit = Unit, EvaluationPeriods = EvaluationPeriods, DatapointsToAlarm = DatapointsToAlarm, Threshold = Threshold, ComparisonOperator = ComparisonOperator, TreatMissingData = TreatMissingData, EvaluateLowSampleCountPercentile = EvaluateLowSampleCountPercentile, Metrics = Metrics, Tags = Tags, ThresholdMetricId = ThresholdMetricId)
  output <- .cloudwatch$put_metric_alarm_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_metric_alarm <- cloudwatch_put_metric_alarm

#' Publishes metric data points to Amazon CloudWatch
#'
#' Publishes metric data points to Amazon CloudWatch. CloudWatch associates
#' the data points with the specified metric. If the specified metric does
#' not exist, CloudWatch creates the metric. When CloudWatch creates a
#' metric, it can take up to fifteen minutes for the metric to appear in
#' calls to ListMetrics.
#' 
#' You can publish either individual data points in the `Value` field, or
#' arrays of values and the number of times each value occurred during the
#' period by using the `Values` and `Counts` fields in the `MetricDatum`
#' structure. Using the `Values` and `Counts` method enables you to publish
#' up to 150 values per metric with one `PutMetricData` request, and
#' supports retrieving percentile statistics on this data.
#' 
#' Each `PutMetricData` request is limited to 40 KB in size for HTTP POST
#' requests. You can send a payload compressed by gzip. Each request is
#' also limited to no more than 20 different metrics.
#' 
#' Although the `Value` parameter accepts numbers of type `Double`,
#' CloudWatch rejects values that are either too small or too large. Values
#' must be in the range of 8.515920e-109 to 1.174271e+108 (Base 10) or
#' 2e-360 to 2e360 (Base 2). In addition, special values (for example, NaN,
#' +Infinity, -Infinity) are not supported.
#' 
#' You can use up to 10 dimensions per metric to further clarify what data
#' the metric collects. Each dimension consists of a Name and Value pair.
#' For more information about specifying dimensions, see [Publishing
#' Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
#' in the *Amazon CloudWatch User Guide*.
#' 
#' Data points with time stamps from 24 hours ago or longer can take at
#' least 48 hours to become available for GetMetricData or
#' GetMetricStatistics from the time they are submitted.
#' 
#' CloudWatch needs raw data points to calculate percentile statistics. If
#' you publish data using a statistic set instead, you can only retrieve
#' percentile statistics for this data if one of the following conditions
#' is true:
#' 
#' -   The `SampleCount` value of the statistic set is 1 and `Min`, `Max`,
#'     and `Sum` are all equal.
#' 
#' -   The `Min` and `Max` are equal, and `Sum` is equal to `Min`
#'     multiplied by `SampleCount`.
#'
#' @usage
#' cloudwatch_put_metric_data(Namespace, MetricData)
#'
#' @param Namespace &#91;required&#93; The namespace for the metric data.
#' 
#' You cannot specify a namespace that begins with \"AWS/\". Namespaces
#' that begin with \"AWS/\" are reserved for use by Amazon Web Services
#' products.
#' @param MetricData &#91;required&#93; The data for the metric. The array can include no more than 20 metrics
#' per call.
#'
#' @section Request syntax:
#' ```
#' svc$put_metric_data(
#'   Namespace = "string",
#'   MetricData = list(
#'     list(
#'       MetricName = "string",
#'       Dimensions = list(
#'         list(
#'           Name = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Value = 123.0,
#'       StatisticValues = list(
#'         SampleCount = 123.0,
#'         Sum = 123.0,
#'         Minimum = 123.0,
#'         Maximum = 123.0
#'       ),
#'       Values = list(
#'         123.0
#'       ),
#'       Counts = list(
#'         123.0
#'       ),
#'       Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'       StorageResolution = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_metric_data
cloudwatch_put_metric_data <- function(Namespace, MetricData) {
  op <- new_operation(
    name = "PutMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_metric_data_input(Namespace = Namespace, MetricData = MetricData)
  output <- .cloudwatch$put_metric_data_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_metric_data <- cloudwatch_put_metric_data

#' Temporarily sets the state of an alarm for testing purposes
#'
#' Temporarily sets the state of an alarm for testing purposes. When the
#' updated state differs from the previous value, the action configured for
#' the appropriate state is invoked. For example, if your alarm is
#' configured to send an Amazon SNS message when an alarm is triggered,
#' temporarily changing the alarm state to `ALARM` sends an SNS message.
#' The alarm returns to its actual state (often within seconds). Because
#' the alarm state change happens quickly, it is typically only visible in
#' the alarm\'s **History** tab in the Amazon CloudWatch console or through
#' DescribeAlarmHistory.
#'
#' @usage
#' cloudwatch_set_alarm_state(AlarmName, StateValue, StateReason,
#'   StateReasonData)
#'
#' @param AlarmName &#91;required&#93; The name for the alarm. This name must be unique within the AWS account.
#' The maximum length is 255 characters.
#' @param StateValue &#91;required&#93; The value of the state.
#' @param StateReason &#91;required&#93; The reason that this alarm is set to this specific state, in text
#' format.
#' @param StateReasonData The reason that this alarm is set to this specific state, in JSON
#' format.
#'
#' @section Request syntax:
#' ```
#' svc$set_alarm_state(
#'   AlarmName = "string",
#'   StateValue = "OK"|"ALARM"|"INSUFFICIENT_DATA",
#'   StateReason = "string",
#'   StateReasonData = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_set_alarm_state
cloudwatch_set_alarm_state <- function(AlarmName, StateValue, StateReason, StateReasonData = NULL) {
  op <- new_operation(
    name = "SetAlarmState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$set_alarm_state_input(AlarmName = AlarmName, StateValue = StateValue, StateReason = StateReason, StateReasonData = StateReasonData)
  output <- .cloudwatch$set_alarm_state_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$set_alarm_state <- cloudwatch_set_alarm_state

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' resource
#'
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' resource. Tags can help you organize and categorize your resources. You
#' can also use them to scope user permissions, by granting a user
#' permission to access or change only resources with certain tag values.
#' In CloudWatch, alarms can be tagged.
#' 
#' Tags don\'t have any semantic meaning to AWS and are interpreted
#' strictly as strings of characters.
#' 
#' You can use the `TagResource` action with a resource that already has
#' tags. If you specify a new tag key for the resource, this tag is
#' appended to the list of tags associated with the resource. If you
#' specify a tag key that is already associated with the resource, the new
#' tag value that you specify replaces the previous value for that tag.
#' 
#' You can associate as many as 50 tags with a resource.
#'
#' @usage
#' cloudwatch_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch resource that you\'re adding tags to. For more
#' information on ARN format, see [Example
#' ARNs](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-cloudwatch)
#' in the *Amazon Web Services General Reference*.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_tag_resource
cloudwatch_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloudwatch$tag_resource_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$tag_resource <- cloudwatch_tag_resource

#' Removes one or more tags from the specified resource
#'
#' Removes one or more tags from the specified resource.
#'
#' @usage
#' cloudwatch_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch resource that you\'re removing tags from. For
#' more information on ARN format, see [Example
#' ARNs](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-cloudwatch)
#' in the *Amazon Web Services General Reference*.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatch_untag_resource
cloudwatch_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloudwatch$untag_resource_output()
  svc <- .cloudwatch$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$untag_resource <- cloudwatch_untag_resource
