% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_budgets_for_resource}
\alias{servicecatalog_list_budgets_for_resource}
\title{Lists all the budgets associated to the specified resource}
\usage{
servicecatalog_list_budgets_for_resource(AcceptLanguage, ResourceId,
  PageSize, PageToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ResourceId}{[required] The resource identifier.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}
}
\value{
A list with the following syntax:\preformatted{list(
  Budgets = list(
    list(
      BudgetName = "string"
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Lists all the budgets associated to the specified resource.
}
\section{Request syntax}{
\preformatted{svc$list_budgets_for_resource(
  AcceptLanguage = "string",
  ResourceId = "string",
  PageSize = 123,
  PageToken = "string"
)
}
}

\keyword{internal}
