% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_organization_config_rule_statuses}
\alias{configservice_describe_organization_config_rule_statuses}
\title{Provides organization config rule deployment status for an organization}
\usage{
configservice_describe_organization_config_rule_statuses(
  OrganizationConfigRuleNames, Limit, NextToken)
}
\arguments{
\item{OrganizationConfigRuleNames}{The names of organization config rules for which you want status
details. If you do not specify any names, AWS Config returns details for
all your organization AWS Confg rules.}

\item{Limit}{The maximum number of \code{OrganizationConfigRuleStatuses} returned on each
page. If you do no specify a number, AWS Config uses the default. The
default is 100.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Provides organization config rule deployment status for an organization.

The status is not considered successful until organization config rule
is successfully deployed in all the member accounts with an exception of
excluded accounts.

When you specify the limit and the next token, you receive a paginated
response. Limit and next token are not applicable if you specify
organization config rule names. It is only applicable, when you request
all the organization config rules.
}
\section{Request syntax}{
\preformatted{svc$describe_organization_config_rule_statuses(
  OrganizationConfigRuleNames = list(
    "string"
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
