% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_create_log_stream}
\alias{cloudwatchlogs_create_log_stream}
\title{Creates a log stream for the specified log group}
\usage{
cloudwatchlogs_create_log_stream(logGroupName, logStreamName)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{logStreamName}{[required] The name of the log stream.}
}
\description{
Creates a log stream for the specified log group. A log stream is a
sequence of log events that originate from a single source, such as an
application instance or a resource that is being monitored.

There is no limit on the number of log streams that you can create for a
log group. There is a limit of 50 TPS on \code{CreateLogStream} operations,
after which transactions are throttled.

You must use the following guidelines when naming a log stream:
\itemize{
\item Log stream names must be unique within the log group.
\item Log stream names can be between 1 and 512 characters long.
\item The ':' (colon) and '*' (asterisk) characters are not allowed.
}
}
\section{Request syntax}{
\preformatted{svc$create_log_stream(
  logGroupName = "string",
  logStreamName = "string"
)
}
}

\keyword{internal}
