% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_create_stack}
\alias{cloudformation_create_stack}
\title{Creates a stack as specified in the template}
\usage{
cloudformation_create_stack(StackName, TemplateBody, TemplateURL,
  Parameters, DisableRollback, RollbackConfiguration, TimeoutInMinutes,
  NotificationARNs, Capabilities, ResourceTypes, RoleARN, OnFailure,
  StackPolicyBody, StackPolicyURL, Tags, ClientRequestToken,
  EnableTerminationProtection)
}
\arguments{
\item{StackName}{[required] The name that is associated with the stack. The name must be unique in
the Region in which you are creating the stack.

A stack name can contain only alphanumeric characters (case sensitive)
and hyphens. It must start with an alphabetic character and cannot be
longer than 128 characters.}

\item{TemplateBody}{Structure containing the template body with a minimum length of 1 byte
and a maximum length of 51,200 bytes. For more information, go to
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify either the \code{TemplateBody} or the
\code{TemplateURL} parameter, but not both.}

\item{TemplateURL}{Location of file containing the template body. The URL must point to a
template (max size: 460,800 bytes) that is located in an Amazon S3
bucket. For more information, go to the \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify either the \code{TemplateBody} or the
\code{TemplateURL} parameter, but not both.}

\item{Parameters}{A list of \code{Parameter} structures that specify input parameters for the
stack. For more information, see the
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html}{Parameter}
data type.}

\item{DisableRollback}{Set to \code{true} to disable rollback of the stack if stack creation failed.
You can specify either \code{DisableRollback} or \code{OnFailure}, but not both.

Default: \code{false}}

\item{RollbackConfiguration}{The rollback triggers for AWS CloudFormation to monitor during stack
creation and updating operations, and for the specified monitoring
period afterwards.}

\item{TimeoutInMinutes}{The amount of time that can pass before the stack status becomes
CREATE\\_FAILED; if \code{DisableRollback} is not set or is set to \code{false},
the stack will be rolled back.}

\item{NotificationARNs}{The Simple Notification Service (SNS) topic ARNs to publish stack
related events. You can find your SNS topic ARNs using the SNS console
or your Command Line Interface (CLI).}

\item{Capabilities}{In some cases, you must explicitly acknowledge that your stack template
contains certain capabilities in order for AWS CloudFormation to create
the stack.
\itemize{
\item \code{CAPABILITY_IAM} and \code{CAPABILITY_NAMED_IAM}

Some stack templates might include resources that can affect
permissions in your AWS account; for example, by creating new AWS
Identity and Access Management (IAM) users. For those stacks, you
must explicitly acknowledge this by specifying one of these
capabilities.

The following IAM resources require you to specify either the
\code{CAPABILITY_IAM} or \code{CAPABILITY_NAMED_IAM} capability.
\itemize{
\item If you have IAM resources, you can specify either capability.
\item If you have IAM resources with custom names, you \emph{must} specify
\code{CAPABILITY_NAMED_IAM}.
\item If you don't specify either of these capabilities, AWS
CloudFormation returns an \code{InsufficientCapabilities} error.
}

If your stack template contains these resources, we recommend that
you review all permissions associated with them and edit their
permissions if necessary.
\itemize{
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html}{AWS::IAM::AccessKey}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html}{AWS::IAM::Group}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html}{AWS::IAM::Policy}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html}{AWS::IAM::User}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html}{AWS::IAM::UserToGroupAddition}
}

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities}{Acknowledging IAM Resources in AWS CloudFormation Templates}.
\item \code{CAPABILITY_AUTO_EXPAND}

Some template contain macros. Macros perform custom processing on
templates; this can include simple actions like find-and-replace
operations, all the way to extensive transformations of entire
templates. Because of this, users typically create a change set from
the processed template, so that they can review the changes
resulting from the macros before actually creating the stack. If
your stack template contains one or more macros, and you choose to
create a stack directly from the processed template, without first
reviewing the resulting changes in a change set, you must
acknowledge this capability. This includes the
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html}{AWS::Include}
and
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html}{AWS::Serverless}
transforms, which are macros hosted by AWS CloudFormation.

If you want to create a stack from a stack template that contains
macros \emph{and} nested stacks, you must create the stack directly from
the template using this capability.

You should only create stacks directly from a stack template that
contains macros if you know what processing the macro performs.

Each macro relies on an underlying Lambda service function for
processing stack templates. Be aware that the Lambda function owner
can update the function operation without AWS CloudFormation being
notified.

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html}{Using AWS CloudFormation Macros to Perform Custom Processing on Templates}.
}}

\item{ResourceTypes}{The template resource types that you have permissions to work with for
this create stack action, such as \verb{AWS::EC2::Instance}, \verb{AWS::EC2::*},
or \code{Custom::MyCustomInstance}. Use the following syntax to describe
template resource types: \verb{AWS::*} (for all AWS resource), \verb{Custom::*}
(for all custom resources), \verb{Custom::<i>logical_ID</i> } (for a specific
custom resource), \verb{AWS::<i>service_name</i>::*} (for all resources of a
particular AWS service), and
\verb{AWS::<i>service_name</i>::<i>resource_logical_ID</i> } (for a specific
AWS resource).

If the list of resource types doesn't include a resource that you're
creating, the stack creation fails. By default, AWS CloudFormation
grants permissions to all resource types. AWS Identity and Access
Management (IAM) uses this parameter for AWS CloudFormation-specific
condition keys in IAM policies. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html}{Controlling Access with AWS Identity and Access Management}.}

\item{RoleARN}{The Amazon Resource Name (ARN) of an AWS Identity and Access Management
(IAM) role that AWS CloudFormation assumes to create the stack. AWS
CloudFormation uses the role's credentials to make calls on your behalf.
AWS CloudFormation always uses this role for all future operations on
the stack. As long as users have permission to operate on the stack, AWS
CloudFormation uses this role even if the users don't have permission to
pass it. Ensure that the role grants least privilege.

If you don't specify a value, AWS CloudFormation uses the role that was
previously associated with the stack. If no role is available, AWS
CloudFormation uses a temporary session that is generated from your user
credentials.}

\item{OnFailure}{Determines what action will be taken if stack creation fails. This must
be one of: DO\\_NOTHING, ROLLBACK, or DELETE. You can specify either
\code{OnFailure} or \code{DisableRollback}, but not both.

Default: \code{ROLLBACK}}

\item{StackPolicyBody}{Structure containing the stack policy body. For more information, go to
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html}{Prevent Updates to Stack Resources}
in the \emph{AWS CloudFormation User Guide}. You can specify either the
\code{StackPolicyBody} or the \code{StackPolicyURL} parameter, but not both.}

\item{StackPolicyURL}{Location of a file containing the stack policy. The URL must point to a
policy (maximum size: 16 KB) located in an S3 bucket in the same Region
as the stack. You can specify either the \code{StackPolicyBody} or the
\code{StackPolicyURL} parameter, but not both.}

\item{Tags}{Key-value pairs to associate with this stack. AWS CloudFormation also
propagates these tags to the resources created in the stack. A maximum
number of 50 tags can be specified.}

\item{ClientRequestToken}{A unique identifier for this \code{CreateStack} request. Specify this token
if you plan to retry requests so that AWS CloudFormation knows that
you're not attempting to create a stack with the same name. You might
retry \code{CreateStack} requests to ensure that AWS CloudFormation
successfully received them.

All events triggered by a given stack operation are assigned the same
client request token, which you can use to track operations. For
example, if you execute a \code{CreateStack} operation with the token
\code{token1}, then all the \code{StackEvents} generated by that operation will
have \code{ClientRequestToken} set as \code{token1}.

In the console, stack operations display the client request token on the
Events tab. Stack operations that are initiated from the console use the
token format \emph{Console-StackOperation-ID}, which helps you easily
identify the stack operation . For example, if you create a stack using
the console, each stack event would be assigned the same token in the
following format:
\verb{Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002}.}

\item{EnableTerminationProtection}{Whether to enable termination protection on the specified stack. If a
user attempts to delete a stack with termination protection enabled, the
operation fails and the stack remains unchanged. For more information,
see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html}{Protecting a Stack From Being Deleted}
in the \emph{AWS CloudFormation User Guide}. Termination protection is
disabled on stacks by default.

For \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html}{nested stacks},
termination protection is set on the root stack and cannot be changed
directly on the nested stack.}
}
\description{
Creates a stack as specified in the template. After the call completes
successfully, the stack creation starts. You can check the status of the
stack via the DescribeStacks API.
}
\section{Request syntax}{
\preformatted{svc$create_stack(
  StackName = "string",
  TemplateBody = "string",
  TemplateURL = "string",
  Parameters = list(
    list(
      ParameterKey = "string",
      ParameterValue = "string",
      UsePreviousValue = TRUE|FALSE,
      ResolvedValue = "string"
    )
  ),
  DisableRollback = TRUE|FALSE,
  RollbackConfiguration = list(
    RollbackTriggers = list(
      list(
        Arn = "string",
        Type = "string"
      )
    ),
    MonitoringTimeInMinutes = 123
  ),
  TimeoutInMinutes = 123,
  NotificationARNs = list(
    "string"
  ),
  Capabilities = list(
    "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
  ),
  ResourceTypes = list(
    "string"
  ),
  RoleARN = "string",
  OnFailure = "DO_NOTHING"|"ROLLBACK"|"DELETE",
  StackPolicyBody = "string",
  StackPolicyURL = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  ClientRequestToken = "string",
  EnableTerminationProtection = TRUE|FALSE
)
}
}

\keyword{internal}
