% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_update_solution}
\alias{personalize_update_solution}
\title{Updates an Amazon Personalize solution to use a different automatic
training configuration}
\usage{
personalize_update_solution(
  solutionArn,
  performAutoTraining = NULL,
  solutionUpdateConfig = NULL
)
}
\arguments{
\item{solutionArn}{[required] The Amazon Resource Name (ARN) of the solution to update.}

\item{performAutoTraining}{Whether the solution uses automatic training to create new solution
versions (trained models). You can change the training frequency by
specifying a \code{schedulingExpression} in the \code{AutoTrainingConfig} as part
of solution configuration.

If you turn on automatic training, the first automatic training starts
within one hour after the solution update completes. If you manually
create a solution version within the hour, the solution skips the first
automatic training. For more information about automatic training, see
\href{https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html}{Configuring automatic training}.

After training starts, you can get the solution version's Amazon
Resource Name (ARN) with the
\code{\link[=personalize_list_solution_versions]{list_solution_versions}} API
operation. To get its status, use the
\code{\link[=personalize_describe_solution_version]{describe_solution_version}}.}

\item{solutionUpdateConfig}{The new configuration details of the solution.}
}
\description{
Updates an Amazon Personalize solution to use a different automatic training configuration. When you update a solution, you can change whether the solution uses automatic training, and you can change the training frequency. For more information about updating a solution, see \href{https://docs.aws.amazon.com/personalize/latest/dg/updating-solution.html}{Updating a solution}.

See \url{https://www.paws-r-sdk.com/docs/personalize_update_solution/} for full documentation.
}
\keyword{internal}
