# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include bedrockruntime_service.R
NULL

#' The action to apply a guardrail
#'
#' @description
#' The action to apply a guardrail.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_apply_guardrail/](https://www.paws-r-sdk.com/docs/bedrockruntime_apply_guardrail/) for full documentation.
#'
#' @param guardrailIdentifier &#91;required&#93; The guardrail identifier used in the request to apply the guardrail.
#' @param guardrailVersion &#91;required&#93; The guardrail version used in the request to apply the guardrail.
#' @param source &#91;required&#93; The source of data used in the request to apply the guardrail.
#' @param content &#91;required&#93; The content details used in the request to apply the guardrail.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_apply_guardrail
bedrockruntime_apply_guardrail <- function(guardrailIdentifier, guardrailVersion, source, content) {
  op <- new_operation(
    name = "ApplyGuardrail",
    http_method = "POST",
    http_path = "/guardrail/{guardrailIdentifier}/version/{guardrailVersion}/apply",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockruntime$apply_guardrail_input(guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion, source = source, content = content)
  output <- .bedrockruntime$apply_guardrail_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$apply_guardrail <- bedrockruntime_apply_guardrail

#' Sends messages to the specified Amazon Bedrock model
#'
#' @description
#' Sends messages to the specified Amazon Bedrock model. [`converse`][bedrockruntime_converse] provides a consistent interface that works with all models that support messages. This allows you to write code once and use it with different models. If a model has unique inference parameters, you can also pass those unique parameters to the model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_converse/](https://www.paws-r-sdk.com/docs/bedrockruntime_converse/) for full documentation.
#'
#' @param modelId &#91;required&#93; Specifies the model or throughput with which to run inference, or the
#' prompt resource to use in inference. The value depends on the resource
#' that you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an inference profile, specify the inference profile ID or
#'     its ARN. For a list of inference profile IDs, see [Supported Regions
#'     and models for cross-region
#'     inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   To include a prompt that was defined in [Prompt
#'     management](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html),
#'     specify the ARN of the prompt version to use.
#' 
#' The Converse API doesn't support [imported
#' models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html).
#' @param messages The messages that you want to send to the model.
#' @param system A prompt that provides instructions or context to the model about the
#' task it should perform, or the persona it should adopt during the
#' conversation.
#' @param inferenceConfig Inference parameters to pass to the model.
#' [`converse`][bedrockruntime_converse] and
#' [`converse_stream`][bedrockruntime_converse_stream] support a base set
#' of inference parameters. If you need to pass additional parameters that
#' the model supports, use the `additionalModelRequestFields` request
#' field.
#' @param toolConfig Configuration information for the tools that the model can use when
#' generating a response.
#' 
#' For information about models that support tool use, see [Supported
#' models and model
#' features](https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference.html#conversation-inference-supported-models-features).
#' @param guardrailConfig Configuration information for a guardrail that you want to use in the
#' request. If you include `guardContent` blocks in the `content` field in
#' the `messages` field, the guardrail operates only on those messages. If
#' you include no `guardContent` blocks, the guardrail operates on all
#' messages in the request body and in any included prompt resource.
#' @param additionalModelRequestFields Additional inference parameters that the model supports, beyond the base
#' set of inference parameters that [`converse`][bedrockruntime_converse]
#' and [`converse_stream`][bedrockruntime_converse_stream] support in the
#' `inferenceConfig` field. For more information, see [Model
#' parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
#' @param promptVariables Contains a map of variables in a prompt from Prompt management to
#' objects containing the values to fill in for them when running model
#' invocation. This field is ignored if you don't specify a prompt resource
#' in the `modelId` field.
#' @param additionalModelResponseFieldPaths Additional model parameters field paths to return in the response.
#' [`converse`][bedrockruntime_converse] and
#' [`converse_stream`][bedrockruntime_converse_stream] return the requested
#' fields as a JSON Pointer object in the `additionalModelResponseFields`
#' field. The following is example JSON for
#' `additionalModelResponseFieldPaths`.
#' 
#' `[ "/stop_sequence" ]`
#' 
#' For information about the JSON Pointer syntax, see the [Internet
#' Engineering Task Force
#' (IETF)](https://datatracker.ietf.org/doc/html/rfc6901) documentation.
#' 
#' [`converse`][bedrockruntime_converse] and
#' [`converse_stream`][bedrockruntime_converse_stream] reject an empty JSON
#' Pointer or incorrectly structured JSON Pointer with a `400` error code.
#' if the JSON Pointer is valid, but the requested field is not in the
#' model response, it is ignored by [`converse`][bedrockruntime_converse].
#' @param requestMetadata Key-value pairs that you can use to filter invocation logs.
#' @param performanceConfig Model performance settings for the request.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_converse
bedrockruntime_converse <- function(modelId, messages = NULL, system = NULL, inferenceConfig = NULL, toolConfig = NULL, guardrailConfig = NULL, additionalModelRequestFields = NULL, promptVariables = NULL, additionalModelResponseFieldPaths = NULL, requestMetadata = NULL, performanceConfig = NULL) {
  op <- new_operation(
    name = "Converse",
    http_method = "POST",
    http_path = "/model/{modelId}/converse",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockruntime$converse_input(modelId = modelId, messages = messages, system = system, inferenceConfig = inferenceConfig, toolConfig = toolConfig, guardrailConfig = guardrailConfig, additionalModelRequestFields = additionalModelRequestFields, promptVariables = promptVariables, additionalModelResponseFieldPaths = additionalModelResponseFieldPaths, requestMetadata = requestMetadata, performanceConfig = performanceConfig)
  output <- .bedrockruntime$converse_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$converse <- bedrockruntime_converse

#' Sends messages to the specified Amazon Bedrock model and returns the
#' response in a stream
#'
#' @description
#' Sends messages to the specified Amazon Bedrock model and returns the response in a stream. [`converse_stream`][bedrockruntime_converse_stream] provides a consistent API that works with all Amazon Bedrock models that support messages. This allows you to write code once and use it with different models. Should a model have unique inference parameters, you can also pass those unique parameters to the model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_converse_stream/](https://www.paws-r-sdk.com/docs/bedrockruntime_converse_stream/) for full documentation.
#'
#' @param modelId &#91;required&#93; Specifies the model or throughput with which to run inference, or the
#' prompt resource to use in inference. The value depends on the resource
#' that you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an inference profile, specify the inference profile ID or
#'     its ARN. For a list of inference profile IDs, see [Supported Regions
#'     and models for cross-region
#'     inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   To include a prompt that was defined in [Prompt
#'     management](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html),
#'     specify the ARN of the prompt version to use.
#' 
#' The Converse API doesn't support [imported
#' models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html).
#' @param messages The messages that you want to send to the model.
#' @param system A prompt that provides instructions or context to the model about the
#' task it should perform, or the persona it should adopt during the
#' conversation.
#' @param inferenceConfig Inference parameters to pass to the model.
#' [`converse`][bedrockruntime_converse] and
#' [`converse_stream`][bedrockruntime_converse_stream] support a base set
#' of inference parameters. If you need to pass additional parameters that
#' the model supports, use the `additionalModelRequestFields` request
#' field.
#' @param toolConfig Configuration information for the tools that the model can use when
#' generating a response.
#' 
#' For information about models that support streaming tool use, see
#' [Supported models and model
#' features](https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference.html#conversation-inference-supported-models-features).
#' @param guardrailConfig Configuration information for a guardrail that you want to use in the
#' request. If you include `guardContent` blocks in the `content` field in
#' the `messages` field, the guardrail operates only on those messages. If
#' you include no `guardContent` blocks, the guardrail operates on all
#' messages in the request body and in any included prompt resource.
#' @param additionalModelRequestFields Additional inference parameters that the model supports, beyond the base
#' set of inference parameters that [`converse`][bedrockruntime_converse]
#' and [`converse_stream`][bedrockruntime_converse_stream] support in the
#' `inferenceConfig` field. For more information, see [Model
#' parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
#' @param promptVariables Contains a map of variables in a prompt from Prompt management to
#' objects containing the values to fill in for them when running model
#' invocation. This field is ignored if you don't specify a prompt resource
#' in the `modelId` field.
#' @param additionalModelResponseFieldPaths Additional model parameters field paths to return in the response.
#' [`converse`][bedrockruntime_converse] and
#' [`converse_stream`][bedrockruntime_converse_stream] return the requested
#' fields as a JSON Pointer object in the `additionalModelResponseFields`
#' field. The following is example JSON for
#' `additionalModelResponseFieldPaths`.
#' 
#' `[ "/stop_sequence" ]`
#' 
#' For information about the JSON Pointer syntax, see the [Internet
#' Engineering Task Force
#' (IETF)](https://datatracker.ietf.org/doc/html/rfc6901) documentation.
#' 
#' [`converse`][bedrockruntime_converse] and
#' [`converse_stream`][bedrockruntime_converse_stream] reject an empty JSON
#' Pointer or incorrectly structured JSON Pointer with a `400` error code.
#' if the JSON Pointer is valid, but the requested field is not in the
#' model response, it is ignored by [`converse`][bedrockruntime_converse].
#' @param requestMetadata Key-value pairs that you can use to filter invocation logs.
#' @param performanceConfig Model performance settings for the request.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_converse_stream
bedrockruntime_converse_stream <- function(modelId, messages = NULL, system = NULL, inferenceConfig = NULL, toolConfig = NULL, guardrailConfig = NULL, additionalModelRequestFields = NULL, promptVariables = NULL, additionalModelResponseFieldPaths = NULL, requestMetadata = NULL, performanceConfig = NULL) {
  op <- new_operation(
    name = "ConverseStream",
    http_method = "POST",
    http_path = "/model/{modelId}/converse-stream",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockruntime$converse_stream_input(modelId = modelId, messages = messages, system = system, inferenceConfig = inferenceConfig, toolConfig = toolConfig, guardrailConfig = guardrailConfig, additionalModelRequestFields = additionalModelRequestFields, promptVariables = promptVariables, additionalModelResponseFieldPaths = additionalModelResponseFieldPaths, requestMetadata = requestMetadata, performanceConfig = performanceConfig)
  output <- .bedrockruntime$converse_stream_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$converse_stream <- bedrockruntime_converse_stream

#' Retrieve information about an asynchronous invocation
#'
#' @description
#' Retrieve information about an asynchronous invocation.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_get_async_invoke/](https://www.paws-r-sdk.com/docs/bedrockruntime_get_async_invoke/) for full documentation.
#'
#' @param invocationArn &#91;required&#93; The invocation's ARN.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_get_async_invoke
bedrockruntime_get_async_invoke <- function(invocationArn) {
  op <- new_operation(
    name = "GetAsyncInvoke",
    http_method = "GET",
    http_path = "/async-invoke/{invocationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockruntime$get_async_invoke_input(invocationArn = invocationArn)
  output <- .bedrockruntime$get_async_invoke_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$get_async_invoke <- bedrockruntime_get_async_invoke

#' Invokes the specified Amazon Bedrock model to run inference using the
#' prompt and inference parameters provided in the request body
#'
#' @description
#' Invokes the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. You use model inference to generate text, images, and embeddings.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model/](https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model/) for full documentation.
#'
#' @param body The prompt and inference parameters in the format specified in the
#' `contentType` in the header. You must provide the body in JSON format.
#' To see the format and content of the request and response bodies for
#' different models, refer to [Inference
#' parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
#' For more information, see [Run
#' inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference.html)
#' in the Bedrock User Guide.
#' @param contentType The MIME type of the input data in the request. You must specify
#' `application/json`.
#' @param accept The desired MIME type of the inference body in the response. The default
#' value is `application/json`.
#' @param modelId &#91;required&#93; The unique identifier of the model to invoke to run inference.
#' 
#' The `modelId` to provide depends on the type of model or throughput that
#' you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an inference profile, specify the inference profile ID or
#'     its ARN. For a list of inference profile IDs, see [Supported Regions
#'     and models for cross-region
#'     inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an [imported
#'     model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html),
#'     specify the ARN of the imported model. You can get the model ARN
#'     from a successful call to
#'     [CreateModelImportJob](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html)
#'     or from the Imported models page in the Amazon Bedrock console.
#' @param trace Specifies whether to enable or disable the Bedrock trace. If enabled,
#' you can see the full Bedrock trace.
#' @param guardrailIdentifier The unique identifier of the guardrail that you want to use. If you
#' don't provide a value, no guardrail is applied to the invocation.
#' 
#' An error will be thrown in the following situations.
#' 
#' -   You don't provide a guardrail identifier but you specify the
#'     `amazon-bedrock-guardrailConfig` field in the request body.
#' 
#' -   You enable the guardrail but the `contentType` isn't
#'     `application/json`.
#' 
#' -   You provide a guardrail identifier, but `guardrailVersion` isn't
#'     specified.
#' @param guardrailVersion The version number for the guardrail. The value can also be `DRAFT`.
#' @param performanceConfigLatency Model performance settings for the request.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_invoke_model
bedrockruntime_invoke_model <- function(body = NULL, contentType = NULL, accept = NULL, modelId, trace = NULL, guardrailIdentifier = NULL, guardrailVersion = NULL, performanceConfigLatency = NULL) {
  op <- new_operation(
    name = "InvokeModel",
    http_method = "POST",
    http_path = "/model/{modelId}/invoke",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockruntime$invoke_model_input(body = body, contentType = contentType, accept = accept, modelId = modelId, trace = trace, guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion, performanceConfigLatency = performanceConfigLatency)
  output <- .bedrockruntime$invoke_model_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$invoke_model <- bedrockruntime_invoke_model

#' Invoke the specified Amazon Bedrock model to run inference using the
#' prompt and inference parameters provided in the request body
#'
#' @description
#' Invoke the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. The response is returned in a stream.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model_with_response_stream/](https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model_with_response_stream/) for full documentation.
#'
#' @param body The prompt and inference parameters in the format specified in the
#' `contentType` in the header. You must provide the body in JSON format.
#' To see the format and content of the request and response bodies for
#' different models, refer to [Inference
#' parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
#' For more information, see [Run
#' inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference.html)
#' in the Bedrock User Guide.
#' @param contentType The MIME type of the input data in the request. You must specify
#' `application/json`.
#' @param accept The desired MIME type of the inference body in the response. The default
#' value is `application/json`.
#' @param modelId &#91;required&#93; The unique identifier of the model to invoke to run inference.
#' 
#' The `modelId` to provide depends on the type of model or throughput that
#' you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an inference profile, specify the inference profile ID or
#'     its ARN. For a list of inference profile IDs, see [Supported Regions
#'     and models for cross-region
#'     inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an [imported
#'     model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html),
#'     specify the ARN of the imported model. You can get the model ARN
#'     from a successful call to
#'     [CreateModelImportJob](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html)
#'     or from the Imported models page in the Amazon Bedrock console.
#' @param trace Specifies whether to enable or disable the Bedrock trace. If enabled,
#' you can see the full Bedrock trace.
#' @param guardrailIdentifier The unique identifier of the guardrail that you want to use. If you
#' don't provide a value, no guardrail is applied to the invocation.
#' 
#' An error is thrown in the following situations.
#' 
#' -   You don't provide a guardrail identifier but you specify the
#'     `amazon-bedrock-guardrailConfig` field in the request body.
#' 
#' -   You enable the guardrail but the `contentType` isn't
#'     `application/json`.
#' 
#' -   You provide a guardrail identifier, but `guardrailVersion` isn't
#'     specified.
#' @param guardrailVersion The version number for the guardrail. The value can also be `DRAFT`.
#' @param performanceConfigLatency Model performance settings for the request.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_invoke_model_with_response_stream
bedrockruntime_invoke_model_with_response_stream <- function(body = NULL, contentType = NULL, accept = NULL, modelId, trace = NULL, guardrailIdentifier = NULL, guardrailVersion = NULL, performanceConfigLatency = NULL) {
  op <- new_operation(
    name = "InvokeModelWithResponseStream",
    http_method = "POST",
    http_path = "/model/{modelId}/invoke-with-response-stream",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockruntime$invoke_model_with_response_stream_input(body = body, contentType = contentType, accept = accept, modelId = modelId, trace = trace, guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion, performanceConfigLatency = performanceConfigLatency)
  output <- .bedrockruntime$invoke_model_with_response_stream_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$invoke_model_with_response_stream <- bedrockruntime_invoke_model_with_response_stream

#' Lists asynchronous invocations
#'
#' @description
#' Lists asynchronous invocations.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_list_async_invokes/](https://www.paws-r-sdk.com/docs/bedrockruntime_list_async_invokes/) for full documentation.
#'
#' @param submitTimeAfter Include invocations submitted after this time.
#' @param submitTimeBefore Include invocations submitted before this time.
#' @param statusEquals Filter invocations by status.
#' @param maxResults The maximum number of invocations to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param sortBy How to sort the response.
#' @param sortOrder The sorting order for the response.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_list_async_invokes
bedrockruntime_list_async_invokes <- function(submitTimeAfter = NULL, submitTimeBefore = NULL, statusEquals = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListAsyncInvokes",
    http_method = "GET",
    http_path = "/async-invoke",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "asyncInvokeSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockruntime$list_async_invokes_input(submitTimeAfter = submitTimeAfter, submitTimeBefore = submitTimeBefore, statusEquals = statusEquals, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrockruntime$list_async_invokes_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$list_async_invokes <- bedrockruntime_list_async_invokes

#' Starts an asynchronous invocation
#'
#' @description
#' Starts an asynchronous invocation.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_start_async_invoke/](https://www.paws-r-sdk.com/docs/bedrockruntime_start_async_invoke/) for full documentation.
#'
#' @param clientRequestToken Specify idempotency token to ensure that requests are not duplicated.
#' @param modelId &#91;required&#93; The model to invoke.
#' @param modelInput &#91;required&#93; Input to send to the model.
#' @param outputDataConfig &#91;required&#93; Where to store the output.
#' @param tags Tags to apply to the invocation.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_start_async_invoke
bedrockruntime_start_async_invoke <- function(clientRequestToken = NULL, modelId, modelInput, outputDataConfig, tags = NULL) {
  op <- new_operation(
    name = "StartAsyncInvoke",
    http_method = "POST",
    http_path = "/async-invoke",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockruntime$start_async_invoke_input(clientRequestToken = clientRequestToken, modelId = modelId, modelInput = modelInput, outputDataConfig = outputDataConfig, tags = tags)
  output <- .bedrockruntime$start_async_invoke_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$start_async_invoke <- bedrockruntime_start_async_invoke
