# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemakerruntime_service.R
NULL

#' After you deploy a model into production using Amazon SageMaker hosting
#' services, your client applications use this API to get inferences from
#' the model hosted at the specified endpoint
#'
#' @description
#' After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint/](https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you specified when you created the
#' endpoint using the
#' [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html)
#' API.
#' @param Body &#91;required&#93; Provides input data, in the format specified in the `ContentType`
#' request header. Amazon SageMaker passes all of the data in the body to
#' the model.
#' 
#' For information about the format of the request body, see [Common Data
#' Formats-Inference](https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html).
#' @param ContentType The MIME type of the input data in the request body.
#' @param Accept The desired MIME type of the inference response from the model
#' container.
#' @param CustomAttributes Provides additional information about a request for an inference
#' submitted to a model hosted at an Amazon SageMaker endpoint. The
#' information is an opaque value that is forwarded verbatim. You could use
#' this value, for example, to provide an ID that you can use to track a
#' request or to provide other metadata that a service endpoint was
#' programmed to process. The value must consist of no more than 1024
#' visible US-ASCII characters as specified in [Section 3.3.6. Field Value
#' Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6)
#' of the Hypertext Transfer Protocol (HTTP/1.1).
#' 
#' The code in your model is responsible for setting or updating any custom
#' attributes in the response. If your code does not set this value in the
#' response, an empty value is returned. For example, if a custom attribute
#' represents the trace ID, your model can prepend the custom attribute
#' with `Trace ID:` in your post-processing function.
#' 
#' This feature is currently supported in the Amazon Web Services SDKs but
#' not in the Amazon SageMaker Python SDK.
#' @param TargetModel The model to request for inference when invoking a multi-model endpoint.
#' @param TargetVariant Specify the production variant to send the inference request to when
#' invoking an endpoint that is running two or more variants. Note that
#' this parameter overrides the default behavior for the endpoint, which is
#' to distribute the invocation traffic based on the variant weights.
#' 
#' For information about how to use variant targeting to perform a/b
#' testing, see [Test models in
#' production](https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html)
#' @param TargetContainerHostname If the endpoint hosts multiple containers and is configured to use
#' direct invocation, this parameter specifies the host name of the
#' container to invoke.
#' @param InferenceId If you provide a value, it is added to the captured data when you enable
#' data capture on the endpoint. For information about data capture, see
#' [Capture
#' Data](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html).
#' @param EnableExplanations An optional JMESPath expression used to override the
#' `EnableExplanations` parameter of the `ClarifyExplainerConfig` API. See
#' the
#' [EnableExplanations](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable)
#' section in the developer guide for more information.
#' @param InferenceComponentName If the endpoint hosts one or more inference components, this parameter
#' specifies the name of inference component to invoke.
#'
#' @keywords internal
#'
#' @rdname sagemakerruntime_invoke_endpoint
sagemakerruntime_invoke_endpoint <- function(EndpointName, Body, ContentType = NULL, Accept = NULL, CustomAttributes = NULL, TargetModel = NULL, TargetVariant = NULL, TargetContainerHostname = NULL, InferenceId = NULL, EnableExplanations = NULL, InferenceComponentName = NULL) {
  op <- new_operation(
    name = "InvokeEndpoint",
    http_method = "POST",
    http_path = "/endpoints/{EndpointName}/invocations",
    paginator = list()
  )
  input <- .sagemakerruntime$invoke_endpoint_input(EndpointName = EndpointName, Body = Body, ContentType = ContentType, Accept = Accept, CustomAttributes = CustomAttributes, TargetModel = TargetModel, TargetVariant = TargetVariant, TargetContainerHostname = TargetContainerHostname, InferenceId = InferenceId, EnableExplanations = EnableExplanations, InferenceComponentName = InferenceComponentName)
  output <- .sagemakerruntime$invoke_endpoint_output()
  config <- get_config()
  svc <- .sagemakerruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerruntime$operations$invoke_endpoint <- sagemakerruntime_invoke_endpoint

#' After you deploy a model into production using Amazon SageMaker hosting
#' services, your client applications use this API to get inferences from
#' the model hosted at the specified endpoint in an asynchronous manner
#'
#' @description
#' After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint in an asynchronous manner.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint_async/](https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint_async/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you specified when you created the
#' endpoint using the
#' [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html)
#' API.
#' @param ContentType The MIME type of the input data in the request body.
#' @param Accept The desired MIME type of the inference response from the model
#' container.
#' @param CustomAttributes Provides additional information about a request for an inference
#' submitted to a model hosted at an Amazon SageMaker endpoint. The
#' information is an opaque value that is forwarded verbatim. You could use
#' this value, for example, to provide an ID that you can use to track a
#' request or to provide other metadata that a service endpoint was
#' programmed to process. The value must consist of no more than 1024
#' visible US-ASCII characters as specified in [Section 3.3.6. Field Value
#' Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6)
#' of the Hypertext Transfer Protocol (HTTP/1.1).
#' 
#' The code in your model is responsible for setting or updating any custom
#' attributes in the response. If your code does not set this value in the
#' response, an empty value is returned. For example, if a custom attribute
#' represents the trace ID, your model can prepend the custom attribute
#' with `Trace ID:` in your post-processing function.
#' 
#' This feature is currently supported in the Amazon Web Services SDKs but
#' not in the Amazon SageMaker Python SDK.
#' @param InferenceId The identifier for the inference request. Amazon SageMaker will generate
#' an identifier for you if none is specified.
#' @param InputLocation &#91;required&#93; The Amazon S3 URI where the inference request payload is stored.
#' @param RequestTTLSeconds Maximum age in seconds a request can be in the queue before it is marked
#' as expired. The default is 6 hours, or 21,600 seconds.
#' @param InvocationTimeoutSeconds Maximum amount of time in seconds a request can be processed before it
#' is marked as expired. The default is 15 minutes, or 900 seconds.
#'
#' @keywords internal
#'
#' @rdname sagemakerruntime_invoke_endpoint_async
sagemakerruntime_invoke_endpoint_async <- function(EndpointName, ContentType = NULL, Accept = NULL, CustomAttributes = NULL, InferenceId = NULL, InputLocation, RequestTTLSeconds = NULL, InvocationTimeoutSeconds = NULL) {
  op <- new_operation(
    name = "InvokeEndpointAsync",
    http_method = "POST",
    http_path = "/endpoints/{EndpointName}/async-invocations",
    paginator = list()
  )
  input <- .sagemakerruntime$invoke_endpoint_async_input(EndpointName = EndpointName, ContentType = ContentType, Accept = Accept, CustomAttributes = CustomAttributes, InferenceId = InferenceId, InputLocation = InputLocation, RequestTTLSeconds = RequestTTLSeconds, InvocationTimeoutSeconds = InvocationTimeoutSeconds)
  output <- .sagemakerruntime$invoke_endpoint_async_output()
  config <- get_config()
  svc <- .sagemakerruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerruntime$operations$invoke_endpoint_async <- sagemakerruntime_invoke_endpoint_async

#' Invokes a model at the specified endpoint to return the inference
#' response as a stream
#'
#' @description
#' Invokes a model at the specified endpoint to return the inference response as a stream. The inference stream provides the response payload incrementally as a series of parts. Before you can get an inference stream, you must have access to a model that's deployed using Amazon SageMaker hosting services, and the container for that model must support inference streaming.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint_with_response_stream/](https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint_with_response_stream/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you specified when you created the
#' endpoint using the
#' [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html)
#' API.
#' @param Body &#91;required&#93; Provides input data, in the format specified in the `ContentType`
#' request header. Amazon SageMaker passes all of the data in the body to
#' the model.
#' 
#' For information about the format of the request body, see [Common Data
#' Formats-Inference](https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html).
#' @param ContentType The MIME type of the input data in the request body.
#' @param Accept The desired MIME type of the inference response from the model
#' container.
#' @param CustomAttributes Provides additional information about a request for an inference
#' submitted to a model hosted at an Amazon SageMaker endpoint. The
#' information is an opaque value that is forwarded verbatim. You could use
#' this value, for example, to provide an ID that you can use to track a
#' request or to provide other metadata that a service endpoint was
#' programmed to process. The value must consist of no more than 1024
#' visible US-ASCII characters as specified in [Section 3.3.6. Field Value
#' Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6)
#' of the Hypertext Transfer Protocol (HTTP/1.1).
#' 
#' The code in your model is responsible for setting or updating any custom
#' attributes in the response. If your code does not set this value in the
#' response, an empty value is returned. For example, if a custom attribute
#' represents the trace ID, your model can prepend the custom attribute
#' with `Trace ID:` in your post-processing function.
#' 
#' This feature is currently supported in the Amazon Web Services SDKs but
#' not in the Amazon SageMaker Python SDK.
#' @param TargetVariant Specify the production variant to send the inference request to when
#' invoking an endpoint that is running two or more variants. Note that
#' this parameter overrides the default behavior for the endpoint, which is
#' to distribute the invocation traffic based on the variant weights.
#' 
#' For information about how to use variant targeting to perform a/b
#' testing, see [Test models in
#' production](https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html)
#' @param TargetContainerHostname If the endpoint hosts multiple containers and is configured to use
#' direct invocation, this parameter specifies the host name of the
#' container to invoke.
#' @param InferenceId An identifier that you assign to your request.
#' @param InferenceComponentName If the endpoint hosts one or more inference components, this parameter
#' specifies the name of inference component to invoke for a streaming
#' response.
#'
#' @keywords internal
#'
#' @rdname sagemakerruntime_invoke_endpoint_with_response_stream
sagemakerruntime_invoke_endpoint_with_response_stream <- function(EndpointName, Body, ContentType = NULL, Accept = NULL, CustomAttributes = NULL, TargetVariant = NULL, TargetContainerHostname = NULL, InferenceId = NULL, InferenceComponentName = NULL) {
  op <- new_operation(
    name = "InvokeEndpointWithResponseStream",
    http_method = "POST",
    http_path = "/endpoints/{EndpointName}/invocations-response-stream",
    paginator = list()
  )
  input <- .sagemakerruntime$invoke_endpoint_with_response_stream_input(EndpointName = EndpointName, Body = Body, ContentType = ContentType, Accept = Accept, CustomAttributes = CustomAttributes, TargetVariant = TargetVariant, TargetContainerHostname = TargetContainerHostname, InferenceId = InferenceId, InferenceComponentName = InferenceComponentName)
  output <- .sagemakerruntime$invoke_endpoint_with_response_stream_output()
  config <- get_config()
  svc <- .sagemakerruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakerruntime$operations$invoke_endpoint_with_response_stream <- sagemakerruntime_invoke_endpoint_with_response_stream
