% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_provisioned_model_throughputs}
\alias{bedrock_list_provisioned_model_throughputs}
\title{List the provisioned capacities}
\usage{
bedrock_list_provisioned_model_throughputs(
  creationTimeAfter = NULL,
  creationTimeBefore = NULL,
  statusEquals = NULL,
  modelArnEquals = NULL,
  nameContains = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{creationTimeAfter}{Return provisioned capacities created after the specified time.}

\item{creationTimeBefore}{Return provisioned capacities created before the specified time.}

\item{statusEquals}{Return the list of provisioned capacities that match the specified
status.}

\item{modelArnEquals}{Return the list of provisioned capacities where their model ARN is equal
to this parameter.}

\item{nameContains}{Return the list of provisioned capacities if their name contains these
characters.}

\item{maxResults}{THe maximum number of results to return in the response.}

\item{nextToken}{Continuation token from the previous response, for Amazon Bedrock to
list the next set of results.}

\item{sortBy}{The field to sort by in the returned list of provisioned capacities.}

\item{sortOrder}{The sort order of the results.}
}
\description{
List the provisioned capacities. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Provisioned throughput} in the Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_provisioned_model_throughputs/} for full documentation.
}
\keyword{internal}
