% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_image_versions}
\alias{sagemaker_list_image_versions}
\title{Lists the versions of a specified image and their properties}
\usage{
sagemaker_list_image_versions(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  ImageName,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only versions created on or after the specified
time.}

\item{CreationTimeBefore}{A filter that returns only versions created on or before the specified
time.}

\item{ImageName}{[required] The name of the image to list the versions of.}

\item{LastModifiedTimeAfter}{A filter that returns only versions modified on or after the specified
time.}

\item{LastModifiedTimeBefore}{A filter that returns only versions modified on or before the specified
time.}

\item{MaxResults}{The maximum number of versions to return in the response. The default
value is 10.}

\item{NextToken}{If the previous call to
\code{\link[=sagemaker_list_image_versions]{list_image_versions}} didn't return the
full set of versions, the call returns a token for getting the next set
of versions.}

\item{SortBy}{The property used to sort results. The default value is \code{CREATION_TIME}.}

\item{SortOrder}{The sort order. The default value is \code{DESCENDING}.}
}
\description{
Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_image_versions/} for full documentation.
}
\keyword{internal}
