% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_create_face_liveness_session}
\alias{rekognition_create_face_liveness_session}
\title{This API operation initiates a Face Liveness session}
\usage{
rekognition_create_face_liveness_session(
  KmsKeyId = NULL,
  Settings = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{KmsKeyId}{The identifier for your AWS Key Management Service key (AWS KMS key).
Used to encrypt audit images and reference images.}

\item{Settings}{A session settings object. It contains settings for the operation to be
performed. For Face Liveness, it accepts \code{OutputConfig} and
\code{AuditImagesLimit}.}

\item{ClientRequestToken}{Idempotent token is used to recognize the Face Liveness request. If the
same token is used with multiple
\code{\link[=rekognition_create_face_liveness_session]{create_face_liveness_session}}
requests, the same session is returned. This token is employed to avoid
unintentionally creating the same session multiple times.}
}
\description{
This API operation initiates a Face Liveness session. It returns a \code{SessionId}, which you can use to start streaming Face Liveness video and get the results for a Face Liveness session. You can use the \code{OutputConfig} option in the Settings parameter to provide an Amazon S3 bucket location. The Amazon S3 bucket stores reference images and audit images. You can use \code{AuditImagesLimit} to limit the number of audit images returned. This number is between 0 and 4. By default, it is set to 0. The limit is best effort and based on the duration of the selfie-video.

See \url{https://www.paws-r-sdk.com/docs/rekognition_create_face_liveness_session/} for full documentation.
}
\keyword{internal}
