% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_endpoints}
\alias{sagemaker_list_endpoints}
\title{Lists endpoints}
\usage{
sagemaker_list_endpoints(
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  NameContains = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  StatusEquals = NULL
)
}
\arguments{
\item{SortBy}{Sorts the list of results. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Descending}.}

\item{NextToken}{If the result of a \code{\link[=sagemaker_list_endpoints]{list_endpoints}} request
was truncated, the response includes a \code{NextToken}. To retrieve the next
set of endpoints, use the token in the next request.}

\item{MaxResults}{The maximum number of endpoints to return in the response. This value
defaults to 10.}

\item{NameContains}{A string in endpoint names. This filter returns only endpoints whose
name contains the specified string.}

\item{CreationTimeBefore}{A filter that returns only endpoints that were created before the
specified time (timestamp).}

\item{CreationTimeAfter}{A filter that returns only endpoints with a creation time greater than
or equal to the specified time (timestamp).}

\item{LastModifiedTimeBefore}{A filter that returns only endpoints that were modified before the
specified timestamp.}

\item{LastModifiedTimeAfter}{A filter that returns only endpoints that were modified after the
specified timestamp.}

\item{StatusEquals}{A filter that returns only endpoints with the specified status.}
}
\description{
Lists endpoints.

See \url{https://paws-r.github.io/docs/sagemaker/list_endpoints.html} for full documentation.
}
\keyword{internal}
