% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_dataset_group}
\alias{personalize_create_dataset_group}
\title{Creates an empty dataset group}
\usage{
personalize_create_dataset_group(
  name,
  roleArn = NULL,
  kmsKeyArn = NULL,
  domain = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name for the new dataset group.}

\item{roleArn}{The ARN of the Identity and Access Management (IAM) role that has
permissions to access the Key Management Service (KMS) key. Supplying an
IAM role is only valid when also specifying a KMS key.}

\item{kmsKeyArn}{The Amazon Resource Name (ARN) of a Key Management Service (KMS) key
used to encrypt the datasets.}

\item{domain}{The domain of the dataset group. Specify a domain to create a Domain
dataset group. The domain you specify determines the default schemas for
datasets and the use cases available for recommenders. If you don't
specify a domain, you create a Custom dataset group with solution
versions that you deploy with a campaign.}

\item{tags}{A list of tags to apply to the dataset group.}
}
\description{
Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:

See \url{https://paws-r.github.io/docs/personalize/create_dataset_group.html} for full documentation.
}
\keyword{internal}
