% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_candidates_for_auto_ml_job}
\alias{sagemaker_list_candidates_for_auto_ml_job}
\title{List the Candidates created for the job}
\usage{
sagemaker_list_candidates_for_auto_ml_job(AutoMLJobName, StatusEquals,
  CandidateNameEquals, SortOrder, SortBy, MaxResults, NextToken)
}
\arguments{
\item{AutoMLJobName}{[required] List the Candidates created for the job by providing the job\'s name.}

\item{StatusEquals}{List the Candidates for the job and filter by status.}

\item{CandidateNameEquals}{List the Candidates for the job and filter by candidate name.}

\item{SortOrder}{The sort order for the results. The default is Ascending.}

\item{SortBy}{The parameter by which to sort the results. The default is Descending.}

\item{MaxResults}{List the job\'s Candidates up to a specified limit.}

\item{NextToken}{If the previous response was truncated, you will receive this token. Use
it in your next request to receive the next set of results.}
}
\description{
List the Candidates created for the job.
}
\section{Request syntax}{
\preformatted{svc$list_candidates_for_auto_ml_job(
  AutoMLJobName = "string",
  StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping",
  CandidateNameEquals = "string",
  SortOrder = "Ascending"|"Descending",
  SortBy = "CreationTime"|"Status"|"FinalObjectiveMetricValue",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
