# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include rekognition_service.R
NULL

#' Compares a face in the _source_ input image with each of the 100 largest
#' faces detected in the _target_ input image
#'
#' Compares a face in the *source* input image with each of the 100 largest
#' faces detected in the *target* input image.
#' 
#' If the source image contains multiple faces, the service detects the
#' largest face and compares it with each face detected in the target
#' image.
#' 
#' You pass the input and target images either as base64-encoded image
#' bytes or as references to images in an Amazon S3 bucket. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing image bytes
#' isn\'t supported. The image must be formatted as a PNG or JPEG file.
#' 
#' In response, the operation returns an array of face matches ordered by
#' similarity score in descending order. For each face match, the response
#' provides a bounding box of the face, facial landmarks, pose details
#' (pitch, role, and yaw), quality (brightness and sharpness), and
#' confidence value (indicating the level of confidence that the bounding
#' box contains a face). The response also provides a similarity score,
#' which indicates how closely the faces match.
#' 
#' By default, only faces with a similarity score of greater than or equal
#' to 80% are returned in the response. You can change this value by
#' specifying the `SimilarityThreshold` parameter.
#' 
#' `CompareFaces` also returns an array of faces that don\'t match the
#' source image. For each face, it returns a bounding box, confidence
#' value, landmarks, pose details, and quality. The response also returns
#' information about the face in the source image, including the bounding
#' box of the face and confidence value.
#' 
#' The `QualityFilter` input parameter allows you to filter out detected
#' faces that don't meet a required quality bar. The quality bar is based
#' on a variety of common use cases. Use `QualityFilter` to set the quality
#' bar by specifying `LOW`, `MEDIUM`, or `HIGH`. If you do not want to
#' filter detected faces, specify `NONE`. The default value is `NONE`.
#' 
#' To use quality filtering, you need a collection associated with version
#' 3 of the face model or higher. To get the version of the face model
#' associated with a collection, call DescribeCollection.
#' 
#' If the image doesn\'t contain Exif metadata, `CompareFaces` returns
#' orientation information for the source and target images. Use these
#' values to display the images with the correct image orientation.
#' 
#' If no faces are detected in the source or target images, `CompareFaces`
#' returns an `InvalidParameterException` error.
#' 
#' This is a stateless API operation. That is, data returned by this
#' operation doesn\'t persist.
#' 
#' For an example, see Comparing Faces in Images in the Amazon Rekognition
#' Developer Guide.
#' 
#' This operation requires permissions to perform the
#' `rekognition:CompareFaces` action.
#'
#' @usage
#' rekognition_compare_faces(SourceImage, TargetImage, SimilarityThreshold,
#'   QualityFilter)
#'
#' @param SourceImage &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes is not supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param TargetImage &#91;required&#93; The target image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes is not supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param SimilarityThreshold The minimum level of confidence in the face matches that a match must
#' meet to be included in the `FaceMatches` array.
#' @param QualityFilter A filter that specifies a quality bar for how much filtering is done to
#' identify faces. Filtered faces aren\'t compared. If you specify `AUTO`,
#' Amazon Rekognition chooses the quality bar. If you specify `LOW`,
#' `MEDIUM`, or `HIGH`, filtering removes all faces that don't meet the
#' chosen quality bar. The quality bar is based on a variety of common use
#' cases. Low-quality detections can occur for a number of reasons. Some
#' examples are an object that\'s misidentified as a face, a face that\'s
#' too blurry, or a face with a pose that\'s too extreme to use. If you
#' specify `NONE`, no filtering is performed. The default value is `NONE`.
#' 
#' To use quality filtering, the collection you are using must be
#' associated with version 3 of the face model or higher.
#'
#' @section Request syntax:
#' ```
#' svc$compare_faces(
#'   SourceImage = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   TargetImage = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   SimilarityThreshold = 123.0,
#'   QualityFilter = "NONE"|"AUTO"|"LOW"|"MEDIUM"|"HIGH"
#' )
#' ```
#'
#' @examples
#' # This operation compares the largest face detected in the source image
#' # with each face detected in the target image.
#' \dontrun{svc$compare_faces(
#'   SimilarityThreshold = 90L,
#'   SourceImage = list(
#'     S3Object = list(
#'       Bucket = "mybucket",
#'       Name = "mysourceimage"
#'     )
#'   ),
#'   TargetImage = list(
#'     S3Object = list(
#'       Bucket = "mybucket",
#'       Name = "mytargetimage"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_compare_faces
rekognition_compare_faces <- function(SourceImage, TargetImage, SimilarityThreshold = NULL, QualityFilter = NULL) {
  op <- new_operation(
    name = "CompareFaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$compare_faces_input(SourceImage = SourceImage, TargetImage = TargetImage, SimilarityThreshold = SimilarityThreshold, QualityFilter = QualityFilter)
  output <- .rekognition$compare_faces_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$compare_faces <- rekognition_compare_faces

#' Creates a collection in an AWS Region
#'
#' Creates a collection in an AWS Region. You can add faces to the
#' collection using the IndexFaces operation.
#' 
#' For example, you might create collections, one for each of your
#' application users. A user can then index faces using the `IndexFaces`
#' operation and persist results in a specific collection. Then, a user can
#' search the collection for faces in the user-specific container.
#' 
#' When you create a collection, it is associated with the latest version
#' of the face model version.
#' 
#' Collection names are case-sensitive.
#' 
#' This operation requires permissions to perform the
#' `rekognition:CreateCollection` action.
#'
#' @usage
#' rekognition_create_collection(CollectionId)
#'
#' @param CollectionId &#91;required&#93; ID for the collection that you are creating.
#'
#' @section Request syntax:
#' ```
#' svc$create_collection(
#'   CollectionId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation creates a Rekognition collection for storing image data.
#' \dontrun{svc$create_collection(
#'   CollectionId = "myphotos"
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_create_collection
rekognition_create_collection <- function(CollectionId) {
  op <- new_operation(
    name = "CreateCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$create_collection_input(CollectionId = CollectionId)
  output <- .rekognition$create_collection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$create_collection <- rekognition_create_collection

#' Creates a new Amazon Rekognition Custom Labels project
#'
#' Creates a new Amazon Rekognition Custom Labels project. A project is a
#' logical grouping of resources (images, Labels, models) and operations
#' (training, evaluation and detection).
#' 
#' This operation requires permissions to perform the
#' `rekognition:CreateProject` action.
#'
#' @usage
#' rekognition_create_project(ProjectName)
#'
#' @param ProjectName &#91;required&#93; The name of the project to create.
#'
#' @section Request syntax:
#' ```
#' svc$create_project(
#'   ProjectName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_create_project
rekognition_create_project <- function(ProjectName) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$create_project_input(ProjectName = ProjectName)
  output <- .rekognition$create_project_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$create_project <- rekognition_create_project

#' Creates a new version of a model and begins training
#'
#' Creates a new version of a model and begins training. Models are managed
#' as part of an Amazon Rekognition Custom Labels project. You can specify
#' one training dataset and one testing dataset. The response from
#' `CreateProjectVersion` is an Amazon Resource Name (ARN) for the version
#' of the model.
#' 
#' Training takes a while to complete. You can get the current status by
#' calling DescribeProjectVersions.
#' 
#' Once training has successfully completed, call DescribeProjectVersions
#' to get the training results and evaluate the model.
#' 
#' After evaluating the model, you start the model by calling
#' StartProjectVersion.
#' 
#' This operation requires permissions to perform the
#' `rekognition:CreateProjectVersion` action.
#'
#' @usage
#' rekognition_create_project_version(ProjectArn, VersionName,
#'   OutputConfig, TrainingData, TestingData)
#'
#' @param ProjectArn &#91;required&#93; The ARN of the Amazon Rekognition Custom Labels project that manages the
#' model that you want to train.
#' @param VersionName &#91;required&#93; A name for the version of the model. This value must be unique.
#' @param OutputConfig &#91;required&#93; The Amazon S3 location to store the results of training.
#' @param TrainingData &#91;required&#93; The dataset to use for training.
#' @param TestingData &#91;required&#93; The dataset to use for testing.
#'
#' @section Request syntax:
#' ```
#' svc$create_project_version(
#'   ProjectArn = "string",
#'   VersionName = "string",
#'   OutputConfig = list(
#'     S3Bucket = "string",
#'     S3KeyPrefix = "string"
#'   ),
#'   TrainingData = list(
#'     Assets = list(
#'       list(
#'         GroundTruthManifest = list(
#'           S3Object = list(
#'             Bucket = "string",
#'             Name = "string",
#'             Version = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   TestingData = list(
#'     Assets = list(
#'       list(
#'         GroundTruthManifest = list(
#'           S3Object = list(
#'             Bucket = "string",
#'             Name = "string",
#'             Version = "string"
#'           )
#'         )
#'       )
#'     ),
#'     AutoCreate = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_create_project_version
rekognition_create_project_version <- function(ProjectArn, VersionName, OutputConfig, TrainingData, TestingData) {
  op <- new_operation(
    name = "CreateProjectVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$create_project_version_input(ProjectArn = ProjectArn, VersionName = VersionName, OutputConfig = OutputConfig, TrainingData = TrainingData, TestingData = TestingData)
  output <- .rekognition$create_project_version_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$create_project_version <- rekognition_create_project_version

#' Creates an Amazon Rekognition stream processor that you can use to
#' detect and recognize faces in a streaming video
#'
#' Creates an Amazon Rekognition stream processor that you can use to
#' detect and recognize faces in a streaming video.
#' 
#' Amazon Rekognition Video is a consumer of live video from Amazon Kinesis
#' Video Streams. Amazon Rekognition Video sends analysis results to Amazon
#' Kinesis Data Streams.
#' 
#' You provide as input a Kinesis video stream (`Input`) and a Kinesis data
#' stream (`Output`) stream. You also specify the face recognition criteria
#' in `Settings`. For example, the collection containing faces that you
#' want to recognize. Use `Name` to assign an identifier for the stream
#' processor. You use `Name` to manage the stream processor. For example,
#' you can start processing the source video by calling
#' StartStreamProcessor with the `Name` field.
#' 
#' After you have finished analyzing a streaming video, use
#' StopStreamProcessor to stop processing. You can delete the stream
#' processor by calling DeleteStreamProcessor.
#'
#' @usage
#' rekognition_create_stream_processor(Input, Output, Name, Settings,
#'   RoleArn)
#'
#' @param Input &#91;required&#93; Kinesis video stream stream that provides the source streaming video. If
#' you are using the AWS CLI, the parameter name is `StreamProcessorInput`.
#' @param Output &#91;required&#93; Kinesis data stream stream to which Amazon Rekognition Video puts the
#' analysis results. If you are using the AWS CLI, the parameter name is
#' `StreamProcessorOutput`.
#' @param Name &#91;required&#93; An identifier you assign to the stream processor. You can use `Name` to
#' manage the stream processor. For example, you can get the current status
#' of the stream processor by calling DescribeStreamProcessor. `Name` is
#' idempotent.
#' @param Settings &#91;required&#93; Face recognition input parameters to be used by the stream processor.
#' Includes the collection to use for face recognition and the face
#' attributes to detect.
#' @param RoleArn &#91;required&#93; ARN of the IAM role that allows access to the stream processor.
#'
#' @section Request syntax:
#' ```
#' svc$create_stream_processor(
#'   Input = list(
#'     KinesisVideoStream = list(
#'       Arn = "string"
#'     )
#'   ),
#'   Output = list(
#'     KinesisDataStream = list(
#'       Arn = "string"
#'     )
#'   ),
#'   Name = "string",
#'   Settings = list(
#'     FaceSearch = list(
#'       CollectionId = "string",
#'       FaceMatchThreshold = 123.0
#'     )
#'   ),
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_create_stream_processor
rekognition_create_stream_processor <- function(Input, Output, Name, Settings, RoleArn) {
  op <- new_operation(
    name = "CreateStreamProcessor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$create_stream_processor_input(Input = Input, Output = Output, Name = Name, Settings = Settings, RoleArn = RoleArn)
  output <- .rekognition$create_stream_processor_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$create_stream_processor <- rekognition_create_stream_processor

#' Deletes the specified collection
#'
#' Deletes the specified collection. Note that this operation removes all
#' faces in the collection. For an example, see
#' delete-collection-procedure.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DeleteCollection` action.
#'
#' @usage
#' rekognition_delete_collection(CollectionId)
#'
#' @param CollectionId &#91;required&#93; ID of the collection to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_collection(
#'   CollectionId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes a Rekognition collection.
#' \dontrun{svc$delete_collection(
#'   CollectionId = "myphotos"
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_delete_collection
rekognition_delete_collection <- function(CollectionId) {
  op <- new_operation(
    name = "DeleteCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$delete_collection_input(CollectionId = CollectionId)
  output <- .rekognition$delete_collection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$delete_collection <- rekognition_delete_collection

#' Deletes faces from a collection
#'
#' Deletes faces from a collection. You specify a collection ID and an
#' array of face IDs to remove from the collection.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DeleteFaces` action.
#'
#' @usage
#' rekognition_delete_faces(CollectionId, FaceIds)
#'
#' @param CollectionId &#91;required&#93; Collection from which to remove the specific faces.
#' @param FaceIds &#91;required&#93; An array of face IDs to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_faces(
#'   CollectionId = "string",
#'   FaceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation deletes one or more faces from a Rekognition collection.
#' \dontrun{svc$delete_faces(
#'   CollectionId = "myphotos",
#'   FaceIds = list(
#'     "ff43d742-0c13-5d16-a3e8-03d3f58e980b"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_delete_faces
rekognition_delete_faces <- function(CollectionId, FaceIds) {
  op <- new_operation(
    name = "DeleteFaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$delete_faces_input(CollectionId = CollectionId, FaceIds = FaceIds)
  output <- .rekognition$delete_faces_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$delete_faces <- rekognition_delete_faces

#' Deletes the stream processor identified by Name
#'
#' Deletes the stream processor identified by `Name`. You assign the value
#' for `Name` when you create the stream processor with
#' CreateStreamProcessor. You might not be able to use the same name for a
#' stream processor for a few seconds after calling
#' `DeleteStreamProcessor`.
#'
#' @usage
#' rekognition_delete_stream_processor(Name)
#'
#' @param Name &#91;required&#93; The name of the stream processor you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stream_processor(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_delete_stream_processor
rekognition_delete_stream_processor <- function(Name) {
  op <- new_operation(
    name = "DeleteStreamProcessor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$delete_stream_processor_input(Name = Name)
  output <- .rekognition$delete_stream_processor_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$delete_stream_processor <- rekognition_delete_stream_processor

#' Describes the specified collection
#'
#' Describes the specified collection. You can use `DescribeCollection` to
#' get information, such as the number of faces indexed into a collection
#' and the version of the model used by the collection for face detection.
#' 
#' For more information, see Describing a Collection in the Amazon
#' Rekognition Developer Guide.
#'
#' @usage
#' rekognition_describe_collection(CollectionId)
#'
#' @param CollectionId &#91;required&#93; The ID of the collection to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_collection(
#'   CollectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_describe_collection
rekognition_describe_collection <- function(CollectionId) {
  op <- new_operation(
    name = "DescribeCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$describe_collection_input(CollectionId = CollectionId)
  output <- .rekognition$describe_collection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$describe_collection <- rekognition_describe_collection

#' Lists and describes the models in an Amazon Rekognition Custom Labels
#' project
#'
#' Lists and describes the models in an Amazon Rekognition Custom Labels
#' project. You can specify up to 10 model versions in
#' `ProjectVersionArns`. If you don\'t specify a value, descriptions for
#' all models are returned.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DescribeProjectVersions` action.
#'
#' @usage
#' rekognition_describe_project_versions(ProjectArn, VersionNames,
#'   NextToken, MaxResults)
#'
#' @param ProjectArn &#91;required&#93; The Amazon Resource Name (ARN) of the project that contains the models
#' you want to describe.
#' @param VersionNames A list of model version names that you want to describe. You can add up
#' to 10 model version names to the list. If you don\'t specify a value,
#' all model descriptions are returned.
#' @param NextToken If the previous response was incomplete (because there is more results
#' to retrieve), Amazon Rekognition Custom Labels returns a pagination
#' token in the response. You can use this pagination token to retrieve the
#' next set of results.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 100. If you specify a value greater than 100, a
#' ValidationException error occurs. The default value is 100.
#'
#' @section Request syntax:
#' ```
#' svc$describe_project_versions(
#'   ProjectArn = "string",
#'   VersionNames = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_describe_project_versions
rekognition_describe_project_versions <- function(ProjectArn, VersionNames = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeProjectVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$describe_project_versions_input(ProjectArn = ProjectArn, VersionNames = VersionNames, NextToken = NextToken, MaxResults = MaxResults)
  output <- .rekognition$describe_project_versions_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$describe_project_versions <- rekognition_describe_project_versions

#' Lists and gets information about your Amazon Rekognition Custom Labels
#' projects
#'
#' Lists and gets information about your Amazon Rekognition Custom Labels
#' projects.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DescribeProjects` action.
#'
#' @usage
#' rekognition_describe_projects(NextToken, MaxResults)
#'
#' @param NextToken If the previous response was incomplete (because there is more results
#' to retrieve), Amazon Rekognition Custom Labels returns a pagination
#' token in the response. You can use this pagination token to retrieve the
#' next set of results.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 100. If you specify a value greater than 100, a
#' ValidationException error occurs. The default value is 100.
#'
#' @section Request syntax:
#' ```
#' svc$describe_projects(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_describe_projects
rekognition_describe_projects <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$describe_projects_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .rekognition$describe_projects_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$describe_projects <- rekognition_describe_projects

#' Provides information about a stream processor created by
#' CreateStreamProcessor
#'
#' Provides information about a stream processor created by
#' CreateStreamProcessor. You can get information about the input and
#' output streams, the input parameters for the face recognition being
#' performed, and the current status of the stream processor.
#'
#' @usage
#' rekognition_describe_stream_processor(Name)
#'
#' @param Name &#91;required&#93; Name of the stream processor for which you want information.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stream_processor(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_describe_stream_processor
rekognition_describe_stream_processor <- function(Name) {
  op <- new_operation(
    name = "DescribeStreamProcessor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$describe_stream_processor_input(Name = Name)
  output <- .rekognition$describe_stream_processor_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$describe_stream_processor <- rekognition_describe_stream_processor

#' Detects custom labels in a supplied image by using an Amazon Rekognition
#' Custom Labels model
#'
#' Detects custom labels in a supplied image by using an Amazon Rekognition
#' Custom Labels model.
#' 
#' You specify which version of a model version to use by using the
#' `ProjectVersionArn` input parameter.
#' 
#' You pass the input image as base64-encoded image bytes or as a reference
#' to an image in an Amazon S3 bucket. If you use the AWS CLI to call
#' Amazon Rekognition operations, passing image bytes is not supported. The
#' image must be either a PNG or JPEG formatted file.
#' 
#' For each object that the model version detects on an image, the API
#' returns a (`CustomLabel`) object in an array (`CustomLabels`). Each
#' `CustomLabel` object provides the label name (`Name`), the level of
#' confidence that the image contains the object (`Confidence`), and object
#' location information, if it exists, for the label on the image
#' (`Geometry`).
#' 
#' During training model calculates a threshold value that determines if a
#' prediction for a label is true. By default, `DetectCustomLabels`
#' doesn\'t return labels whose confidence value is below the model\'s
#' calculated threshold value. To filter labels that are returned, specify
#' a value for `MinConfidence` that is higher than the model\'s calculated
#' threshold. You can get the model\'s calculated threshold from the
#' model\'s training results shown in the Amazon Rekognition Custom Labels
#' console. To get all labels, regardless of confidence, specify a
#' `MinConfidence` value of 0.
#' 
#' You can also add the `MaxResults` parameter to limit the number of
#' labels returned.
#' 
#' This is a stateless API operation. That is, the operation does not
#' persist any data.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DetectCustomLabels` action.
#'
#' @usage
#' rekognition_detect_custom_labels(ProjectVersionArn, Image, MaxResults,
#'   MinConfidence)
#'
#' @param ProjectVersionArn &#91;required&#93; The ARN of the model version that you want to use.
#' @param Image &#91;required&#93; 
#' @param MaxResults Maximum number of results you want the service to return in the
#' response. The service returns the specified number of highest confidence
#' labels ranked from highest confidence to lowest.
#' @param MinConfidence Specifies the minimum confidence level for the labels to return. Amazon
#' Rekognition doesn\'t return any labels with a confidence lower than this
#' specified value. If you specify a value of 0, all labels are return,
#' regardless of the default thresholds that the model version applies.
#'
#' @section Request syntax:
#' ```
#' svc$detect_custom_labels(
#'   ProjectVersionArn = "string",
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   MaxResults = 123,
#'   MinConfidence = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_detect_custom_labels
rekognition_detect_custom_labels <- function(ProjectVersionArn, Image, MaxResults = NULL, MinConfidence = NULL) {
  op <- new_operation(
    name = "DetectCustomLabels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$detect_custom_labels_input(ProjectVersionArn = ProjectVersionArn, Image = Image, MaxResults = MaxResults, MinConfidence = MinConfidence)
  output <- .rekognition$detect_custom_labels_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$detect_custom_labels <- rekognition_detect_custom_labels

#' Detects faces within an image that is provided as input
#'
#' Detects faces within an image that is provided as input.
#' 
#' `DetectFaces` detects the 100 largest faces in the image. For each face
#' detected, the operation returns face details. These details include a
#' bounding box of the face, a confidence value (that the bounding box
#' contains a face), and a fixed set of attributes such as facial landmarks
#' (for example, coordinates of eye and mouth), presence of beard,
#' sunglasses, and so on.
#' 
#' The face-detection algorithm is most effective on frontal faces. For
#' non-frontal or obscured faces, the algorithm might not detect the faces
#' or might detect faces with lower confidence.
#' 
#' You pass the input image either as base64-encoded image bytes or as a
#' reference to an image in an Amazon S3 bucket. If you use the to call
#' Amazon Rekognition operations, passing image bytes is not supported. The
#' image must be either a PNG or JPEG formatted file.
#' 
#' This is a stateless API operation. That is, the operation does not
#' persist any data.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DetectFaces` action.
#'
#' @usage
#' rekognition_detect_faces(Image, Attributes)
#'
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes is not supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param Attributes An array of facial attributes you want to be returned. This can be the
#' default list of attributes or all attributes. If you don\'t specify a
#' value for `Attributes` or if you specify `\\["DEFAULT"\\]`, the API
#' returns the following subset of facial attributes: `BoundingBox`,
#' `Confidence`, `Pose`, `Quality`, and `Landmarks`. If you provide
#' `\\["ALL"\\]`, all facial attributes are returned, but the operation
#' takes longer to complete.
#' 
#' If you provide both, `\\["ALL", "DEFAULT"\\]`, the service uses a
#' logical AND operator to determine which attributes to return (in this
#' case, all attributes).
#'
#' @section Request syntax:
#' ```
#' svc$detect_faces(
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   Attributes = list(
#'     "DEFAULT"|"ALL"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation detects faces in an image stored in an AWS S3 bucket.
#' \dontrun{svc$detect_faces(
#'   Image = list(
#'     S3Object = list(
#'       Bucket = "mybucket",
#'       Name = "myphoto"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_detect_faces
rekognition_detect_faces <- function(Image, Attributes = NULL) {
  op <- new_operation(
    name = "DetectFaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$detect_faces_input(Image = Image, Attributes = Attributes)
  output <- .rekognition$detect_faces_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$detect_faces <- rekognition_detect_faces

#' Detects instances of real-world entities within an image (JPEG or PNG)
#' provided as input
#'
#' Detects instances of real-world entities within an image (JPEG or PNG)
#' provided as input. This includes objects like flower, tree, and table;
#' events like wedding, graduation, and birthday party; and concepts like
#' landscape, evening, and nature.
#' 
#' For an example, see Analyzing Images Stored in an Amazon S3 Bucket in
#' the Amazon Rekognition Developer Guide.
#' 
#' `DetectLabels` does not support the detection of activities. However,
#' activity detection is supported for label detection in videos. For more
#' information, see StartLabelDetection in the Amazon Rekognition Developer
#' Guide.
#' 
#' You pass the input image as base64-encoded image bytes or as a reference
#' to an image in an Amazon S3 bucket. If you use the AWS CLI to call
#' Amazon Rekognition operations, passing image bytes is not supported. The
#' image must be either a PNG or JPEG formatted file.
#' 
#' For each object, scene, and concept the API returns one or more labels.
#' Each label provides the object name, and the level of confidence that
#' the image contains the object. For example, suppose the input image has
#' a lighthouse, the sea, and a rock. The response includes all three
#' labels, one for each object.
#' 
#' `\{Name: lighthouse, Confidence: 98.4629\}`
#' 
#' `\{Name: rock,Confidence: 79.2097\}`
#' 
#' ` \{Name: sea,Confidence: 75.061\}`
#' 
#' In the preceding example, the operation returns one label for each of
#' the three objects. The operation can also return multiple labels for the
#' same object in the image. For example, if the input image shows a flower
#' (for example, a tulip), the operation might return the following three
#' labels.
#' 
#' `\{Name: flower,Confidence: 99.0562\}`
#' 
#' `\{Name: plant,Confidence: 99.0562\}`
#' 
#' `\{Name: tulip,Confidence: 99.0562\}`
#' 
#' In this example, the detection algorithm more precisely identifies the
#' flower as a tulip.
#' 
#' In response, the API returns an array of labels. In addition, the
#' response also includes the orientation correction. Optionally, you can
#' specify `MinConfidence` to control the confidence threshold for the
#' labels returned. The default is 55%. You can also add the `MaxLabels`
#' parameter to limit the number of labels returned.
#' 
#' If the object detected is a person, the operation doesn\'t provide the
#' same facial details that the DetectFaces operation provides.
#' 
#' `DetectLabels` returns bounding boxes for instances of common object
#' labels in an array of Instance objects. An `Instance` object contains a
#' BoundingBox object, for the location of the label on the image. It also
#' includes the confidence by which the bounding box was detected.
#' 
#' `DetectLabels` also returns a hierarchical taxonomy of detected labels.
#' For example, a detected car might be assigned the label *car*. The label
#' *car* has two parent labels: *Vehicle* (its parent) and *Transportation*
#' (its grandparent). The response returns the entire list of ancestors for
#' a label. Each ancestor is a unique label in the response. In the
#' previous example, *Car*, *Vehicle*, and *Transportation* are returned as
#' unique labels in the response.
#' 
#' This is a stateless API operation. That is, the operation does not
#' persist any data.
#' 
#' This operation requires permissions to perform the
#' `rekognition:DetectLabels` action.
#'
#' @usage
#' rekognition_detect_labels(Image, MaxLabels, MinConfidence)
#'
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing image bytes is
#' not supported. Images stored in an S3 Bucket do not need to be
#' base64-encoded.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param MaxLabels Maximum number of labels you want the service to return in the response.
#' The service returns the specified number of highest confidence labels.
#' @param MinConfidence Specifies the minimum confidence level for the labels to return. Amazon
#' Rekognition doesn\'t return any labels with confidence lower than this
#' specified value.
#' 
#' If `MinConfidence` is not specified, the operation returns labels with a
#' confidence values greater than or equal to 55 percent.
#'
#' @section Request syntax:
#' ```
#' svc$detect_labels(
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   MaxLabels = 123,
#'   MinConfidence = 123.0
#' )
#' ```
#'
#' @examples
#' # This operation detects labels in the supplied image
#' \dontrun{svc$detect_labels(
#'   Image = list(
#'     S3Object = list(
#'       Bucket = "mybucket",
#'       Name = "myphoto"
#'     )
#'   ),
#'   MaxLabels = 123L,
#'   MinConfidence = 70L
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_detect_labels
rekognition_detect_labels <- function(Image, MaxLabels = NULL, MinConfidence = NULL) {
  op <- new_operation(
    name = "DetectLabels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$detect_labels_input(Image = Image, MaxLabels = MaxLabels, MinConfidence = MinConfidence)
  output <- .rekognition$detect_labels_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$detect_labels <- rekognition_detect_labels

#' Detects unsafe content in a specified JPEG or PNG format image
#'
#' Detects unsafe content in a specified JPEG or PNG format image. Use
#' `DetectModerationLabels` to moderate images depending on your
#' requirements. For example, you might want to filter images that contain
#' nudity, but not images containing suggestive content.
#' 
#' To filter images, use the labels returned by `DetectModerationLabels` to
#' determine which types of content are appropriate.
#' 
#' For information about moderation labels, see Detecting Unsafe Content in
#' the Amazon Rekognition Developer Guide.
#' 
#' You pass the input image either as base64-encoded image bytes or as a
#' reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
#' call Amazon Rekognition operations, passing image bytes is not
#' supported. The image must be either a PNG or JPEG formatted file.
#'
#' @usage
#' rekognition_detect_moderation_labels(Image, MinConfidence,
#'   HumanLoopConfig)
#'
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes is not supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param MinConfidence Specifies the minimum confidence level for the labels to return. Amazon
#' Rekognition doesn\'t return any labels with a confidence level lower
#' than this specified value.
#' 
#' If you don\'t specify `MinConfidence`, the operation returns labels with
#' confidence values greater than or equal to 50 percent.
#' @param HumanLoopConfig Sets up the configuration for human evaluation, including the
#' FlowDefinition the image will be sent to.
#'
#' @section Request syntax:
#' ```
#' svc$detect_moderation_labels(
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   MinConfidence = 123.0,
#'   HumanLoopConfig = list(
#'     HumanLoopName = "string",
#'     FlowDefinitionArn = "string",
#'     DataAttributes = list(
#'       ContentClassifiers = list(
#'         "FreeOfPersonallyIdentifiableInformation"|"FreeOfAdultContent"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_detect_moderation_labels
rekognition_detect_moderation_labels <- function(Image, MinConfidence = NULL, HumanLoopConfig = NULL) {
  op <- new_operation(
    name = "DetectModerationLabels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$detect_moderation_labels_input(Image = Image, MinConfidence = MinConfidence, HumanLoopConfig = HumanLoopConfig)
  output <- .rekognition$detect_moderation_labels_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$detect_moderation_labels <- rekognition_detect_moderation_labels

#' Detects text in the input image and converts it into machine-readable
#' text
#'
#' Detects text in the input image and converts it into machine-readable
#' text.
#' 
#' Pass the input image as base64-encoded image bytes or as a reference to
#' an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
#' Rekognition operations, you must pass it as a reference to an image in
#' an Amazon S3 bucket. For the AWS CLI, passing image bytes is not
#' supported. The image must be either a .png or .jpeg formatted file.
#' 
#' The `DetectText` operation returns text in an array of TextDetection
#' elements, `TextDetections`. Each `TextDetection` element provides
#' information about a single word or line of text that was detected in the
#' image.
#' 
#' A word is one or more ISO basic latin script characters that are not
#' separated by spaces. `DetectText` can detect up to 50 words in an image.
#' 
#' A line is a string of equally spaced words. A line isn\'t necessarily a
#' complete sentence. For example, a driver\'s license number is detected
#' as a line. A line ends when there is no aligned text after it. Also, a
#' line ends when there is a large gap between words, relative to the
#' length of the words. This means, depending on the gap between words,
#' Amazon Rekognition may detect multiple lines in text aligned in the same
#' direction. Periods don\'t represent the end of a line. If a sentence
#' spans multiple lines, the `DetectText` operation returns multiple lines.
#' 
#' To determine whether a `TextDetection` element is a line of text or a
#' word, use the `TextDetection` object `Type` field.
#' 
#' To be detected, text must be within +/- 90 degrees orientation of the
#' horizontal axis.
#' 
#' For more information, see DetectText in the Amazon Rekognition Developer
#' Guide.
#'
#' @usage
#' rekognition_detect_text(Image)
#'
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an Amazon S3 object. If you
#' use the AWS CLI to call Amazon Rekognition operations, you can\'t pass
#' image bytes.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#'
#' @section Request syntax:
#' ```
#' svc$detect_text(
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_detect_text
rekognition_detect_text <- function(Image) {
  op <- new_operation(
    name = "DetectText",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$detect_text_input(Image = Image)
  output <- .rekognition$detect_text_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$detect_text <- rekognition_detect_text

#' Gets the name and additional information about a celebrity based on his
#' or her Amazon Rekognition ID
#'
#' Gets the name and additional information about a celebrity based on his
#' or her Amazon Rekognition ID. The additional information is returned as
#' an array of URLs. If there is no additional information about the
#' celebrity, this list is empty.
#' 
#' For more information, see Recognizing Celebrities in an Image in the
#' Amazon Rekognition Developer Guide.
#' 
#' This operation requires permissions to perform the
#' `rekognition:GetCelebrityInfo` action.
#'
#' @usage
#' rekognition_get_celebrity_info(Id)
#'
#' @param Id &#91;required&#93; The ID for the celebrity. You get the celebrity ID from a call to the
#' RecognizeCelebrities operation, which recognizes celebrities in an
#' image.
#'
#' @section Request syntax:
#' ```
#' svc$get_celebrity_info(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_celebrity_info
rekognition_get_celebrity_info <- function(Id) {
  op <- new_operation(
    name = "GetCelebrityInfo",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_celebrity_info_input(Id = Id)
  output <- .rekognition$get_celebrity_info_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_celebrity_info <- rekognition_get_celebrity_info

#' Gets the celebrity recognition results for a Amazon Rekognition Video
#' analysis started by StartCelebrityRecognition
#'
#' Gets the celebrity recognition results for a Amazon Rekognition Video
#' analysis started by StartCelebrityRecognition.
#' 
#' Celebrity recognition in a video is an asynchronous operation. Analysis
#' is started by a call to StartCelebrityRecognition which returns a job
#' identifier (`JobId`). When the celebrity recognition operation finishes,
#' Amazon Rekognition Video publishes a completion status to the Amazon
#' Simple Notification Service topic registered in the initial call to
#' `StartCelebrityRecognition`. To get the results of the celebrity
#' recognition analysis, first check that the status value published to the
#' Amazon SNS topic is `SUCCEEDED`. If so, call `GetCelebrityDetection` and
#' pass the job identifier (`JobId`) from the initial call to
#' `StartCelebrityDetection`.
#' 
#' For more information, see Working With Stored Videos in the Amazon
#' Rekognition Developer Guide.
#' 
#' `GetCelebrityRecognition` returns detected celebrities and the time(s)
#' they are detected in an array (`Celebrities`) of CelebrityRecognition
#' objects. Each `CelebrityRecognition` contains information about the
#' celebrity in a CelebrityDetail object and the time, `Timestamp`, the
#' celebrity was detected.
#' 
#' `GetCelebrityRecognition` only returns the default facial attributes
#' (`BoundingBox`, `Confidence`, `Landmarks`, `Pose`, and `Quality`). The
#' other facial attributes listed in the `Face` object of the following
#' response syntax are not returned. For more information, see FaceDetail
#' in the Amazon Rekognition Developer Guide.
#' 
#' By default, the `Celebrities` array is sorted by time (milliseconds from
#' the start of the video). You can also sort the array by celebrity by
#' specifying the value `ID` in the `SortBy` input parameter.
#' 
#' The `CelebrityDetail` object includes the celebrity identifer and
#' additional information urls. If you don\'t store the additional
#' information urls, you can get them later by calling GetCelebrityInfo
#' with the celebrity identifer.
#' 
#' No information is returned for faces not recognized as celebrities.
#' 
#' Use MaxResults parameter to limit the number of labels returned. If
#' there are more results than specified in `MaxResults`, the value of
#' `NextToken` in the operation response contains a pagination token for
#' getting the next set of results. To get the next page of results, call
#' `GetCelebrityDetection` and populate the `NextToken` request parameter
#' with the token value returned from the previous call to
#' `GetCelebrityRecognition`.
#'
#' @usage
#' rekognition_get_celebrity_recognition(JobId, MaxResults, NextToken,
#'   SortBy)
#'
#' @param JobId &#91;required&#93; Job identifier for the required celebrity recognition analysis. You can
#' get the job identifer from a call to `StartCelebrityRecognition`.
#' @param MaxResults Maximum number of results to return per paginated call. The largest
#' value you can specify is 1000. If you specify a value greater than 1000,
#' a maximum of 1000 results is returned. The default value is 1000.
#' @param NextToken If the previous response was incomplete (because there is more
#' recognized celebrities to retrieve), Amazon Rekognition Video returns a
#' pagination token in the response. You can use this pagination token to
#' retrieve the next set of celebrities.
#' @param SortBy Sort to use for celebrities returned in `Celebrities` field. Specify
#' `ID` to sort by the celebrity identifier, specify `TIMESTAMP` to sort by
#' the time the celebrity was recognized.
#'
#' @section Request syntax:
#' ```
#' svc$get_celebrity_recognition(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SortBy = "ID"|"TIMESTAMP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_celebrity_recognition
rekognition_get_celebrity_recognition <- function(JobId, MaxResults = NULL, NextToken = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetCelebrityRecognition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_celebrity_recognition_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy)
  output <- .rekognition$get_celebrity_recognition_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_celebrity_recognition <- rekognition_get_celebrity_recognition

#' Gets the unsafe content analysis results for a Amazon Rekognition Video
#' analysis started by StartContentModeration
#'
#' Gets the unsafe content analysis results for a Amazon Rekognition Video
#' analysis started by StartContentModeration.
#' 
#' Unsafe content analysis of a video is an asynchronous operation. You
#' start analysis by calling StartContentModeration which returns a job
#' identifier (`JobId`). When analysis finishes, Amazon Rekognition Video
#' publishes a completion status to the Amazon Simple Notification Service
#' topic registered in the initial call to `StartContentModeration`. To get
#' the results of the unsafe content analysis, first check that the status
#' value published to the Amazon SNS topic is `SUCCEEDED`. If so, call
#' `GetContentModeration` and pass the job identifier (`JobId`) from the
#' initial call to `StartContentModeration`.
#' 
#' For more information, see Working with Stored Videos in the Amazon
#' Rekognition Devlopers Guide.
#' 
#' `GetContentModeration` returns detected unsafe content labels, and the
#' time they are detected, in an array, `ModerationLabels`, of
#' ContentModerationDetection objects.
#' 
#' By default, the moderated labels are returned sorted by time, in
#' milliseconds from the start of the video. You can also sort them by
#' moderated label by specifying `NAME` for the `SortBy` input parameter.
#' 
#' Since video analysis can return a large number of results, use the
#' `MaxResults` parameter to limit the number of labels returned in a
#' single call to `GetContentModeration`. If there are more results than
#' specified in `MaxResults`, the value of `NextToken` in the operation
#' response contains a pagination token for getting the next set of
#' results. To get the next page of results, call `GetContentModeration`
#' and populate the `NextToken` request parameter with the value of
#' `NextToken` returned from the previous call to `GetContentModeration`.
#' 
#' For more information, see Detecting Unsafe Content in the Amazon
#' Rekognition Developer Guide.
#'
#' @usage
#' rekognition_get_content_moderation(JobId, MaxResults, NextToken, SortBy)
#'
#' @param JobId &#91;required&#93; The identifier for the unsafe content job. Use `JobId` to identify the
#' job in a subsequent call to `GetContentModeration`.
#' @param MaxResults Maximum number of results to return per paginated call. The largest
#' value you can specify is 1000. If you specify a value greater than 1000,
#' a maximum of 1000 results is returned. The default value is 1000.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Rekognition returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' unsafe content labels.
#' @param SortBy Sort to use for elements in the `ModerationLabelDetections` array. Use
#' `TIMESTAMP` to sort array elements by the time labels are detected. Use
#' `NAME` to alphabetically group elements for a label together. Within
#' each label group, the array element are sorted by detection confidence.
#' The default sort is by `TIMESTAMP`.
#'
#' @section Request syntax:
#' ```
#' svc$get_content_moderation(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SortBy = "NAME"|"TIMESTAMP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_content_moderation
rekognition_get_content_moderation <- function(JobId, MaxResults = NULL, NextToken = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetContentModeration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_content_moderation_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy)
  output <- .rekognition$get_content_moderation_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_content_moderation <- rekognition_get_content_moderation

#' Gets face detection results for a Amazon Rekognition Video analysis
#' started by StartFaceDetection
#'
#' Gets face detection results for a Amazon Rekognition Video analysis
#' started by StartFaceDetection.
#' 
#' Face detection with Amazon Rekognition Video is an asynchronous
#' operation. You start face detection by calling StartFaceDetection which
#' returns a job identifier (`JobId`). When the face detection operation
#' finishes, Amazon Rekognition Video publishes a completion status to the
#' Amazon Simple Notification Service topic registered in the initial call
#' to `StartFaceDetection`. To get the results of the face detection
#' operation, first check that the status value published to the Amazon SNS
#' topic is `SUCCEEDED`. If so, call GetFaceDetection and pass the job
#' identifier (`JobId`) from the initial call to `StartFaceDetection`.
#' 
#' `GetFaceDetection` returns an array of detected faces (`Faces`) sorted
#' by the time the faces were detected.
#' 
#' Use MaxResults parameter to limit the number of labels returned. If
#' there are more results than specified in `MaxResults`, the value of
#' `NextToken` in the operation response contains a pagination token for
#' getting the next set of results. To get the next page of results, call
#' `GetFaceDetection` and populate the `NextToken` request parameter with
#' the token value returned from the previous call to `GetFaceDetection`.
#'
#' @usage
#' rekognition_get_face_detection(JobId, MaxResults, NextToken)
#'
#' @param JobId &#91;required&#93; Unique identifier for the face detection job. The `JobId` is returned
#' from `StartFaceDetection`.
#' @param MaxResults Maximum number of results to return per paginated call. The largest
#' value you can specify is 1000. If you specify a value greater than 1000,
#' a maximum of 1000 results is returned. The default value is 1000.
#' @param NextToken If the previous response was incomplete (because there are more faces to
#' retrieve), Amazon Rekognition Video returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' faces.
#'
#' @section Request syntax:
#' ```
#' svc$get_face_detection(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_face_detection
rekognition_get_face_detection <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetFaceDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_face_detection_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .rekognition$get_face_detection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_face_detection <- rekognition_get_face_detection

#' Gets the face search results for Amazon Rekognition Video face search
#' started by StartFaceSearch
#'
#' Gets the face search results for Amazon Rekognition Video face search
#' started by StartFaceSearch. The search returns faces in a collection
#' that match the faces of persons detected in a video. It also includes
#' the time(s) that faces are matched in the video.
#' 
#' Face search in a video is an asynchronous operation. You start face
#' search by calling to StartFaceSearch which returns a job identifier
#' (`JobId`). When the search operation finishes, Amazon Rekognition Video
#' publishes a completion status to the Amazon Simple Notification Service
#' topic registered in the initial call to `StartFaceSearch`. To get the
#' search results, first check that the status value published to the
#' Amazon SNS topic is `SUCCEEDED`. If so, call `GetFaceSearch` and pass
#' the job identifier (`JobId`) from the initial call to `StartFaceSearch`.
#' 
#' For more information, see Searching Faces in a Collection in the Amazon
#' Rekognition Developer Guide.
#' 
#' The search results are retured in an array, `Persons`, of PersonMatch
#' objects. Each`PersonMatch` element contains details about the matching
#' faces in the input collection, person information (facial attributes,
#' bounding boxes, and person identifer) for the matched person, and the
#' time the person was matched in the video.
#' 
#' `GetFaceSearch` only returns the default facial attributes
#' (`BoundingBox`, `Confidence`, `Landmarks`, `Pose`, and `Quality`). The
#' other facial attributes listed in the `Face` object of the following
#' response syntax are not returned. For more information, see FaceDetail
#' in the Amazon Rekognition Developer Guide.
#' 
#' By default, the `Persons` array is sorted by the time, in milliseconds
#' from the start of the video, persons are matched. You can also sort by
#' persons by specifying `INDEX` for the `SORTBY` input parameter.
#'
#' @usage
#' rekognition_get_face_search(JobId, MaxResults, NextToken, SortBy)
#'
#' @param JobId &#91;required&#93; The job identifer for the search request. You get the job identifier
#' from an initial call to `StartFaceSearch`.
#' @param MaxResults Maximum number of results to return per paginated call. The largest
#' value you can specify is 1000. If you specify a value greater than 1000,
#' a maximum of 1000 results is returned. The default value is 1000.
#' @param NextToken If the previous response was incomplete (because there is more search
#' results to retrieve), Amazon Rekognition Video returns a pagination
#' token in the response. You can use this pagination token to retrieve the
#' next set of search results.
#' @param SortBy Sort to use for grouping faces in the response. Use `TIMESTAMP` to group
#' faces by the time that they are recognized. Use `INDEX` to sort by
#' recognized faces.
#'
#' @section Request syntax:
#' ```
#' svc$get_face_search(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SortBy = "INDEX"|"TIMESTAMP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_face_search
rekognition_get_face_search <- function(JobId, MaxResults = NULL, NextToken = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetFaceSearch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_face_search_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy)
  output <- .rekognition$get_face_search_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_face_search <- rekognition_get_face_search

#' Gets the label detection results of a Amazon Rekognition Video analysis
#' started by StartLabelDetection
#'
#' Gets the label detection results of a Amazon Rekognition Video analysis
#' started by StartLabelDetection.
#' 
#' The label detection operation is started by a call to
#' StartLabelDetection which returns a job identifier (`JobId`). When the
#' label detection operation finishes, Amazon Rekognition publishes a
#' completion status to the Amazon Simple Notification Service topic
#' registered in the initial call to `StartlabelDetection`. To get the
#' results of the label detection operation, first check that the status
#' value published to the Amazon SNS topic is `SUCCEEDED`. If so, call
#' GetLabelDetection and pass the job identifier (`JobId`) from the initial
#' call to `StartLabelDetection`.
#' 
#' `GetLabelDetection` returns an array of detected labels (`Labels`)
#' sorted by the time the labels were detected. You can also sort by the
#' label name by specifying `NAME` for the `SortBy` input parameter.
#' 
#' The labels returned include the label name, the percentage confidence in
#' the accuracy of the detected label, and the time the label was detected
#' in the video.
#' 
#' The returned labels also include bounding box information for common
#' objects, a hierarchical taxonomy of detected labels, and the version of
#' the label model used for detection.
#' 
#' Use MaxResults parameter to limit the number of labels returned. If
#' there are more results than specified in `MaxResults`, the value of
#' `NextToken` in the operation response contains a pagination token for
#' getting the next set of results. To get the next page of results, call
#' `GetlabelDetection` and populate the `NextToken` request parameter with
#' the token value returned from the previous call to `GetLabelDetection`.
#'
#' @usage
#' rekognition_get_label_detection(JobId, MaxResults, NextToken, SortBy)
#'
#' @param JobId &#91;required&#93; Job identifier for the label detection operation for which you want
#' results returned. You get the job identifer from an initial call to
#' `StartlabelDetection`.
#' @param MaxResults Maximum number of results to return per paginated call. The largest
#' value you can specify is 1000. If you specify a value greater than 1000,
#' a maximum of 1000 results is returned. The default value is 1000.
#' @param NextToken If the previous response was incomplete (because there are more labels
#' to retrieve), Amazon Rekognition Video returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' labels.
#' @param SortBy Sort to use for elements in the `Labels` array. Use `TIMESTAMP` to sort
#' array elements by the time labels are detected. Use `NAME` to
#' alphabetically group elements for a label together. Within each label
#' group, the array element are sorted by detection confidence. The default
#' sort is by `TIMESTAMP`.
#'
#' @section Request syntax:
#' ```
#' svc$get_label_detection(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SortBy = "NAME"|"TIMESTAMP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_label_detection
rekognition_get_label_detection <- function(JobId, MaxResults = NULL, NextToken = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetLabelDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_label_detection_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy)
  output <- .rekognition$get_label_detection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_label_detection <- rekognition_get_label_detection

#' Gets the path tracking results of a Amazon Rekognition Video analysis
#' started by StartPersonTracking
#'
#' Gets the path tracking results of a Amazon Rekognition Video analysis
#' started by StartPersonTracking.
#' 
#' The person path tracking operation is started by a call to
#' `StartPersonTracking` which returns a job identifier (`JobId`). When the
#' operation finishes, Amazon Rekognition Video publishes a completion
#' status to the Amazon Simple Notification Service topic registered in the
#' initial call to `StartPersonTracking`.
#' 
#' To get the results of the person path tracking operation, first check
#' that the status value published to the Amazon SNS topic is `SUCCEEDED`.
#' If so, call GetPersonTracking and pass the job identifier (`JobId`) from
#' the initial call to `StartPersonTracking`.
#' 
#' `GetPersonTracking` returns an array, `Persons`, of tracked persons and
#' the time(s) their paths were tracked in the video.
#' 
#' `GetPersonTracking` only returns the default facial attributes
#' (`BoundingBox`, `Confidence`, `Landmarks`, `Pose`, and `Quality`). The
#' other facial attributes listed in the `Face` object of the following
#' response syntax are not returned.
#' 
#' For more information, see FaceDetail in the Amazon Rekognition Developer
#' Guide.
#' 
#' By default, the array is sorted by the time(s) a person\'s path is
#' tracked in the video. You can sort by tracked persons by specifying
#' `INDEX` for the `SortBy` input parameter.
#' 
#' Use the `MaxResults` parameter to limit the number of items returned. If
#' there are more results than specified in `MaxResults`, the value of
#' `NextToken` in the operation response contains a pagination token for
#' getting the next set of results. To get the next page of results, call
#' `GetPersonTracking` and populate the `NextToken` request parameter with
#' the token value returned from the previous call to `GetPersonTracking`.
#'
#' @usage
#' rekognition_get_person_tracking(JobId, MaxResults, NextToken, SortBy)
#'
#' @param JobId &#91;required&#93; The identifier for a job that tracks persons in a video. You get the
#' `JobId` from a call to `StartPersonTracking`.
#' @param MaxResults Maximum number of results to return per paginated call. The largest
#' value you can specify is 1000. If you specify a value greater than 1000,
#' a maximum of 1000 results is returned. The default value is 1000.
#' @param NextToken If the previous response was incomplete (because there are more persons
#' to retrieve), Amazon Rekognition Video returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' persons.
#' @param SortBy Sort to use for elements in the `Persons` array. Use `TIMESTAMP` to sort
#' array elements by the time persons are detected. Use `INDEX` to sort by
#' the tracked persons. If you sort by `INDEX`, the array elements for each
#' person are sorted by detection confidence. The default sort is by
#' `TIMESTAMP`.
#'
#' @section Request syntax:
#' ```
#' svc$get_person_tracking(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SortBy = "INDEX"|"TIMESTAMP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_get_person_tracking
rekognition_get_person_tracking <- function(JobId, MaxResults = NULL, NextToken = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetPersonTracking",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$get_person_tracking_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy)
  output <- .rekognition$get_person_tracking_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$get_person_tracking <- rekognition_get_person_tracking

#' Detects faces in the input image and adds them to the specified
#' collection
#'
#' Detects faces in the input image and adds them to the specified
#' collection.
#' 
#' Amazon Rekognition doesn\'t save the actual faces that are detected.
#' Instead, the underlying detection algorithm first detects the faces in
#' the input image. For each face, the algorithm extracts facial features
#' into a feature vector, and stores it in the backend database. Amazon
#' Rekognition uses feature vectors when it performs face match and search
#' operations using the SearchFaces and SearchFacesByImage operations.
#' 
#' For more information, see Adding Faces to a Collection in the Amazon
#' Rekognition Developer Guide.
#' 
#' To get the number of faces in a collection, call DescribeCollection.
#' 
#' If you\'re using version 1.0 of the face detection model, `IndexFaces`
#' indexes the 15 largest faces in the input image. Later versions of the
#' face detection model index the 100 largest faces in the input image.
#' 
#' If you\'re using version 4 or later of the face model, image orientation
#' information is not returned in the `OrientationCorrection` field.
#' 
#' To determine which version of the model you\'re using, call
#' DescribeCollection and supply the collection ID. You can also get the
#' model version from the value of `FaceModelVersion` in the response from
#' `IndexFaces`
#' 
#' For more information, see Model Versioning in the Amazon Rekognition
#' Developer Guide.
#' 
#' If you provide the optional `ExternalImageID` for the input image you
#' provided, Amazon Rekognition associates this ID with all faces that it
#' detects. When you call the ListFaces operation, the response returns the
#' external ID. You can use this external image ID to create a client-side
#' index to associate the faces with each image. You can then use the index
#' to find all faces in an image.
#' 
#' You can specify the maximum number of faces to index with the `MaxFaces`
#' input parameter. This is useful when you want to index the largest faces
#' in an image and don\'t want to index smaller faces, such as those
#' belonging to people standing in the background.
#' 
#' The `QualityFilter` input parameter allows you to filter out detected
#' faces that don't meet a required quality bar. The quality bar is based
#' on a variety of common use cases. By default, `IndexFaces` chooses the
#' quality bar that\'s used to filter faces. You can also explicitly choose
#' the quality bar. Use `QualityFilter`, to set the quality bar by
#' specifying `LOW`, `MEDIUM`, or `HIGH`. If you do not want to filter
#' detected faces, specify `NONE`.
#' 
#' To use quality filtering, you need a collection associated with version
#' 3 of the face model or higher. To get the version of the face model
#' associated with a collection, call DescribeCollection.
#' 
#' Information about faces detected in an image, but not indexed, is
#' returned in an array of UnindexedFace objects, `UnindexedFaces`. Faces
#' aren\'t indexed for reasons such as:
#' 
#' -   The number of faces detected exceeds the value of the `MaxFaces`
#'     request parameter.
#' 
#' -   The face is too small compared to the image dimensions.
#' 
#' -   The face is too blurry.
#' 
#' -   The image is too dark.
#' 
#' -   The face has an extreme pose.
#' 
#' -   The face doesn't have enough detail to be suitable for face search.
#' 
#' In response, the `IndexFaces` operation returns an array of metadata for
#' all detected faces, `FaceRecords`. This includes:
#' 
#' -   The bounding box, `BoundingBox`, of the detected face.
#' 
#' -   A confidence value, `Confidence`, which indicates the confidence
#'     that the bounding box contains a face.
#' 
#' -   A face ID, `FaceId`, assigned by the service for each face that\'s
#'     detected and stored.
#' 
#' -   An image ID, `ImageId`, assigned by the service for the input image.
#' 
#' If you request all facial attributes (by using the `detectionAttributes`
#' parameter), Amazon Rekognition returns detailed facial attributes, such
#' as facial landmarks (for example, location of eye and mouth) and other
#' facial attributes. If you provide the same image, specify the same
#' collection, and use the same external ID in the `IndexFaces` operation,
#' Amazon Rekognition doesn\'t save duplicate face metadata.
#' 
#' The input image is passed either as base64-encoded image bytes, or as a
#' reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
#' call Amazon Rekognition operations, passing image bytes isn\'t
#' supported. The image must be formatted as a PNG or JPEG file.
#' 
#' This operation requires permissions to perform the
#' `rekognition:IndexFaces` action.
#'
#' @usage
#' rekognition_index_faces(CollectionId, Image, ExternalImageId,
#'   DetectionAttributes, MaxFaces, QualityFilter)
#'
#' @param CollectionId &#91;required&#93; The ID of an existing collection to which you want to add the faces that
#' are detected in the input images.
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes isn\'t supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param ExternalImageId The ID you want to assign to all the faces detected in the image.
#' @param DetectionAttributes An array of facial attributes that you want to be returned. This can be
#' the default list of attributes or all attributes. If you don\'t specify
#' a value for `Attributes` or if you specify `\\["DEFAULT"\\]`, the API
#' returns the following subset of facial attributes: `BoundingBox`,
#' `Confidence`, `Pose`, `Quality`, and `Landmarks`. If you provide
#' `\\["ALL"\\]`, all facial attributes are returned, but the operation
#' takes longer to complete.
#' 
#' If you provide both, `\\["ALL", "DEFAULT"\\]`, the service uses a
#' logical AND operator to determine which attributes to return (in this
#' case, all attributes).
#' @param MaxFaces The maximum number of faces to index. The value of `MaxFaces` must be
#' greater than or equal to 1. `IndexFaces` returns no more than 100
#' detected faces in an image, even if you specify a larger value for
#' `MaxFaces`.
#' 
#' If `IndexFaces` detects more faces than the value of `MaxFaces`, the
#' faces with the lowest quality are filtered out first. If there are still
#' more faces than the value of `MaxFaces`, the faces with the smallest
#' bounding boxes are filtered out (up to the number that\'s needed to
#' satisfy the value of `MaxFaces`). Information about the unindexed faces
#' is available in the `UnindexedFaces` array.
#' 
#' The faces that are returned by `IndexFaces` are sorted by the largest
#' face bounding box size to the smallest size, in descending order.
#' 
#' `MaxFaces` can be used with a collection associated with any version of
#' the face model.
#' @param QualityFilter A filter that specifies a quality bar for how much filtering is done to
#' identify faces. Filtered faces aren\'t indexed. If you specify `AUTO`,
#' Amazon Rekognition chooses the quality bar. If you specify `LOW`,
#' `MEDIUM`, or `HIGH`, filtering removes all faces that don't meet the
#' chosen quality bar. The default value is `AUTO`. The quality bar is
#' based on a variety of common use cases. Low-quality detections can occur
#' for a number of reasons. Some examples are an object that\'s
#' misidentified as a face, a face that\'s too blurry, or a face with a
#' pose that\'s too extreme to use. If you specify `NONE`, no filtering is
#' performed.
#' 
#' To use quality filtering, the collection you are using must be
#' associated with version 3 of the face model or higher.
#'
#' @section Request syntax:
#' ```
#' svc$index_faces(
#'   CollectionId = "string",
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ExternalImageId = "string",
#'   DetectionAttributes = list(
#'     "DEFAULT"|"ALL"
#'   ),
#'   MaxFaces = 123,
#'   QualityFilter = "NONE"|"AUTO"|"LOW"|"MEDIUM"|"HIGH"
#' )
#' ```
#'
#' @examples
#' # This operation detects faces in an image and adds them to the specified
#' # Rekognition collection.
#' \dontrun{svc$index_faces(
#'   CollectionId = "myphotos",
#'   DetectionAttributes = list(),
#'   ExternalImageId = "myphotoid",
#'   Image = list(
#'     S3Object = list(
#'       Bucket = "mybucket",
#'       Name = "myphoto"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_index_faces
rekognition_index_faces <- function(CollectionId, Image, ExternalImageId = NULL, DetectionAttributes = NULL, MaxFaces = NULL, QualityFilter = NULL) {
  op <- new_operation(
    name = "IndexFaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$index_faces_input(CollectionId = CollectionId, Image = Image, ExternalImageId = ExternalImageId, DetectionAttributes = DetectionAttributes, MaxFaces = MaxFaces, QualityFilter = QualityFilter)
  output <- .rekognition$index_faces_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$index_faces <- rekognition_index_faces

#' Returns list of collection IDs in your account
#'
#' Returns list of collection IDs in your account. If the result is
#' truncated, the response also provides a `NextToken` that you can use in
#' the subsequent request to fetch the next set of collection IDs.
#' 
#' For an example, see Listing Collections in the Amazon Rekognition
#' Developer Guide.
#' 
#' This operation requires permissions to perform the
#' `rekognition:ListCollections` action.
#'
#' @usage
#' rekognition_list_collections(NextToken, MaxResults)
#'
#' @param NextToken Pagination token from the previous response.
#' @param MaxResults Maximum number of collection IDs to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_collections(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This operation returns a list of Rekognition collections.
#' \dontrun{svc$list_collections()}
#'
#' @keywords internal
#'
#' @rdname rekognition_list_collections
rekognition_list_collections <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCollections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$list_collections_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .rekognition$list_collections_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$list_collections <- rekognition_list_collections

#' Returns metadata for faces in the specified collection
#'
#' Returns metadata for faces in the specified collection. This metadata
#' includes information such as the bounding box coordinates, the
#' confidence (that the bounding box contains a face), and face ID. For an
#' example, see Listing Faces in a Collection in the Amazon Rekognition
#' Developer Guide.
#' 
#' This operation requires permissions to perform the
#' `rekognition:ListFaces` action.
#'
#' @usage
#' rekognition_list_faces(CollectionId, NextToken, MaxResults)
#'
#' @param CollectionId &#91;required&#93; ID of the collection from which to list the faces.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Rekognition returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' faces.
#' @param MaxResults Maximum number of faces to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_faces(
#'   CollectionId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This operation lists the faces in a Rekognition collection.
#' \dontrun{svc$list_faces(
#'   CollectionId = "myphotos",
#'   MaxResults = 20L
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_list_faces
rekognition_list_faces <- function(CollectionId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$list_faces_input(CollectionId = CollectionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .rekognition$list_faces_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$list_faces <- rekognition_list_faces

#' Gets a list of stream processors that you have created with
#' CreateStreamProcessor
#'
#' Gets a list of stream processors that you have created with
#' CreateStreamProcessor.
#'
#' @usage
#' rekognition_list_stream_processors(NextToken, MaxResults)
#'
#' @param NextToken If the previous response was incomplete (because there are more stream
#' processors to retrieve), Amazon Rekognition Video returns a pagination
#' token in the response. You can use this pagination token to retrieve the
#' next set of stream processors.
#' @param MaxResults Maximum number of stream processors you want Amazon Rekognition Video to
#' return in the response. The default is 1000.
#'
#' @section Request syntax:
#' ```
#' svc$list_stream_processors(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_list_stream_processors
rekognition_list_stream_processors <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListStreamProcessors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$list_stream_processors_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .rekognition$list_stream_processors_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$list_stream_processors <- rekognition_list_stream_processors

#' Returns an array of celebrities recognized in the input image
#'
#' Returns an array of celebrities recognized in the input image. For more
#' information, see Recognizing Celebrities in the Amazon Rekognition
#' Developer Guide.
#' 
#' `RecognizeCelebrities` returns the 100 largest faces in the image. It
#' lists recognized celebrities in the `CelebrityFaces` array and
#' unrecognized faces in the `UnrecognizedFaces` array.
#' `RecognizeCelebrities` doesn\'t return celebrities whose faces aren\'t
#' among the largest 100 faces in the image.
#' 
#' For each celebrity recognized, `RecognizeCelebrities` returns a
#' `Celebrity` object. The `Celebrity` object contains the celebrity name,
#' ID, URL links to additional information, match confidence, and a
#' `ComparedFace` object that you can use to locate the celebrity\'s face
#' on the image.
#' 
#' Amazon Rekognition doesn\'t retain information about which images a
#' celebrity has been recognized in. Your application must store this
#' information and use the `Celebrity` ID property as a unique identifier
#' for the celebrity. If you don\'t store the celebrity name or additional
#' information URLs returned by `RecognizeCelebrities`, you will need the
#' ID to identify the celebrity in a call to the GetCelebrityInfo
#' operation.
#' 
#' You pass the input image either as base64-encoded image bytes or as a
#' reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
#' call Amazon Rekognition operations, passing image bytes is not
#' supported. The image must be either a PNG or JPEG formatted file.
#' 
#' For an example, see Recognizing Celebrities in an Image in the Amazon
#' Rekognition Developer Guide.
#' 
#' This operation requires permissions to perform the
#' `rekognition:RecognizeCelebrities` operation.
#'
#' @usage
#' rekognition_recognize_celebrities(Image)
#'
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes is not supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#'
#' @section Request syntax:
#' ```
#' svc$recognize_celebrities(
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_recognize_celebrities
rekognition_recognize_celebrities <- function(Image) {
  op <- new_operation(
    name = "RecognizeCelebrities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$recognize_celebrities_input(Image = Image)
  output <- .rekognition$recognize_celebrities_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$recognize_celebrities <- rekognition_recognize_celebrities

#' For a given input face ID, searches for matching faces in the collection
#' the face belongs to
#'
#' For a given input face ID, searches for matching faces in the collection
#' the face belongs to. You get a face ID when you add a face to the
#' collection using the IndexFaces operation. The operation compares the
#' features of the input face with faces in the specified collection.
#' 
#' You can also search faces without indexing faces by using the
#' `SearchFacesByImage` operation.
#' 
#' The operation response returns an array of faces that match, ordered by
#' similarity score with the highest similarity first. More specifically,
#' it is an array of metadata for each face match that is found. Along with
#' the metadata, the response also includes a `confidence` value for each
#' face match, indicating the confidence that the specific face matches the
#' input face.
#' 
#' For an example, see Searching for a Face Using Its Face ID in the Amazon
#' Rekognition Developer Guide.
#' 
#' This operation requires permissions to perform the
#' `rekognition:SearchFaces` action.
#'
#' @usage
#' rekognition_search_faces(CollectionId, FaceId, MaxFaces,
#'   FaceMatchThreshold)
#'
#' @param CollectionId &#91;required&#93; ID of the collection the face belongs to.
#' @param FaceId &#91;required&#93; ID of a face to find matches for in the collection.
#' @param MaxFaces Maximum number of faces to return. The operation returns the maximum
#' number of faces with the highest confidence in the match.
#' @param FaceMatchThreshold Optional value specifying the minimum confidence in the face match to
#' return. For example, don\'t return any matches where confidence in
#' matches is less than 70%. The default value is 80%.
#'
#' @section Request syntax:
#' ```
#' svc$search_faces(
#'   CollectionId = "string",
#'   FaceId = "string",
#'   MaxFaces = 123,
#'   FaceMatchThreshold = 123.0
#' )
#' ```
#'
#' @examples
#' # This operation searches for matching faces in the collection the
#' # supplied face belongs to.
#' \dontrun{svc$search_faces(
#'   CollectionId = "myphotos",
#'   FaceId = "70008e50-75e4-55d0-8e80-363fb73b3a14",
#'   FaceMatchThreshold = 90L,
#'   MaxFaces = 10L
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_search_faces
rekognition_search_faces <- function(CollectionId, FaceId, MaxFaces = NULL, FaceMatchThreshold = NULL) {
  op <- new_operation(
    name = "SearchFaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$search_faces_input(CollectionId = CollectionId, FaceId = FaceId, MaxFaces = MaxFaces, FaceMatchThreshold = FaceMatchThreshold)
  output <- .rekognition$search_faces_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$search_faces <- rekognition_search_faces

#' For a given input image, first detects the largest face in the image,
#' and then searches the specified collection for matching faces
#'
#' For a given input image, first detects the largest face in the image,
#' and then searches the specified collection for matching faces. The
#' operation compares the features of the input face with faces in the
#' specified collection.
#' 
#' To search for all faces in an input image, you might first call the
#' IndexFaces operation, and then use the face IDs returned in subsequent
#' calls to the SearchFaces operation.
#' 
#' You can also call the `DetectFaces` operation and use the bounding boxes
#' in the response to make face crops, which then you can pass in to the
#' `SearchFacesByImage` operation.
#' 
#' You pass the input image either as base64-encoded image bytes or as a
#' reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
#' call Amazon Rekognition operations, passing image bytes is not
#' supported. The image must be either a PNG or JPEG formatted file.
#' 
#' The response returns an array of faces that match, ordered by similarity
#' score with the highest similarity first. More specifically, it is an
#' array of metadata for each face match found. Along with the metadata,
#' the response also includes a `similarity` indicating how similar the
#' face is to the input face. In the response, the operation also returns
#' the bounding box (and a confidence level that the bounding box contains
#' a face) of the face that Amazon Rekognition used for the input image.
#' 
#' For an example, Searching for a Face Using an Image in the Amazon
#' Rekognition Developer Guide.
#' 
#' The `QualityFilter` input parameter allows you to filter out detected
#' faces that don't meet a required quality bar. The quality bar is based
#' on a variety of common use cases. Use `QualityFilter` to set the quality
#' bar for filtering by specifying `LOW`, `MEDIUM`, or `HIGH`. If you do
#' not want to filter detected faces, specify `NONE`. The default value is
#' `NONE`.
#' 
#' To use quality filtering, you need a collection associated with version
#' 3 of the face model or higher. To get the version of the face model
#' associated with a collection, call DescribeCollection.
#' 
#' This operation requires permissions to perform the
#' `rekognition:SearchFacesByImage` action.
#'
#' @usage
#' rekognition_search_faces_by_image(CollectionId, Image, MaxFaces,
#'   FaceMatchThreshold, QualityFilter)
#'
#' @param CollectionId &#91;required&#93; ID of the collection to search.
#' @param Image &#91;required&#93; The input image as base64-encoded bytes or an S3 object. If you use the
#' AWS CLI to call Amazon Rekognition operations, passing base64-encoded
#' image bytes is not supported.
#' 
#' If you are using an AWS SDK to call Amazon Rekognition, you might not
#' need to base64-encode image bytes passed using the `Bytes` field. For
#' more information, see Images in the Amazon Rekognition developer guide.
#' @param MaxFaces Maximum number of faces to return. The operation returns the maximum
#' number of faces with the highest confidence in the match.
#' @param FaceMatchThreshold (Optional) Specifies the minimum confidence in the face match to return.
#' For example, don\'t return any matches where confidence in matches is
#' less than 70%. The default value is 80%.
#' @param QualityFilter A filter that specifies a quality bar for how much filtering is done to
#' identify faces. Filtered faces aren\'t searched for in the collection.
#' If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If
#' you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that
#' don't meet the chosen quality bar. The quality bar is based on a variety
#' of common use cases. Low-quality detections can occur for a number of
#' reasons. Some examples are an object that\'s misidentified as a face, a
#' face that\'s too blurry, or a face with a pose that\'s too extreme to
#' use. If you specify `NONE`, no filtering is performed. The default value
#' is `NONE`.
#' 
#' To use quality filtering, the collection you are using must be
#' associated with version 3 of the face model or higher.
#'
#' @section Request syntax:
#' ```
#' svc$search_faces_by_image(
#'   CollectionId = "string",
#'   Image = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   MaxFaces = 123,
#'   FaceMatchThreshold = 123.0,
#'   QualityFilter = "NONE"|"AUTO"|"LOW"|"MEDIUM"|"HIGH"
#' )
#' ```
#'
#' @examples
#' # This operation searches for faces in a Rekognition collection that match
#' # the largest face in an S3 bucket stored image.
#' \dontrun{svc$search_faces_by_image(
#'   CollectionId = "myphotos",
#'   FaceMatchThreshold = 95L,
#'   Image = list(
#'     S3Object = list(
#'       Bucket = "mybucket",
#'       Name = "myphoto"
#'     )
#'   ),
#'   MaxFaces = 5L
#' )}
#'
#' @keywords internal
#'
#' @rdname rekognition_search_faces_by_image
rekognition_search_faces_by_image <- function(CollectionId, Image, MaxFaces = NULL, FaceMatchThreshold = NULL, QualityFilter = NULL) {
  op <- new_operation(
    name = "SearchFacesByImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$search_faces_by_image_input(CollectionId = CollectionId, Image = Image, MaxFaces = MaxFaces, FaceMatchThreshold = FaceMatchThreshold, QualityFilter = QualityFilter)
  output <- .rekognition$search_faces_by_image_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$search_faces_by_image <- rekognition_search_faces_by_image

#' Starts asynchronous recognition of celebrities in a stored video
#'
#' Starts asynchronous recognition of celebrities in a stored video.
#' 
#' Amazon Rekognition Video can detect celebrities in a video must be
#' stored in an Amazon S3 bucket. Use Video to specify the bucket name and
#' the filename of the video. `StartCelebrityRecognition` returns a job
#' identifier (`JobId`) which you use to get the results of the analysis.
#' When celebrity recognition analysis is finished, Amazon Rekognition
#' Video publishes a completion status to the Amazon Simple Notification
#' Service topic that you specify in `NotificationChannel`. To get the
#' results of the celebrity recognition analysis, first check that the
#' status value published to the Amazon SNS topic is `SUCCEEDED`. If so,
#' call GetCelebrityRecognition and pass the job identifier (`JobId`) from
#' the initial call to `StartCelebrityRecognition`.
#' 
#' For more information, see Recognizing Celebrities in the Amazon
#' Rekognition Developer Guide.
#'
#' @usage
#' rekognition_start_celebrity_recognition(Video, ClientRequestToken,
#'   NotificationChannel, JobTag)
#'
#' @param Video &#91;required&#93; The video in which you want to recognize celebrities. The video must be
#' stored in an Amazon S3 bucket.
#' @param ClientRequestToken Idempotent token used to identify the start request. If you use the same
#' token with multiple `StartCelebrityRecognition` requests, the same
#' `JobId` is returned. Use `ClientRequestToken` to prevent the same job
#' from being accidently started more than once.
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Rekognition Video to
#' publish the completion status of the celebrity recognition analysis to.
#' @param JobTag An identifier you specify that\'s returned in the completion
#' notification that\'s published to your Amazon Simple Notification
#' Service topic. For example, you can use `JobTag` to group related jobs
#' and identify them in the completion notification.
#'
#' @section Request syntax:
#' ```
#' svc$start_celebrity_recognition(
#'   Video = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   ),
#'   JobTag = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_celebrity_recognition
rekognition_start_celebrity_recognition <- function(Video, ClientRequestToken = NULL, NotificationChannel = NULL, JobTag = NULL) {
  op <- new_operation(
    name = "StartCelebrityRecognition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_celebrity_recognition_input(Video = Video, ClientRequestToken = ClientRequestToken, NotificationChannel = NotificationChannel, JobTag = JobTag)
  output <- .rekognition$start_celebrity_recognition_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_celebrity_recognition <- rekognition_start_celebrity_recognition

#' Starts asynchronous detection of unsafe content in a stored video
#'
#' Starts asynchronous detection of unsafe content in a stored video.
#' 
#' Amazon Rekognition Video can moderate content in a video stored in an
#' Amazon S3 bucket. Use Video to specify the bucket name and the filename
#' of the video. `StartContentModeration` returns a job identifier
#' (`JobId`) which you use to get the results of the analysis. When unsafe
#' content analysis is finished, Amazon Rekognition Video publishes a
#' completion status to the Amazon Simple Notification Service topic that
#' you specify in `NotificationChannel`.
#' 
#' To get the results of the unsafe content analysis, first check that the
#' status value published to the Amazon SNS topic is `SUCCEEDED`. If so,
#' call GetContentModeration and pass the job identifier (`JobId`) from the
#' initial call to `StartContentModeration`.
#' 
#' For more information, see Detecting Unsafe Content in the Amazon
#' Rekognition Developer Guide.
#'
#' @usage
#' rekognition_start_content_moderation(Video, MinConfidence,
#'   ClientRequestToken, NotificationChannel, JobTag)
#'
#' @param Video &#91;required&#93; The video in which you want to detect unsafe content. The video must be
#' stored in an Amazon S3 bucket.
#' @param MinConfidence Specifies the minimum confidence that Amazon Rekognition must have in
#' order to return a moderated content label. Confidence represents how
#' certain Amazon Rekognition is that the moderated content is correctly
#' identified. 0 is the lowest confidence. 100 is the highest confidence.
#' Amazon Rekognition doesn\'t return any moderated content labels with a
#' confidence level lower than this specified value. If you don\'t specify
#' `MinConfidence`, `GetContentModeration` returns labels with confidence
#' values greater than or equal to 50 percent.
#' @param ClientRequestToken Idempotent token used to identify the start request. If you use the same
#' token with multiple `StartContentModeration` requests, the same `JobId`
#' is returned. Use `ClientRequestToken` to prevent the same job from being
#' accidently started more than once.
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Rekognition Video to
#' publish the completion status of the unsafe content analysis to.
#' @param JobTag An identifier you specify that\'s returned in the completion
#' notification that\'s published to your Amazon Simple Notification
#' Service topic. For example, you can use `JobTag` to group related jobs
#' and identify them in the completion notification.
#'
#' @section Request syntax:
#' ```
#' svc$start_content_moderation(
#'   Video = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   MinConfidence = 123.0,
#'   ClientRequestToken = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   ),
#'   JobTag = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_content_moderation
rekognition_start_content_moderation <- function(Video, MinConfidence = NULL, ClientRequestToken = NULL, NotificationChannel = NULL, JobTag = NULL) {
  op <- new_operation(
    name = "StartContentModeration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_content_moderation_input(Video = Video, MinConfidence = MinConfidence, ClientRequestToken = ClientRequestToken, NotificationChannel = NotificationChannel, JobTag = JobTag)
  output <- .rekognition$start_content_moderation_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_content_moderation <- rekognition_start_content_moderation

#' Starts asynchronous detection of faces in a stored video
#'
#' Starts asynchronous detection of faces in a stored video.
#' 
#' Amazon Rekognition Video can detect faces in a video stored in an Amazon
#' S3 bucket. Use Video to specify the bucket name and the filename of the
#' video. `StartFaceDetection` returns a job identifier (`JobId`) that you
#' use to get the results of the operation. When face detection is
#' finished, Amazon Rekognition Video publishes a completion status to the
#' Amazon Simple Notification Service topic that you specify in
#' `NotificationChannel`. To get the results of the face detection
#' operation, first check that the status value published to the Amazon SNS
#' topic is `SUCCEEDED`. If so, call GetFaceDetection and pass the job
#' identifier (`JobId`) from the initial call to `StartFaceDetection`.
#' 
#' For more information, see Detecting Faces in a Stored Video in the
#' Amazon Rekognition Developer Guide.
#'
#' @usage
#' rekognition_start_face_detection(Video, ClientRequestToken,
#'   NotificationChannel, FaceAttributes, JobTag)
#'
#' @param Video &#91;required&#93; The video in which you want to detect faces. The video must be stored in
#' an Amazon S3 bucket.
#' @param ClientRequestToken Idempotent token used to identify the start request. If you use the same
#' token with multiple `StartFaceDetection` requests, the same `JobId` is
#' returned. Use `ClientRequestToken` to prevent the same job from being
#' accidently started more than once.
#' @param NotificationChannel The ARN of the Amazon SNS topic to which you want Amazon Rekognition
#' Video to publish the completion status of the face detection operation.
#' @param FaceAttributes The face attributes you want returned.
#' 
#' `DEFAULT` - The following subset of facial attributes are returned:
#' BoundingBox, Confidence, Pose, Quality and Landmarks.
#' 
#' `ALL` - All facial attributes are returned.
#' @param JobTag An identifier you specify that\'s returned in the completion
#' notification that\'s published to your Amazon Simple Notification
#' Service topic. For example, you can use `JobTag` to group related jobs
#' and identify them in the completion notification.
#'
#' @section Request syntax:
#' ```
#' svc$start_face_detection(
#'   Video = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   ),
#'   FaceAttributes = "DEFAULT"|"ALL",
#'   JobTag = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_face_detection
rekognition_start_face_detection <- function(Video, ClientRequestToken = NULL, NotificationChannel = NULL, FaceAttributes = NULL, JobTag = NULL) {
  op <- new_operation(
    name = "StartFaceDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_face_detection_input(Video = Video, ClientRequestToken = ClientRequestToken, NotificationChannel = NotificationChannel, FaceAttributes = FaceAttributes, JobTag = JobTag)
  output <- .rekognition$start_face_detection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_face_detection <- rekognition_start_face_detection

#' Starts the asynchronous search for faces in a collection that match the
#' faces of persons detected in a stored video
#'
#' Starts the asynchronous search for faces in a collection that match the
#' faces of persons detected in a stored video.
#' 
#' The video must be stored in an Amazon S3 bucket. Use Video to specify
#' the bucket name and the filename of the video. `StartFaceSearch` returns
#' a job identifier (`JobId`) which you use to get the search results once
#' the search has completed. When searching is finished, Amazon Rekognition
#' Video publishes a completion status to the Amazon Simple Notification
#' Service topic that you specify in `NotificationChannel`. To get the
#' search results, first check that the status value published to the
#' Amazon SNS topic is `SUCCEEDED`. If so, call GetFaceSearch and pass the
#' job identifier (`JobId`) from the initial call to `StartFaceSearch`. For
#' more information, see procedure-person-search-videos.
#'
#' @usage
#' rekognition_start_face_search(Video, ClientRequestToken,
#'   FaceMatchThreshold, CollectionId, NotificationChannel, JobTag)
#'
#' @param Video &#91;required&#93; The video you want to search. The video must be stored in an Amazon S3
#' bucket.
#' @param ClientRequestToken Idempotent token used to identify the start request. If you use the same
#' token with multiple `StartFaceSearch` requests, the same `JobId` is
#' returned. Use `ClientRequestToken` to prevent the same job from being
#' accidently started more than once.
#' @param FaceMatchThreshold The minimum confidence in the person match to return. For example,
#' don\'t return any matches where confidence in matches is less than 70%.
#' The default value is 80%.
#' @param CollectionId &#91;required&#93; ID of the collection that contains the faces you want to search for.
#' @param NotificationChannel The ARN of the Amazon SNS topic to which you want Amazon Rekognition
#' Video to publish the completion status of the search.
#' @param JobTag An identifier you specify that\'s returned in the completion
#' notification that\'s published to your Amazon Simple Notification
#' Service topic. For example, you can use `JobTag` to group related jobs
#' and identify them in the completion notification.
#'
#' @section Request syntax:
#' ```
#' svc$start_face_search(
#'   Video = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   FaceMatchThreshold = 123.0,
#'   CollectionId = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   ),
#'   JobTag = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_face_search
rekognition_start_face_search <- function(Video, ClientRequestToken = NULL, FaceMatchThreshold = NULL, CollectionId, NotificationChannel = NULL, JobTag = NULL) {
  op <- new_operation(
    name = "StartFaceSearch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_face_search_input(Video = Video, ClientRequestToken = ClientRequestToken, FaceMatchThreshold = FaceMatchThreshold, CollectionId = CollectionId, NotificationChannel = NotificationChannel, JobTag = JobTag)
  output <- .rekognition$start_face_search_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_face_search <- rekognition_start_face_search

#' Starts asynchronous detection of labels in a stored video
#'
#' Starts asynchronous detection of labels in a stored video.
#' 
#' Amazon Rekognition Video can detect labels in a video. Labels are
#' instances of real-world entities. This includes objects like flower,
#' tree, and table; events like wedding, graduation, and birthday party;
#' concepts like landscape, evening, and nature; and activities like a
#' person getting out of a car or a person skiing.
#' 
#' The video must be stored in an Amazon S3 bucket. Use Video to specify
#' the bucket name and the filename of the video. `StartLabelDetection`
#' returns a job identifier (`JobId`) which you use to get the results of
#' the operation. When label detection is finished, Amazon Rekognition
#' Video publishes a completion status to the Amazon Simple Notification
#' Service topic that you specify in `NotificationChannel`.
#' 
#' To get the results of the label detection operation, first check that
#' the status value published to the Amazon SNS topic is `SUCCEEDED`. If
#' so, call GetLabelDetection and pass the job identifier (`JobId`) from
#' the initial call to `StartLabelDetection`.
#'
#' @usage
#' rekognition_start_label_detection(Video, ClientRequestToken,
#'   MinConfidence, NotificationChannel, JobTag)
#'
#' @param Video &#91;required&#93; The video in which you want to detect labels. The video must be stored
#' in an Amazon S3 bucket.
#' @param ClientRequestToken Idempotent token used to identify the start request. If you use the same
#' token with multiple `StartLabelDetection` requests, the same `JobId` is
#' returned. Use `ClientRequestToken` to prevent the same job from being
#' accidently started more than once.
#' @param MinConfidence Specifies the minimum confidence that Amazon Rekognition Video must have
#' in order to return a detected label. Confidence represents how certain
#' Amazon Rekognition is that a label is correctly identified.0 is the
#' lowest confidence. 100 is the highest confidence. Amazon Rekognition
#' Video doesn\'t return any labels with a confidence level lower than this
#' specified value.
#' 
#' If you don\'t specify `MinConfidence`, the operation returns labels with
#' confidence values greater than or equal to 50 percent.
#' @param NotificationChannel The Amazon SNS topic ARN you want Amazon Rekognition Video to publish
#' the completion status of the label detection operation to.
#' @param JobTag An identifier you specify that\'s returned in the completion
#' notification that\'s published to your Amazon Simple Notification
#' Service topic. For example, you can use `JobTag` to group related jobs
#' and identify them in the completion notification.
#'
#' @section Request syntax:
#' ```
#' svc$start_label_detection(
#'   Video = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   MinConfidence = 123.0,
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   ),
#'   JobTag = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_label_detection
rekognition_start_label_detection <- function(Video, ClientRequestToken = NULL, MinConfidence = NULL, NotificationChannel = NULL, JobTag = NULL) {
  op <- new_operation(
    name = "StartLabelDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_label_detection_input(Video = Video, ClientRequestToken = ClientRequestToken, MinConfidence = MinConfidence, NotificationChannel = NotificationChannel, JobTag = JobTag)
  output <- .rekognition$start_label_detection_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_label_detection <- rekognition_start_label_detection

#' Starts the asynchronous tracking of a person's path in a stored video
#'
#' Starts the asynchronous tracking of a person\'s path in a stored video.
#' 
#' Amazon Rekognition Video can track the path of people in a video stored
#' in an Amazon S3 bucket. Use Video to specify the bucket name and the
#' filename of the video. `StartPersonTracking` returns a job identifier
#' (`JobId`) which you use to get the results of the operation. When label
#' detection is finished, Amazon Rekognition publishes a completion status
#' to the Amazon Simple Notification Service topic that you specify in
#' `NotificationChannel`.
#' 
#' To get the results of the person detection operation, first check that
#' the status value published to the Amazon SNS topic is `SUCCEEDED`. If
#' so, call GetPersonTracking and pass the job identifier (`JobId`) from
#' the initial call to `StartPersonTracking`.
#'
#' @usage
#' rekognition_start_person_tracking(Video, ClientRequestToken,
#'   NotificationChannel, JobTag)
#'
#' @param Video &#91;required&#93; The video in which you want to detect people. The video must be stored
#' in an Amazon S3 bucket.
#' @param ClientRequestToken Idempotent token used to identify the start request. If you use the same
#' token with multiple `StartPersonTracking` requests, the same `JobId` is
#' returned. Use `ClientRequestToken` to prevent the same job from being
#' accidently started more than once.
#' @param NotificationChannel The Amazon SNS topic ARN you want Amazon Rekognition Video to publish
#' the completion status of the people detection operation to.
#' @param JobTag An identifier you specify that\'s returned in the completion
#' notification that\'s published to your Amazon Simple Notification
#' Service topic. For example, you can use `JobTag` to group related jobs
#' and identify them in the completion notification.
#'
#' @section Request syntax:
#' ```
#' svc$start_person_tracking(
#'   Video = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   ),
#'   JobTag = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_person_tracking
rekognition_start_person_tracking <- function(Video, ClientRequestToken = NULL, NotificationChannel = NULL, JobTag = NULL) {
  op <- new_operation(
    name = "StartPersonTracking",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_person_tracking_input(Video = Video, ClientRequestToken = ClientRequestToken, NotificationChannel = NotificationChannel, JobTag = JobTag)
  output <- .rekognition$start_person_tracking_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_person_tracking <- rekognition_start_person_tracking

#' Starts the running of the version of a model
#'
#' Starts the running of the version of a model. Starting a model takes a
#' while to complete. To check the current state of the model, use
#' DescribeProjectVersions.
#' 
#' Once the model is running, you can detect custom labels in new images by
#' calling DetectCustomLabels.
#' 
#' You are charged for the amount of time that the model is running. To
#' stop a running model, call StopProjectVersion.
#' 
#' This operation requires permissions to perform the
#' `rekognition:StartProjectVersion` action.
#'
#' @usage
#' rekognition_start_project_version(ProjectVersionArn, MinInferenceUnits)
#'
#' @param ProjectVersionArn &#91;required&#93; The Amazon Resource Name(ARN) of the model version that you want to
#' start.
#' @param MinInferenceUnits &#91;required&#93; The minimum number of inference units to use. A single inference unit
#' represents 1 hour of processing and can support up to 5 Transaction Pers
#' Second (TPS). Use a higher number to increase the TPS throughput of your
#' model. You are charged for the number of inference units that you use.
#'
#' @section Request syntax:
#' ```
#' svc$start_project_version(
#'   ProjectVersionArn = "string",
#'   MinInferenceUnits = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_project_version
rekognition_start_project_version <- function(ProjectVersionArn, MinInferenceUnits) {
  op <- new_operation(
    name = "StartProjectVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_project_version_input(ProjectVersionArn = ProjectVersionArn, MinInferenceUnits = MinInferenceUnits)
  output <- .rekognition$start_project_version_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_project_version <- rekognition_start_project_version

#' Starts processing a stream processor
#'
#' Starts processing a stream processor. You create a stream processor by
#' calling CreateStreamProcessor. To tell `StartStreamProcessor` which
#' stream processor to start, use the value of the `Name` field specified
#' in the call to `CreateStreamProcessor`.
#'
#' @usage
#' rekognition_start_stream_processor(Name)
#'
#' @param Name &#91;required&#93; The name of the stream processor to start processing.
#'
#' @section Request syntax:
#' ```
#' svc$start_stream_processor(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_start_stream_processor
rekognition_start_stream_processor <- function(Name) {
  op <- new_operation(
    name = "StartStreamProcessor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$start_stream_processor_input(Name = Name)
  output <- .rekognition$start_stream_processor_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$start_stream_processor <- rekognition_start_stream_processor

#' Stops a running model
#'
#' Stops a running model. The operation might take a while to complete. To
#' check the current status, call DescribeProjectVersions.
#'
#' @usage
#' rekognition_stop_project_version(ProjectVersionArn)
#'
#' @param ProjectVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the model version that you want to
#' delete.
#' 
#' This operation requires permissions to perform the
#' `rekognition:StopProjectVersion` action.
#'
#' @section Request syntax:
#' ```
#' svc$stop_project_version(
#'   ProjectVersionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_stop_project_version
rekognition_stop_project_version <- function(ProjectVersionArn) {
  op <- new_operation(
    name = "StopProjectVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$stop_project_version_input(ProjectVersionArn = ProjectVersionArn)
  output <- .rekognition$stop_project_version_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$stop_project_version <- rekognition_stop_project_version

#' Stops a running stream processor that was created by
#' CreateStreamProcessor
#'
#' Stops a running stream processor that was created by
#' CreateStreamProcessor.
#'
#' @usage
#' rekognition_stop_stream_processor(Name)
#'
#' @param Name &#91;required&#93; The name of a stream processor created by CreateStreamProcessor.
#'
#' @section Request syntax:
#' ```
#' svc$stop_stream_processor(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rekognition_stop_stream_processor
rekognition_stop_stream_processor <- function(Name) {
  op <- new_operation(
    name = "StopStreamProcessor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rekognition$stop_stream_processor_input(Name = Name)
  output <- .rekognition$stop_stream_processor_output()
  config <- get_config()
  svc <- .rekognition$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rekognition$operations$stop_stream_processor <- rekognition_stop_stream_processor
