% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_put_slot_type}
\alias{lexmodelbuildingservice_put_slot_type}
\title{Creates a custom slot type or replaces an existing custom slot type}
\usage{
lexmodelbuildingservice_put_slot_type(name, description,
  enumerationValues, checksum, valueSelectionStrategy, createVersion)
}
\arguments{
\item{name}{[required] The name of the slot type. The name is \emph{not} case sensitive.

The name can't match a built-in slot type name, or a built-in slot type
name with "AMAZON." removed. For example, because there is a built-in
slot type called \code{AMAZON.DATE}, you can't create a custom slot type
called \code{DATE}.

For a list of built-in slot types, see \href{https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference}{Slot Type Reference}
in the \emph{Alexa Skills Kit}.}

\item{description}{A description of the slot type.}

\item{enumerationValues}{A list of \code{EnumerationValue} objects that defines the values that the
slot type can take. Each value can have a list of \code{synonyms}, which are
additional values that help train the machine learning model about the
values that it resolves for a slot.

When Amazon Lex resolves a slot value, it generates a resolution list
that contains up to five possible values for the slot. If you are using
a Lambda function, this resolution list is passed to the function. If
you are not using a Lambda function you can choose to return the value
that the user entered or the first value in the resolution list as the
slot value. The \code{valueSelectionStrategy} field indicates the option to
use.}

\item{checksum}{Identifies a specific revision of the \code{$LATEST} version.

When you create a new slot type, leave the \code{checksum} field blank. If
you specify a checksum you get a \code{BadRequestException} exception.

When you want to update a slot type, set the \code{checksum} field to the
checksum of the most recent revision of the \code{$LATEST} version. If you
don't specify the \code{ checksum} field, or if the checksum does not match
the \code{$LATEST} version, you get a \code{PreconditionFailedException}
exception.}

\item{valueSelectionStrategy}{Determines the slot resolution strategy that Amazon Lex uses to return
slot type values. The field can be set to one of the following values:
\itemize{
\item \code{ORIGINAL_VALUE} - Returns the value entered by the user, if the
user value is similar to the slot value.
\item \code{TOP_RESOLUTION} - If there is a resolution list for the slot,
return the first value in the resolution list as the slot type
value. If there is no resolution list, null is returned.
}

If you don't specify the \code{valueSelectionStrategy}, the default is
\code{ORIGINAL_VALUE}.}

\item{createVersion}{}
}
\description{
Creates a custom slot type or replaces an existing custom slot type.
}
\details{
To create a custom slot type, specify a name for the slot type and a set
of enumeration values, which are the values that a slot of this type can
assume. For more information, see how-it-works.

If you specify the name of an existing slot type, the fields in the
request replace the existing values in the \code{$LATEST} version of the slot
type. Amazon Lex removes the fields that you don't provide in the
request. If you don't specify required fields, Amazon Lex throws an
exception. When you update the \code{$LATEST} version of a slot type, if a
bot uses the \code{$LATEST} version of an intent that contains the slot type,
the bot's \code{status} field is set to \code{NOT_BUILT}.

This operation requires permissions for the \code{lex:PutSlotType} action.
}
\section{Request syntax}{
\preformatted{svc$put_slot_type(
  name = "string",
  description = "string",
  enumerationValues = list(
    list(
      value = "string",
      synonyms = list(
        "string"
      )
    )
  ),
  checksum = "string",
  valueSelectionStrategy = "ORIGINAL_VALUE"|"TOP_RESOLUTION",
  createVersion = TRUE|FALSE
)
}
}

\examples{
# This example shows how to create a slot type that describes pizza
# sauces.
\donttest{svc$put_slot_type(
  name = "PizzaSauceType",
  description = "Available pizza sauces",
  enumerationValues = list(
    list(
      value = "red"
    ),
    list(
      value = "white"
    )
  )
)}

}
\keyword{internal}
