# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include personalizeevents_service.R
NULL

#' Records user interaction event data
#'
#' Records user interaction event data.
#'
#' @usage
#' personalizeevents_put_events(trackingId, userId, sessionId, eventList)
#'
#' @param trackingId &#91;required&#93; The tracking ID for the event. The ID is generated by a call to the
#' [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
#' API.
#' @param userId The user associated with the event.
#' @param sessionId &#91;required&#93; The session ID associated with the user\'s visit.
#' @param eventList &#91;required&#93; A list of event data from the session.
#'
#' @section Request syntax:
#' ```
#' svc$put_events(
#'   trackingId = "string",
#'   userId = "string",
#'   sessionId = "string",
#'   eventList = list(
#'     list(
#'       eventId = "string",
#'       eventType = "string",
#'       properties = "string",
#'       sentAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalizeevents_put_events
personalizeevents_put_events <- function(trackingId, userId = NULL, sessionId, eventList) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/events",
    paginator = list()
  )
  input <- .personalizeevents$put_events_input(trackingId = trackingId, userId = userId, sessionId = sessionId, eventList = eventList)
  output <- .personalizeevents$put_events_output()
  svc <- .personalizeevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalizeevents$operations$put_events <- personalizeevents_put_events
