% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_application}
\alias{appstream_create_application}
\title{Creates an application}
\usage{
appstream_create_application(
  Name,
  DisplayName = NULL,
  Description = NULL,
  IconS3Location,
  LaunchPath,
  WorkingDirectory = NULL,
  LaunchParameters = NULL,
  Platforms,
  InstanceFamilies,
  AppBlockArn,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the application. This name is visible to users when display
name is not specified.}

\item{DisplayName}{The display name of the application. This name is visible to users in
the application catalog.}

\item{Description}{The description of the application.}

\item{IconS3Location}{[required] The location in S3 of the application icon.}

\item{LaunchPath}{[required] The launch path of the application.}

\item{WorkingDirectory}{The working directory of the application.}

\item{LaunchParameters}{The launch parameters of the application.}

\item{Platforms}{[required] The platforms the application supports. WINDOWS_SERVER_2019 and
AMAZON_LINUX2 are supported for Elastic fleets.}

\item{InstanceFamilies}{[required] The instance families the application supports. Valid values are
GENERAL_PURPOSE and GRAPHICS_G4.}

\item{AppBlockArn}{[required] The app block ARN to which the application should be associated}

\item{Tags}{The tags assigned to the application.}
}
\description{
Creates an application.

See \url{https://www.paws-r-sdk.com/docs/appstream_create_application/} for full documentation.
}
\keyword{internal}
