% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_modify_workspace_properties}
\alias{workspaces_modify_workspace_properties}
\title{Modifies the specified WorkSpace properties}
\usage{
workspaces_modify_workspace_properties(WorkspaceId, WorkspaceProperties)
}
\arguments{
\item{WorkspaceId}{[required] The identifier of the WorkSpace.}

\item{WorkspaceProperties}{[required] The properties of the WorkSpace.}
}
\value{
An empty list.
}
\description{
Modifies the specified WorkSpace properties. For important information
about how to modify the size of the root and user volumes, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html}{Modify a WorkSpace}.
}
\section{Request syntax}{
\preformatted{svc$modify_workspace_properties(
  WorkspaceId = "string",
  WorkspaceProperties = list(
    RunningMode = "AUTO_STOP"|"ALWAYS_ON",
    RunningModeAutoStopTimeoutInMinutes = 123,
    RootVolumeSizeGib = 123,
    UserVolumeSizeGib = 123,
    ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
  )
)
}
}

\keyword{internal}
