% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellarchitected_operations.R
\name{wellarchitected_create_workload}
\alias{wellarchitected_create_workload}
\title{Create a new workload}
\usage{
wellarchitected_create_workload(
  WorkloadName,
  Description,
  Environment,
  AccountIds = NULL,
  AwsRegions = NULL,
  NonAwsRegions = NULL,
  PillarPriorities = NULL,
  ArchitecturalDesign = NULL,
  ReviewOwner = NULL,
  IndustryType = NULL,
  Industry = NULL,
  Lenses,
  Notes = NULL,
  ClientRequestToken,
  Tags = NULL,
  DiscoveryConfig = NULL,
  Applications = NULL,
  ProfileArns = NULL,
  ReviewTemplateArns = NULL,
  JiraConfiguration = NULL
)
}
\arguments{
\item{WorkloadName}{[required]}

\item{Description}{[required]}

\item{Environment}{[required]}

\item{AccountIds}{}

\item{AwsRegions}{}

\item{NonAwsRegions}{}

\item{PillarPriorities}{}

\item{ArchitecturalDesign}{}

\item{ReviewOwner}{}

\item{IndustryType}{}

\item{Industry}{}

\item{Lenses}{[required]}

\item{Notes}{}

\item{ClientRequestToken}{[required]}

\item{Tags}{The tags to be associated with the workload.}

\item{DiscoveryConfig}{Well-Architected discovery configuration settings associated to the
workload.}

\item{Applications}{List of AppRegistry application ARNs associated to the workload.}

\item{ProfileArns}{The list of profile ARNs associated with the workload.}

\item{ReviewTemplateArns}{The list of review template ARNs to associate with the workload.}

\item{JiraConfiguration}{Jira configuration settings when creating a workload.}
}
\description{
Create a new workload.

See \url{https://www.paws-r-sdk.com/docs/wellarchitected_create_workload/} for full documentation.
}
\keyword{internal}
