# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include devopsguru_service.R
NULL

#' Adds a notification channel to DevOps Guru
#'
#' @description
#' Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_add_notification_channel/](https://www.paws-r-sdk.com/docs/devopsguru_add_notification_channel/) for full documentation.
#'
#' @param Config &#91;required&#93; A `NotificationChannelConfig` object that specifies what type of
#' notification channel to add. The one supported notification channel is
#' Amazon Simple Notification Service (Amazon SNS).
#'
#' @keywords internal
#'
#' @rdname devopsguru_add_notification_channel
devopsguru_add_notification_channel <- function(Config) {
  op <- new_operation(
    name = "AddNotificationChannel",
    http_method = "PUT",
    http_path = "/channels",
    paginator = list()
  )
  input <- .devopsguru$add_notification_channel_input(Config = Config)
  output <- .devopsguru$add_notification_channel_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$add_notification_channel <- devopsguru_add_notification_channel

#' Deletes the insight along with the associated anomalies, events and
#' recommendations
#'
#' @description
#' Deletes the insight along with the associated anomalies, events and recommendations.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_delete_insight/](https://www.paws-r-sdk.com/docs/devopsguru_delete_insight/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the insight.
#'
#' @keywords internal
#'
#' @rdname devopsguru_delete_insight
devopsguru_delete_insight <- function(Id) {
  op <- new_operation(
    name = "DeleteInsight",
    http_method = "DELETE",
    http_path = "/insights/{Id}",
    paginator = list()
  )
  input <- .devopsguru$delete_insight_input(Id = Id)
  output <- .devopsguru$delete_insight_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$delete_insight <- devopsguru_delete_insight

#' Returns the number of open reactive insights, the number of open
#' proactive insights, and the number of metrics analyzed in your Amazon
#' Web Services account
#'
#' @description
#' Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_account_health/](https://www.paws-r-sdk.com/docs/devopsguru_describe_account_health/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_account_health
devopsguru_describe_account_health <- function() {
  op <- new_operation(
    name = "DescribeAccountHealth",
    http_method = "GET",
    http_path = "/accounts/health",
    paginator = list()
  )
  input <- .devopsguru$describe_account_health_input()
  output <- .devopsguru$describe_account_health_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_account_health <- devopsguru_describe_account_health

#' For the time range passed in, returns the number of open reactive
#' insight that were created, the number of open proactive insights that
#' were created, and the Mean Time to Recover (MTTR) for all closed
#' reactive insights
#'
#' @description
#' For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_account_overview/](https://www.paws-r-sdk.com/docs/devopsguru_describe_account_overview/) for full documentation.
#'
#' @param FromTime &#91;required&#93; The start of the time range passed in. The start time granularity is at
#' the day level. The floor of the start time is used. Returned information
#' occurred after this day.
#' @param ToTime The end of the time range passed in. The start time granularity is at
#' the day level. The floor of the start time is used. Returned information
#' occurred before this day. If this is not specified, then the current day
#' is used.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_account_overview
devopsguru_describe_account_overview <- function(FromTime, ToTime = NULL) {
  op <- new_operation(
    name = "DescribeAccountOverview",
    http_method = "POST",
    http_path = "/accounts/overview",
    paginator = list()
  )
  input <- .devopsguru$describe_account_overview_input(FromTime = FromTime, ToTime = ToTime)
  output <- .devopsguru$describe_account_overview_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_account_overview <- devopsguru_describe_account_overview

#' Returns details about an anomaly that you specify using its ID
#'
#' @description
#' Returns details about an anomaly that you specify using its ID.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_anomaly/](https://www.paws-r-sdk.com/docs/devopsguru_describe_anomaly/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the anomaly.
#' @param AccountId The ID of the member account.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_anomaly
devopsguru_describe_anomaly <- function(Id, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeAnomaly",
    http_method = "GET",
    http_path = "/anomalies/{Id}",
    paginator = list()
  )
  input <- .devopsguru$describe_anomaly_input(Id = Id, AccountId = AccountId)
  output <- .devopsguru$describe_anomaly_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_anomaly <- devopsguru_describe_anomaly

#' Returns the integration status of services that are integrated with
#' DevOps Guru as Consumer via EventBridge
#'
#' @description
#' Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_event_sources_config/](https://www.paws-r-sdk.com/docs/devopsguru_describe_event_sources_config/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_event_sources_config
devopsguru_describe_event_sources_config <- function() {
  op <- new_operation(
    name = "DescribeEventSourcesConfig",
    http_method = "POST",
    http_path = "/event-sources",
    paginator = list()
  )
  input <- .devopsguru$describe_event_sources_config_input()
  output <- .devopsguru$describe_event_sources_config_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_event_sources_config <- devopsguru_describe_event_sources_config

#' Returns the most recent feedback submitted in the current Amazon Web
#' Services account and Region
#'
#' @description
#' Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_feedback/](https://www.paws-r-sdk.com/docs/devopsguru_describe_feedback/) for full documentation.
#'
#' @param InsightId The ID of the insight for which the feedback was provided.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_feedback
devopsguru_describe_feedback <- function(InsightId = NULL) {
  op <- new_operation(
    name = "DescribeFeedback",
    http_method = "POST",
    http_path = "/feedback",
    paginator = list()
  )
  input <- .devopsguru$describe_feedback_input(InsightId = InsightId)
  output <- .devopsguru$describe_feedback_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_feedback <- devopsguru_describe_feedback

#' Returns details about an insight that you specify using its ID
#'
#' @description
#' Returns details about an insight that you specify using its ID.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_insight/](https://www.paws-r-sdk.com/docs/devopsguru_describe_insight/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the insight.
#' @param AccountId The ID of the member account in the organization.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_insight
devopsguru_describe_insight <- function(Id, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeInsight",
    http_method = "GET",
    http_path = "/insights/{Id}",
    paginator = list()
  )
  input <- .devopsguru$describe_insight_input(Id = Id, AccountId = AccountId)
  output <- .devopsguru$describe_insight_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_insight <- devopsguru_describe_insight

#' Returns active insights, predictive insights, and resource hours
#' analyzed in last hour
#'
#' @description
#' Returns active insights, predictive insights, and resource hours analyzed in last hour.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_health/](https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_health/) for full documentation.
#'
#' @param AccountIds The ID of the Amazon Web Services account.
#' @param OrganizationalUnitIds The ID of the organizational unit.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_organization_health
devopsguru_describe_organization_health <- function(AccountIds = NULL, OrganizationalUnitIds = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationHealth",
    http_method = "POST",
    http_path = "/organization/health",
    paginator = list()
  )
  input <- .devopsguru$describe_organization_health_input(AccountIds = AccountIds, OrganizationalUnitIds = OrganizationalUnitIds)
  output <- .devopsguru$describe_organization_health_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_organization_health <- devopsguru_describe_organization_health

#' Returns an overview of your organization's history based on the
#' specified time range
#'
#' @description
#' Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_overview/](https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_overview/) for full documentation.
#'
#' @param FromTime &#91;required&#93; The start of the time range passed in. The start time granularity is at
#' the day level. The floor of the start time is used. Returned information
#' occurred after this day.
#' @param ToTime The end of the time range passed in. The start time granularity is at
#' the day level. The floor of the start time is used. Returned information
#' occurred before this day. If this is not specified, then the current day
#' is used.
#' @param AccountIds The ID of the Amazon Web Services account.
#' @param OrganizationalUnitIds The ID of the organizational unit.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_organization_overview
devopsguru_describe_organization_overview <- function(FromTime, ToTime = NULL, AccountIds = NULL, OrganizationalUnitIds = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationOverview",
    http_method = "POST",
    http_path = "/organization/overview",
    paginator = list()
  )
  input <- .devopsguru$describe_organization_overview_input(FromTime = FromTime, ToTime = ToTime, AccountIds = AccountIds, OrganizationalUnitIds = OrganizationalUnitIds)
  output <- .devopsguru$describe_organization_overview_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_organization_overview <- devopsguru_describe_organization_overview

#' Provides an overview of your system's health
#'
#' @description
#' Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the `AccountIds` field.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_resource_collection_health/](https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_resource_collection_health/) for full documentation.
#'
#' @param OrganizationResourceCollectionType &#91;required&#93; An Amazon Web Services resource collection type. This type specifies how
#' analyzed Amazon Web Services resources are defined. The two types of
#' Amazon Web Services resource collections supported are Amazon Web
#' Services CloudFormation stacks and Amazon Web Services resources that
#' contain the same Amazon Web Services tag. DevOps Guru can be configured
#' to analyze the Amazon Web Services resources that are defined in the
#' stacks or that are tagged using the same tag *key*. You can specify up
#' to 500 Amazon Web Services CloudFormation stacks.
#' @param AccountIds The ID of the Amazon Web Services account.
#' @param OrganizationalUnitIds The ID of the organizational unit.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_organization_resource_collection_health
devopsguru_describe_organization_resource_collection_health <- function(OrganizationResourceCollectionType, AccountIds = NULL, OrganizationalUnitIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationResourceCollectionHealth",
    http_method = "POST",
    http_path = "/organization/health/resource-collection",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = list( "CloudFormation", "Account", "Service", "Tags"))
  )
  input <- .devopsguru$describe_organization_resource_collection_health_input(OrganizationResourceCollectionType = OrganizationResourceCollectionType, AccountIds = AccountIds, OrganizationalUnitIds = OrganizationalUnitIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .devopsguru$describe_organization_resource_collection_health_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_organization_resource_collection_health <- devopsguru_describe_organization_resource_collection_health

#' Returns the number of open proactive insights, open reactive insights,
#' and the Mean Time to Recover (MTTR) for all closed insights in resource
#' collections in your account
#'
#' @description
#' Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_resource_collection_health/](https://www.paws-r-sdk.com/docs/devopsguru_describe_resource_collection_health/) for full documentation.
#'
#' @param ResourceCollectionType &#91;required&#93; An Amazon Web Services resource collection type. This type specifies how
#' analyzed Amazon Web Services resources are defined. The two types of
#' Amazon Web Services resource collections supported are Amazon Web
#' Services CloudFormation stacks and Amazon Web Services resources that
#' contain the same Amazon Web Services tag. DevOps Guru can be configured
#' to analyze the Amazon Web Services resources that are defined in the
#' stacks or that are tagged using the same tag *key*. You can specify up
#' to 500 Amazon Web Services CloudFormation stacks.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_resource_collection_health
devopsguru_describe_resource_collection_health <- function(ResourceCollectionType, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeResourceCollectionHealth",
    http_method = "GET",
    http_path = "/accounts/health/resource-collection/{ResourceCollectionType}",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = list( "CloudFormation", "Service", "Tags"))
  )
  input <- .devopsguru$describe_resource_collection_health_input(ResourceCollectionType = ResourceCollectionType, NextToken = NextToken)
  output <- .devopsguru$describe_resource_collection_health_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_resource_collection_health <- devopsguru_describe_resource_collection_health

#' Returns the integration status of services that are integrated with
#' DevOps Guru
#'
#' @description
#' Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_describe_service_integration/](https://www.paws-r-sdk.com/docs/devopsguru_describe_service_integration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname devopsguru_describe_service_integration
devopsguru_describe_service_integration <- function() {
  op <- new_operation(
    name = "DescribeServiceIntegration",
    http_method = "GET",
    http_path = "/service-integrations",
    paginator = list()
  )
  input <- .devopsguru$describe_service_integration_input()
  output <- .devopsguru$describe_service_integration_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$describe_service_integration <- devopsguru_describe_service_integration

#' Returns an estimate of the monthly cost for DevOps Guru to analyze your
#' Amazon Web Services resources
#'
#' @description
#' Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](https://aws.amazon.com/devops-guru/pricing/).
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_get_cost_estimation/](https://www.paws-r-sdk.com/docs/devopsguru_get_cost_estimation/) for full documentation.
#'
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_get_cost_estimation
devopsguru_get_cost_estimation <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetCostEstimation",
    http_method = "GET",
    http_path = "/cost-estimation",
    paginator = list(input_token = "NextToken", non_aggregate_keys = list("Status", "TotalCost", "TimeRange", "ResourceCollection"), output_token = "NextToken", result_key = list("Costs"))
  )
  input <- .devopsguru$get_cost_estimation_input(NextToken = NextToken)
  output <- .devopsguru$get_cost_estimation_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$get_cost_estimation <- devopsguru_get_cost_estimation

#' Returns lists Amazon Web Services resources that are of the specified
#' resource collection type
#'
#' @description
#' Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_get_resource_collection/](https://www.paws-r-sdk.com/docs/devopsguru_get_resource_collection/) for full documentation.
#'
#' @param ResourceCollectionType &#91;required&#93; The type of Amazon Web Services resource collections to return. The one
#' valid value is `CLOUD_FORMATION` for Amazon Web Services CloudFormation
#' stacks.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_get_resource_collection
devopsguru_get_resource_collection <- function(ResourceCollectionType, NextToken = NULL) {
  op <- new_operation(
    name = "GetResourceCollection",
    http_method = "GET",
    http_path = "/resource-collections/{ResourceCollectionType}",
    paginator = list(input_token = "NextToken", non_aggregate_keys = list("ResourceCollection"), output_token = "NextToken", result_key = list("ResourceCollection.CloudFormation.StackNames", "ResourceCollection.Tags"))
  )
  input <- .devopsguru$get_resource_collection_input(ResourceCollectionType = ResourceCollectionType, NextToken = NextToken)
  output <- .devopsguru$get_resource_collection_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$get_resource_collection <- devopsguru_get_resource_collection

#' Returns a list of the anomalies that belong to an insight that you
#' specify using its ID
#'
#' @description
#' Returns a list of the anomalies that belong to an insight that you specify using its ID.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_anomalies_for_insight/](https://www.paws-r-sdk.com/docs/devopsguru_list_anomalies_for_insight/) for full documentation.
#'
#' @param InsightId &#91;required&#93; The ID of the insight. The returned anomalies belong to this insight.
#' @param StartTimeRange A time range used to specify when the requested anomalies started. All
#' returned anomalies started during this time range.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param AccountId The ID of the Amazon Web Services account.
#' @param Filters Specifies one or more service names that are used to list anomalies.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_anomalies_for_insight
devopsguru_list_anomalies_for_insight <- function(InsightId, StartTimeRange = NULL, MaxResults = NULL, NextToken = NULL, AccountId = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListAnomaliesForInsight",
    http_method = "POST",
    http_path = "/anomalies/insight/{InsightId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("ReactiveAnomalies", "ProactiveAnomalies"))
  )
  input <- .devopsguru$list_anomalies_for_insight_input(InsightId = InsightId, StartTimeRange = StartTimeRange, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId, Filters = Filters)
  output <- .devopsguru$list_anomalies_for_insight_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_anomalies_for_insight <- devopsguru_list_anomalies_for_insight

#' Returns the list of log groups that contain log anomalies
#'
#' @description
#' Returns the list of log groups that contain log anomalies.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_anomalous_log_groups/](https://www.paws-r-sdk.com/docs/devopsguru_list_anomalous_log_groups/) for full documentation.
#'
#' @param InsightId &#91;required&#93; The ID of the insight containing the log groups.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_anomalous_log_groups
devopsguru_list_anomalous_log_groups <- function(InsightId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAnomalousLogGroups",
    http_method = "POST",
    http_path = "/list-log-anomalies",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("InsightId", "AnomalousLogGroups"))
  )
  input <- .devopsguru$list_anomalous_log_groups_input(InsightId = InsightId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .devopsguru$list_anomalous_log_groups_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_anomalous_log_groups <- devopsguru_list_anomalous_log_groups

#' Returns a list of the events emitted by the resources that are evaluated
#' by DevOps Guru
#'
#' @description
#' Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_events/](https://www.paws-r-sdk.com/docs/devopsguru_list_events/) for full documentation.
#'
#' @param Filters &#91;required&#93; A `ListEventsFilters` object used to specify which events to return.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param AccountId The ID of the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_events
devopsguru_list_events <- function(Filters, MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListEvents",
    http_method = "POST",
    http_path = "/events",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Events")
  )
  input <- .devopsguru$list_events_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .devopsguru$list_events_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_events <- devopsguru_list_events

#' Returns a list of insights in your Amazon Web Services account
#'
#' @description
#' Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (`ONGOING`, `CLOSED`, or `ANY`).
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_insights/](https://www.paws-r-sdk.com/docs/devopsguru_list_insights/) for full documentation.
#'
#' @param StatusFilter &#91;required&#93; A filter used to filter the returned insights by their status. You can
#' specify one status filter.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_insights
devopsguru_list_insights <- function(StatusFilter, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInsights",
    http_method = "POST",
    http_path = "/insights",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("ProactiveInsights", "ReactiveInsights"))
  )
  input <- .devopsguru$list_insights_input(StatusFilter = StatusFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .devopsguru$list_insights_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_insights <- devopsguru_list_insights

#' Returns the list of all log groups that are being monitored and tagged
#' by DevOps Guru
#'
#' @description
#' Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_monitored_resources/](https://www.paws-r-sdk.com/docs/devopsguru_list_monitored_resources/) for full documentation.
#'
#' @param Filters Filters to determine which monitored resources you want to retrieve. You
#' can filter by resource type or resource permission status.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_monitored_resources
devopsguru_list_monitored_resources <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMonitoredResources",
    http_method = "POST",
    http_path = "/monitoredResources",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("MonitoredResourceIdentifiers"))
  )
  input <- .devopsguru$list_monitored_resources_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .devopsguru$list_monitored_resources_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_monitored_resources <- devopsguru_list_monitored_resources

#' Returns a list of notification channels configured for DevOps Guru
#'
#' @description
#' Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_notification_channels/](https://www.paws-r-sdk.com/docs/devopsguru_list_notification_channels/) for full documentation.
#'
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_notification_channels
devopsguru_list_notification_channels <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListNotificationChannels",
    http_method = "POST",
    http_path = "/channels",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Channels")
  )
  input <- .devopsguru$list_notification_channels_input(NextToken = NextToken)
  output <- .devopsguru$list_notification_channels_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_notification_channels <- devopsguru_list_notification_channels

#' Returns a list of insights associated with the account or OU Id
#'
#' @description
#' Returns a list of insights associated with the account or OU Id.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_organization_insights/](https://www.paws-r-sdk.com/docs/devopsguru_list_organization_insights/) for full documentation.
#'
#' @param StatusFilter &#91;required&#93; 
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param AccountIds The ID of the Amazon Web Services account.
#' @param OrganizationalUnitIds The ID of the organizational unit.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_organization_insights
devopsguru_list_organization_insights <- function(StatusFilter, MaxResults = NULL, AccountIds = NULL, OrganizationalUnitIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationInsights",
    http_method = "POST",
    http_path = "/organization/insights",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("ProactiveInsights", "ReactiveInsights"))
  )
  input <- .devopsguru$list_organization_insights_input(StatusFilter = StatusFilter, MaxResults = MaxResults, AccountIds = AccountIds, OrganizationalUnitIds = OrganizationalUnitIds, NextToken = NextToken)
  output <- .devopsguru$list_organization_insights_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_organization_insights <- devopsguru_list_organization_insights

#' Returns a list of a specified insight's recommendations
#'
#' @description
#' Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_list_recommendations/](https://www.paws-r-sdk.com/docs/devopsguru_list_recommendations/) for full documentation.
#'
#' @param InsightId &#91;required&#93; The ID of the requested insight.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param Locale A locale that specifies the language to use for recommendations.
#' @param AccountId The ID of the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname devopsguru_list_recommendations
devopsguru_list_recommendations <- function(InsightId, NextToken = NULL, Locale = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListRecommendations",
    http_method = "POST",
    http_path = "/recommendations",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Recommendations")
  )
  input <- .devopsguru$list_recommendations_input(InsightId = InsightId, NextToken = NextToken, Locale = Locale, AccountId = AccountId)
  output <- .devopsguru$list_recommendations_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$list_recommendations <- devopsguru_list_recommendations

#' Collects customer feedback about the specified insight
#'
#' @description
#' Collects customer feedback about the specified insight.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_put_feedback/](https://www.paws-r-sdk.com/docs/devopsguru_put_feedback/) for full documentation.
#'
#' @param InsightFeedback The feedback from customers is about the recommendations in this
#' insight.
#'
#' @keywords internal
#'
#' @rdname devopsguru_put_feedback
devopsguru_put_feedback <- function(InsightFeedback = NULL) {
  op <- new_operation(
    name = "PutFeedback",
    http_method = "PUT",
    http_path = "/feedback",
    paginator = list()
  )
  input <- .devopsguru$put_feedback_input(InsightFeedback = InsightFeedback)
  output <- .devopsguru$put_feedback_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$put_feedback <- devopsguru_put_feedback

#' Removes a notification channel from DevOps Guru
#'
#' @description
#' Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_remove_notification_channel/](https://www.paws-r-sdk.com/docs/devopsguru_remove_notification_channel/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the notification channel to be removed.
#'
#' @keywords internal
#'
#' @rdname devopsguru_remove_notification_channel
devopsguru_remove_notification_channel <- function(Id) {
  op <- new_operation(
    name = "RemoveNotificationChannel",
    http_method = "DELETE",
    http_path = "/channels/{Id}",
    paginator = list()
  )
  input <- .devopsguru$remove_notification_channel_input(Id = Id)
  output <- .devopsguru$remove_notification_channel_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$remove_notification_channel <- devopsguru_remove_notification_channel

#' Returns a list of insights in your Amazon Web Services account
#'
#' @description
#' Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (`ONGOING` or `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_search_insights/](https://www.paws-r-sdk.com/docs/devopsguru_search_insights/) for full documentation.
#'
#' @param StartTimeRange &#91;required&#93; The start of the time range passed in. Returned insights occurred after
#' this time.
#' @param Filters A `SearchInsightsFilters` object that is used to set the severity and
#' status filters on your insight search.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param Type &#91;required&#93; The type of insights you are searching for (`REACTIVE` or `PROACTIVE`).
#'
#' @keywords internal
#'
#' @rdname devopsguru_search_insights
devopsguru_search_insights <- function(StartTimeRange, Filters = NULL, MaxResults = NULL, NextToken = NULL, Type) {
  op <- new_operation(
    name = "SearchInsights",
    http_method = "POST",
    http_path = "/insights/search",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("ProactiveInsights", "ReactiveInsights"))
  )
  input <- .devopsguru$search_insights_input(StartTimeRange = StartTimeRange, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, Type = Type)
  output <- .devopsguru$search_insights_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$search_insights <- devopsguru_search_insights

#' Returns a list of insights in your organization
#'
#' @description
#' Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_search_organization_insights/](https://www.paws-r-sdk.com/docs/devopsguru_search_organization_insights/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The ID of the Amazon Web Services account.
#' @param StartTimeRange &#91;required&#93; 
#' @param Filters A `SearchOrganizationInsightsFilters` object that is used to set the
#' severity and status filters on your insight search.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param Type &#91;required&#93; The type of insights you are searching for (`REACTIVE` or `PROACTIVE`).
#'
#' @keywords internal
#'
#' @rdname devopsguru_search_organization_insights
devopsguru_search_organization_insights <- function(AccountIds, StartTimeRange, Filters = NULL, MaxResults = NULL, NextToken = NULL, Type) {
  op <- new_operation(
    name = "SearchOrganizationInsights",
    http_method = "POST",
    http_path = "/organization/insights/search",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = list("ProactiveInsights", "ReactiveInsights"))
  )
  input <- .devopsguru$search_organization_insights_input(AccountIds = AccountIds, StartTimeRange = StartTimeRange, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, Type = Type)
  output <- .devopsguru$search_organization_insights_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$search_organization_insights <- devopsguru_search_organization_insights

#' Starts the creation of an estimate of the monthly cost to analyze your
#' Amazon Web Services resources
#'
#' @description
#' Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_start_cost_estimation/](https://www.paws-r-sdk.com/docs/devopsguru_start_cost_estimation/) for full documentation.
#'
#' @param ResourceCollection &#91;required&#93; The collection of Amazon Web Services resources used to create a monthly
#' DevOps Guru cost estimate.
#' @param ClientToken The idempotency token used to identify each cost estimate request.
#'
#' @keywords internal
#'
#' @rdname devopsguru_start_cost_estimation
devopsguru_start_cost_estimation <- function(ResourceCollection, ClientToken = NULL) {
  op <- new_operation(
    name = "StartCostEstimation",
    http_method = "PUT",
    http_path = "/cost-estimation",
    paginator = list()
  )
  input <- .devopsguru$start_cost_estimation_input(ResourceCollection = ResourceCollection, ClientToken = ClientToken)
  output <- .devopsguru$start_cost_estimation_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$start_cost_estimation <- devopsguru_start_cost_estimation

#' Enables or disables integration with a service that can be integrated
#' with DevOps Guru
#'
#' @description
#' Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_update_event_sources_config/](https://www.paws-r-sdk.com/docs/devopsguru_update_event_sources_config/) for full documentation.
#'
#' @param EventSources Configuration information about the integration of DevOps Guru as the
#' Consumer via EventBridge with another AWS Service.
#'
#' @keywords internal
#'
#' @rdname devopsguru_update_event_sources_config
devopsguru_update_event_sources_config <- function(EventSources = NULL) {
  op <- new_operation(
    name = "UpdateEventSourcesConfig",
    http_method = "PUT",
    http_path = "/event-sources",
    paginator = list()
  )
  input <- .devopsguru$update_event_sources_config_input(EventSources = EventSources)
  output <- .devopsguru$update_event_sources_config_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$update_event_sources_config <- devopsguru_update_event_sources_config

#' Updates the collection of resources that DevOps Guru analyzes
#'
#' @description
#' Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_update_resource_collection/](https://www.paws-r-sdk.com/docs/devopsguru_update_resource_collection/) for full documentation.
#'
#' @param Action &#91;required&#93; Specifies if the resource collection in the request is added or deleted
#' to the resource collection.
#' @param ResourceCollection &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname devopsguru_update_resource_collection
devopsguru_update_resource_collection <- function(Action, ResourceCollection) {
  op <- new_operation(
    name = "UpdateResourceCollection",
    http_method = "PUT",
    http_path = "/resource-collections",
    paginator = list()
  )
  input <- .devopsguru$update_resource_collection_input(Action = Action, ResourceCollection = ResourceCollection)
  output <- .devopsguru$update_resource_collection_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$update_resource_collection <- devopsguru_update_resource_collection

#' Enables or disables integration with a service that can be integrated
#' with DevOps Guru
#'
#' @description
#' Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
#'
#' See [https://www.paws-r-sdk.com/docs/devopsguru_update_service_integration/](https://www.paws-r-sdk.com/docs/devopsguru_update_service_integration/) for full documentation.
#'
#' @param ServiceIntegration &#91;required&#93; An `IntegratedServiceConfig` object used to specify the integrated
#' service you want to update, and whether you want to update it to enabled
#' or disabled.
#'
#' @keywords internal
#'
#' @rdname devopsguru_update_service_integration
devopsguru_update_service_integration <- function(ServiceIntegration) {
  op <- new_operation(
    name = "UpdateServiceIntegration",
    http_method = "PUT",
    http_path = "/service-integrations",
    paginator = list()
  )
  input <- .devopsguru$update_service_integration_input(ServiceIntegration = ServiceIntegration)
  output <- .devopsguru$update_service_integration_output()
  config <- get_config()
  svc <- .devopsguru$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.devopsguru$operations$update_service_integration <- devopsguru_update_service_integration
