% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_describe_user_profile}
\alias{codestar_describe_user_profile}
\title{Describes a user in AWS CodeStar and the user attributes across all
projects}
\usage{
codestar_describe_user_profile(userArn)
}
\arguments{
\item{userArn}{[required] The Amazon Resource Name (ARN) of the user.}
}
\value{
A list with the following syntax:\preformatted{list(
  userArn = "string",
  displayName = "string",
  emailAddress = "string",
  sshPublicKey = "string",
  createdTimestamp = as.POSIXct(
    "2015-01-01"
  ),
  lastModifiedTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Describes a user in AWS CodeStar and the user attributes across all
projects.
}
\section{Request syntax}{
\preformatted{svc$describe_user_profile(
  userArn = "string"
)
}
}

\keyword{internal}
