% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_builds_for_project}
\alias{codebuild_list_builds_for_project}
\title{Gets a list of build IDs for the specified build project, with each
build ID representing a single build}
\usage{
codebuild_list_builds_for_project(projectName, sortOrder, nextToken)
}
\arguments{
\item{projectName}{[required] The name of the AWS CodeBuild project.}

\item{sortOrder}{The order to list build IDs. Valid values include:
\itemize{
\item \code{ASCENDING}: List the build IDs in ascending order by build ID.
\item \code{DESCENDING}: List the build IDs in descending order by build ID.
}}

\item{nextToken}{During a previous call, if there are more than 100 items in the list,
only the first 100 items are returned, along with a unique string called
a \emph{nextToken}. To get the next batch of items in the list, call this
operation again, adding the next token to the call. To get all of the
items in the list, keep calling this operation with each subsequent next
token that is returned, until no more next tokens are returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  ids = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Gets a list of build IDs for the specified build project, with each
build ID representing a single build.
}
\section{Request syntax}{
\preformatted{svc$list_builds_for_project(
  projectName = "string",
  sortOrder = "ASCENDING"|"DESCENDING",
  nextToken = "string"
)
}
}

\keyword{internal}
