% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_to_point_in_time}
\alias{rds_restore_db_instance_to_point_in_time}
\title{Restores a DB instance to an arbitrary point in time}
\usage{
rds_restore_db_instance_to_point_in_time(
  SourceDBInstanceIdentifier = NULL,
  TargetDBInstanceIdentifier,
  RestoreTime = NULL,
  UseLatestRestorableTime = NULL,
  DBInstanceClass = NULL,
  Port = NULL,
  AvailabilityZone = NULL,
  DBSubnetGroupName = NULL,
  MultiAZ = NULL,
  PubliclyAccessible = NULL,
  AutoMinorVersionUpgrade = NULL,
  LicenseModel = NULL,
  DBName = NULL,
  Engine = NULL,
  Iops = NULL,
  OptionGroupName = NULL,
  CopyTagsToSnapshot = NULL,
  Tags = NULL,
  StorageType = NULL,
  TdeCredentialArn = NULL,
  TdeCredentialPassword = NULL,
  VpcSecurityGroupIds = NULL,
  Domain = NULL,
  DomainIAMRoleName = NULL,
  DomainFqdn = NULL,
  DomainOu = NULL,
  DomainAuthSecretArn = NULL,
  DomainDnsIps = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  EnableCloudwatchLogsExports = NULL,
  ProcessorFeatures = NULL,
  UseDefaultProcessorFeatures = NULL,
  DBParameterGroupName = NULL,
  DeletionProtection = NULL,
  SourceDbiResourceId = NULL,
  MaxAllocatedStorage = NULL,
  SourceDBInstanceAutomatedBackupsArn = NULL,
  EnableCustomerOwnedIp = NULL,
  CustomIamInstanceProfile = NULL,
  BackupTarget = NULL,
  NetworkType = NULL,
  StorageThroughput = NULL,
  AllocatedStorage = NULL,
  DedicatedLogVolume = NULL,
  CACertificateIdentifier = NULL,
  EngineLifecycleSupport = NULL
)
}
\arguments{
\item{SourceDBInstanceIdentifier}{The identifier of the source DB instance from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DB instance.
}}

\item{TargetDBInstanceIdentifier}{[required] The name of the new DB instance to create.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{RestoreTime}{The date and time to restore from.

Constraints:
\itemize{
\item Must be a time in Universal Coordinated Time (UTC) format.
\item Must be before the latest restorable time for the DB instance.
\item Can't be specified if the \code{UseLatestRestorableTime} parameter is
enabled.
}

Example: \verb{2009-09-07T23:45:00Z}}

\item{UseLatestRestorableTime}{Specifies whether the DB instance is restored from the latest backup
time. By default, the DB instance isn't restored from the latest backup
time.

Constraints:
\itemize{
\item Can't be specified if the \code{RestoreTime} parameter is provided.
}}

\item{DBInstanceClass}{The compute and memory capacity of the Amazon RDS DB instance, for
example db.m4.large. Not all DB instance classes are available in all
Amazon Web Services Regions, or for all database engines. For the full
list of DB instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide}.

Default: The same DB instance class as the original DB instance.}

\item{Port}{The port number on which the database accepts connections.

Default: The same port as the original DB instance.

Constraints:
\itemize{
\item The value must be \code{1150-65535}.
}}

\item{AvailabilityZone}{The Availability Zone (AZ) where the DB instance will be created.

Default: A random, system-chosen Availability Zone.

Constraints:
\itemize{
\item You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.
}

Example: \verb{us-east-1a}}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new instance.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB subnet group.
}

Example: \code{mydbsubnetgroup}}

\item{MultiAZ}{Secifies whether the DB instance is a Multi-AZ deployment.

This setting doesn't apply to RDS Custom.

Constraints:
\itemize{
\item You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.
}}

\item{PubliclyAccessible}{Specifies whether the DB instance is publicly accessible.

When the DB cluster is publicly accessible, its Domain Name System (DNS)
endpoint resolves to the private IP address from within the DB cluster's
virtual private cloud (VPC). It resolves to the public IP address from
outside of the DB cluster's VPC. Access to the DB cluster is ultimately
controlled by the security group it uses. That public access isn't
permitted if the security group assigned to the DB cluster doesn't
permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

For more information, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{AutoMinorVersionUpgrade}{Specifies whether minor version upgrades are applied automatically to
the DB instance during the maintenance window.

This setting doesn't apply to RDS Custom.}

\item{LicenseModel}{The license model information for the restored DB instance.

License models for RDS for Db2 require additional configuration. The
Bring Your Own License (BYOL) model requires a custom parameter group.
The Db2 license through Amazon Web Services Marketplace model requires
an Amazon Web Services Marketplace subscription. For more information,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html}{RDS for Db2 licensing options}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.

Valid Values:
\itemize{
\item RDS for Db2 - \code{bring-your-own-license | marketplace-license}
\item RDS for MariaDB - \code{general-public-license}
\item RDS for Microsoft SQL Server - \code{license-included}
\item RDS for MySQL - \code{general-public-license}
\item RDS for Oracle - \code{bring-your-own-license | license-included}
\item RDS for PostgreSQL - \code{postgresql-license}
}

Default: Same as the source.}

\item{DBName}{The database name for the restored DB instance.

This parameter doesn't apply to the following DB instances:
\itemize{
\item RDS Custom
\item RDS for Db2
\item RDS for MariaDB
\item RDS for MySQL
}}

\item{Engine}{The database engine to use for the new instance.

This setting doesn't apply to RDS Custom.

Valid Values:
\itemize{
\item \code{db2-ae}
\item \code{db2-se}
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}

Default: The same as source

Constraints:
\itemize{
\item Must be compatible with the engine of the source.
}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
initially allocate for the DB instance.

This setting doesn't apply to SQL Server.

Constraints:
\itemize{
\item Must be an integer greater than 1000.
}}

\item{OptionGroupName}{The name of the option group to use for the restored DB instance.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance after it is associated with a DB instance

This setting doesn't apply to RDS Custom.}

\item{CopyTagsToSnapshot}{Specifies whether to copy all tags from the restored DB instance to
snapshots of the DB instance. By default, tags are not copied.}

\item{Tags}{}

\item{StorageType}{The storage type to associate with the DB instance.

Valid Values: \code{gp2 | gp3 | io1 | io2 | standard}

Default: \code{io1}, if the \code{Iops} parameter is specified. Otherwise, \code{gp2}.

Constraints:
\itemize{
\item If you specify \code{io1}, \code{io2}, or \code{gp3}, you must also include a value
for the \code{Iops} parameter.
}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.

This setting doesn't apply to RDS Custom.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.

This setting doesn't apply to RDS Custom.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{Domain}{The Active Directory directory ID to restore the DB instance in. Create
the domain before running this command. Currently, you can create only
the MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in
an Active Directory Domain.

This setting doesn't apply to RDS Custom.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.}

\item{DomainIAMRoleName}{The name of the IAM role to use when making API calls to the Directory
Service.

This setting doesn't apply to RDS Custom DB instances.}

\item{DomainFqdn}{The fully qualified domain name (FQDN) of an Active Directory domain.

Constraints:
\itemize{
\item Can't be longer than 64 characters.
}

Example: \code{mymanagedADtest.mymanagedAD.mydomain}}

\item{DomainOu}{The Active Directory organizational unit for your DB instance to join.

Constraints:
\itemize{
\item Must be in the distinguished name format.
\item Can't be longer than 64 characters.
}

Example:
\verb{OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain}}

\item{DomainAuthSecretArn}{The ARN for the Secrets Manager secret with the credentials for the user
joining the domain.

Constraints:
\itemize{
\item Can't be longer than 64 characters.
}

Example:
\code{arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456}}

\item{DomainDnsIps}{The IPv4 DNS IP addresses of your primary and secondary Active Directory
domain controllers.

Constraints:
\itemize{
\item Two IP addresses must be provided. If there isn't a secondary domain
controller, use the IP address of the primary domain controller for
both entries in the list.
}

Example: \verb{123.124.125.126,234.235.236.237}}

\item{EnableIAMDatabaseAuthentication}{Specifies whether to enable mapping of Amazon Web Services Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping isn't enabled.

This setting doesn't apply to RDS Custom.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.

This setting doesn't apply to RDS Custom.}

\item{UseDefaultProcessorFeatures}{Specifies whether the DB instance class of the DB instance uses its
default processor features.

This setting doesn't apply to RDS Custom.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you do not specify a value for \code{DBParameterGroupName}, then the
default \code{DBParameterGroup} for the specified DB engine is used.

This setting doesn't apply to RDS Custom.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB parameter group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{Specifies whether the DB instance has deletion protection enabled. The
database can't be deleted when deletion protection is enabled. By
default, deletion protection isn't enabled. For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{SourceDbiResourceId}{The resource ID of the source DB instance from which to restore.}

\item{MaxAllocatedStorage}{The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
scale the storage of the DB instance.

For more information about this setting, including limitations that
apply to it, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling}{Managing capacity automatically with Amazon RDS storage autoscaling}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{SourceDBInstanceAutomatedBackupsArn}{The Amazon Resource Name (ARN) of the replicated automated backups from
which to restore, for example,
\code{arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE}.

This setting doesn't apply to RDS Custom.}

\item{EnableCustomerOwnedIp}{Specifies whether to enable a customer-owned IP address (CoIP) for an
RDS on Outposts DB instance.

A \emph{CoIP} provides local or external connectivity to resources in your
Outpost subnets through your on-premises network. For some use cases, a
CoIP can provide lower latency for connections to the DB instance from
outside of its virtual private cloud (VPC) on your local network.

This setting doesn't apply to RDS Custom.

For more information about RDS on Outposts, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.

For more information about CoIPs, see \href{https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing}{Customer-owned IP addresses}
in the \emph{Amazon Web Services Outposts User Guide}.}

\item{CustomIamInstanceProfile}{The instance profile associated with the underlying Amazon EC2 instance
of an RDS Custom DB instance. The instance profile must meet the
following requirements:
\itemize{
\item The profile must exist in your account.
\item The profile must have an IAM role that Amazon EC2 has permissions to
assume.
\item The instance profile name and the associated IAM role name must
start with the prefix \code{AWSRDSCustom}.
}

For the list of permissions required for the IAM role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc}{Configure IAM and your VPC}
in the \emph{Amazon RDS User Guide}.

This setting is required for RDS Custom.}

\item{BackupTarget}{The location for storing automated backups and manual snapshots for the
restored DB instance.

Valid Values:
\itemize{
\item \code{outposts} (Amazon Web Services Outposts)
\item \code{region} (Amazon Web Services Region)
}

Default: \code{region}

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.}

\item{NetworkType}{The network type of the DB instance.

The network type is determined by the \code{DBSubnetGroup} specified for the
DB instance. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon RDS User Guide.}

Valid Values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}}

\item{StorageThroughput}{The storage throughput value for the DB instance.

This setting doesn't apply to RDS Custom or Amazon Aurora.}

\item{AllocatedStorage}{The amount of storage (in gibibytes) to allocate initially for the DB
instance. Follow the allocation rules specified in
\code{\link[=rds_create_db_instance]{create_db_instance}}.

Be sure to allocate enough storage for your new DB instance so that the
restore operation can succeed. You can also allocate additional storage
for future growth.}

\item{DedicatedLogVolume}{Specifies whether to enable a dedicated log volume (DLV) for the DB
instance.}

\item{CACertificateIdentifier}{The CA certificate identifier to use for the DB instance's server
certificate.

This setting doesn't apply to RDS Custom DB instances.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html}{Using SSL/TLS to encrypt a connection to a DB instance}
in the \emph{Amazon RDS User Guide} and \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html}{Using SSL/TLS to encrypt a connection to a DB cluster}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineLifecycleSupport}{The life cycle type for this DB instance.

By default, this value is set to \code{open-source-rds-extended-support},
which enrolls your DB instance into Amazon RDS Extended Support. At the
end of standard support, you can avoid charges for Extended Support by
setting the value to \code{open-source-rds-extended-support-disabled}. In
this case, RDS automatically upgrades your restored DB instance to a
higher engine version, if the major engine version is past its end of
standard support date.

You can use this setting to enroll your DB instance into Amazon RDS
Extended Support. With RDS Extended Support, you can run the selected
major engine version on your DB instance past the end of standard
support for that engine version. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html}{Using Amazon RDS Extended Support}
in the \emph{Amazon RDS User Guide}.

This setting applies only to RDS for MySQL and RDS for PostgreSQL. For
Amazon Aurora DB instances, the life cycle type is managed by the DB
cluster.

Valid Values:
\code{open-source-rds-extended-support | open-source-rds-extended-support-disabled}

Default: \code{open-source-rds-extended-support}}
}
\description{
Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the \code{LatestRestorableTime} property. You can restore to a point up to the number of days specified by the \code{BackupRetentionPeriod} property.

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_instance_to_point_in_time/} for full documentation.
}
\keyword{internal}
