% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_scan}
\alias{dynamodb_scan}
\title{The Scan operation returns one or more items and item attributes by
accessing every item in a table or a secondary index}
\usage{
dynamodb_scan(
  TableName,
  IndexName = NULL,
  AttributesToGet = NULL,
  Limit = NULL,
  Select = NULL,
  ScanFilter = NULL,
  ConditionalOperator = NULL,
  ExclusiveStartKey = NULL,
  ReturnConsumedCapacity = NULL,
  TotalSegments = NULL,
  Segment = NULL,
  ProjectionExpression = NULL,
  FilterExpression = NULL,
  ExpressionAttributeNames = NULL,
  ExpressionAttributeValues = NULL,
  ConsistentRead = NULL
)
}
\arguments{
\item{TableName}{[required] The name of the table containing the requested items; or, if you provide
\code{IndexName}, the name of the table to which that index belongs.}

\item{IndexName}{The name of a secondary index to scan. This index can be any local
secondary index or global secondary index. Note that if you use the
\code{IndexName} parameter, you must also provide \code{TableName}.}

\item{AttributesToGet}{This is a legacy parameter. Use \code{ProjectionExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html}{AttributesToGet}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{Limit}{The maximum number of items to evaluate (not necessarily the number of
matching items). If DynamoDB processes the number of items up to the
limit while processing the results, it stops the operation and returns
the matching values up to that point, and a key in \code{LastEvaluatedKey} to
apply in a subsequent operation, so that you can pick up where you left
off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
reaches this limit, it stops the operation and returns the matching
values up to the limit, and a key in \code{LastEvaluatedKey} to apply in a
subsequent operation to continue the operation. For more information,
see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html}{Working with Queries}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{Select}{The attributes to be returned in the result. You can retrieve all item
attributes, specific item attributes, the count of matching items, or in
the case of an index, some or all of the attributes projected into the
index.
\itemize{
\item \code{ALL_ATTRIBUTES} - Returns all of the item attributes from the
specified table or index. If you query a local secondary index, then
for each matching item in the index, DynamoDB fetches the entire
item from the parent table. If the index is configured to project
all item attributes, then all of the data can be obtained from the
local secondary index, and no fetching is required.
\item \code{ALL_PROJECTED_ATTRIBUTES} - Allowed only when querying an index.
Retrieves all attributes that have been projected into the index. If
the index is configured to project all attributes, this return value
is equivalent to specifying \code{ALL_ATTRIBUTES}.
\item \code{COUNT} - Returns the number of matching items, rather than the
matching items themselves. Note that this uses the same quantity of
read capacity units as getting the items, and is subject to the same
item size calculations.
\item \code{SPECIFIC_ATTRIBUTES} - Returns only the attributes listed in
\code{ProjectionExpression}. This return value is equivalent to
specifying \code{ProjectionExpression} without specifying any value for
\code{Select}.

If you query or scan a local secondary index and request only
attributes that are projected into that index, the operation reads
only the index and not the table. If any of the requested attributes
are not projected into the local secondary index, DynamoDB fetches
each of these attributes from the parent table. This extra fetching
incurs additional throughput cost and latency.

If you query or scan a global secondary index, you can only request
attributes that are projected into the index. Global secondary index
queries cannot fetch attributes from the parent table.
}

If neither \code{Select} nor \code{ProjectionExpression} are specified, DynamoDB
defaults to \code{ALL_ATTRIBUTES} when accessing a table, and
\code{ALL_PROJECTED_ATTRIBUTES} when accessing an index. You cannot use both
\code{Select} and \code{ProjectionExpression} together in a single request, unless
the value for \code{Select} is \code{SPECIFIC_ATTRIBUTES}. (This usage is
equivalent to specifying \code{ProjectionExpression} without any value for
\code{Select}.)

If you use the \code{ProjectionExpression} parameter, then the value for
\code{Select} can only be \code{SPECIFIC_ATTRIBUTES}. Any other value for \code{Select}
will return an error.}

\item{ScanFilter}{This is a legacy parameter. Use \code{FilterExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html}{ScanFilter}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConditionalOperator}{This is a legacy parameter. Use \code{FilterExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html}{ConditionalOperator}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExclusiveStartKey}{The primary key of the first item that this operation will evaluate. Use
the value that was returned for \code{LastEvaluatedKey} in the previous
operation.

The data type for \code{ExclusiveStartKey} must be String, Number or Binary.
No set data types are allowed.

In a parallel scan, a \code{\link[=dynamodb_scan]{scan}} request that includes
\code{ExclusiveStartKey} must specify the same segment whose previous
\code{\link[=dynamodb_scan]{scan}} returned the corresponding value of
\code{LastEvaluatedKey}.}

\item{ReturnConsumedCapacity}{}

\item{TotalSegments}{For a parallel \code{\link[=dynamodb_scan]{scan}} request, \code{TotalSegments}
represents the total number of segments into which the
\code{\link[=dynamodb_scan]{scan}} operation will be divided. The value of
\code{TotalSegments} corresponds to the number of application workers that
will perform the parallel scan. For example, if you want to use four
application threads to scan a table or an index, specify a
\code{TotalSegments} value of 4.

The value for \code{TotalSegments} must be greater than or equal to 1, and
less than or equal to 1000000. If you specify a \code{TotalSegments} value of
1, the \code{\link[=dynamodb_scan]{scan}} operation will be sequential rather than
parallel.

If you specify \code{TotalSegments}, you must also specify \code{Segment}.}

\item{Segment}{For a parallel \code{\link[=dynamodb_scan]{scan}} request, \code{Segment} identifies an
individual segment to be scanned by an application worker.

Segment IDs are zero-based, so the first segment is always 0. For
example, if you want to use four application threads to scan a table or
an index, then the first thread specifies a \code{Segment} value of 0, the
second thread specifies 1, and so on.

The value of \code{LastEvaluatedKey} returned from a parallel
\code{\link[=dynamodb_scan]{scan}} request must be used as \code{ExclusiveStartKey} with
the same segment ID in a subsequent \code{\link[=dynamodb_scan]{scan}} operation.

The value for \code{Segment} must be greater than or equal to 0, and less
than the value provided for \code{TotalSegments}.

If you provide \code{Segment}, you must also provide \code{TotalSegments}.}

\item{ProjectionExpression}{A string that identifies one or more attributes to retrieve from the
specified table or index. These attributes can include scalars, sets, or
elements of a JSON document. The attributes in the expression must be
separated by commas.

If no attribute names are specified, then all attributes will be
returned. If any of the requested attributes are not found, they will
not appear in the result.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{FilterExpression}{A string that contains conditions that DynamoDB applies after the
\code{\link[=dynamodb_scan]{scan}} operation, but before the data is returned to
you. Items that do not satisfy the \code{FilterExpression} criteria are not
returned.

A \code{FilterExpression} is applied after the items have already been read;
the process of filtering does not consume any additional read capacity
units.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.FilterExpression}{Filter Expressions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeNames}{One or more substitution tokens for attribute names in an expression.
The following are some use cases for using \code{ExpressionAttributeNames}:
\itemize{
\item To access an attribute whose name conflicts with a DynamoDB reserved
word.
\item To create a placeholder for repeating occurrences of an attribute
name in an expression.
\item To prevent special characters in an attribute name from being
misinterpreted in an expression.
}

Use the \strong{#} character in an expression to dereference an attribute
name. For example, consider the following attribute name:
\itemize{
\item \code{Percentile}
}

The name of this attribute conflicts with a reserved word, so it cannot
be used directly in an expression. (For the complete list of reserved
words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}). To work around this, you
could specify the following for \code{ExpressionAttributeNames}:
\itemize{
\item \code{{"#P":"Percentile"}}
}

You could then use this substitution in an expression, as in this
example:
\itemize{
\item \verb{#P = :val}
}

Tokens that begin with the \strong{:} character are \emph{expression attribute
values}, which are placeholders for the actual value at runtime.

For more information on expression attribute names, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeValues}{One or more values that can be substituted in an expression.

Use the \strong{:} (colon) character in an expression to dereference an
attribute value. For example, suppose that you wanted to check whether
the value of the \code{ProductStatus} attribute was one of the following:

\code{Available | Backordered | Discontinued}

You would first need to specify \code{ExpressionAttributeValues} as follows:

\verb{\{ ":avail":\{"S":"Available"\}, ":back":\{"S":"Backordered"\}, ":disc":\{"S":"Discontinued"\} \}}

You could then use these values in an expression, such as this:

\verb{ProductStatus IN (:avail, :back, :disc)}

For more information on expression attribute values, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.ConditionExpressions.html}{Condition Expressions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConsistentRead}{A Boolean value that determines the read consistency model during the
scan:
\itemize{
\item If \code{ConsistentRead} is \code{false}, then the data returned from
\code{\link[=dynamodb_scan]{scan}} might not contain the results from other
recently completed write operations
(\code{\link[=dynamodb_put_item]{put_item}},
\code{\link[=dynamodb_update_item]{update_item}}, or
\code{\link[=dynamodb_delete_item]{delete_item}}).
\item If \code{ConsistentRead} is \code{true}, then all of the write operations that
completed before the \code{\link[=dynamodb_scan]{scan}} began are guaranteed to
be contained in the \code{\link[=dynamodb_scan]{scan}} response.
}

The default setting for \code{ConsistentRead} is \code{false}.

The \code{ConsistentRead} parameter is not supported on global secondary
indexes. If you scan a global secondary index with \code{ConsistentRead} set
to true, you will receive a \code{ValidationException}.}
}
\description{
The \code{\link[=dynamodb_scan]{scan}} operation returns one or more items and item attributes by accessing every item in a table or a secondary index. To have DynamoDB return fewer items, you can provide a \code{FilterExpression} operation.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_scan/} for full documentation.
}
\keyword{internal}
