% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster_iam_roles}
\alias{redshift_modify_cluster_iam_roles}
\title{Modifies the list of AWS Identity and Access Management (IAM) roles that
can be used by the cluster to access other AWS services}
\usage{
redshift_modify_cluster_iam_roles(ClusterIdentifier, AddIamRoles,
  RemoveIamRoles)
}
\arguments{
\item{ClusterIdentifier}{[required] The unique identifier of the cluster for which you want to associate or
disassociate IAM roles.}

\item{AddIamRoles}{Zero or more IAM roles to associate with the cluster. The roles must be
in their Amazon Resource Name (ARN) format. You can associate up to 10
IAM roles with a single cluster in a single request.}

\item{RemoveIamRoles}{Zero or more IAM roles in ARN format to disassociate from the cluster.
You can disassociate up to 10 IAM roles from a single cluster in a
single request.}
}
\description{
Modifies the list of AWS Identity and Access Management (IAM) roles that
can be used by the cluster to access other AWS services.
}
\details{
A cluster can have up to 10 IAM roles associated at any time.
}
\section{Request syntax}{
\preformatted{svc$modify_cluster_iam_roles(
  ClusterIdentifier = "string",
  AddIamRoles = list(
    "string"
  ),
  RemoveIamRoles = list(
    "string"
  )
)
}
}

\keyword{internal}
