% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_from_s3}
\alias{rds_restore_db_instance_from_s3}
\title{Amazon Relational Database Service (Amazon RDS) supports importing MySQL
databases by using backup files}
\usage{
rds_restore_db_instance_from_s3(DBName, DBInstanceIdentifier,
  AllocatedStorage, DBInstanceClass, Engine, MasterUsername,
  MasterUserPassword, DBSecurityGroups, VpcSecurityGroupIds,
  AvailabilityZone, DBSubnetGroupName, PreferredMaintenanceWindow,
  DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
  Port, MultiAZ, EngineVersion, AutoMinorVersionUpgrade, LicenseModel,
  Iops, OptionGroupName, PubliclyAccessible, Tags, StorageType,
  StorageEncrypted, KmsKeyId, CopyTagsToSnapshot, MonitoringInterval,
  MonitoringRoleArn, EnableIAMDatabaseAuthentication, SourceEngine,
  SourceEngineVersion, S3BucketName, S3Prefix, S3IngestionRoleArn,
  EnablePerformanceInsights, PerformanceInsightsKMSKeyId,
  PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports,
  ProcessorFeatures, UseDefaultProcessorFeatures, DeletionProtection)
}
\arguments{
\item{DBName}{The name of the database to create when the DB instance is created.
Follow the naming rules specified in \code{CreateDBInstance}.}

\item{DBInstanceIdentifier}{[required] The DB instance identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{AllocatedStorage}{The amount of storage (in gigabytes) to allocate initially for the DB
instance. Follow the allocation rules specified in \code{CreateDBInstance}.

Be sure to allocate enough memory for your new DB instance so that the
restore operation can succeed. You can also allocate additional memory
for future growth.}

\item{DBInstanceClass}{[required] The compute and memory capacity of the DB instance, for example,
\code{db.m4.large}. Not all DB instance classes are available in all AWS
Regions, or for all database engines. For the full list of DB instance
classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Importing from Amazon S3 is not supported on the db.t2.micro DB instance
class.}

\item{Engine}{[required] The name of the database engine to be used for this instance.

Valid Values: \code{mysql}}

\item{MasterUsername}{The name for the master user.

Constraints:
\itemize{
\item Must be 1 to 16 letters or numbers.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{The password for the master user. The password can include any printable
ASCII character except "/", """, or "@".

Constraints: Must contain from 8 to 41 characters.}

\item{DBSecurityGroups}{A list of DB security groups to associate with this DB instance.

Default: The default DB security group for the database engine.}

\item{VpcSecurityGroupIds}{A list of VPC security groups to associate with this DB instance.}

\item{AvailabilityZone}{The Availability Zone that the DB instance is created in. For
information about AWS Regions and Availability Zones, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html}{Regions and Availability Zones}
in the \emph{Amazon RDS User Guide.}

Default: A random, system-chosen Availability Zone in the endpoint's
AWS Region.

Example: \code{us-east-1d}

Constraint: The \code{AvailabilityZone} parameter can't be specified if the
DB instance is a Multi-AZ deployment. The specified Availability Zone
must be in the same AWS Region as the current endpoint.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB instance.}

\item{PreferredMaintenanceWindow}{The time range each week during which system maintenance can occur, in
Universal Coordinated Time (UTC). For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance}{Amazon RDS Maintenance Window}
in the \emph{Amazon RDS User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{ddd:hh24:mi-ddd:hh24:mi}.
\item Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred backup window.
\item Must be at least 30 minutes.
}}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.
If this argument is omitted, the default parameter group for the
specified engine is used.}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. Setting
this parameter to a positive number enables backups. For more
information, see \code{CreateDBInstance}.}

\item{PreferredBackupWindow}{The time range each day during which automated backups are created if
automated backups are enabled. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow}{The Backup Window}
in the \emph{Amazon RDS User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{Port}{The port number on which the database accepts connections.

Type: Integer

Valid Values: \code{1150}-\code{65535}

Default: \code{3306}}

\item{MultiAZ}{A value that indicates whether the DB instance is a Multi-AZ deployment.
If the DB instance is a Multi-AZ deployment, you can't set the
\code{AvailabilityZone} parameter.}

\item{EngineVersion}{The version number of the database engine to use. Choose the latest
minor version of your database engine. For information about engine
versions, see \code{CreateDBInstance}, or call \code{DescribeDBEngineVersions}.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor engine upgrades are applied
automatically to the DB instance during the maintenance window. By
default, minor engine upgrades are not applied automatically.}

\item{LicenseModel}{The license model for this DB instance. Use \code{general-public-license}.}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
allocate initially for the DB instance. For information about valid Iops
values, see see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS Storage to Improve Performance}
in the \emph{Amazon RDS User Guide.}}

\item{OptionGroupName}{The name of the option group to associate with this DB instance. If this
argument is omitted, the default option group for the specified engine
is used.}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.
When the DB instance is publicly accessible, it is an Internet-facing
instance with a publicly resolvable DNS name, which resolves to a public
IP address. When the DB instance is not publicly accessible, it is an
internal instance with a DNS name that resolves to a private IP address.
For more information, see CreateDBInstance.}

\item{Tags}{A list of tags to associate with this DB instance. For more information,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html}{Tagging Amazon RDS Resources}
in the \emph{Amazon RDS User Guide.}}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid values: \code{standard} \| \code{gp2} \| \code{io1}

If you specify \code{io1}, you must also include a value for the \code{Iops}
parameter.

Default: \code{io1} if the \code{Iops} parameter is specified; otherwise \code{gp2}}

\item{StorageEncrypted}{A value that indicates whether the new DB instance is encrypted or not.}

\item{KmsKeyId}{The AWS KMS key identifier for an encrypted DB instance.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a DB instance with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
instance, then you can use the KMS key alias instead of the ARN for the
KM encryption key.

If the \code{StorageEncrypted} parameter is enabled, and you do not specify a
value for the \code{KmsKeyId} parameter, then Amazon RDS will use your
default encryption key. AWS KMS creates the default encryption key for
your AWS account. Your AWS account has a different default encryption
key for each AWS Region.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the DB instance to
snapshots of the DB instance. By default, tags are not copied.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: 0, 1, 5, 10, 15, 30, 60

Default: \code{0}}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits RDS to send enhanced monitoring
metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}. For information on creating a
monitoring role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling}{Setting Up and Enabling Enhanced Monitoring}
in the \emph{Amazon RDS User Guide.}

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.}

\item{SourceEngine}{[required] The name of the engine of your source database.

Valid Values: \code{mysql}}

\item{SourceEngineVersion}{[required] The engine version of your source database.

Valid Values: \code{5.6}}

\item{S3BucketName}{[required] The name of your Amazon S3 bucket that contains your database backup
file.}

\item{S3Prefix}{The prefix of your Amazon S3 bucket.}

\item{S3IngestionRoleArn}{[required] An AWS Identity and Access Management (IAM) role to allow Amazon RDS to
access your Amazon S3 bucket.}

\item{EnablePerformanceInsights}{A value that indicates whether to enable Performance Insights for the DB
instance.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Using Amazon Performance Insights}
in the \emph{Amazon Relational Database Service User Guide}.}

\item{PerformanceInsightsKMSKeyId}{The AWS KMS key identifier for encryption of Performance Insights data.
The KMS key ID is the Amazon Resource Name (ARN), the KMS key
identifier, or the KMS key alias for the KMS encryption key.

If you do not specify a value for \code{PerformanceInsightsKMSKeyId}, then
Amazon RDS uses your default encryption key. AWS KMS creates the default
encryption key for your AWS account. Your AWS account has a different
default encryption key for each AWS Region.}

\item{PerformanceInsightsRetentionPeriod}{The amount of time, in days, to retain Performance Insights data. Valid
values are 7 or 731 (2 years).}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}
}
\description{
Amazon Relational Database Service (Amazon RDS) supports importing MySQL
databases by using backup files. You can create a backup of your
on-premises database, store it on Amazon Simple Storage Service (Amazon
S3), and then restore the backup file onto a new Amazon RDS DB instance
running MySQL. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html}{Importing Data into an Amazon RDS MySQL DB Instance}
in the \emph{Amazon RDS User Guide.}
}
\section{Request syntax}{
\preformatted{svc$restore_db_instance_from_s3(
  DBName = "string",
  DBInstanceIdentifier = "string",
  AllocatedStorage = 123,
  DBInstanceClass = "string",
  Engine = "string",
  MasterUsername = "string",
  MasterUserPassword = "string",
  DBSecurityGroups = list(
    "string"
  ),
  VpcSecurityGroupIds = list(
    "string"
  ),
  AvailabilityZone = "string",
  DBSubnetGroupName = "string",
  PreferredMaintenanceWindow = "string",
  DBParameterGroupName = "string",
  BackupRetentionPeriod = 123,
  PreferredBackupWindow = "string",
  Port = 123,
  MultiAZ = TRUE|FALSE,
  EngineVersion = "string",
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  Iops = 123,
  OptionGroupName = "string",
  PubliclyAccessible = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageType = "string",
  StorageEncrypted = TRUE|FALSE,
  KmsKeyId = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  MonitoringInterval = 123,
  MonitoringRoleArn = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  SourceEngine = "string",
  SourceEngineVersion = "string",
  S3BucketName = "string",
  S3Prefix = "string",
  S3IngestionRoleArn = "string",
  EnablePerformanceInsights = TRUE|FALSE,
  PerformanceInsightsKMSKeyId = "string",
  PerformanceInsightsRetentionPeriod = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  ProcessorFeatures = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  UseDefaultProcessorFeatures = TRUE|FALSE,
  DeletionProtection = TRUE|FALSE
)
}
}

\keyword{internal}
