% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_register_db_proxy_targets}
\alias{rds_register_db_proxy_targets}
\title{Associate one or more DBProxyTarget data structures with a
DBProxyTargetGroup}
\usage{
rds_register_db_proxy_targets(DBProxyName, TargetGroupName,
  DBInstanceIdentifiers, DBClusterIdentifiers)
}
\arguments{
\item{DBProxyName}{[required] The identifier of the \code{DBProxy} that is associated with the
\code{DBProxyTargetGroup}.}

\item{TargetGroupName}{The identifier of the \code{DBProxyTargetGroup}.}

\item{DBInstanceIdentifiers}{One or more DB instance identifiers.}

\item{DBClusterIdentifiers}{One or more DB cluster identifiers.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBProxyTargets = list(
    list(
      TargetArn = "string",
      Endpoint = "string",
      TrackedClusterId = "string",
      RdsResourceId = "string",
      Port = 123,
      Type = "RDS_INSTANCE"|"RDS_SERVERLESS_ENDPOINT"|"TRACKED_CLUSTER",
      TargetHealth = list(
        State = "REGISTERING"|"AVAILABLE"|"UNAVAILABLE",
        Reason = "UNREACHABLE"|"CONNECTION_FAILED"|"AUTH_FAILURE"|"PENDING_PROXY_CAPACITY",
        Description = "string"
      )
    )
  )
)
}
}
\description{
Associate one or more \code{DBProxyTarget} data structures with a
\code{DBProxyTargetGroup}.
}
\section{Request syntax}{
\preformatted{svc$register_db_proxy_targets(
  DBProxyName = "string",
  TargetGroupName = "string",
  DBInstanceIdentifiers = list(
    "string"
  ),
  DBClusterIdentifiers = list(
    "string"
  )
)
}
}

\keyword{internal}
