% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_option_group}
\alias{rds_create_option_group}
\title{Creates a new option group}
\usage{
rds_create_option_group(OptionGroupName, EngineName, MajorEngineVersion,
  OptionGroupDescription, Tags)
}
\arguments{
\item{OptionGroupName}{[required] Specifies the name of the option group to be created.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{myoptiongroup}}

\item{EngineName}{[required] Specifies the name of the engine that this option group should be
associated with.}

\item{MajorEngineVersion}{[required] Specifies the major version of the engine that this option group should
be associated with.}

\item{OptionGroupDescription}{[required] The description of the option group.}

\item{Tags}{Tags to assign to the option group.}
}
\value{
A list with the following syntax:\preformatted{list(
  OptionGroup = list(
    OptionGroupName = "string",
    OptionGroupDescription = "string",
    EngineName = "string",
    MajorEngineVersion = "string",
    Options = list(
      list(
        OptionName = "string",
        OptionDescription = "string",
        Persistent = TRUE|FALSE,
        Permanent = TRUE|FALSE,
        Port = 123,
        OptionVersion = "string",
        OptionSettings = list(
          list(
            Name = "string",
            Value = "string",
            DefaultValue = "string",
            Description = "string",
            ApplyType = "string",
            DataType = "string",
            AllowedValues = "string",
            IsModifiable = TRUE|FALSE,
            IsCollection = TRUE|FALSE
          )
        ),
        DBSecurityGroupMemberships = list(
          list(
            DBSecurityGroupName = "string",
            Status = "string"
          )
        ),
        VpcSecurityGroupMemberships = list(
          list(
            VpcSecurityGroupId = "string",
            Status = "string"
          )
        )
      )
    ),
    AllowsVpcAndNonVpcInstanceMemberships = TRUE|FALSE,
    VpcId = "string",
    OptionGroupArn = "string"
  )
)
}
}
\description{
Creates a new option group. You can create up to 20 option groups.
}
\section{Request syntax}{
\preformatted{svc$create_option_group(
  OptionGroupName = "string",
  EngineName = "string",
  MajorEngineVersion = "string",
  OptionGroupDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
