% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_db_clusters}
\alias{neptune_describe_db_clusters}
\title{Returns information about provisioned DB clusters, and supports
pagination}
\usage{
neptune_describe_db_clusters(DBClusterIdentifier, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{DBClusterIdentifier}{The user-supplied DB cluster identifier. If this parameter is specified,
information from only the specific DB cluster is returned. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item If supplied, must match an existing DBClusterIdentifier.
}}

\item{Filters}{A filter that specifies one or more DB clusters to describe.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list will only include
information about the DB clusters identified by these ARNs.
\item \code{engine} - Accepts an engine name (such as \code{neptune}), and restricts
the results list to DB clusters created by that engine.
}

For example, to invoke this API from the AWS CLI and filter so that only
Neptune DB clusters are returned, you could use the following command:}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=neptune_describe_db_clusters]{describe_db_clusters}} request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  DBClusters = list(
    list(
      AllocatedStorage = 123,
      AvailabilityZones = list(
        "string"
      ),
      BackupRetentionPeriod = 123,
      CharacterSetName = "string",
      DatabaseName = "string",
      DBClusterIdentifier = "string",
      DBClusterParameterGroup = "string",
      DBSubnetGroup = "string",
      Status = "string",
      PercentProgress = "string",
      EarliestRestorableTime = as.POSIXct(
        "2015-01-01"
      ),
      Endpoint = "string",
      ReaderEndpoint = "string",
      MultiAZ = TRUE|FALSE,
      Engine = "string",
      EngineVersion = "string",
      LatestRestorableTime = as.POSIXct(
        "2015-01-01"
      ),
      Port = 123,
      MasterUsername = "string",
      DBClusterOptionGroupMemberships = list(
        list(
          DBClusterOptionGroupName = "string",
          Status = "string"
        )
      ),
      PreferredBackupWindow = "string",
      PreferredMaintenanceWindow = "string",
      ReplicationSourceIdentifier = "string",
      ReadReplicaIdentifiers = list(
        "string"
      ),
      DBClusterMembers = list(
        list(
          DBInstanceIdentifier = "string",
          IsClusterWriter = TRUE|FALSE,
          DBClusterParameterGroupStatus = "string",
          PromotionTier = 123
        )
      ),
      VpcSecurityGroups = list(
        list(
          VpcSecurityGroupId = "string",
          Status = "string"
        )
      ),
      HostedZoneId = "string",
      StorageEncrypted = TRUE|FALSE,
      KmsKeyId = "string",
      DbClusterResourceId = "string",
      DBClusterArn = "string",
      AssociatedRoles = list(
        list(
          RoleArn = "string",
          Status = "string",
          FeatureName = "string"
        )
      ),
      IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
      CloneGroupId = "string",
      ClusterCreateTime = as.POSIXct(
        "2015-01-01"
      ),
      EnabledCloudwatchLogsExports = list(
        "string"
      ),
      DeletionProtection = TRUE|FALSE
    )
  )
)
}
}
\description{
Returns information about provisioned DB clusters, and supports
pagination.

This operation can also return information for Amazon RDS clusters and
Amazon DocDB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_clusters(
  DBClusterIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
