% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_test_failover}
\alias{elasticache_test_failover}
\title{Represents the input of a TestFailover operation which test automatic
failover on a specified node group (called shard in the console) in a
replication group (called cluster in the console)}
\usage{
elasticache_test_failover(ReplicationGroupId, NodeGroupId)
}
\arguments{
\item{ReplicationGroupId}{[required] The name of the replication group (console: cluster) whose automatic
failover is being tested by this operation.}

\item{NodeGroupId}{[required] The name of the node group (called shard in the console) in this
replication group on which automatic failover is to be tested. You may
test automatic failover on up to 5 node groups in any rolling 24-hour
period.}
}
\value{
A list with the following syntax:\preformatted{list(
  ReplicationGroup = list(
    ReplicationGroupId = "string",
    Description = "string",
    GlobalReplicationGroupInfo = list(
      GlobalReplicationGroupId = "string",
      GlobalReplicationGroupMemberRole = "string"
    ),
    Status = "string",
    PendingModifiedValues = list(
      PrimaryClusterId = "string",
      AutomaticFailoverStatus = "enabled"|"disabled",
      Resharding = list(
        SlotMigration = list(
          ProgressPercentage = 123.0
        )
      ),
      AuthTokenStatus = "SETTING"|"ROTATING",
      UserGroups = list(
        UserGroupIdsToAdd = list(
          "string"
        ),
        UserGroupIdsToRemove = list(
          "string"
        )
      )
    ),
    MemberClusters = list(
      "string"
    ),
    NodeGroups = list(
      list(
        NodeGroupId = "string",
        Status = "string",
        PrimaryEndpoint = list(
          Address = "string",
          Port = 123
        ),
        ReaderEndpoint = list(
          Address = "string",
          Port = 123
        ),
        Slots = "string",
        NodeGroupMembers = list(
          list(
            CacheClusterId = "string",
            CacheNodeId = "string",
            ReadEndpoint = list(
              Address = "string",
              Port = 123
            ),
            PreferredAvailabilityZone = "string",
            PreferredOutpostArn = "string",
            CurrentRole = "string"
          )
        )
      )
    ),
    SnapshottingClusterId = "string",
    AutomaticFailover = "enabled"|"disabled"|"enabling"|"disabling",
    MultiAZ = "enabled"|"disabled",
    ConfigurationEndpoint = list(
      Address = "string",
      Port = 123
    ),
    SnapshotRetentionLimit = 123,
    SnapshotWindow = "string",
    ClusterEnabled = TRUE|FALSE,
    CacheNodeType = "string",
    AuthTokenEnabled = TRUE|FALSE,
    AuthTokenLastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    TransitEncryptionEnabled = TRUE|FALSE,
    AtRestEncryptionEnabled = TRUE|FALSE,
    MemberClustersOutpostArns = list(
      "string"
    ),
    KmsKeyId = "string",
    ARN = "string",
    UserGroupIds = list(
      "string"
    )
  )
)
}
}
\description{
Represents the input of a \code{\link[=elasticache_test_failover]{test_failover}}
operation which test automatic failover on a specified node group
(called shard in the console) in a replication group (called cluster in
the console).

\strong{Note the following}
\itemize{
\item A customer can use this operation to test automatic failover on up
to 5 shards (called node groups in the ElastiCache API and AWS CLI)
in any rolling 24-hour period.
\item If calling this operation on shards in different clusters (called
replication groups in the API and CLI), the calls can be made
concurrently.
\item If calling this operation multiple times on different shards in the
same Redis (cluster mode enabled) replication group, the first node
replacement must complete before a subsequent call can be made.
\item To determine whether the node replacement is complete you can check
Events using the Amazon ElastiCache console, the AWS CLI, or the
ElastiCache API. Look for the following automatic failover related
events, listed here in order of occurrance:
\enumerate{
\item Replication group message:
\verb{Test Failover API called for node group <node-group-id>}
\item Cache cluster message:
\verb{Failover from primary node <primary-node-id> to replica node <node-id> completed}
\item Replication group message:
\verb{Failover from primary node <primary-node-id> to replica node <node-id> completed}
\item Cache cluster message: \verb{Recovering cache nodes <node-id>}
\item Cache cluster message:
\verb{Finished recovery for cache nodes <node-id>}
}

For more information see:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html}{Viewing ElastiCache Events}
in the \emph{ElastiCache User Guide}
\item \code{\link[=elasticache_describe_events]{describe_events}} in the
ElastiCache API Reference
}
}

Also see, \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test}{Testing Multi-AZ}
in the \emph{ElastiCache User Guide}.
}
\section{Request syntax}{
\preformatted{svc$test_failover(
  ReplicationGroupId = "string",
  NodeGroupId = "string"
)
}
}

\keyword{internal}
