% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_delete_cache_cluster}
\alias{elasticache_delete_cache_cluster}
\title{Deletes a previously provisioned cluster}
\usage{
elasticache_delete_cache_cluster(CacheClusterId,
  FinalSnapshotIdentifier)
}
\arguments{
\item{CacheClusterId}{[required] The cluster identifier for the cluster to be deleted. This parameter is
not case sensitive.}

\item{FinalSnapshotIdentifier}{The user-supplied name of a final cluster snapshot. This is the unique
name that identifies the snapshot. ElastiCache creates the snapshot, and
then deletes the cluster immediately afterward.}
}
\value{
A list with the following syntax:\preformatted{list(
  CacheCluster = list(
    CacheClusterId = "string",
    ConfigurationEndpoint = list(
      Address = "string",
      Port = 123
    ),
    ClientDownloadLandingPage = "string",
    CacheNodeType = "string",
    Engine = "string",
    EngineVersion = "string",
    CacheClusterStatus = "string",
    NumCacheNodes = 123,
    PreferredAvailabilityZone = "string",
    PreferredOutpostArn = "string",
    CacheClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      NumCacheNodes = 123,
      CacheNodeIdsToRemove = list(
        "string"
      ),
      EngineVersion = "string",
      CacheNodeType = "string",
      AuthTokenStatus = "SETTING"|"ROTATING"
    ),
    NotificationConfiguration = list(
      TopicArn = "string",
      TopicStatus = "string"
    ),
    CacheSecurityGroups = list(
      list(
        CacheSecurityGroupName = "string",
        Status = "string"
      )
    ),
    CacheParameterGroup = list(
      CacheParameterGroupName = "string",
      ParameterApplyStatus = "string",
      CacheNodeIdsToReboot = list(
        "string"
      )
    ),
    CacheSubnetGroupName = "string",
    CacheNodes = list(
      list(
        CacheNodeId = "string",
        CacheNodeStatus = "string",
        CacheNodeCreateTime = as.POSIXct(
          "2015-01-01"
        ),
        Endpoint = list(
          Address = "string",
          Port = 123
        ),
        ParameterGroupStatus = "string",
        SourceCacheNodeId = "string",
        CustomerAvailabilityZone = "string",
        CustomerOutpostArn = "string"
      )
    ),
    AutoMinorVersionUpgrade = TRUE|FALSE,
    SecurityGroups = list(
      list(
        SecurityGroupId = "string",
        Status = "string"
      )
    ),
    ReplicationGroupId = "string",
    SnapshotRetentionLimit = 123,
    SnapshotWindow = "string",
    AuthTokenEnabled = TRUE|FALSE,
    AuthTokenLastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    TransitEncryptionEnabled = TRUE|FALSE,
    AtRestEncryptionEnabled = TRUE|FALSE,
    ARN = "string"
  )
)
}
}
\description{
Deletes a previously provisioned cluster.
\code{\link[=elasticache_delete_cache_cluster]{delete_cache_cluster}} deletes all
associated cache nodes, node endpoints and the cluster itself. When you
receive a successful response from this operation, Amazon ElastiCache
immediately begins deleting the cluster; you cannot cancel or revert
this operation.

This operation is not valid for:
\itemize{
\item Redis (cluster mode enabled) clusters
\item A cluster that is the last read replica of a replication group
\item A node group (shard) that has Multi-AZ mode enabled
\item A cluster from a Redis (cluster mode enabled) replication group
\item A cluster that is not in the \code{available} state
}
}
\section{Request syntax}{
\preformatted{svc$delete_cache_cluster(
  CacheClusterId = "string",
  FinalSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
