% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_global_table}
\alias{dynamodb_describe_global_table}
\title{Returns information about the specified global table}
\usage{
dynamodb_describe_global_table(GlobalTableName)
}
\arguments{
\item{GlobalTableName}{[required] The name of the global table.}
}
\value{
A list with the following syntax:\preformatted{list(
  GlobalTableDescription = list(
    ReplicationGroup = list(
      list(
        RegionName = "string",
        ReplicaStatus = "CREATING"|"CREATION_FAILED"|"UPDATING"|"DELETING"|"ACTIVE"|"REGION_DISABLED"|"INACCESSIBLE_ENCRYPTION_CREDENTIALS",
        ReplicaStatusDescription = "string",
        ReplicaStatusPercentProgress = "string",
        KMSMasterKeyId = "string",
        ProvisionedThroughputOverride = list(
          ReadCapacityUnits = 123
        ),
        GlobalSecondaryIndexes = list(
          list(
            IndexName = "string",
            ProvisionedThroughputOverride = list(
              ReadCapacityUnits = 123
            )
          )
        ),
        ReplicaInaccessibleDateTime = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    GlobalTableArn = "string",
    CreationDateTime = as.POSIXct(
      "2015-01-01"
    ),
    GlobalTableStatus = "CREATING"|"ACTIVE"|"DELETING"|"UPDATING",
    GlobalTableName = "string"
  )
)
}
}
\description{
Returns information about the specified global table.

This operation only applies to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html}{Version 2017.11.29}
of global tables. If you are using global tables \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html}{Version 2019.11.21}
you can use \code{\link[=dynamodb_describe_table]{describe_table}} instead.
}
\section{Request syntax}{
\preformatted{svc$describe_global_table(
  GlobalTableName = "string"
)
}
}

\keyword{internal}
