% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_limits}
\alias{dynamodb_describe_limits}
\title{Returns the current provisioned-capacity quotas for your AWS account in
a Region, both for the Region as a whole and for any one DynamoDB table
that you create there}
\usage{
dynamodb_describe_limits()
}
\description{
Returns the current provisioned-capacity quotas for your AWS account in
a Region, both for the Region as a whole and for any one DynamoDB table
that you create there.

When you establish an AWS account, the account has initial quotas on the
maximum read capacity units and write capacity units that you can
provision across all of your DynamoDB tables in a given Region. Also,
there are per-table quotas that apply when you create a table there. For
more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html}{Service, Account, and Table Quotas}
page in the \emph{Amazon DynamoDB Developer Guide}.

Although you can increase these quotas by filing a case at AWS Support
Center, obtaining the increase is not instantaneous. The
\code{DescribeLimits} action lets you write code to compare the capacity you
are currently using to those quotas imposed by your account so that you
have enough time to apply for an increase before you hit a quota.

For example, you could use one of the AWS SDKs to do the following:
\enumerate{
\item Call \code{DescribeLimits} for a particular Region to obtain your current
account quotas on provisioned capacity there.
\item Create a variable to hold the aggregate read capacity units
provisioned for all your tables in that Region, and one to hold the
aggregate write capacity units. Zero them both.
\item Call \code{ListTables} to obtain a list of all your DynamoDB tables.
\item For each table name listed by \code{ListTables}, do the following:
\itemize{
\item Call \code{DescribeTable} with the table name.
\item Use the data returned by \code{DescribeTable} to add the read
capacity units and write capacity units provisioned for the
table itself to your variables.
\item If the table has one or more global secondary indexes (GSIs),
loop over these GSIs and add their provisioned capacity values
to your variables as well.
}
\item Report the account quotas for that Region returned by
\code{DescribeLimits}, along with the total current provisioned capacity
levels you have calculated.
}

This will let you see whether you are getting close to your
account-level quotas.

The per-table quotas apply only when you are creating a new table. They
restrict the sum of the provisioned capacity of the new table itself and
all its global secondary indexes.

For existing tables and their GSIs, DynamoDB doesn't let you increase
provisioned capacity extremely rapidly, but the only quota that applies
is that the aggregate provisioned capacity over all your tables and GSIs
cannot exceed either of the per-account quotas.

\code{DescribeLimits} should only be called periodically. You can expect
throttling errors if you call it more than once in a minute.

The \code{DescribeLimits} Request element has no content.
}
\section{Request syntax}{
\preformatted{svc$describe_limits()
}
}

\examples{
\dontrun{
# The following example returns the maximum read and write capacity units
# per table, and for the AWS account, in the current AWS region.
svc$describe_limits()
}

}
\keyword{internal}
