% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_outbound_chat_contact}
\alias{connect_start_outbound_chat_contact}
\title{Initiates a new outbound SMS contact to a customer}
\usage{
connect_start_outbound_chat_contact(
  SourceEndpoint,
  DestinationEndpoint,
  InstanceId,
  SegmentAttributes,
  Attributes = NULL,
  ContactFlowId,
  ChatDurationInMinutes = NULL,
  ParticipantDetails = NULL,
  InitialSystemMessage = NULL,
  RelatedContactId = NULL,
  SupportedMessagingContentTypes = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{SourceEndpoint}{[required]}

\item{DestinationEndpoint}{[required]}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the instance
ID in the Amazon Resource Name (ARN) of the instance.}

\item{SegmentAttributes}{[required] A set of system defined key-value pairs stored on individual contact
segments using an attribute map. The attributes are standard Amazon
Connect attributes. They can be accessed in flows.
\itemize{
\item Attribute keys can include only alphanumeric, \code{-}, and \verb{_}.
\item This field can be used to show channel subtype, such as
\code{connect:Guide} and \code{connect:SMS}.
}}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in flows just
like any other contact attributes.}

\item{ContactFlowId}{[required] The identifier of the flow for the call. To see the ContactFlowId in the
Amazon Connect console user interface, on the navigation menu go to
\strong{Routing, Contact Flows}. Choose the flow. On the flow page, under the
name of the flow, choose \strong{Show additional flow information}. The
ContactFlowId is the last part of the ARN, shown here in bold:
\itemize{
\item arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/\strong{123ec456-a007-89c0-1234-xxxxxxxxxxxx}
}}

\item{ChatDurationInMinutes}{The total duration of the newly started chat session. If not specified,
the chat session duration defaults to 25 hour. The minimum configurable
time is 60 minutes. The maximum configurable time is 10,080 minutes (7
days).}

\item{ParticipantDetails}{}

\item{InitialSystemMessage}{}

\item{RelatedContactId}{The unique identifier for an Amazon Connect contact. This identifier is
related to the contact starting.}

\item{SupportedMessagingContentTypes}{The supported chat message content types. Supported types are:
\itemize{
\item \code{text/plain}
\item \code{text/markdown}
\item \verb{application/json, application/vnd.amazonaws.connect.message.interactive}
\item \code{application/vnd.amazonaws.connect.message.interactive.response}
}

Content types must always contain \code{text/plain}. You can then put any
other supported type in the list. For example, all the following lists
are valid because they contain \code{text/plain}:
\itemize{
\item \verb{[text/plain, text/markdown, application/json]}
\item \verb{[text/markdown, text/plain]}
\item \verb{[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]}
}}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the AWS SDK populates this
field. For more information about idempotency, see \href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.
The token is valid for 7 days after creation. If a contact is already
started, the contact ID is returned.}
}
\description{
Initiates a new outbound SMS contact to a customer. Response of this API provides the \code{ContactId} of the outbound SMS contact created.

See \url{https://www.paws-r-sdk.com/docs/connect_start_outbound_chat_contact/} for full documentation.
}
\keyword{internal}
