# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pinpoint_service.R
NULL

#' Creates an application
#'
#' @description
#' Creates an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_app.html](https://paws-r.github.io/docs/pinpoint/create_app.html) for full documentation.
#'
#' @param CreateApplicationRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_app
pinpoint_create_app <- function(CreateApplicationRequest) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/v1/apps",
    paginator = list()
  )
  input <- .pinpoint$create_app_input(CreateApplicationRequest = CreateApplicationRequest)
  output <- .pinpoint$create_app_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_app <- pinpoint_create_app

#' Creates a new campaign for an application or updates the settings of an
#' existing campaign for an application
#'
#' @description
#' Creates a new campaign for an application or updates the settings of an existing campaign for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_campaign.html](https://paws-r.github.io/docs/pinpoint/create_campaign.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteCampaignRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_campaign
pinpoint_create_campaign <- function(ApplicationId, WriteCampaignRequest) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/campaigns",
    paginator = list()
  )
  input <- .pinpoint$create_campaign_input(ApplicationId = ApplicationId, WriteCampaignRequest = WriteCampaignRequest)
  output <- .pinpoint$create_campaign_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_campaign <- pinpoint_create_campaign

#' Creates a message template for messages that are sent through the email
#' channel
#'
#' @description
#' Creates a message template for messages that are sent through the email channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_email_template.html](https://paws-r.github.io/docs/pinpoint/create_email_template.html) for full documentation.
#'
#' @param EmailTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_email_template
pinpoint_create_email_template <- function(EmailTemplateRequest, TemplateName) {
  op <- new_operation(
    name = "CreateEmailTemplate",
    http_method = "POST",
    http_path = "/v1/templates/{template-name}/email",
    paginator = list()
  )
  input <- .pinpoint$create_email_template_input(EmailTemplateRequest = EmailTemplateRequest, TemplateName = TemplateName)
  output <- .pinpoint$create_email_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_email_template <- pinpoint_create_email_template

#' Creates an export job for an application
#'
#' @description
#' Creates an export job for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_export_job.html](https://paws-r.github.io/docs/pinpoint/create_export_job.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param ExportJobRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_export_job
pinpoint_create_export_job <- function(ApplicationId, ExportJobRequest) {
  op <- new_operation(
    name = "CreateExportJob",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$create_export_job_input(ApplicationId = ApplicationId, ExportJobRequest = ExportJobRequest)
  output <- .pinpoint$create_export_job_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_export_job <- pinpoint_create_export_job

#' Creates an import job for an application
#'
#' @description
#' Creates an import job for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_import_job.html](https://paws-r.github.io/docs/pinpoint/create_import_job.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param ImportJobRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_import_job
pinpoint_create_import_job <- function(ApplicationId, ImportJobRequest) {
  op <- new_operation(
    name = "CreateImportJob",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$create_import_job_input(ApplicationId = ApplicationId, ImportJobRequest = ImportJobRequest)
  output <- .pinpoint$create_import_job_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_import_job <- pinpoint_create_import_job

#' Creates a new message template for messages using the in-app message
#' channel
#'
#' @description
#' Creates a new message template for messages using the in-app message channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_in_app_template.html](https://paws-r.github.io/docs/pinpoint/create_in_app_template.html) for full documentation.
#'
#' @param InAppTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_in_app_template
pinpoint_create_in_app_template <- function(InAppTemplateRequest, TemplateName) {
  op <- new_operation(
    name = "CreateInAppTemplate",
    http_method = "POST",
    http_path = "/v1/templates/{template-name}/inapp",
    paginator = list()
  )
  input <- .pinpoint$create_in_app_template_input(InAppTemplateRequest = InAppTemplateRequest, TemplateName = TemplateName)
  output <- .pinpoint$create_in_app_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_in_app_template <- pinpoint_create_in_app_template

#' Creates a journey for an application
#'
#' @description
#' Creates a journey for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_journey.html](https://paws-r.github.io/docs/pinpoint/create_journey.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteJourneyRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_journey
pinpoint_create_journey <- function(ApplicationId, WriteJourneyRequest) {
  op <- new_operation(
    name = "CreateJourney",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/journeys",
    paginator = list()
  )
  input <- .pinpoint$create_journey_input(ApplicationId = ApplicationId, WriteJourneyRequest = WriteJourneyRequest)
  output <- .pinpoint$create_journey_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_journey <- pinpoint_create_journey

#' Creates a message template for messages that are sent through a push
#' notification channel
#'
#' @description
#' Creates a message template for messages that are sent through a push notification channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_push_template.html](https://paws-r.github.io/docs/pinpoint/create_push_template.html) for full documentation.
#'
#' @param PushNotificationTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_push_template
pinpoint_create_push_template <- function(PushNotificationTemplateRequest, TemplateName) {
  op <- new_operation(
    name = "CreatePushTemplate",
    http_method = "POST",
    http_path = "/v1/templates/{template-name}/push",
    paginator = list()
  )
  input <- .pinpoint$create_push_template_input(PushNotificationTemplateRequest = PushNotificationTemplateRequest, TemplateName = TemplateName)
  output <- .pinpoint$create_push_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_push_template <- pinpoint_create_push_template

#' Creates an Amazon Pinpoint configuration for a recommender model
#'
#' @description
#' Creates an Amazon Pinpoint configuration for a recommender model.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_recommender_configuration.html](https://paws-r.github.io/docs/pinpoint/create_recommender_configuration.html) for full documentation.
#'
#' @param CreateRecommenderConfiguration &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_recommender_configuration
pinpoint_create_recommender_configuration <- function(CreateRecommenderConfiguration) {
  op <- new_operation(
    name = "CreateRecommenderConfiguration",
    http_method = "POST",
    http_path = "/v1/recommenders",
    paginator = list()
  )
  input <- .pinpoint$create_recommender_configuration_input(CreateRecommenderConfiguration = CreateRecommenderConfiguration)
  output <- .pinpoint$create_recommender_configuration_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_recommender_configuration <- pinpoint_create_recommender_configuration

#' Creates a new segment for an application or updates the configuration,
#' dimension, and other settings for an existing segment that's associated
#' with an application
#'
#' @description
#' Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_segment.html](https://paws-r.github.io/docs/pinpoint/create_segment.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteSegmentRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_segment
pinpoint_create_segment <- function(ApplicationId, WriteSegmentRequest) {
  op <- new_operation(
    name = "CreateSegment",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/segments",
    paginator = list()
  )
  input <- .pinpoint$create_segment_input(ApplicationId = ApplicationId, WriteSegmentRequest = WriteSegmentRequest)
  output <- .pinpoint$create_segment_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_segment <- pinpoint_create_segment

#' Creates a message template for messages that are sent through the SMS
#' channel
#'
#' @description
#' Creates a message template for messages that are sent through the SMS channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_sms_template.html](https://paws-r.github.io/docs/pinpoint/create_sms_template.html) for full documentation.
#'
#' @param SMSTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_sms_template
pinpoint_create_sms_template <- function(SMSTemplateRequest, TemplateName) {
  op <- new_operation(
    name = "CreateSmsTemplate",
    http_method = "POST",
    http_path = "/v1/templates/{template-name}/sms",
    paginator = list()
  )
  input <- .pinpoint$create_sms_template_input(SMSTemplateRequest = SMSTemplateRequest, TemplateName = TemplateName)
  output <- .pinpoint$create_sms_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_sms_template <- pinpoint_create_sms_template

#' Creates a message template for messages that are sent through the voice
#' channel
#'
#' @description
#' Creates a message template for messages that are sent through the voice channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/create_voice_template.html](https://paws-r.github.io/docs/pinpoint/create_voice_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param VoiceTemplateRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_voice_template
pinpoint_create_voice_template <- function(TemplateName, VoiceTemplateRequest) {
  op <- new_operation(
    name = "CreateVoiceTemplate",
    http_method = "POST",
    http_path = "/v1/templates/{template-name}/voice",
    paginator = list()
  )
  input <- .pinpoint$create_voice_template_input(TemplateName = TemplateName, VoiceTemplateRequest = VoiceTemplateRequest)
  output <- .pinpoint$create_voice_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_voice_template <- pinpoint_create_voice_template

#' Disables the ADM channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the ADM channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_adm_channel.html](https://paws-r.github.io/docs/pinpoint/delete_adm_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_adm_channel
pinpoint_delete_adm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteAdmChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$delete_adm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_adm_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_adm_channel <- pinpoint_delete_adm_channel

#' Disables the APNs channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the APNs channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_apns_channel.html](https://paws-r.github.io/docs/pinpoint/delete_apns_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_channel
pinpoint_delete_apns_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_channel <- pinpoint_delete_apns_channel

#' Disables the APNs sandbox channel for an application and deletes any
#' existing settings for the channel
#'
#' @description
#' Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_apns_sandbox_channel.html](https://paws-r.github.io/docs/pinpoint/delete_apns_sandbox_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_sandbox_channel
pinpoint_delete_apns_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsSandboxChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_sandbox_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_sandbox_channel <- pinpoint_delete_apns_sandbox_channel

#' Disables the APNs VoIP channel for an application and deletes any
#' existing settings for the channel
#'
#' @description
#' Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_apns_voip_channel.html](https://paws-r.github.io/docs/pinpoint/delete_apns_voip_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_voip_channel
pinpoint_delete_apns_voip_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsVoipChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_voip_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_voip_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_voip_channel <- pinpoint_delete_apns_voip_channel

#' Disables the APNs VoIP sandbox channel for an application and deletes
#' any existing settings for the channel
#'
#' @description
#' Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_apns_voip_sandbox_channel.html](https://paws-r.github.io/docs/pinpoint/delete_apns_voip_sandbox_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_voip_sandbox_channel
pinpoint_delete_apns_voip_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsVoipSandboxChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_voip_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_voip_sandbox_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_voip_sandbox_channel <- pinpoint_delete_apns_voip_sandbox_channel

#' Deletes an application
#'
#' @description
#' Deletes an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_app.html](https://paws-r.github.io/docs/pinpoint/delete_app.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_app
pinpoint_delete_app <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_app_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_app_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_app <- pinpoint_delete_app

#' Disables the Baidu channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the Baidu channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_baidu_channel.html](https://paws-r.github.io/docs/pinpoint/delete_baidu_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_baidu_channel
pinpoint_delete_baidu_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteBaiduChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$delete_baidu_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_baidu_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_baidu_channel <- pinpoint_delete_baidu_channel

#' Deletes a campaign from an application
#'
#' @description
#' Deletes a campaign from an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_campaign.html](https://paws-r.github.io/docs/pinpoint/delete_campaign.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_campaign
pinpoint_delete_campaign <- function(ApplicationId, CampaignId) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId)
  output <- .pinpoint$delete_campaign_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_campaign <- pinpoint_delete_campaign

#' Disables the email channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the email channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_email_channel.html](https://paws-r.github.io/docs/pinpoint/delete_email_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_email_channel
pinpoint_delete_email_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteEmailChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$delete_email_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_email_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_email_channel <- pinpoint_delete_email_channel

#' Deletes a message template for messages that were sent through the email
#' channel
#'
#' @description
#' Deletes a message template for messages that were sent through the email channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_email_template.html](https://paws-r.github.io/docs/pinpoint/delete_email_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_email_template
pinpoint_delete_email_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "DeleteEmailTemplate",
    http_method = "DELETE",
    http_path = "/v1/templates/{template-name}/email",
    paginator = list()
  )
  input <- .pinpoint$delete_email_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$delete_email_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_email_template <- pinpoint_delete_email_template

#' Deletes an endpoint from an application
#'
#' @description
#' Deletes an endpoint from an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_endpoint.html](https://paws-r.github.io/docs/pinpoint/delete_endpoint.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_endpoint
pinpoint_delete_endpoint <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$delete_endpoint_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_endpoint <- pinpoint_delete_endpoint

#' Deletes the event stream for an application
#'
#' @description
#' Deletes the event stream for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_event_stream.html](https://paws-r.github.io/docs/pinpoint/delete_event_stream.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_event_stream
pinpoint_delete_event_stream <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteEventStream",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$delete_event_stream_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_event_stream_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_event_stream <- pinpoint_delete_event_stream

#' Disables the GCM channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the GCM channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_gcm_channel.html](https://paws-r.github.io/docs/pinpoint/delete_gcm_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_gcm_channel
pinpoint_delete_gcm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteGcmChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$delete_gcm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_gcm_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_gcm_channel <- pinpoint_delete_gcm_channel

#' Deletes a message template for messages sent using the in-app message
#' channel
#'
#' @description
#' Deletes a message template for messages sent using the in-app message channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_in_app_template.html](https://paws-r.github.io/docs/pinpoint/delete_in_app_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_in_app_template
pinpoint_delete_in_app_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "DeleteInAppTemplate",
    http_method = "DELETE",
    http_path = "/v1/templates/{template-name}/inapp",
    paginator = list()
  )
  input <- .pinpoint$delete_in_app_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$delete_in_app_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_in_app_template <- pinpoint_delete_in_app_template

#' Deletes a journey from an application
#'
#' @description
#' Deletes a journey from an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_journey.html](https://paws-r.github.io/docs/pinpoint/delete_journey.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_journey
pinpoint_delete_journey <- function(ApplicationId, JourneyId) {
  op <- new_operation(
    name = "DeleteJourney",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_journey_input(ApplicationId = ApplicationId, JourneyId = JourneyId)
  output <- .pinpoint$delete_journey_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_journey <- pinpoint_delete_journey

#' Deletes a message template for messages that were sent through a push
#' notification channel
#'
#' @description
#' Deletes a message template for messages that were sent through a push notification channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_push_template.html](https://paws-r.github.io/docs/pinpoint/delete_push_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_push_template
pinpoint_delete_push_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "DeletePushTemplate",
    http_method = "DELETE",
    http_path = "/v1/templates/{template-name}/push",
    paginator = list()
  )
  input <- .pinpoint$delete_push_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$delete_push_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_push_template <- pinpoint_delete_push_template

#' Deletes an Amazon Pinpoint configuration for a recommender model
#'
#' @description
#' Deletes an Amazon Pinpoint configuration for a recommender model.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_recommender_configuration.html](https://paws-r.github.io/docs/pinpoint/delete_recommender_configuration.html) for full documentation.
#'
#' @param RecommenderId &#91;required&#93; The unique identifier for the recommender model configuration. This
#' identifier is displayed as the **Recommender ID** on the Amazon Pinpoint
#' console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_recommender_configuration
pinpoint_delete_recommender_configuration <- function(RecommenderId) {
  op <- new_operation(
    name = "DeleteRecommenderConfiguration",
    http_method = "DELETE",
    http_path = "/v1/recommenders/{recommender-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_recommender_configuration_input(RecommenderId = RecommenderId)
  output <- .pinpoint$delete_recommender_configuration_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_recommender_configuration <- pinpoint_delete_recommender_configuration

#' Deletes a segment from an application
#'
#' @description
#' Deletes a segment from an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_segment.html](https://paws-r.github.io/docs/pinpoint/delete_segment.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_segment
pinpoint_delete_segment <- function(ApplicationId, SegmentId) {
  op <- new_operation(
    name = "DeleteSegment",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId)
  output <- .pinpoint$delete_segment_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_segment <- pinpoint_delete_segment

#' Disables the SMS channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the SMS channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_sms_channel.html](https://paws-r.github.io/docs/pinpoint/delete_sms_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_sms_channel
pinpoint_delete_sms_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteSmsChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$delete_sms_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_sms_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_sms_channel <- pinpoint_delete_sms_channel

#' Deletes a message template for messages that were sent through the SMS
#' channel
#'
#' @description
#' Deletes a message template for messages that were sent through the SMS channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_sms_template.html](https://paws-r.github.io/docs/pinpoint/delete_sms_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_sms_template
pinpoint_delete_sms_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "DeleteSmsTemplate",
    http_method = "DELETE",
    http_path = "/v1/templates/{template-name}/sms",
    paginator = list()
  )
  input <- .pinpoint$delete_sms_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$delete_sms_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_sms_template <- pinpoint_delete_sms_template

#' Deletes all the endpoints that are associated with a specific user ID
#'
#' @description
#' Deletes all the endpoints that are associated with a specific user ID.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_user_endpoints.html](https://paws-r.github.io/docs/pinpoint/delete_user_endpoints.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param UserId &#91;required&#93; The unique identifier for the user.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_user_endpoints
pinpoint_delete_user_endpoints <- function(ApplicationId, UserId) {
  op <- new_operation(
    name = "DeleteUserEndpoints",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/users/{user-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_user_endpoints_input(ApplicationId = ApplicationId, UserId = UserId)
  output <- .pinpoint$delete_user_endpoints_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_user_endpoints <- pinpoint_delete_user_endpoints

#' Disables the voice channel for an application and deletes any existing
#' settings for the channel
#'
#' @description
#' Disables the voice channel for an application and deletes any existing settings for the channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_voice_channel.html](https://paws-r.github.io/docs/pinpoint/delete_voice_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_voice_channel
pinpoint_delete_voice_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteVoiceChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$delete_voice_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_voice_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_voice_channel <- pinpoint_delete_voice_channel

#' Deletes a message template for messages that were sent through the voice
#' channel
#'
#' @description
#' Deletes a message template for messages that were sent through the voice channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/delete_voice_template.html](https://paws-r.github.io/docs/pinpoint/delete_voice_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_voice_template
pinpoint_delete_voice_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "DeleteVoiceTemplate",
    http_method = "DELETE",
    http_path = "/v1/templates/{template-name}/voice",
    paginator = list()
  )
  input <- .pinpoint$delete_voice_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$delete_voice_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_voice_template <- pinpoint_delete_voice_template

#' Retrieves information about the status and settings of the ADM channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the ADM channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_adm_channel.html](https://paws-r.github.io/docs/pinpoint/get_adm_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_adm_channel
pinpoint_get_adm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetAdmChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$get_adm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_adm_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_adm_channel <- pinpoint_get_adm_channel

#' Retrieves information about the status and settings of the APNs channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the APNs channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_apns_channel.html](https://paws-r.github.io/docs/pinpoint/get_apns_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_channel
pinpoint_get_apns_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$get_apns_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_channel <- pinpoint_get_apns_channel

#' Retrieves information about the status and settings of the APNs sandbox
#' channel for an application
#'
#' @description
#' Retrieves information about the status and settings of the APNs sandbox channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_apns_sandbox_channel.html](https://paws-r.github.io/docs/pinpoint/get_apns_sandbox_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_sandbox_channel
pinpoint_get_apns_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsSandboxChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$get_apns_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_sandbox_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_sandbox_channel <- pinpoint_get_apns_sandbox_channel

#' Retrieves information about the status and settings of the APNs VoIP
#' channel for an application
#'
#' @description
#' Retrieves information about the status and settings of the APNs VoIP channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_apns_voip_channel.html](https://paws-r.github.io/docs/pinpoint/get_apns_voip_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_voip_channel
pinpoint_get_apns_voip_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsVoipChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$get_apns_voip_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_voip_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_voip_channel <- pinpoint_get_apns_voip_channel

#' Retrieves information about the status and settings of the APNs VoIP
#' sandbox channel for an application
#'
#' @description
#' Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_apns_voip_sandbox_channel.html](https://paws-r.github.io/docs/pinpoint/get_apns_voip_sandbox_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_voip_sandbox_channel
pinpoint_get_apns_voip_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsVoipSandboxChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$get_apns_voip_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_voip_sandbox_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_voip_sandbox_channel <- pinpoint_get_apns_voip_sandbox_channel

#' Retrieves information about an application
#'
#' @description
#' Retrieves information about an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_app.html](https://paws-r.github.io/docs/pinpoint/get_app.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_app
pinpoint_get_app <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApp",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}",
    paginator = list()
  )
  input <- .pinpoint$get_app_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_app_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_app <- pinpoint_get_app

#' Retrieves (queries) pre-aggregated data for a standard metric that
#' applies to an application
#'
#' @description
#' Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_application_date_range_kpi.html](https://paws-r.github.io/docs/pinpoint/get_application_date_range_kpi.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndTime The last date and time to retrieve data for, as part of an inclusive
#' date range that filters the query results. This value should be in
#' extended ISO 8601 format and use Coordinated Universal Time (UTC), for
#' example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
#' @param KpiName &#91;required&#93; The name of the metric, also referred to as a *key performance indicator
#' (KPI)*, to retrieve data for. This value describes the associated metric
#' and consists of two or more terms, which are comprised of lowercase
#' alphanumeric characters, separated by a hyphen. Examples are
#' email-open-rate and successful-delivery-rate. For a list of valid
#' values, see the [Amazon Pinpoint Developer
#' Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param StartTime The first date and time to retrieve data for, as part of an inclusive
#' date range that filters the query results. This value should be in
#' extended ISO 8601 format and use Coordinated Universal Time (UTC), for
#' example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value
#' should also be fewer than 90 days from the current day.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_application_date_range_kpi
pinpoint_get_application_date_range_kpi <- function(ApplicationId, EndTime = NULL, KpiName, NextToken = NULL, PageSize = NULL, StartTime = NULL) {
  op <- new_operation(
    name = "GetApplicationDateRangeKpi",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/kpis/daterange/{kpi-name}",
    paginator = list()
  )
  input <- .pinpoint$get_application_date_range_kpi_input(ApplicationId = ApplicationId, EndTime = EndTime, KpiName = KpiName, NextToken = NextToken, PageSize = PageSize, StartTime = StartTime)
  output <- .pinpoint$get_application_date_range_kpi_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_application_date_range_kpi <- pinpoint_get_application_date_range_kpi

#' Retrieves information about the settings for an application
#'
#' @description
#' Retrieves information about the settings for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_application_settings.html](https://paws-r.github.io/docs/pinpoint/get_application_settings.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_application_settings
pinpoint_get_application_settings <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApplicationSettings",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/settings",
    paginator = list()
  )
  input <- .pinpoint$get_application_settings_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_application_settings_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_application_settings <- pinpoint_get_application_settings

#' Retrieves information about all the applications that are associated
#' with your Amazon Pinpoint account
#'
#' @description
#' Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_apps.html](https://paws-r.github.io/docs/pinpoint/get_apps.html) for full documentation.
#'
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apps
pinpoint_get_apps <- function(PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetApps",
    http_method = "GET",
    http_path = "/v1/apps",
    paginator = list()
  )
  input <- .pinpoint$get_apps_input(PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_apps_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apps <- pinpoint_get_apps

#' Retrieves information about the status and settings of the Baidu channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the Baidu channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_baidu_channel.html](https://paws-r.github.io/docs/pinpoint/get_baidu_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_baidu_channel
pinpoint_get_baidu_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetBaiduChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$get_baidu_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_baidu_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_baidu_channel <- pinpoint_get_baidu_channel

#' Retrieves information about the status, configuration, and other
#' settings for a campaign
#'
#' @description
#' Retrieves information about the status, configuration, and other settings for a campaign.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_campaign.html](https://paws-r.github.io/docs/pinpoint/get_campaign.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign
pinpoint_get_campaign <- function(ApplicationId, CampaignId) {
  op <- new_operation(
    name = "GetCampaign",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId)
  output <- .pinpoint$get_campaign_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign <- pinpoint_get_campaign

#' Retrieves information about all the activities for a campaign
#'
#' @description
#' Retrieves information about all the activities for a campaign.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_campaign_activities.html](https://paws-r.github.io/docs/pinpoint/get_campaign_activities.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_activities
pinpoint_get_campaign_activities <- function(ApplicationId, CampaignId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaignActivities",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_activities_input(ApplicationId = ApplicationId, CampaignId = CampaignId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaign_activities_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_activities <- pinpoint_get_campaign_activities

#' Retrieves (queries) pre-aggregated data for a standard metric that
#' applies to a campaign
#'
#' @description
#' Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_campaign_date_range_kpi.html](https://paws-r.github.io/docs/pinpoint/get_campaign_date_range_kpi.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param EndTime The last date and time to retrieve data for, as part of an inclusive
#' date range that filters the query results. This value should be in
#' extended ISO 8601 format and use Coordinated Universal Time (UTC), for
#' example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
#' @param KpiName &#91;required&#93; The name of the metric, also referred to as a *key performance indicator
#' (KPI)*, to retrieve data for. This value describes the associated metric
#' and consists of two or more terms, which are comprised of lowercase
#' alphanumeric characters, separated by a hyphen. Examples are
#' email-open-rate and successful-delivery-rate. For a list of valid
#' values, see the [Amazon Pinpoint Developer
#' Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param StartTime The first date and time to retrieve data for, as part of an inclusive
#' date range that filters the query results. This value should be in
#' extended ISO 8601 format and use Coordinated Universal Time (UTC), for
#' example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value
#' should also be fewer than 90 days from the current day.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_date_range_kpi
pinpoint_get_campaign_date_range_kpi <- function(ApplicationId, CampaignId, EndTime = NULL, KpiName, NextToken = NULL, PageSize = NULL, StartTime = NULL) {
  op <- new_operation(
    name = "GetCampaignDateRangeKpi",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/kpis/daterange/{kpi-name}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_date_range_kpi_input(ApplicationId = ApplicationId, CampaignId = CampaignId, EndTime = EndTime, KpiName = KpiName, NextToken = NextToken, PageSize = PageSize, StartTime = StartTime)
  output <- .pinpoint$get_campaign_date_range_kpi_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_date_range_kpi <- pinpoint_get_campaign_date_range_kpi

#' Retrieves information about the status, configuration, and other
#' settings for a specific version of a campaign
#'
#' @description
#' Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_campaign_version.html](https://paws-r.github.io/docs/pinpoint/get_campaign_version.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param Version &#91;required&#93; The unique version number (Version property) for the campaign version.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_version
pinpoint_get_campaign_version <- function(ApplicationId, CampaignId, Version) {
  op <- new_operation(
    name = "GetCampaignVersion",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_version_input(ApplicationId = ApplicationId, CampaignId = CampaignId, Version = Version)
  output <- .pinpoint$get_campaign_version_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_version <- pinpoint_get_campaign_version

#' Retrieves information about the status, configuration, and other
#' settings for all versions of a campaign
#'
#' @description
#' Retrieves information about the status, configuration, and other settings for all versions of a campaign.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_campaign_versions.html](https://paws-r.github.io/docs/pinpoint/get_campaign_versions.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_versions
pinpoint_get_campaign_versions <- function(ApplicationId, CampaignId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaignVersions",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_versions_input(ApplicationId = ApplicationId, CampaignId = CampaignId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaign_versions_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_versions <- pinpoint_get_campaign_versions

#' Retrieves information about the status, configuration, and other
#' settings for all the campaigns that are associated with an application
#'
#' @description
#' Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_campaigns.html](https://paws-r.github.io/docs/pinpoint/get_campaigns.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaigns
pinpoint_get_campaigns <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaigns",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns",
    paginator = list()
  )
  input <- .pinpoint$get_campaigns_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaigns_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaigns <- pinpoint_get_campaigns

#' Retrieves information about the history and status of each channel for
#' an application
#'
#' @description
#' Retrieves information about the history and status of each channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_channels.html](https://paws-r.github.io/docs/pinpoint/get_channels.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_channels
pinpoint_get_channels <- function(ApplicationId) {
  op <- new_operation(
    name = "GetChannels",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels",
    paginator = list()
  )
  input <- .pinpoint$get_channels_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_channels_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_channels <- pinpoint_get_channels

#' Retrieves information about the status and settings of the email channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the email channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_email_channel.html](https://paws-r.github.io/docs/pinpoint/get_email_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_email_channel
pinpoint_get_email_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetEmailChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$get_email_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_email_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_email_channel <- pinpoint_get_email_channel

#' Retrieves the content and settings of a message template for messages
#' that are sent through the email channel
#'
#' @description
#' Retrieves the content and settings of a message template for messages that are sent through the email channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_email_template.html](https://paws-r.github.io/docs/pinpoint/get_email_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_email_template
pinpoint_get_email_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "GetEmailTemplate",
    http_method = "GET",
    http_path = "/v1/templates/{template-name}/email",
    paginator = list()
  )
  input <- .pinpoint$get_email_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$get_email_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_email_template <- pinpoint_get_email_template

#' Retrieves information about the settings and attributes of a specific
#' endpoint for an application
#'
#' @description
#' Retrieves information about the settings and attributes of a specific endpoint for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_endpoint.html](https://paws-r.github.io/docs/pinpoint/get_endpoint.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_endpoint
pinpoint_get_endpoint <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "GetEndpoint",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$get_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$get_endpoint_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_endpoint <- pinpoint_get_endpoint

#' Retrieves information about the event stream settings for an application
#'
#' @description
#' Retrieves information about the event stream settings for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_event_stream.html](https://paws-r.github.io/docs/pinpoint/get_event_stream.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_event_stream
pinpoint_get_event_stream <- function(ApplicationId) {
  op <- new_operation(
    name = "GetEventStream",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$get_event_stream_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_event_stream_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_event_stream <- pinpoint_get_event_stream

#' Retrieves information about the status and settings of a specific export
#' job for an application
#'
#' @description
#' Retrieves information about the status and settings of a specific export job for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_export_job.html](https://paws-r.github.io/docs/pinpoint/get_export_job.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JobId &#91;required&#93; The unique identifier for the job.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_export_job
pinpoint_get_export_job <- function(ApplicationId, JobId) {
  op <- new_operation(
    name = "GetExportJob",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/export/{job-id}",
    paginator = list()
  )
  input <- .pinpoint$get_export_job_input(ApplicationId = ApplicationId, JobId = JobId)
  output <- .pinpoint$get_export_job_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_export_job <- pinpoint_get_export_job

#' Retrieves information about the status and settings of all the export
#' jobs for an application
#'
#' @description
#' Retrieves information about the status and settings of all the export jobs for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_export_jobs.html](https://paws-r.github.io/docs/pinpoint/get_export_jobs.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_export_jobs
pinpoint_get_export_jobs <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetExportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$get_export_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_export_jobs_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_export_jobs <- pinpoint_get_export_jobs

#' Retrieves information about the status and settings of the GCM channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the GCM channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_gcm_channel.html](https://paws-r.github.io/docs/pinpoint/get_gcm_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_gcm_channel
pinpoint_get_gcm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetGcmChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$get_gcm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_gcm_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_gcm_channel <- pinpoint_get_gcm_channel

#' Retrieves information about the status and settings of a specific import
#' job for an application
#'
#' @description
#' Retrieves information about the status and settings of a specific import job for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_import_job.html](https://paws-r.github.io/docs/pinpoint/get_import_job.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JobId &#91;required&#93; The unique identifier for the job.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_import_job
pinpoint_get_import_job <- function(ApplicationId, JobId) {
  op <- new_operation(
    name = "GetImportJob",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/import/{job-id}",
    paginator = list()
  )
  input <- .pinpoint$get_import_job_input(ApplicationId = ApplicationId, JobId = JobId)
  output <- .pinpoint$get_import_job_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_import_job <- pinpoint_get_import_job

#' Retrieves information about the status and settings of all the import
#' jobs for an application
#'
#' @description
#' Retrieves information about the status and settings of all the import jobs for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_import_jobs.html](https://paws-r.github.io/docs/pinpoint/get_import_jobs.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_import_jobs
pinpoint_get_import_jobs <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetImportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$get_import_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_import_jobs_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_import_jobs <- pinpoint_get_import_jobs

#' Retrieves the in-app messages targeted for the provided endpoint ID
#'
#' @description
#' Retrieves the in-app messages targeted for the provided endpoint ID.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_in_app_messages.html](https://paws-r.github.io/docs/pinpoint/get_in_app_messages.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_in_app_messages
pinpoint_get_in_app_messages <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "GetInAppMessages",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}/inappmessages",
    paginator = list()
  )
  input <- .pinpoint$get_in_app_messages_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$get_in_app_messages_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_in_app_messages <- pinpoint_get_in_app_messages

#' Retrieves the content and settings of a message template for messages
#' sent through the in-app channel
#'
#' @description
#' Retrieves the content and settings of a message template for messages sent through the in-app channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_in_app_template.html](https://paws-r.github.io/docs/pinpoint/get_in_app_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_in_app_template
pinpoint_get_in_app_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "GetInAppTemplate",
    http_method = "GET",
    http_path = "/v1/templates/{template-name}/inapp",
    paginator = list()
  )
  input <- .pinpoint$get_in_app_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$get_in_app_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_in_app_template <- pinpoint_get_in_app_template

#' Retrieves information about the status, configuration, and other
#' settings for a journey
#'
#' @description
#' Retrieves information about the status, configuration, and other settings for a journey.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_journey.html](https://paws-r.github.io/docs/pinpoint/get_journey.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_journey
pinpoint_get_journey <- function(ApplicationId, JourneyId) {
  op <- new_operation(
    name = "GetJourney",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}",
    paginator = list()
  )
  input <- .pinpoint$get_journey_input(ApplicationId = ApplicationId, JourneyId = JourneyId)
  output <- .pinpoint$get_journey_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_journey <- pinpoint_get_journey

#' Retrieves (queries) pre-aggregated data for a standard engagement metric
#' that applies to a journey
#'
#' @description
#' Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_journey_date_range_kpi.html](https://paws-r.github.io/docs/pinpoint/get_journey_date_range_kpi.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndTime The last date and time to retrieve data for, as part of an inclusive
#' date range that filters the query results. This value should be in
#' extended ISO 8601 format and use Coordinated Universal Time (UTC), for
#' example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#' @param KpiName &#91;required&#93; The name of the metric, also referred to as a *key performance indicator
#' (KPI)*, to retrieve data for. This value describes the associated metric
#' and consists of two or more terms, which are comprised of lowercase
#' alphanumeric characters, separated by a hyphen. Examples are
#' email-open-rate and successful-delivery-rate. For a list of valid
#' values, see the [Amazon Pinpoint Developer
#' Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param StartTime The first date and time to retrieve data for, as part of an inclusive
#' date range that filters the query results. This value should be in
#' extended ISO 8601 format and use Coordinated Universal Time (UTC), for
#' example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value
#' should also be fewer than 90 days from the current day.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_journey_date_range_kpi
pinpoint_get_journey_date_range_kpi <- function(ApplicationId, EndTime = NULL, JourneyId, KpiName, NextToken = NULL, PageSize = NULL, StartTime = NULL) {
  op <- new_operation(
    name = "GetJourneyDateRangeKpi",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}/kpis/daterange/{kpi-name}",
    paginator = list()
  )
  input <- .pinpoint$get_journey_date_range_kpi_input(ApplicationId = ApplicationId, EndTime = EndTime, JourneyId = JourneyId, KpiName = KpiName, NextToken = NextToken, PageSize = PageSize, StartTime = StartTime)
  output <- .pinpoint$get_journey_date_range_kpi_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_journey_date_range_kpi <- pinpoint_get_journey_date_range_kpi

#' Retrieves (queries) pre-aggregated data for a standard execution metric
#' that applies to a journey activity
#'
#' @description
#' Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_journey_execution_activity_metrics.html](https://paws-r.github.io/docs/pinpoint/get_journey_execution_activity_metrics.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JourneyActivityId &#91;required&#93; The unique identifier for the journey activity.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_journey_execution_activity_metrics
pinpoint_get_journey_execution_activity_metrics <- function(ApplicationId, JourneyActivityId, JourneyId, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "GetJourneyExecutionActivityMetrics",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}/activities/{journey-activity-id}/execution-metrics",
    paginator = list()
  )
  input <- .pinpoint$get_journey_execution_activity_metrics_input(ApplicationId = ApplicationId, JourneyActivityId = JourneyActivityId, JourneyId = JourneyId, NextToken = NextToken, PageSize = PageSize)
  output <- .pinpoint$get_journey_execution_activity_metrics_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_journey_execution_activity_metrics <- pinpoint_get_journey_execution_activity_metrics

#' Retrieves (queries) pre-aggregated data for a standard execution metric
#' that applies to a journey
#'
#' @description
#' Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_journey_execution_metrics.html](https://paws-r.github.io/docs/pinpoint/get_journey_execution_metrics.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_journey_execution_metrics
pinpoint_get_journey_execution_metrics <- function(ApplicationId, JourneyId, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "GetJourneyExecutionMetrics",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}/execution-metrics",
    paginator = list()
  )
  input <- .pinpoint$get_journey_execution_metrics_input(ApplicationId = ApplicationId, JourneyId = JourneyId, NextToken = NextToken, PageSize = PageSize)
  output <- .pinpoint$get_journey_execution_metrics_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_journey_execution_metrics <- pinpoint_get_journey_execution_metrics

#' Retrieves the content and settings of a message template for messages
#' that are sent through a push notification channel
#'
#' @description
#' Retrieves the content and settings of a message template for messages that are sent through a push notification channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_push_template.html](https://paws-r.github.io/docs/pinpoint/get_push_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_push_template
pinpoint_get_push_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "GetPushTemplate",
    http_method = "GET",
    http_path = "/v1/templates/{template-name}/push",
    paginator = list()
  )
  input <- .pinpoint$get_push_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$get_push_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_push_template <- pinpoint_get_push_template

#' Retrieves information about an Amazon Pinpoint configuration for a
#' recommender model
#'
#' @description
#' Retrieves information about an Amazon Pinpoint configuration for a recommender model.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_recommender_configuration.html](https://paws-r.github.io/docs/pinpoint/get_recommender_configuration.html) for full documentation.
#'
#' @param RecommenderId &#91;required&#93; The unique identifier for the recommender model configuration. This
#' identifier is displayed as the **Recommender ID** on the Amazon Pinpoint
#' console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_recommender_configuration
pinpoint_get_recommender_configuration <- function(RecommenderId) {
  op <- new_operation(
    name = "GetRecommenderConfiguration",
    http_method = "GET",
    http_path = "/v1/recommenders/{recommender-id}",
    paginator = list()
  )
  input <- .pinpoint$get_recommender_configuration_input(RecommenderId = RecommenderId)
  output <- .pinpoint$get_recommender_configuration_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_recommender_configuration <- pinpoint_get_recommender_configuration

#' Retrieves information about all the recommender model configurations
#' that are associated with your Amazon Pinpoint account
#'
#' @description
#' Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_recommender_configurations.html](https://paws-r.github.io/docs/pinpoint/get_recommender_configurations.html) for full documentation.
#'
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_recommender_configurations
pinpoint_get_recommender_configurations <- function(PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetRecommenderConfigurations",
    http_method = "GET",
    http_path = "/v1/recommenders",
    paginator = list()
  )
  input <- .pinpoint$get_recommender_configurations_input(PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_recommender_configurations_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_recommender_configurations <- pinpoint_get_recommender_configurations

#' Retrieves information about the configuration, dimension, and other
#' settings for a specific segment that's associated with an application
#'
#' @description
#' Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_segment.html](https://paws-r.github.io/docs/pinpoint/get_segment.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment
pinpoint_get_segment <- function(ApplicationId, SegmentId) {
  op <- new_operation(
    name = "GetSegment",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$get_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId)
  output <- .pinpoint$get_segment_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment <- pinpoint_get_segment

#' Retrieves information about the status and settings of the export jobs
#' for a segment
#'
#' @description
#' Retrieves information about the status and settings of the export jobs for a segment.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_segment_export_jobs.html](https://paws-r.github.io/docs/pinpoint/get_segment_export_jobs.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_export_jobs
pinpoint_get_segment_export_jobs <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentExportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$get_segment_export_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_export_jobs_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_export_jobs <- pinpoint_get_segment_export_jobs

#' Retrieves information about the status and settings of the import jobs
#' for a segment
#'
#' @description
#' Retrieves information about the status and settings of the import jobs for a segment.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_segment_import_jobs.html](https://paws-r.github.io/docs/pinpoint/get_segment_import_jobs.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_import_jobs
pinpoint_get_segment_import_jobs <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentImportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$get_segment_import_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_import_jobs_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_import_jobs <- pinpoint_get_segment_import_jobs

#' Retrieves information about the configuration, dimension, and other
#' settings for a specific version of a segment that's associated with an
#' application
#'
#' @description
#' Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_segment_version.html](https://paws-r.github.io/docs/pinpoint/get_segment_version.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Version &#91;required&#93; The unique version number (Version property) for the campaign version.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_version
pinpoint_get_segment_version <- function(ApplicationId, SegmentId, Version) {
  op <- new_operation(
    name = "GetSegmentVersion",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
    paginator = list()
  )
  input <- .pinpoint$get_segment_version_input(ApplicationId = ApplicationId, SegmentId = SegmentId, Version = Version)
  output <- .pinpoint$get_segment_version_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_version <- pinpoint_get_segment_version

#' Retrieves information about the configuration, dimension, and other
#' settings for all the versions of a specific segment that's associated
#' with an application
#'
#' @description
#' Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_segment_versions.html](https://paws-r.github.io/docs/pinpoint/get_segment_versions.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_versions
pinpoint_get_segment_versions <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentVersions",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/versions",
    paginator = list()
  )
  input <- .pinpoint$get_segment_versions_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_versions_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_versions <- pinpoint_get_segment_versions

#' Retrieves information about the configuration, dimension, and other
#' settings for all the segments that are associated with an application
#'
#' @description
#' Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_segments.html](https://paws-r.github.io/docs/pinpoint/get_segments.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segments
pinpoint_get_segments <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetSegments",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments",
    paginator = list()
  )
  input <- .pinpoint$get_segments_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_segments_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segments <- pinpoint_get_segments

#' Retrieves information about the status and settings of the SMS channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the SMS channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_sms_channel.html](https://paws-r.github.io/docs/pinpoint/get_sms_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_sms_channel
pinpoint_get_sms_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetSmsChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$get_sms_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_sms_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_sms_channel <- pinpoint_get_sms_channel

#' Retrieves the content and settings of a message template for messages
#' that are sent through the SMS channel
#'
#' @description
#' Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_sms_template.html](https://paws-r.github.io/docs/pinpoint/get_sms_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_sms_template
pinpoint_get_sms_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "GetSmsTemplate",
    http_method = "GET",
    http_path = "/v1/templates/{template-name}/sms",
    paginator = list()
  )
  input <- .pinpoint$get_sms_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$get_sms_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_sms_template <- pinpoint_get_sms_template

#' Retrieves information about all the endpoints that are associated with a
#' specific user ID
#'
#' @description
#' Retrieves information about all the endpoints that are associated with a specific user ID.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_user_endpoints.html](https://paws-r.github.io/docs/pinpoint/get_user_endpoints.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param UserId &#91;required&#93; The unique identifier for the user.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_user_endpoints
pinpoint_get_user_endpoints <- function(ApplicationId, UserId) {
  op <- new_operation(
    name = "GetUserEndpoints",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/users/{user-id}",
    paginator = list()
  )
  input <- .pinpoint$get_user_endpoints_input(ApplicationId = ApplicationId, UserId = UserId)
  output <- .pinpoint$get_user_endpoints_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_user_endpoints <- pinpoint_get_user_endpoints

#' Retrieves information about the status and settings of the voice channel
#' for an application
#'
#' @description
#' Retrieves information about the status and settings of the voice channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_voice_channel.html](https://paws-r.github.io/docs/pinpoint/get_voice_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_voice_channel
pinpoint_get_voice_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetVoiceChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$get_voice_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_voice_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_voice_channel <- pinpoint_get_voice_channel

#' Retrieves the content and settings of a message template for messages
#' that are sent through the voice channel
#'
#' @description
#' Retrieves the content and settings of a message template for messages that are sent through the voice channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/get_voice_template.html](https://paws-r.github.io/docs/pinpoint/get_voice_template.html) for full documentation.
#'
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_voice_template
pinpoint_get_voice_template <- function(TemplateName, Version = NULL) {
  op <- new_operation(
    name = "GetVoiceTemplate",
    http_method = "GET",
    http_path = "/v1/templates/{template-name}/voice",
    paginator = list()
  )
  input <- .pinpoint$get_voice_template_input(TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$get_voice_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_voice_template <- pinpoint_get_voice_template

#' Retrieves information about the status, configuration, and other
#' settings for all the journeys that are associated with an application
#'
#' @description
#' Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/list_journeys.html](https://paws-r.github.io/docs/pinpoint/list_journeys.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname pinpoint_list_journeys
pinpoint_list_journeys <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "ListJourneys",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/journeys",
    paginator = list()
  )
  input <- .pinpoint$list_journeys_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$list_journeys_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$list_journeys <- pinpoint_list_journeys

#' Retrieves all the tags (keys and values) that are associated with an
#' application, campaign, message template, or segment
#'
#' @description
#' Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.
#'
#' See [https://paws-r.github.io/docs/pinpoint/list_tags_for_resource.html](https://paws-r.github.io/docs/pinpoint/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname pinpoint_list_tags_for_resource
pinpoint_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpoint$list_tags_for_resource_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$list_tags_for_resource <- pinpoint_list_tags_for_resource

#' Retrieves information about all the versions of a specific message
#' template
#'
#' @description
#' Retrieves information about all the versions of a specific message template.
#'
#' See [https://paws-r.github.io/docs/pinpoint/list_template_versions.html](https://paws-r.github.io/docs/pinpoint/list_template_versions.html) for full documentation.
#'
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param TemplateType &#91;required&#93; The type of channel that the message template is designed for. Valid
#' values are: EMAIL, PUSH, SMS, and VOICE.
#'
#' @keywords internal
#'
#' @rdname pinpoint_list_template_versions
pinpoint_list_template_versions <- function(NextToken = NULL, PageSize = NULL, TemplateName, TemplateType) {
  op <- new_operation(
    name = "ListTemplateVersions",
    http_method = "GET",
    http_path = "/v1/templates/{template-name}/{template-type}/versions",
    paginator = list()
  )
  input <- .pinpoint$list_template_versions_input(NextToken = NextToken, PageSize = PageSize, TemplateName = TemplateName, TemplateType = TemplateType)
  output <- .pinpoint$list_template_versions_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$list_template_versions <- pinpoint_list_template_versions

#' Retrieves information about all the message templates that are
#' associated with your Amazon Pinpoint account
#'
#' @description
#' Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
#'
#' See [https://paws-r.github.io/docs/pinpoint/list_templates.html](https://paws-r.github.io/docs/pinpoint/list_templates.html) for full documentation.
#'
#' @param NextToken The string that specifies which page of results to return in a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param PageSize The maximum number of items to include in each page of a paginated
#' response. This parameter is not supported for application, campaign, and
#' journey metrics.
#' @param Prefix The substring to match in the names of the message templates to include
#' in the results. If you specify this value, Amazon Pinpoint returns only
#' those templates whose names begin with the value that you specify.
#' @param TemplateType The type of message template to include in the results. Valid values
#' are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in
#' the results, don't include this parameter in your request.
#'
#' @keywords internal
#'
#' @rdname pinpoint_list_templates
pinpoint_list_templates <- function(NextToken = NULL, PageSize = NULL, Prefix = NULL, TemplateType = NULL) {
  op <- new_operation(
    name = "ListTemplates",
    http_method = "GET",
    http_path = "/v1/templates",
    paginator = list()
  )
  input <- .pinpoint$list_templates_input(NextToken = NextToken, PageSize = PageSize, Prefix = Prefix, TemplateType = TemplateType)
  output <- .pinpoint$list_templates_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$list_templates <- pinpoint_list_templates

#' Retrieves information about a phone number
#'
#' @description
#' Retrieves information about a phone number.
#'
#' See [https://paws-r.github.io/docs/pinpoint/phone_number_validate.html](https://paws-r.github.io/docs/pinpoint/phone_number_validate.html) for full documentation.
#'
#' @param NumberValidateRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_phone_number_validate
pinpoint_phone_number_validate <- function(NumberValidateRequest) {
  op <- new_operation(
    name = "PhoneNumberValidate",
    http_method = "POST",
    http_path = "/v1/phone/number/validate",
    paginator = list()
  )
  input <- .pinpoint$phone_number_validate_input(NumberValidateRequest = NumberValidateRequest)
  output <- .pinpoint$phone_number_validate_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$phone_number_validate <- pinpoint_phone_number_validate

#' Creates a new event stream for an application or updates the settings of
#' an existing event stream for an application
#'
#' @description
#' Creates a new event stream for an application or updates the settings of an existing event stream for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/put_event_stream.html](https://paws-r.github.io/docs/pinpoint/put_event_stream.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteEventStream &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_put_event_stream
pinpoint_put_event_stream <- function(ApplicationId, WriteEventStream) {
  op <- new_operation(
    name = "PutEventStream",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$put_event_stream_input(ApplicationId = ApplicationId, WriteEventStream = WriteEventStream)
  output <- .pinpoint$put_event_stream_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$put_event_stream <- pinpoint_put_event_stream

#' Creates a new event to record for endpoints, or creates or updates
#' endpoint data that existing events are associated with
#'
#' @description
#' Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.
#'
#' See [https://paws-r.github.io/docs/pinpoint/put_events.html](https://paws-r.github.io/docs/pinpoint/put_events.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EventsRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_put_events
pinpoint_put_events <- function(ApplicationId, EventsRequest) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/events",
    paginator = list()
  )
  input <- .pinpoint$put_events_input(ApplicationId = ApplicationId, EventsRequest = EventsRequest)
  output <- .pinpoint$put_events_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$put_events <- pinpoint_put_events

#' Removes one or more attributes, of the same attribute type, from all the
#' endpoints that are associated with an application
#'
#' @description
#' Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/remove_attributes.html](https://paws-r.github.io/docs/pinpoint/remove_attributes.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param AttributeType &#91;required&#93; The type of attribute or attributes to remove. Valid values are:
#' 
#' -   endpoint-custom-attributes - Custom attributes that describe
#'     endpoints, such as the date when an associated user opted in or out
#'     of receiving communications from you through a specific type of
#'     channel.
#' 
#' -   endpoint-metric-attributes - Custom metrics that your app reports to
#'     Amazon Pinpoint for endpoints, such as the number of app sessions or
#'     the number of items left in a cart.
#' 
#' -   endpoint-user-attributes - Custom attributes that describe users,
#'     such as first name, last name, and age.
#' @param UpdateAttributesRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_remove_attributes
pinpoint_remove_attributes <- function(ApplicationId, AttributeType, UpdateAttributesRequest) {
  op <- new_operation(
    name = "RemoveAttributes",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/attributes/{attribute-type}",
    paginator = list()
  )
  input <- .pinpoint$remove_attributes_input(ApplicationId = ApplicationId, AttributeType = AttributeType, UpdateAttributesRequest = UpdateAttributesRequest)
  output <- .pinpoint$remove_attributes_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$remove_attributes <- pinpoint_remove_attributes

#' Creates and sends a direct message
#'
#' @description
#' Creates and sends a direct message.
#'
#' See [https://paws-r.github.io/docs/pinpoint/send_messages.html](https://paws-r.github.io/docs/pinpoint/send_messages.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param MessageRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_messages
pinpoint_send_messages <- function(ApplicationId, MessageRequest) {
  op <- new_operation(
    name = "SendMessages",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/messages",
    paginator = list()
  )
  input <- .pinpoint$send_messages_input(ApplicationId = ApplicationId, MessageRequest = MessageRequest)
  output <- .pinpoint$send_messages_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_messages <- pinpoint_send_messages

#' Send an OTP message
#'
#' @description
#' Send an OTP message
#'
#' See [https://paws-r.github.io/docs/pinpoint/send_otp_message.html](https://paws-r.github.io/docs/pinpoint/send_otp_message.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SendOTPMessageRequestParameters &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_otp_message
pinpoint_send_otp_message <- function(ApplicationId, SendOTPMessageRequestParameters) {
  op <- new_operation(
    name = "SendOTPMessage",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/otp",
    paginator = list()
  )
  input <- .pinpoint$send_otp_message_input(ApplicationId = ApplicationId, SendOTPMessageRequestParameters = SendOTPMessageRequestParameters)
  output <- .pinpoint$send_otp_message_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_otp_message <- pinpoint_send_otp_message

#' Creates and sends a message to a list of users
#'
#' @description
#' Creates and sends a message to a list of users.
#'
#' See [https://paws-r.github.io/docs/pinpoint/send_users_messages.html](https://paws-r.github.io/docs/pinpoint/send_users_messages.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SendUsersMessageRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_users_messages
pinpoint_send_users_messages <- function(ApplicationId, SendUsersMessageRequest) {
  op <- new_operation(
    name = "SendUsersMessages",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/users-messages",
    paginator = list()
  )
  input <- .pinpoint$send_users_messages_input(ApplicationId = ApplicationId, SendUsersMessageRequest = SendUsersMessageRequest)
  output <- .pinpoint$send_users_messages_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_users_messages <- pinpoint_send_users_messages

#' Adds one or more tags (keys and values) to an application, campaign,
#' message template, or segment
#'
#' @description
#' Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
#'
#' See [https://paws-r.github.io/docs/pinpoint/tag_resource.html](https://paws-r.github.io/docs/pinpoint/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagsModel &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_tag_resource
pinpoint_tag_resource <- function(ResourceArn, TagsModel) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$tag_resource_input(ResourceArn = ResourceArn, TagsModel = TagsModel)
  output <- .pinpoint$tag_resource_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$tag_resource <- pinpoint_tag_resource

#' Removes one or more tags (keys and values) from an application,
#' campaign, message template, or segment
#'
#' @description
#' Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
#'
#' See [https://paws-r.github.io/docs/pinpoint/untag_resource.html](https://paws-r.github.io/docs/pinpoint/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; The key of the tag to remove from the resource. To remove multiple tags,
#' append the tagKeys parameter and argument for each additional tag to
#' remove, separated by an ampersand (&).
#'
#' @keywords internal
#'
#' @rdname pinpoint_untag_resource
pinpoint_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpoint$untag_resource_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$untag_resource <- pinpoint_untag_resource

#' Enables the ADM channel for an application or updates the status and
#' settings of the ADM channel for an application
#'
#' @description
#' Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_adm_channel.html](https://paws-r.github.io/docs/pinpoint/update_adm_channel.html) for full documentation.
#'
#' @param ADMChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_adm_channel
pinpoint_update_adm_channel <- function(ADMChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateAdmChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$update_adm_channel_input(ADMChannelRequest = ADMChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_adm_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_adm_channel <- pinpoint_update_adm_channel

#' Enables the APNs channel for an application or updates the status and
#' settings of the APNs channel for an application
#'
#' @description
#' Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_apns_channel.html](https://paws-r.github.io/docs/pinpoint/update_apns_channel.html) for full documentation.
#'
#' @param APNSChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_channel
pinpoint_update_apns_channel <- function(APNSChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$update_apns_channel_input(APNSChannelRequest = APNSChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_channel <- pinpoint_update_apns_channel

#' Enables the APNs sandbox channel for an application or updates the
#' status and settings of the APNs sandbox channel for an application
#'
#' @description
#' Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_apns_sandbox_channel.html](https://paws-r.github.io/docs/pinpoint/update_apns_sandbox_channel.html) for full documentation.
#'
#' @param APNSSandboxChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_sandbox_channel
pinpoint_update_apns_sandbox_channel <- function(APNSSandboxChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsSandboxChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$update_apns_sandbox_channel_input(APNSSandboxChannelRequest = APNSSandboxChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_sandbox_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_sandbox_channel <- pinpoint_update_apns_sandbox_channel

#' Enables the APNs VoIP channel for an application or updates the status
#' and settings of the APNs VoIP channel for an application
#'
#' @description
#' Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_apns_voip_channel.html](https://paws-r.github.io/docs/pinpoint/update_apns_voip_channel.html) for full documentation.
#'
#' @param APNSVoipChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_voip_channel
pinpoint_update_apns_voip_channel <- function(APNSVoipChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsVoipChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$update_apns_voip_channel_input(APNSVoipChannelRequest = APNSVoipChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_voip_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_voip_channel <- pinpoint_update_apns_voip_channel

#' Enables the APNs VoIP sandbox channel for an application or updates the
#' status and settings of the APNs VoIP sandbox channel for an application
#'
#' @description
#' Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_apns_voip_sandbox_channel.html](https://paws-r.github.io/docs/pinpoint/update_apns_voip_sandbox_channel.html) for full documentation.
#'
#' @param APNSVoipSandboxChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_voip_sandbox_channel
pinpoint_update_apns_voip_sandbox_channel <- function(APNSVoipSandboxChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsVoipSandboxChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$update_apns_voip_sandbox_channel_input(APNSVoipSandboxChannelRequest = APNSVoipSandboxChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_voip_sandbox_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_voip_sandbox_channel <- pinpoint_update_apns_voip_sandbox_channel

#' Updates the settings for an application
#'
#' @description
#' Updates the settings for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_application_settings.html](https://paws-r.github.io/docs/pinpoint/update_application_settings.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteApplicationSettingsRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_application_settings
pinpoint_update_application_settings <- function(ApplicationId, WriteApplicationSettingsRequest) {
  op <- new_operation(
    name = "UpdateApplicationSettings",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/settings",
    paginator = list()
  )
  input <- .pinpoint$update_application_settings_input(ApplicationId = ApplicationId, WriteApplicationSettingsRequest = WriteApplicationSettingsRequest)
  output <- .pinpoint$update_application_settings_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_application_settings <- pinpoint_update_application_settings

#' Enables the Baidu channel for an application or updates the status and
#' settings of the Baidu channel for an application
#'
#' @description
#' Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_baidu_channel.html](https://paws-r.github.io/docs/pinpoint/update_baidu_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param BaiduChannelRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_baidu_channel
pinpoint_update_baidu_channel <- function(ApplicationId, BaiduChannelRequest) {
  op <- new_operation(
    name = "UpdateBaiduChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$update_baidu_channel_input(ApplicationId = ApplicationId, BaiduChannelRequest = BaiduChannelRequest)
  output <- .pinpoint$update_baidu_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_baidu_channel <- pinpoint_update_baidu_channel

#' Updates the configuration and other settings for a campaign
#'
#' @description
#' Updates the configuration and other settings for a campaign.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_campaign.html](https://paws-r.github.io/docs/pinpoint/update_campaign.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param WriteCampaignRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_campaign
pinpoint_update_campaign <- function(ApplicationId, CampaignId, WriteCampaignRequest) {
  op <- new_operation(
    name = "UpdateCampaign",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$update_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId, WriteCampaignRequest = WriteCampaignRequest)
  output <- .pinpoint$update_campaign_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_campaign <- pinpoint_update_campaign

#' Enables the email channel for an application or updates the status and
#' settings of the email channel for an application
#'
#' @description
#' Enables the email channel for an application or updates the status and settings of the email channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_email_channel.html](https://paws-r.github.io/docs/pinpoint/update_email_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EmailChannelRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_email_channel
pinpoint_update_email_channel <- function(ApplicationId, EmailChannelRequest) {
  op <- new_operation(
    name = "UpdateEmailChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$update_email_channel_input(ApplicationId = ApplicationId, EmailChannelRequest = EmailChannelRequest)
  output <- .pinpoint$update_email_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_email_channel <- pinpoint_update_email_channel

#' Updates an existing message template for messages that are sent through
#' the email channel
#'
#' @description
#' Updates an existing message template for messages that are sent through the email channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_email_template.html](https://paws-r.github.io/docs/pinpoint/update_email_template.html) for full documentation.
#'
#' @param CreateNewVersion Specifies whether to save the updates as a new version of the message
#' template. Valid values are: true, save the updates as a new version;
#' and, false, save the updates to (overwrite) the latest existing version
#' of the template.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint saves
#' the updates to (overwrites) the latest existing version of the template.
#' If you specify a value of true for this parameter, don't specify a value
#' for the version parameter. Otherwise, an error will occur.
#' @param EmailTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_email_template
pinpoint_update_email_template <- function(CreateNewVersion = NULL, EmailTemplateRequest, TemplateName, Version = NULL) {
  op <- new_operation(
    name = "UpdateEmailTemplate",
    http_method = "PUT",
    http_path = "/v1/templates/{template-name}/email",
    paginator = list()
  )
  input <- .pinpoint$update_email_template_input(CreateNewVersion = CreateNewVersion, EmailTemplateRequest = EmailTemplateRequest, TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$update_email_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_email_template <- pinpoint_update_email_template

#' Creates a new endpoint for an application or updates the settings and
#' attributes of an existing endpoint for an application
#'
#' @description
#' Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_endpoint.html](https://paws-r.github.io/docs/pinpoint/update_endpoint.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#' @param EndpointRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_endpoint
pinpoint_update_endpoint <- function(ApplicationId, EndpointId, EndpointRequest) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$update_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId, EndpointRequest = EndpointRequest)
  output <- .pinpoint$update_endpoint_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_endpoint <- pinpoint_update_endpoint

#' Creates a new batch of endpoints for an application or updates the
#' settings and attributes of a batch of existing endpoints for an
#' application
#'
#' @description
#' Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_endpoints_batch.html](https://paws-r.github.io/docs/pinpoint/update_endpoints_batch.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointBatchRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_endpoints_batch
pinpoint_update_endpoints_batch <- function(ApplicationId, EndpointBatchRequest) {
  op <- new_operation(
    name = "UpdateEndpointsBatch",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/endpoints",
    paginator = list()
  )
  input <- .pinpoint$update_endpoints_batch_input(ApplicationId = ApplicationId, EndpointBatchRequest = EndpointBatchRequest)
  output <- .pinpoint$update_endpoints_batch_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_endpoints_batch <- pinpoint_update_endpoints_batch

#' Enables the GCM channel for an application or updates the status and
#' settings of the GCM channel for an application
#'
#' @description
#' Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_gcm_channel.html](https://paws-r.github.io/docs/pinpoint/update_gcm_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param GCMChannelRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_gcm_channel
pinpoint_update_gcm_channel <- function(ApplicationId, GCMChannelRequest) {
  op <- new_operation(
    name = "UpdateGcmChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$update_gcm_channel_input(ApplicationId = ApplicationId, GCMChannelRequest = GCMChannelRequest)
  output <- .pinpoint$update_gcm_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_gcm_channel <- pinpoint_update_gcm_channel

#' Updates an existing message template for messages sent through the
#' in-app message channel
#'
#' @description
#' Updates an existing message template for messages sent through the in-app message channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_in_app_template.html](https://paws-r.github.io/docs/pinpoint/update_in_app_template.html) for full documentation.
#'
#' @param CreateNewVersion Specifies whether to save the updates as a new version of the message
#' template. Valid values are: true, save the updates as a new version;
#' and, false, save the updates to (overwrite) the latest existing version
#' of the template.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint saves
#' the updates to (overwrites) the latest existing version of the template.
#' If you specify a value of true for this parameter, don't specify a value
#' for the version parameter. Otherwise, an error will occur.
#' @param InAppTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_in_app_template
pinpoint_update_in_app_template <- function(CreateNewVersion = NULL, InAppTemplateRequest, TemplateName, Version = NULL) {
  op <- new_operation(
    name = "UpdateInAppTemplate",
    http_method = "PUT",
    http_path = "/v1/templates/{template-name}/inapp",
    paginator = list()
  )
  input <- .pinpoint$update_in_app_template_input(CreateNewVersion = CreateNewVersion, InAppTemplateRequest = InAppTemplateRequest, TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$update_in_app_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_in_app_template <- pinpoint_update_in_app_template

#' Updates the configuration and other settings for a journey
#'
#' @description
#' Updates the configuration and other settings for a journey.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_journey.html](https://paws-r.github.io/docs/pinpoint/update_journey.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#' @param WriteJourneyRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_journey
pinpoint_update_journey <- function(ApplicationId, JourneyId, WriteJourneyRequest) {
  op <- new_operation(
    name = "UpdateJourney",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}",
    paginator = list()
  )
  input <- .pinpoint$update_journey_input(ApplicationId = ApplicationId, JourneyId = JourneyId, WriteJourneyRequest = WriteJourneyRequest)
  output <- .pinpoint$update_journey_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_journey <- pinpoint_update_journey

#' Cancels (stops) an active journey
#'
#' @description
#' Cancels (stops) an active journey.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_journey_state.html](https://paws-r.github.io/docs/pinpoint/update_journey_state.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JourneyId &#91;required&#93; The unique identifier for the journey.
#' @param JourneyStateRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_journey_state
pinpoint_update_journey_state <- function(ApplicationId, JourneyId, JourneyStateRequest) {
  op <- new_operation(
    name = "UpdateJourneyState",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/journeys/{journey-id}/state",
    paginator = list()
  )
  input <- .pinpoint$update_journey_state_input(ApplicationId = ApplicationId, JourneyId = JourneyId, JourneyStateRequest = JourneyStateRequest)
  output <- .pinpoint$update_journey_state_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_journey_state <- pinpoint_update_journey_state

#' Updates an existing message template for messages that are sent through
#' a push notification channel
#'
#' @description
#' Updates an existing message template for messages that are sent through a push notification channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_push_template.html](https://paws-r.github.io/docs/pinpoint/update_push_template.html) for full documentation.
#'
#' @param CreateNewVersion Specifies whether to save the updates as a new version of the message
#' template. Valid values are: true, save the updates as a new version;
#' and, false, save the updates to (overwrite) the latest existing version
#' of the template.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint saves
#' the updates to (overwrites) the latest existing version of the template.
#' If you specify a value of true for this parameter, don't specify a value
#' for the version parameter. Otherwise, an error will occur.
#' @param PushNotificationTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_push_template
pinpoint_update_push_template <- function(CreateNewVersion = NULL, PushNotificationTemplateRequest, TemplateName, Version = NULL) {
  op <- new_operation(
    name = "UpdatePushTemplate",
    http_method = "PUT",
    http_path = "/v1/templates/{template-name}/push",
    paginator = list()
  )
  input <- .pinpoint$update_push_template_input(CreateNewVersion = CreateNewVersion, PushNotificationTemplateRequest = PushNotificationTemplateRequest, TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$update_push_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_push_template <- pinpoint_update_push_template

#' Updates an Amazon Pinpoint configuration for a recommender model
#'
#' @description
#' Updates an Amazon Pinpoint configuration for a recommender model.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_recommender_configuration.html](https://paws-r.github.io/docs/pinpoint/update_recommender_configuration.html) for full documentation.
#'
#' @param RecommenderId &#91;required&#93; The unique identifier for the recommender model configuration. This
#' identifier is displayed as the **Recommender ID** on the Amazon Pinpoint
#' console.
#' @param UpdateRecommenderConfiguration &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_recommender_configuration
pinpoint_update_recommender_configuration <- function(RecommenderId, UpdateRecommenderConfiguration) {
  op <- new_operation(
    name = "UpdateRecommenderConfiguration",
    http_method = "PUT",
    http_path = "/v1/recommenders/{recommender-id}",
    paginator = list()
  )
  input <- .pinpoint$update_recommender_configuration_input(RecommenderId = RecommenderId, UpdateRecommenderConfiguration = UpdateRecommenderConfiguration)
  output <- .pinpoint$update_recommender_configuration_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_recommender_configuration <- pinpoint_update_recommender_configuration

#' Creates a new segment for an application or updates the configuration,
#' dimension, and other settings for an existing segment that's associated
#' with an application
#'
#' @description
#' Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_segment.html](https://paws-r.github.io/docs/pinpoint/update_segment.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param WriteSegmentRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_segment
pinpoint_update_segment <- function(ApplicationId, SegmentId, WriteSegmentRequest) {
  op <- new_operation(
    name = "UpdateSegment",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$update_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId, WriteSegmentRequest = WriteSegmentRequest)
  output <- .pinpoint$update_segment_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_segment <- pinpoint_update_segment

#' Enables the SMS channel for an application or updates the status and
#' settings of the SMS channel for an application
#'
#' @description
#' Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_sms_channel.html](https://paws-r.github.io/docs/pinpoint/update_sms_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SMSChannelRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_sms_channel
pinpoint_update_sms_channel <- function(ApplicationId, SMSChannelRequest) {
  op <- new_operation(
    name = "UpdateSmsChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$update_sms_channel_input(ApplicationId = ApplicationId, SMSChannelRequest = SMSChannelRequest)
  output <- .pinpoint$update_sms_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_sms_channel <- pinpoint_update_sms_channel

#' Updates an existing message template for messages that are sent through
#' the SMS channel
#'
#' @description
#' Updates an existing message template for messages that are sent through the SMS channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_sms_template.html](https://paws-r.github.io/docs/pinpoint/update_sms_template.html) for full documentation.
#'
#' @param CreateNewVersion Specifies whether to save the updates as a new version of the message
#' template. Valid values are: true, save the updates as a new version;
#' and, false, save the updates to (overwrite) the latest existing version
#' of the template.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint saves
#' the updates to (overwrites) the latest existing version of the template.
#' If you specify a value of true for this parameter, don't specify a value
#' for the version parameter. Otherwise, an error will occur.
#' @param SMSTemplateRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_sms_template
pinpoint_update_sms_template <- function(CreateNewVersion = NULL, SMSTemplateRequest, TemplateName, Version = NULL) {
  op <- new_operation(
    name = "UpdateSmsTemplate",
    http_method = "PUT",
    http_path = "/v1/templates/{template-name}/sms",
    paginator = list()
  )
  input <- .pinpoint$update_sms_template_input(CreateNewVersion = CreateNewVersion, SMSTemplateRequest = SMSTemplateRequest, TemplateName = TemplateName, Version = Version)
  output <- .pinpoint$update_sms_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_sms_template <- pinpoint_update_sms_template

#' Changes the status of a specific version of a message template to active
#'
#' @description
#' Changes the status of a specific version of a message template to *active*.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_template_active_version.html](https://paws-r.github.io/docs/pinpoint/update_template_active_version.html) for full documentation.
#'
#' @param TemplateActiveVersionRequest &#91;required&#93; 
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param TemplateType &#91;required&#93; The type of channel that the message template is designed for. Valid
#' values are: EMAIL, PUSH, SMS, and VOICE.
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_template_active_version
pinpoint_update_template_active_version <- function(TemplateActiveVersionRequest, TemplateName, TemplateType) {
  op <- new_operation(
    name = "UpdateTemplateActiveVersion",
    http_method = "PUT",
    http_path = "/v1/templates/{template-name}/{template-type}/active-version",
    paginator = list()
  )
  input <- .pinpoint$update_template_active_version_input(TemplateActiveVersionRequest = TemplateActiveVersionRequest, TemplateName = TemplateName, TemplateType = TemplateType)
  output <- .pinpoint$update_template_active_version_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_template_active_version <- pinpoint_update_template_active_version

#' Enables the voice channel for an application or updates the status and
#' settings of the voice channel for an application
#'
#' @description
#' Enables the voice channel for an application or updates the status and settings of the voice channel for an application.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_voice_channel.html](https://paws-r.github.io/docs/pinpoint/update_voice_channel.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param VoiceChannelRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_voice_channel
pinpoint_update_voice_channel <- function(ApplicationId, VoiceChannelRequest) {
  op <- new_operation(
    name = "UpdateVoiceChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$update_voice_channel_input(ApplicationId = ApplicationId, VoiceChannelRequest = VoiceChannelRequest)
  output <- .pinpoint$update_voice_channel_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_voice_channel <- pinpoint_update_voice_channel

#' Updates an existing message template for messages that are sent through
#' the voice channel
#'
#' @description
#' Updates an existing message template for messages that are sent through the voice channel.
#'
#' See [https://paws-r.github.io/docs/pinpoint/update_voice_template.html](https://paws-r.github.io/docs/pinpoint/update_voice_template.html) for full documentation.
#'
#' @param CreateNewVersion Specifies whether to save the updates as a new version of the message
#' template. Valid values are: true, save the updates as a new version;
#' and, false, save the updates to (overwrite) the latest existing version
#' of the template.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint saves
#' the updates to (overwrites) the latest existing version of the template.
#' If you specify a value of true for this parameter, don't specify a value
#' for the version parameter. Otherwise, an error will occur.
#' @param TemplateName &#91;required&#93; The name of the message template. A template name must start with an
#' alphanumeric character and can contain a maximum of 128 characters. The
#' characters can be alphanumeric characters, underscores (_), or hyphens
#' (-). Template names are case sensitive.
#' @param Version The unique identifier for the version of the message template to update,
#' retrieve information about, or delete. To retrieve identifiers and other
#' information for all the versions of a template, use the Template
#' Versions resource.
#' 
#' If specified, this value must match the identifier for an existing
#' template version. If specified for an update operation, this value must
#' match the identifier for the latest existing version of the template.
#' This restriction helps ensure that race conditions don't occur.
#' 
#' If you don't specify a value for this parameter, Amazon Pinpoint does
#' the following:
#' 
#' -   For a get operation, retrieves information about the active version
#'     of the template.
#' 
#' -   For an update operation, saves the updates to (overwrites) the
#'     latest existing version of the template, if the create-new-version
#'     parameter isn't used or is set to false.
#' 
#' -   For a delete operation, deletes the template, including all versions
#'     of the template.
#' @param VoiceTemplateRequest &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_voice_template
pinpoint_update_voice_template <- function(CreateNewVersion = NULL, TemplateName, Version = NULL, VoiceTemplateRequest) {
  op <- new_operation(
    name = "UpdateVoiceTemplate",
    http_method = "PUT",
    http_path = "/v1/templates/{template-name}/voice",
    paginator = list()
  )
  input <- .pinpoint$update_voice_template_input(CreateNewVersion = CreateNewVersion, TemplateName = TemplateName, Version = Version, VoiceTemplateRequest = VoiceTemplateRequest)
  output <- .pinpoint$update_voice_template_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_voice_template <- pinpoint_update_voice_template

#' Verify an OTP
#'
#' @description
#' Verify an OTP
#'
#' See [https://paws-r.github.io/docs/pinpoint/verify_otp_message.html](https://paws-r.github.io/docs/pinpoint/verify_otp_message.html) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param VerifyOTPMessageRequestParameters &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname pinpoint_verify_otp_message
pinpoint_verify_otp_message <- function(ApplicationId, VerifyOTPMessageRequestParameters) {
  op <- new_operation(
    name = "VerifyOTPMessage",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/verify-otp",
    paginator = list()
  )
  input <- .pinpoint$verify_otp_message_input(ApplicationId = ApplicationId, VerifyOTPMessageRequestParameters = VerifyOTPMessageRequestParameters)
  output <- .pinpoint$verify_otp_message_output()
  config <- get_config()
  svc <- .pinpoint$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$verify_otp_message <- pinpoint_verify_otp_message
