% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_identity_dkim_enabled}
\alias{ses_set_identity_dkim_enabled}
\title{Enables or disables Easy DKIM signing of email sent from an identity}
\usage{
ses_set_identity_dkim_enabled(Identity, DkimEnabled)
}
\arguments{
\item{Identity}{[required] The identity for which DKIM signing should be enabled or disabled.}

\item{DkimEnabled}{[required] Sets whether DKIM signing is enabled for an identity. Set to \code{true} to
enable DKIM signing for this identity; \code{false} to disable it.}
}
\description{
Enables or disables Easy DKIM signing of email sent from an identity. If
Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to
sign all email that it sends from addresses on that domain. If Easy DKIM
signing is enabled for an email address, then Amazon SES uses DKIM to
sign all email it sends from that address.
}
\details{
For email addresses (for example, \code{user@example.com}), you can only
enable DKIM signing if the corresponding domain (in this case,
\code{example.com}) has been set up to use Easy DKIM.

You can enable DKIM signing for an identity at any time after you start
the verification process for the identity, even if the verification
process isn\'t complete.

You can execute this operation no more than once per second.

For more information about Easy DKIM signing, go to the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_identity_dkim_enabled(
  Identity = "string",
  DkimEnabled = TRUE|FALSE
)
}
}

\examples{
# The following example configures Amazon SES to Easy DKIM-sign the email
# sent from an identity:
\donttest{svc$set_identity_dkim_enabled(
  DkimEnabled = TRUE,
  Identity = "user@example.com"
)}

}
\keyword{internal}
