% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billingconductor_operations.R
\name{billingconductor_create_custom_line_item}
\alias{billingconductor_create_custom_line_item}
\title{Creates a custom line item that can be used to create a one-time fixed
charge that can be applied to a single billing group for the current or
previous billing period}
\usage{
billingconductor_create_custom_line_item(
  ClientToken = NULL,
  Name,
  Description,
  BillingGroupArn,
  BillingPeriodRange = NULL,
  Tags = NULL,
  ChargeDetails,
  AccountId = NULL
)
}
\arguments{
\item{ClientToken}{The token that is needed to support idempotency. Idempotency isn't
currently supported, but will be implemented in a future update.}

\item{Name}{[required] The name of the custom line item.}

\item{Description}{[required] The description of the custom line item. This is shown on the Bills page
in association with the charge value.}

\item{BillingGroupArn}{[required] The Amazon Resource Name (ARN) that references the billing group where
the custom line item applies to.}

\item{BillingPeriodRange}{A time range for which the custom line item is effective.}

\item{Tags}{A map that contains tag keys and tag values that are attached to a
custom line item.}

\item{ChargeDetails}{[required] A \code{CustomLineItemChargeDetails} that describes the charge details for a
custom line item.}

\item{AccountId}{The Amazon Web Services account in which this custom line item will be
applied to.}
}
\description{
Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.

See \url{https://www.paws-r-sdk.com/docs/billingconductor_create_custom_line_item/} for full documentation.
}
\keyword{internal}
