# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include paymentcryptographycontrolplane_service.R
NULL

#' Creates an alias, or a friendly name, for an Amazon Web Services Payment
#' Cryptography key
#'
#' @description
#' Creates an *alias*, or a friendly name, for an Amazon Web Services Payment Cryptography key. You can use an alias to identify a key in the console and when you call cryptographic operations such as [EncryptData](https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_EncryptData.html) or [DecryptData](https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_DecryptData.html).
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_create_alias/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_create_alias/) for full documentation.
#'
#' @param AliasName &#91;required&#93; A friendly name that you can use to refer to a key. An alias must begin
#' with `alias/` followed by a name, for example `alias/ExampleAlias`. It
#' can contain only alphanumeric characters, forward slashes (/),
#' underscores (_), and dashes (-).
#' 
#' Don't include personal, confidential or sensitive information in this
#' field. This field may be displayed in plaintext in CloudTrail logs and
#' other output.
#' @param KeyArn The `KeyARN` of the key to associate with the alias.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_create_alias
paymentcryptographycontrolplane_create_alias <- function(AliasName, KeyArn = NULL) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$create_alias_input(AliasName = AliasName, KeyArn = KeyArn)
  output <- .paymentcryptographycontrolplane$create_alias_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$create_alias <- paymentcryptographycontrolplane_create_alias

#' Creates an Amazon Web Services Payment Cryptography key, a logical
#' representation of a cryptographic key, that is unique in your account
#' and Amazon Web Services Region
#'
#' @description
#' Creates an Amazon Web Services Payment Cryptography key, a logical representation of a cryptographic key, that is unique in your account and Amazon Web Services Region. You use keys for cryptographic functions such as encryption and decryption.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_create_key/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_create_key/) for full documentation.
#'
#' @param Enabled Specifies whether to enable the key. If the key is enabled, it is
#' activated for use within the service. If the key is not enabled, then it
#' is created but not activated. The default value is enabled.
#' @param Exportable &#91;required&#93; Specifies whether the key is exportable from the service.
#' @param KeyAttributes &#91;required&#93; The role of the key, the algorithm it supports, and the cryptographic
#' operations allowed with the key. This data is immutable after the key is
#' created.
#' @param KeyCheckValueAlgorithm The algorithm that Amazon Web Services Payment Cryptography uses to
#' calculate the key check value (KCV). It is used to validate the key
#' integrity.
#' 
#' For TDES keys, the KCV is computed by encrypting 8 bytes, each with
#' value of zero, with the key to be checked and retaining the 3 highest
#' order bytes of the encrypted result. For AES keys, the KCV is computed
#' using a CMAC algorithm where the input data is 16 bytes of zero and
#' retaining the 3 highest order bytes of the encrypted result.
#' @param Tags Assigns one or more tags to the Amazon Web Services Payment Cryptography
#' key. Use this parameter to tag a key when it is created. To tag an
#' existing Amazon Web Services Payment Cryptography key, use the
#' [`tag_resource`][paymentcryptographycontrolplane_tag_resource]
#' operation.
#' 
#' Each tag consists of a tag key and a tag value. Both the tag key and the
#' tag value are required, but the tag value can be an empty (null) string.
#' You can't have more than one tag on an Amazon Web Services Payment
#' Cryptography key with the same tag key.
#' 
#' Don't include personal, confidential or sensitive information in this
#' field. This field may be displayed in plaintext in CloudTrail logs and
#' other output.
#' 
#' Tagging or untagging an Amazon Web Services Payment Cryptography key can
#' allow or deny permission to the key.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_create_key
paymentcryptographycontrolplane_create_key <- function(Enabled = NULL, Exportable, KeyAttributes, KeyCheckValueAlgorithm = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$create_key_input(Enabled = Enabled, Exportable = Exportable, KeyAttributes = KeyAttributes, KeyCheckValueAlgorithm = KeyCheckValueAlgorithm, Tags = Tags)
  output <- .paymentcryptographycontrolplane$create_key_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$create_key <- paymentcryptographycontrolplane_create_key

#' Deletes the alias, but doesn't affect the underlying key
#'
#' @description
#' Deletes the alias, but doesn't affect the underlying key.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_delete_alias/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_delete_alias/) for full documentation.
#'
#' @param AliasName &#91;required&#93; A friendly name that you can use to refer Amazon Web Services Payment
#' Cryptography key. This value must begin with `alias/` followed by a
#' name, such as `alias/ExampleAlias`.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_delete_alias
paymentcryptographycontrolplane_delete_alias <- function(AliasName) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$delete_alias_input(AliasName = AliasName)
  output <- .paymentcryptographycontrolplane$delete_alias_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$delete_alias <- paymentcryptographycontrolplane_delete_alias

#' Deletes the key material and metadata associated with Amazon Web
#' Services Payment Cryptography key
#'
#' @description
#' Deletes the key material and metadata associated with Amazon Web Services Payment Cryptography key.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_delete_key/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_delete_key/) for full documentation.
#'
#' @param DeleteKeyInDays The waiting period for key deletion. The default value is seven days.
#' @param KeyIdentifier &#91;required&#93; The `KeyARN` of the key that is scheduled for deletion.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_delete_key
paymentcryptographycontrolplane_delete_key <- function(DeleteKeyInDays = NULL, KeyIdentifier) {
  op <- new_operation(
    name = "DeleteKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$delete_key_input(DeleteKeyInDays = DeleteKeyInDays, KeyIdentifier = KeyIdentifier)
  output <- .paymentcryptographycontrolplane$delete_key_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$delete_key <- paymentcryptographycontrolplane_delete_key

#' Exports a key from Amazon Web Services Payment Cryptography
#'
#' @description
#' Exports a key from Amazon Web Services Payment Cryptography.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_export_key/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_export_key/) for full documentation.
#'
#' @param ExportAttributes The attributes for IPEK generation during export.
#' @param ExportKeyIdentifier &#91;required&#93; The `KeyARN` of the key under export from Amazon Web Services Payment
#' Cryptography.
#' @param KeyMaterial &#91;required&#93; The key block format type, for example, TR-34 or TR-31, to use during
#' key material export.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_export_key
paymentcryptographycontrolplane_export_key <- function(ExportAttributes = NULL, ExportKeyIdentifier, KeyMaterial) {
  op <- new_operation(
    name = "ExportKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$export_key_input(ExportAttributes = ExportAttributes, ExportKeyIdentifier = ExportKeyIdentifier, KeyMaterial = KeyMaterial)
  output <- .paymentcryptographycontrolplane$export_key_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$export_key <- paymentcryptographycontrolplane_export_key

#' Gets the Amazon Web Services Payment Cryptography key associated with
#' the alias
#'
#' @description
#' Gets the Amazon Web Services Payment Cryptography key associated with the alias.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_alias/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_alias/) for full documentation.
#'
#' @param AliasName &#91;required&#93; The alias of the Amazon Web Services Payment Cryptography key.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_get_alias
paymentcryptographycontrolplane_get_alias <- function(AliasName) {
  op <- new_operation(
    name = "GetAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$get_alias_input(AliasName = AliasName)
  output <- .paymentcryptographycontrolplane$get_alias_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$get_alias <- paymentcryptographycontrolplane_get_alias

#' Gets the key material for an Amazon Web Services Payment Cryptography
#' key, including the immutable and mutable data specified when the key was
#' created
#'
#' @description
#' Gets the key material for an Amazon Web Services Payment Cryptography key, including the immutable and mutable data specified when the key was created.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_key/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_key/) for full documentation.
#'
#' @param KeyIdentifier &#91;required&#93; The `KeyARN` of the Amazon Web Services Payment Cryptography key.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_get_key
paymentcryptographycontrolplane_get_key <- function(KeyIdentifier) {
  op <- new_operation(
    name = "GetKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$get_key_input(KeyIdentifier = KeyIdentifier)
  output <- .paymentcryptographycontrolplane$get_key_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$get_key <- paymentcryptographycontrolplane_get_key

#' Gets the export token and the signing key certificate to initiate a
#' TR-34 key export from Amazon Web Services Payment Cryptography
#'
#' @description
#' Gets the export token and the signing key certificate to initiate a TR-34 key export from Amazon Web Services Payment Cryptography.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_parameters_for_export/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_parameters_for_export/) for full documentation.
#'
#' @param KeyMaterialType &#91;required&#93; The key block format type (for example, TR-34 or TR-31) to use during
#' key material export. Export token is only required for a TR-34 key
#' export, `TR34_KEY_BLOCK`. Export token is not required for TR-31 key
#' export.
#' @param SigningKeyAlgorithm &#91;required&#93; The signing key algorithm to generate a signing key certificate. This
#' certificate signs the wrapped key under export within the TR-34 key
#' block. `RSA_2048` is the only signing key algorithm allowed.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_get_parameters_for_export
paymentcryptographycontrolplane_get_parameters_for_export <- function(KeyMaterialType, SigningKeyAlgorithm) {
  op <- new_operation(
    name = "GetParametersForExport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$get_parameters_for_export_input(KeyMaterialType = KeyMaterialType, SigningKeyAlgorithm = SigningKeyAlgorithm)
  output <- .paymentcryptographycontrolplane$get_parameters_for_export_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$get_parameters_for_export <- paymentcryptographycontrolplane_get_parameters_for_export

#' Gets the import token and the wrapping key certificate in PEM format
#' (base64 encoded) to initiate a TR-34 WrappedKeyBlock
#'
#' @description
#' Gets the import token and the wrapping key certificate in PEM format (base64 encoded) to initiate a TR-34 WrappedKeyBlock.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_parameters_for_import/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_parameters_for_import/) for full documentation.
#'
#' @param KeyMaterialType &#91;required&#93; The method to use for key material import. Import token is only required
#' for TR-34 WrappedKeyBlock (`TR34_KEY_BLOCK`).
#' 
#' Import token is not required for TR-31, root public key cerificate or
#' trusted public key certificate.
#' @param WrappingKeyAlgorithm &#91;required&#93; The wrapping key algorithm to generate a wrapping key certificate. This
#' certificate wraps the key under import.
#' 
#' At this time, `RSA_2048`, `RSA_3072`, `RSA_4096` are the only allowed
#' algorithms for TR-34 WrappedKeyBlock import.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_get_parameters_for_import
paymentcryptographycontrolplane_get_parameters_for_import <- function(KeyMaterialType, WrappingKeyAlgorithm) {
  op <- new_operation(
    name = "GetParametersForImport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$get_parameters_for_import_input(KeyMaterialType = KeyMaterialType, WrappingKeyAlgorithm = WrappingKeyAlgorithm)
  output <- .paymentcryptographycontrolplane$get_parameters_for_import_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$get_parameters_for_import <- paymentcryptographycontrolplane_get_parameters_for_import

#' Gets the public key certificate of the asymmetric key pair that exists
#' within Amazon Web Services Payment Cryptography
#'
#' @description
#' Gets the public key certificate of the asymmetric key pair that exists within Amazon Web Services Payment Cryptography.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_public_key_certificate/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_public_key_certificate/) for full documentation.
#'
#' @param KeyIdentifier &#91;required&#93; The `KeyARN` of the asymmetric key pair.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_get_public_key_certificate
paymentcryptographycontrolplane_get_public_key_certificate <- function(KeyIdentifier) {
  op <- new_operation(
    name = "GetPublicKeyCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$get_public_key_certificate_input(KeyIdentifier = KeyIdentifier)
  output <- .paymentcryptographycontrolplane$get_public_key_certificate_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$get_public_key_certificate <- paymentcryptographycontrolplane_get_public_key_certificate

#' Imports symmetric keys and public key certificates in PEM format (base64
#' encoded) into Amazon Web Services Payment Cryptography
#'
#' @description
#' Imports symmetric keys and public key certificates in PEM format (base64 encoded) into Amazon Web Services Payment Cryptography.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_import_key/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_import_key/) for full documentation.
#'
#' @param Enabled Specifies whether import key is enabled.
#' @param KeyCheckValueAlgorithm The algorithm that Amazon Web Services Payment Cryptography uses to
#' calculate the key check value (KCV). It is used to validate the key
#' integrity.
#' 
#' For TDES keys, the KCV is computed by encrypting 8 bytes, each with
#' value of zero, with the key to be checked and retaining the 3 highest
#' order bytes of the encrypted result. For AES keys, the KCV is computed
#' using a CMAC algorithm where the input data is 16 bytes of zero and
#' retaining the 3 highest order bytes of the encrypted result.
#' @param KeyMaterial &#91;required&#93; The key or public key certificate type to use during key material
#' import, for example TR-34 or RootCertificatePublicKey.
#' @param Tags Assigns one or more tags to the Amazon Web Services Payment Cryptography
#' key. Use this parameter to tag a key when it is imported. To tag an
#' existing Amazon Web Services Payment Cryptography key, use the
#' [`tag_resource`][paymentcryptographycontrolplane_tag_resource]
#' operation.
#' 
#' Each tag consists of a tag key and a tag value. Both the tag key and the
#' tag value are required, but the tag value can be an empty (null) string.
#' You can't have more than one tag on an Amazon Web Services Payment
#' Cryptography key with the same tag key. If you specify an existing tag
#' key with a different tag value, Amazon Web Services Payment Cryptography
#' replaces the current tag value with the specified one.
#' 
#' Don't include personal, confidential or sensitive information in this
#' field. This field may be displayed in plaintext in CloudTrail logs and
#' other output.
#' 
#' Tagging or untagging an Amazon Web Services Payment Cryptography key can
#' allow or deny permission to the key.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_import_key
paymentcryptographycontrolplane_import_key <- function(Enabled = NULL, KeyCheckValueAlgorithm = NULL, KeyMaterial, Tags = NULL) {
  op <- new_operation(
    name = "ImportKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$import_key_input(Enabled = Enabled, KeyCheckValueAlgorithm = KeyCheckValueAlgorithm, KeyMaterial = KeyMaterial, Tags = Tags)
  output <- .paymentcryptographycontrolplane$import_key_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$import_key <- paymentcryptographycontrolplane_import_key

#' Lists the aliases for all keys in the caller's Amazon Web Services
#' account and Amazon Web Services Region
#'
#' @description
#' Lists the aliases for all keys in the caller's Amazon Web Services account and Amazon Web Services Region. You can filter the list of aliases. For more information, see [Using aliases](https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-managealias.html) in the *Amazon Web Services Payment Cryptography User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_list_aliases/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_list_aliases/) for full documentation.
#'
#' @param MaxResults Use this parameter to specify the maximum number of items to return.
#' When this value is present, Amazon Web Services Payment Cryptography
#' does not return more than the specified number of items, but it might
#' return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param NextToken Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextToken` from the
#' truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_list_aliases
paymentcryptographycontrolplane_list_aliases <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Aliases")
  )
  input <- .paymentcryptographycontrolplane$list_aliases_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .paymentcryptographycontrolplane$list_aliases_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$list_aliases <- paymentcryptographycontrolplane_list_aliases

#' Lists the keys in the caller's Amazon Web Services account and Amazon
#' Web Services Region
#'
#' @description
#' Lists the keys in the caller's Amazon Web Services account and Amazon Web Services Region. You can filter the list of keys.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_list_keys/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_list_keys/) for full documentation.
#'
#' @param KeyState The key state of the keys you want to list.
#' @param MaxResults Use this parameter to specify the maximum number of items to return.
#' When this value is present, Amazon Web Services Payment Cryptography
#' does not return more than the specified number of items, but it might
#' return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param NextToken Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextToken` from the
#' truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_list_keys
paymentcryptographycontrolplane_list_keys <- function(KeyState = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Keys")
  )
  input <- .paymentcryptographycontrolplane$list_keys_input(KeyState = KeyState, MaxResults = MaxResults, NextToken = NextToken)
  output <- .paymentcryptographycontrolplane$list_keys_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$list_keys <- paymentcryptographycontrolplane_list_keys

#' Lists the tags for an Amazon Web Services resource
#'
#' @description
#' Lists the tags for an Amazon Web Services resource.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_list_tags_for_resource/) for full documentation.
#'
#' @param MaxResults Use this parameter to specify the maximum number of items to return.
#' When this value is present, Amazon Web Services Payment Cryptography
#' does not return more than the specified number of items, but it might
#' return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param NextToken Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextToken` from the
#' truncated response you just received.
#' @param ResourceArn &#91;required&#93; The `KeyARN` of the key whose tags you are getting.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_list_tags_for_resource
paymentcryptographycontrolplane_list_tags_for_resource <- function(MaxResults = NULL, NextToken = NULL, ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Tags")
  )
  input <- .paymentcryptographycontrolplane$list_tags_for_resource_input(MaxResults = MaxResults, NextToken = NextToken, ResourceArn = ResourceArn)
  output <- .paymentcryptographycontrolplane$list_tags_for_resource_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$list_tags_for_resource <- paymentcryptographycontrolplane_list_tags_for_resource

#' Cancels a scheduled key deletion during the waiting period
#'
#' @description
#' Cancels a scheduled key deletion during the waiting period. Use this operation to restore a `Key` that is scheduled for deletion.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_restore_key/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_restore_key/) for full documentation.
#'
#' @param KeyIdentifier &#91;required&#93; The `KeyARN` of the key to be restored within Amazon Web Services
#' Payment Cryptography.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_restore_key
paymentcryptographycontrolplane_restore_key <- function(KeyIdentifier) {
  op <- new_operation(
    name = "RestoreKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$restore_key_input(KeyIdentifier = KeyIdentifier)
  output <- .paymentcryptographycontrolplane$restore_key_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$restore_key <- paymentcryptographycontrolplane_restore_key

#' Enables an Amazon Web Services Payment Cryptography key, which makes it
#' active for cryptographic operations within Amazon Web Services Payment
#' Cryptography
#'
#' @description
#' Enables an Amazon Web Services Payment Cryptography key, which makes it active for cryptographic operations within Amazon Web Services Payment Cryptography
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_start_key_usage/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_start_key_usage/) for full documentation.
#'
#' @param KeyIdentifier &#91;required&#93; The `KeyArn` of the key.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_start_key_usage
paymentcryptographycontrolplane_start_key_usage <- function(KeyIdentifier) {
  op <- new_operation(
    name = "StartKeyUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$start_key_usage_input(KeyIdentifier = KeyIdentifier)
  output <- .paymentcryptographycontrolplane$start_key_usage_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$start_key_usage <- paymentcryptographycontrolplane_start_key_usage

#' Disables an Amazon Web Services Payment Cryptography key, which makes it
#' inactive within Amazon Web Services Payment Cryptography
#'
#' @description
#' Disables an Amazon Web Services Payment Cryptography key, which makes it inactive within Amazon Web Services Payment Cryptography.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_stop_key_usage/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_stop_key_usage/) for full documentation.
#'
#' @param KeyIdentifier &#91;required&#93; The `KeyArn` of the key.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_stop_key_usage
paymentcryptographycontrolplane_stop_key_usage <- function(KeyIdentifier) {
  op <- new_operation(
    name = "StopKeyUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$stop_key_usage_input(KeyIdentifier = KeyIdentifier)
  output <- .paymentcryptographycontrolplane$stop_key_usage_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$stop_key_usage <- paymentcryptographycontrolplane_stop_key_usage

#' Adds or edits tags on an Amazon Web Services Payment Cryptography key
#'
#' @description
#' Adds or edits tags on an Amazon Web Services Payment Cryptography key.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_tag_resource/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The `KeyARN` of the key whose tags are being updated.
#' @param Tags &#91;required&#93; One or more tags. Each tag consists of a tag key and a tag value. The
#' tag value can be an empty (null) string. You can't have more than one
#' tag on an Amazon Web Services Payment Cryptography key with the same tag
#' key. If you specify an existing tag key with a different tag value,
#' Amazon Web Services Payment Cryptography replaces the current tag value
#' with the new one.
#' 
#' Don't include personal, confidential or sensitive information in this
#' field. This field may be displayed in plaintext in CloudTrail logs and
#' other output.
#' 
#' To use this parameter, you must have
#' [`tag_resource`][paymentcryptographycontrolplane_tag_resource]
#' permission in an IAM policy.
#' 
#' Don't include personal, confidential or sensitive information in this
#' field. This field may be displayed in plaintext in CloudTrail logs and
#' other output.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_tag_resource
paymentcryptographycontrolplane_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .paymentcryptographycontrolplane$tag_resource_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$tag_resource <- paymentcryptographycontrolplane_tag_resource

#' Deletes a tag from an Amazon Web Services Payment Cryptography key
#'
#' @description
#' Deletes a tag from an Amazon Web Services Payment Cryptography key.
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_untag_resource/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The `KeyARN` of the key whose tags are being removed.
#' @param TagKeys &#91;required&#93; One or more tag keys. Don't include the tag values.
#' 
#' If the Amazon Web Services Payment Cryptography key doesn't have the
#' specified tag key, Amazon Web Services Payment Cryptography doesn't
#' throw an exception or return a response. To confirm that the operation
#' succeeded, use the
#' [`list_tags_for_resource`][paymentcryptographycontrolplane_list_tags_for_resource]
#' operation.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_untag_resource
paymentcryptographycontrolplane_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .paymentcryptographycontrolplane$untag_resource_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$untag_resource <- paymentcryptographycontrolplane_untag_resource

#' Associates an existing Amazon Web Services Payment Cryptography alias
#' with a different key
#'
#' @description
#' Associates an existing Amazon Web Services Payment Cryptography alias with a different key. Each alias is associated with only one Amazon Web Services Payment Cryptography key at a time, although a key can have multiple aliases. The alias and the Amazon Web Services Payment Cryptography key must be in the same Amazon Web Services account and Amazon Web Services Region
#'
#' See [https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_update_alias/](https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_update_alias/) for full documentation.
#'
#' @param AliasName &#91;required&#93; The alias whose associated key is changing.
#' @param KeyArn The `KeyARN` for the key that you are updating or removing from the
#' alias.
#'
#' @keywords internal
#'
#' @rdname paymentcryptographycontrolplane_update_alias
paymentcryptographycontrolplane_update_alias <- function(AliasName, KeyArn = NULL) {
  op <- new_operation(
    name = "UpdateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .paymentcryptographycontrolplane$update_alias_input(AliasName = AliasName, KeyArn = KeyArn)
  output <- .paymentcryptographycontrolplane$update_alias_output()
  config <- get_config()
  svc <- .paymentcryptographycontrolplane$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.paymentcryptographycontrolplane$operations$update_alias <- paymentcryptographycontrolplane_update_alias
