% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacecatalog_operations.R
\name{marketplacecatalog_start_change_set}
\alias{marketplacecatalog_start_change_set}
\title{This operation allows you to request changes for your entities}
\usage{
marketplacecatalog_start_change_set(
  Catalog,
  ChangeSet,
  ChangeSetName = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{Catalog}{[required] The catalog related to the request. Fixed value: \code{AWSMarketplace}}

\item{ChangeSet}{[required] Array of \code{change} object.}

\item{ChangeSetName}{Optional case sensitive string of up to 100 ASCII characters. The change
set name can be used to filter the list of change sets.}

\item{ClientRequestToken}{A unique token to identify the request to ensure idempotency.}
}
\description{
This operation allows you to request changes for your entities. Within a single ChangeSet, you cannot start the same change type against the same entity multiple times. Additionally, when a ChangeSet is running, all the entities targeted by the different changes are locked until the ChangeSet has completed (either succeeded, cancelled, or failed). If you try to start a ChangeSet containing a change against an entity that is already locked, you will receive a \code{ResourceInUseException}.

See \url{https://paws-r.github.io/docs/marketplacecatalog/start_change_set.html} for full documentation.
}
\keyword{internal}
