% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_update_event_bus}
\alias{eventbridge_update_event_bus}
\title{Updates the specified event bus}
\usage{
eventbridge_update_event_bus(
  Name = NULL,
  KmsKeyIdentifier = NULL,
  Description = NULL,
  DeadLetterConfig = NULL
)
}
\arguments{
\item{Name}{The name of the event bus.}

\item{KmsKeyIdentifier}{The identifier of the KMS customer managed key for EventBridge to use,
if you choose to use a customer managed key to encrypt events on this
event bus. The identifier can be the key Amazon Resource Name (ARN),
KeyId, key alias, or key alias ARN.

If you do not specify a customer managed key identifier, EventBridge
uses an Amazon Web Services owned key to encrypt events on the event
bus.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html}{Managing keys}
in the \emph{Key Management Service Developer Guide}.

Archives and schema discovery are not supported for event buses
encrypted using a customer managed key. EventBridge returns an error if:
\itemize{
\item You call \code{\link[=eventbridge_create_archive]{create_archive}} on an event
bus set to use a customer managed key for encryption.
\item You call \code{CreateDiscoverer} on an event bus set to use a customer
managed key for encryption.
\item You call \code{UpdatedEventBus} to set a customer managed key on an
event bus with an archives or schema discovery enabled.
}

To enable archives or schema discovery on an event bus, choose to use an
Amazon Web Services owned key. For more information, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/}{Data encryption in EventBridge}
in the \emph{Amazon EventBridge User Guide}.}

\item{Description}{The event bus description.}

\item{DeadLetterConfig}{}
}
\description{
Updates the specified event bus.

See \url{https://www.paws-r-sdk.com/docs/eventbridge_update_event_bus/} for full documentation.
}
\keyword{internal}
