% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_list_dead_letter_source_queues}
\alias{sqs_list_dead_letter_source_queues}
\title{Returns a list of your queues that have the RedrivePolicy queue
attribute configured with a dead-letter queue}
\usage{
sqs_list_dead_letter_source_queues(QueueUrl)
}
\arguments{
\item{QueueUrl}{[required] The URL of a dead-letter queue.

Queue URLs and names are case-sensitive.}
}
\description{
Returns a list of your queues that have the \code{RedrivePolicy} queue
attribute configured with a dead-letter queue.
}
\details{
For more information about using dead-letter queues, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html}{Using Amazon SQS Dead-Letter Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_dead_letter_source_queues(
  QueueUrl = "string"
)
}
}

\keyword{internal}
