# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Simple Workflow Service
#'
#' @description
#' The Amazon Simple Workflow Service (Amazon SWF) makes it easy to build
#' applications that use Amazon\'s cloud to coordinate work across
#' distributed components. In Amazon SWF, a *task* represents a logical
#' unit of work that is performed by a component of your workflow.
#' Coordinating tasks in a workflow involves managing intertask
#' dependencies, scheduling, and concurrency in accordance with the logical
#' flow of the application.
#' 
#' Amazon SWF gives you full control over implementing tasks and
#' coordinating them without worrying about underlying complexities such as
#' tracking their progress and maintaining their state.
#' 
#' This documentation serves as reference only. For a broader overview of
#' the Amazon SWF programming model, see the *[Amazon SWF Developer
#' Guide](https://docs.aws.amazon.com/amazonswf/latest/developerguide/)* .
#'
#' @examples
#' \donttest{svc <- swf()
#' svc$count_closed_workflow_executions(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=swf_count_closed_workflow_executions]{count_closed_workflow_executions} \tab Returns the number of closed workflow executions within the given domain that meet the specified filtering criteria \cr
#'  \link[=swf_count_open_workflow_executions]{count_open_workflow_executions} \tab Returns the number of open workflow executions within the given domain that meet the specified filtering criteria \cr
#'  \link[=swf_count_pending_activity_tasks]{count_pending_activity_tasks} \tab Returns the estimated number of activity tasks in the specified task list \cr
#'  \link[=swf_count_pending_decision_tasks]{count_pending_decision_tasks} \tab Returns the estimated number of decision tasks in the specified task list \cr
#'  \link[=swf_deprecate_activity_type]{deprecate_activity_type} \tab Deprecates the specified _activity type_ \cr
#'  \link[=swf_deprecate_domain]{deprecate_domain} \tab Deprecates the specified domain \cr
#'  \link[=swf_deprecate_workflow_type]{deprecate_workflow_type} \tab Deprecates the specified _workflow type_ \cr
#'  \link[=swf_describe_activity_type]{describe_activity_type} \tab Returns information about the specified activity type \cr
#'  \link[=swf_describe_domain]{describe_domain} \tab Returns information about the specified domain, including description and status \cr
#'  \link[=swf_describe_workflow_execution]{describe_workflow_execution} \tab Returns information about the specified workflow execution including its type and some statistics \cr
#'  \link[=swf_describe_workflow_type]{describe_workflow_type} \tab Returns information about the specified _workflow type_ \cr
#'  \link[=swf_get_workflow_execution_history]{get_workflow_execution_history} \tab Returns the history of the specified workflow execution \cr
#'  \link[=swf_list_activity_types]{list_activity_types} \tab Returns information about all activities registered in the specified domain that match the specified name and registration status \cr
#'  \link[=swf_list_closed_workflow_executions]{list_closed_workflow_executions} \tab Returns a list of closed workflow executions in the specified domain that meet the filtering criteria \cr
#'  \link[=swf_list_domains]{list_domains} \tab Returns the list of domains registered in the account \cr
#'  \link[=swf_list_open_workflow_executions]{list_open_workflow_executions} \tab Returns a list of open workflow executions in the specified domain that meet the filtering criteria \cr
#'  \link[=swf_list_tags_for_resource]{list_tags_for_resource} \tab List tags for a given domain \cr
#'  \link[=swf_list_workflow_types]{list_workflow_types} \tab Returns information about workflow types in the specified domain \cr
#'  \link[=swf_poll_for_activity_task]{poll_for_activity_task} \tab Used by workers to get an ActivityTask from the specified activity taskList \cr
#'  \link[=swf_poll_for_decision_task]{poll_for_decision_task} \tab Used by deciders to get a DecisionTask from the specified decision taskList \cr
#'  \link[=swf_record_activity_task_heartbeat]{record_activity_task_heartbeat} \tab Used by activity workers to report to the service that the ActivityTask represented by the specified taskToken is still making progress \cr
#'  \link[=swf_register_activity_type]{register_activity_type} \tab Registers a new _activity type_ along with its configuration settings in the specified domain \cr
#'  \link[=swf_register_domain]{register_domain} \tab Registers a new domain \cr
#'  \link[=swf_register_workflow_type]{register_workflow_type} \tab Registers a new _workflow type_ and its configuration settings in the specified domain \cr
#'  \link[=swf_request_cancel_workflow_execution]{request_cancel_workflow_execution} \tab Records a WorkflowExecutionCancelRequested event in the currently running workflow execution identified by the given domain, workflowId, and runId \cr
#'  \link[=swf_respond_activity_task_canceled]{respond_activity_task_canceled} \tab Used by workers to tell the service that the ActivityTask identified by the taskToken was successfully canceled \cr
#'  \link[=swf_respond_activity_task_completed]{respond_activity_task_completed} \tab Used by workers to tell the service that the ActivityTask identified by the taskToken completed successfully with a result (if provided) \cr
#'  \link[=swf_respond_activity_task_failed]{respond_activity_task_failed} \tab Used by workers to tell the service that the ActivityTask identified by the taskToken has failed with reason (if specified) \cr
#'  \link[=swf_respond_decision_task_completed]{respond_decision_task_completed} \tab Used by deciders to tell the service that the DecisionTask identified by the taskToken has successfully completed \cr
#'  \link[=swf_signal_workflow_execution]{signal_workflow_execution} \tab Records a WorkflowExecutionSignaled event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId\cr
#'  \link[=swf_start_workflow_execution]{start_workflow_execution} \tab Starts an execution of the workflow type in the specified domain using the provided workflowId and input data \cr
#'  \link[=swf_tag_resource]{tag_resource} \tab Add a tag to a Amazon SWF domain \cr
#'  \link[=swf_terminate_workflow_execution]{terminate_workflow_execution} \tab Records a WorkflowExecutionTerminated event and forces closure of the workflow execution identified by the given domain, runId, and workflowId \cr
#'  \link[=swf_undeprecate_activity_type]{undeprecate_activity_type} \tab Undeprecates a previously deprecated _activity type_ \cr
#'  \link[=swf_undeprecate_domain]{undeprecate_domain} \tab Undeprecates a previously deprecated domain \cr
#'  \link[=swf_undeprecate_workflow_type]{undeprecate_workflow_type} \tab Undeprecates a previously deprecated _workflow type_ \cr
#'  \link[=swf_untag_resource]{untag_resource} \tab Remove a tag from a Amazon SWF domain 
#' }
#'
#' @rdname swf
#' @export
swf <- function() {
  .swf$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.swf <- list()

.swf$operations <- list()

.swf$metadata <- list(
  service_name = "swf",
  endpoints = list("*" = "swf.{region}.amazonaws.com", "cn-*" = "swf.{region}.amazonaws.com.cn"),
  service_id = "SWF",
  api_version = "2012-01-25",
  signing_name = NULL,
  json_version = "1.0",
  target_prefix = "SimpleWorkflowService"
)

.swf$handlers <- new_handlers("jsonrpc", "v4")

.swf$service <- function() {
  new_service(.swf$metadata, .swf$handlers)
}
